/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.graph;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.MultiHashMap;
import uk.ac.ebi.ook.Constants;
import uk.ac.ebi.ook.persistence.query.TermQueryHandler;

public class GraphMaker {
    public static final int MAX_NUMBER_OF_NODES = 125;
    public static final String PATH_TO_ROOT_GRAPH_TYPE = "root";
    public static final String LOCAL_RELATIONS_GRAPH_TYPE = "local";
    private MultiHashMap terms = new MultiHashMap();
    private boolean isPathToRootGraph = false;
    private int numberOfNodes = 0;

    public GraphMaker(String graphType, String termId, String termName, String ontologyName) {
        if (LOCAL_RELATIONS_GRAPH_TYPE.equalsIgnoreCase(graphType)) {
            this.isPathToRootGraph = false;
            this.addLocalRelationships(termId, termName, ontologyName);
        } else {
            this.isPathToRootGraph = true;
            this.recursiveAddTermToRoot(termId, termName, null, ontologyName);
        }
    }

    private void addLocalRelationships(String termId, String termName, String ontologyName) {
        String rel;
        String name;
        String acc;
        Object[] values;
        Iterator i;
        TermHolder term = new TermHolder(termId, termName, null);
        TermQueryHandler tqh = new TermQueryHandler();
        Collection rels = tqh.getTermRelationships(termId, ontologyName);
        if (!rels.isEmpty()) {
            i = rels.iterator();
            while (i.hasNext()) {
                values = (Object[])i.next();
                acc = (String)values[0];
                name = (String)values[1];
                rel = (String)values[3];
                ++this.numberOfNodes;
                this.terms.put((Object)term, (Object)new TermHolder(acc, name, rel));
            }
        } else {
            ++this.numberOfNodes;
            this.terms.put((Object)term, (Object)new TermHolder("ROOT", "ROOT", "ROOT"));
        }
        rels = tqh.getParentTermRelationships(termId, ontologyName);
        if (!rels.isEmpty()) {
            i = rels.iterator();
            while (i.hasNext()) {
                values = (Object[])i.next();
                acc = (String)values[0];
                name = (String)values[1];
                rel = (String)values[3];
                TermHolder parent = new TermHolder(acc, name, null);
                TermHolder child = new TermHolder(termId, termName, rel);
                ++this.numberOfNodes;
                this.terms.put((Object)parent, (Object)child);
            }
        } else {
            ++this.numberOfNodes;
            this.terms.put((Object)term, (Object)new TermHolder("ROOT", "ROOT", "ROOT"));
        }
    }

    private void recursiveAddTermToRoot(String termId, String termName, String termRel, String ontologyName) {
        if (this.numberOfNodes > 125) {
            return;
        }
        TermHolder term = new TermHolder(termId, termName, termRel);
        Collection parents = (Collection)this.terms.get((Object)term);
        if (parents == null) {
            TermQueryHandler tqh = new TermQueryHandler();
            Collection parentRels = tqh.getParentTermRelationships(termId, ontologyName);
            if (!parentRels.isEmpty()) {
                Iterator i = parentRels.iterator();
                while (i.hasNext()) {
                    Object[] values = (Object[])i.next();
                    String acc = (String)values[0];
                    String name = (String)values[1];
                    String rel = (String)values[3];
                    if (Constants.RELATIONSHIPS_TO_IGNORE.contains(rel)) continue;
                    this.terms.put((Object)term, (Object)new TermHolder(acc, name, rel));
                    ++this.numberOfNodes;
                    this.recursiveAddTermToRoot(acc, name, rel, ontologyName);
                }
            } else {
                ++this.numberOfNodes;
                this.terms.put((Object)term, (Object)new TermHolder("ROOT", "ROOT", "ROOT"));
            }
        }
    }

    public String toDot() {
        StringBuffer dot = new StringBuffer();
        dot.append("digraph go_graph {     \n");
        dot.append(" graph [               \n");
        dot.append("  style=\"\",          \n");
        dot.append("  center=\"true\",     \n");
        dot.append("  ratio=\"compress\",  \n");
        dot.append("  concentrate=\"true\",\n");
        dot.append("  nodesep=.1,          \n");
        dot.append("  ranksep=.25,         \n");
        dot.append("  rankdir=\"BT\"       \n");
        dot.append(" ];                    \n");
        dot.append(" node [                              \n");
        dot.append("  shape=\"plaintext\",               \n");
        dot.append("  height=\"0\",                      \n");
        dot.append("  width=\"0\",                       \n");
        dot.append("  fontname=\"Courier\",              \n");
        dot.append("  fontsize=\"8\",                    \n");
        dot.append("  fontcolor=\"black\",               \n");
        dot.append("  color=\"black\",                   \n");
        dot.append("  fillcolor=\"lightgoldenrodyellow\",\n");
        dot.append("  style=\"filled\"                   \n");
        dot.append(" ];\n\n");
        dot.append(" edge [                          \n");
        dot.append("  fontname=\"Courier\",          \n");
        dot.append("  fontsize=\"8\",                \n");
        dot.append("  fontcolor=\"black\",           \n");
        dot.append("  color=\"black\",               \n");
        dot.append("  arrowsize=\"0.5\"              \n");
        dot.append(" ];\n\n");
        if (this.numberOfNodes++ < 125) {
            if (this.isPathToRootGraph) {
                dot.append(this.dumpPathsToRoot());
            } else {
                dot.append(this.dumpLocalRelationships());
            }
        } else {
            dot.append(" TooManyNodes [\n");
            dot.append("  label = \"There are too many nodes to display.\"\n");
            dot.append(" ];\n");
        }
        dot.append("}");
        return dot.toString();
    }

    private String dumpLocalRelationships() {
        StringBuffer dot = new StringBuffer();
        Iterator termIt = this.terms.keySet().iterator();
        while (termIt.hasNext()) {
            TermHolder term;
            TermHolder th = (TermHolder)termIt.next();
            if (th == null) continue;
            dot.append(" ").append(this.stripColon(th.getTermAcc()));
            dot.append(" [ label = \"").append(th.getTermName().replaceAll(" ", "\\\\n")).append("\\n").append(th.getTermAcc()).append("\" ];\n");
            Collection nodes = (Collection)this.terms.get((Object)th);
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                term = (TermHolder)i.next();
                if (term.getTermAcc().equals("ROOT")) continue;
                dot.append(" ").append(this.stripColon(term.getTermAcc()));
                dot.append(" [ label = \"").append(term.getTermName().replaceAll(" ", "\\\\n")).append("\\n").append(term.getTermAcc()).append("\" ];\n");
            }
            i = nodes.iterator();
            while (i.hasNext()) {
                term = (TermHolder)i.next();
                if (term.getTermAcc().equals("ROOT")) continue;
                dot.append(" ").append(this.stripColon(term.getTermAcc())).append("->").append(this.stripColon(th.getTermAcc()));
                dot.append(" [ label = \"").append(term.getTermRel()).append("\" ];\n");
            }
        }
        return dot.toString();
    }

    private String dumpPathsToRoot() {
        TermHolder term;
        StringBuffer dot = new StringBuffer();
        Iterator i = this.terms.keySet().iterator();
        while (i.hasNext()) {
            term = (TermHolder)i.next();
            dot.append(" ").append(this.stripColon(term.getTermAcc()));
            dot.append(" [ label = \"").append(term.getTermName().replaceAll(" ", "\\\\n")).append("\\n").append(term.getTermAcc()).append("\" ];\n");
        }
        i = this.terms.keySet().iterator();
        while (i.hasNext()) {
            term = (TermHolder)i.next();
            Collection relations = (Collection)this.terms.get((Object)term);
            Iterator rel = relations.iterator();
            while (rel.hasNext()) {
                TermHolder th = (TermHolder)rel.next();
                if (th.getTermAcc().equals("ROOT")) continue;
                dot.append(" ").append(this.stripColon(term.getTermAcc())).append("->").append(this.stripColon(th.getTermAcc()));
                dot.append(" [ label = \"").append(th.getTermRel()).append("\" ];\n");
            }
        }
        return dot.toString();
    }

    private String stripColon(String input) {
        return input.replace(':', 't');
    }

    private class TermHolder {
        private String termName;
        private String termAcc;
        private String termRel;

        public String getTermRel() {
            return this.termRel;
        }

        public void setTermRel(String termRel) {
            this.termRel = termRel;
        }

        public String getTermName() {
            return this.termName;
        }

        public void setTermName(String termName) {
            this.termName = termName;
        }

        public String getTermAcc() {
            return this.termAcc;
        }

        public void setTermAcc(String termAcc) {
            this.termAcc = termAcc;
        }

        public TermHolder(String termAcc, String termName, String termRel) {
            this.termName = termName;
            this.termAcc = termAcc;
            this.termRel = termRel;
        }

        public boolean equals(Object o) {
            if (o instanceof TermHolder) {
                TermHolder tmp = (TermHolder)o;
                return this.termName != null && this.termName.equals(tmp.getTermName()) && this.termAcc != null && this.termAcc.equals(tmp.getTermAcc());
            }
            return false;
        }

        public String toString() {
            return "TermHolder{termName='" + this.termName + '\'' + ", termAcc='" + this.termAcc + '\'' + '}';
        }

        public int hashCode() {
            return (this.termName + this.termAcc).hashCode();
        }
    }
}

