/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.config;

import uk.ac.ebi.ook.config.RepositoryConfigurationException;

public class RepositoryConfigEntry {
    public static final String ANONYMOUS = "anonymous";
    private String userName = null;
    private String password = null;
    private String repository = null;
    private boolean useAnonymous = false;
    private boolean useSSH = false;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        if (repository == null) {
            throw new RepositoryConfigurationException("Repository path cannot be null");
        }
        this.repository = repository;
    }

    public boolean useAnonymous() {
        return this.useAnonymous;
    }

    public void setUseAnonymous(boolean useAnonymous) {
        this.useAnonymous = useAnonymous;
        if (useAnonymous) {
            this.password = "";
            this.userName = ANONYMOUS;
        }
    }

    public void setUseAnonymous(String useAnonymous) {
        this.setUseAnonymous(new Boolean(useAnonymous));
    }

    public boolean useSSH() {
        return this.useSSH;
    }

    public void setUseSSH(boolean useSSH) {
        this.useSSH = useSSH;
    }

    public void setUseSSH(String useSSH) {
        this.setUseSSH(new Boolean(useSSH));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryConfigEntry that = (RepositoryConfigEntry)o;
        if (this.useAnonymous != that.useAnonymous) {
            return false;
        }
        if (this.useSSH != that.useSSH) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    public int hashCode() {
        int result = this.userName != null ? this.userName.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
        result = 31 * result + (this.useAnonymous ? 1 : 0);
        result = 31 * result + (this.useSSH ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RepositoryConfigEntry{" + "userName='" + this.userName + '\'' + ", password='" + this.password + '\'' + ", repository='" + this.repository + '\'' + ", useAnonymous=" + this.useAnonymous + ", useSSH=" + this.useSSH + '}';
    }
}

