/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.xpath;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import psidev.psi.tools.validator.ValidatorException;
import psidev.psi.tools.validator.xpath.XPathResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathHelper {
    public static List<XPathResult> evaluateXPath(String xpath, Object root) throws ValidatorException {
        return XPathHelper.evaluateXPathWithClass(xpath, root, XPathResult.class);
    }

    protected static List<XPathResult> evaluateXPathWithClass(String xpath, Object root, Class clazz) throws ValidatorException {
        JXPathContext ctx = JXPathContext.newContext((Object)root);
        Iterator iter = ctx.iteratePointers(xpath);
        ArrayList<XPathResult> results = new ArrayList<XPathResult>();
        while (iter.hasNext()) {
            Pointer p = (Pointer)iter.next();
            try {
                Constructor constructor = clazz.getConstructor(Pointer.class, JXPathContext.class);
                results.add((XPathResult)constructor.newInstance(p, ctx));
            }
            catch (Exception e) {
                throw new ValidatorException("Error creating XPath Result class");
            }
        }
        return results;
    }

    public static boolean hasTrailingSlash(String xpath) {
        return xpath.trim().endsWith("/");
    }

    public static boolean hasLeadingSlash(String xpath) {
        return xpath.trim().startsWith("/");
    }

    public static String removeTrailingSlash(String xpath) {
        if (XPathHelper.hasTrailingSlash(xpath)) {
            xpath = xpath.substring(0, xpath.length() - 1);
        }
        return xpath;
    }
}

