/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.ExperimentalInteractor;
import psidev.psi.mi.xml.model.ExperimentalPreparation;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.HostOrganism;
import psidev.psi.mi.xml.model.InferredInteraction;
import psidev.psi.mi.xml.model.InferredInteractionParticipant;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionRef;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorRef;
import psidev.psi.mi.xml.model.Parameter;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;
import psidev.psi.mi.xml.xmlindex.PsimiXmlPullParser;

public class PsimiXmlExtractor {
    PsimiXmlPullParser ppp;
    private PsimiXmlFileIndex index;
    private Map<Integer, ExperimentDescription> experimentCache = new HashMap<Integer, ExperimentDescription>();

    public PsimiXmlExtractor(PsimiXmlFileIndex index) {
        if (index == null) {
            throw new IllegalArgumentException("You must give a non null index.");
        }
        this.index = index;
        this.ppp = new PsimiXmlPullParser();
    }

    public ExperimentDescription getExperimentById(FileInputStream fis, int id) throws PsimiXmlReaderException {
        ExperimentDescription ed = this.experimentCache.get(id);
        if (ed == null) {
            InputStreamRange range = this.index.getExperimentPosition(id);
            if (range == null) {
                throw new PsimiXmlReaderException("Could not find a range in the index for experiment id:" + id);
            }
            InputStream eis = PsimiXmlExtractor.extractXmlSnippet(fis, range);
            ed = this.ppp.parseExperiment(eis);
            this.experimentCache.put(id, ed);
        }
        return ed;
    }

    public void clearExperimentCache() {
        this.experimentCache.clear();
    }

    public Interactor getInteractorById(FileInputStream fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getInteractorPosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for interactor id:" + id);
        }
        InputStream is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        return this.ppp.parseInteractor(is);
    }

    public Feature getFeatureById(FileInputStream fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getFeaturePosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for feature id:" + id);
        }
        InputStream is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        return this.ppp.parseFeature(is);
    }

    public Participant getParticipantById(FileInputStream fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getParticipantPosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for participant id:" + id);
        }
        InputStream is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        return this.ppp.parseParticipant(is);
    }

    public Interaction getInteractionById(FileInputStream fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getInteractionPosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for interaction id:" + id);
        }
        InputStream is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        return this.ppp.parseInteraction(is);
    }

    public void resolveReferences(FileInputStream fis, Interaction interaction) throws PsimiXmlReaderException {
        if (interaction.hasExperimentRefs()) {
            Iterator<ExperimentRef> itex = interaction.getExperimentRefs().iterator();
            while (itex.hasNext()) {
                ExperimentRef eref = itex.next();
                ExperimentDescription ed = this.getExperimentById(fis, eref.getRef());
                itex.remove();
                interaction.getExperiments().add(ed);
            }
        }
        for (Participant p : interaction.getParticipants()) {
            this.resolveReferences(fis, p);
        }
        if (interaction.hasInferredInteractions()) {
            for (InferredInteraction ii : interaction.getInferredInteractions()) {
                if (ii.hasExperimentRefs()) {
                    Iterator<ExperimentRef> itex = ii.getExperimentRefs().iterator();
                    while (itex.hasNext()) {
                        ExperimentRef eref = itex.next();
                        ExperimentDescription ed = this.getExperimentById(fis, eref.getRef());
                        itex.remove();
                        ii.getExperiments().add(ed);
                    }
                }
                for (InferredInteractionParticipant iip : ii.getParticipant()) {
                    InputStreamRange r;
                    if (iip.hasFeatureRef()) {
                        r = this.index.getFeaturePosition(iip.getFeatureRef().getRef());
                        InputStream pfis = PsimiXmlExtractor.extractXmlSnippet(fis, r);
                        Feature ft = this.ppp.parseFeature(pfis);
                        iip.setFeatureRef(null);
                        iip.setFeature(ft);
                    }
                    if (!iip.hasParticipantRef()) continue;
                    r = this.index.getParticipantPosition(iip.getParticipantRef().getRef());
                    InputStream pis = PsimiXmlExtractor.extractXmlSnippet(fis, r);
                    Participant p = this.ppp.parseParticipant(pis);
                    iip.setParticipantRef(null);
                    iip.setParticipant(p);
                }
            }
        }
        if (interaction.hasParameters()) {
            for (Parameter pm : interaction.getParameters()) {
                if (!pm.hasExperimentRef()) continue;
                ExperimentRef eref = pm.getExperimentRef();
                ExperimentDescription ed = this.getExperimentById(fis, eref.getRef());
                pm.setExperimentRef(null);
                pm.setExperiment(ed);
            }
        }
    }

    public void resolveReferences(FileInputStream fis, Participant participant) throws PsimiXmlReaderException {
        ExperimentDescription ed;
        ExperimentRef eref;
        Iterator<ExperimentRef> itex;
        Object ref;
        if (participant.hasInteractionRef()) {
            ref = participant.getInteractionRef();
            participant.setInteractionRef(null);
            participant.setInteraction(this.getInteractionById(fis, ((InteractionRef)ref).getRef()));
        }
        if (participant.hasInteractorRef()) {
            ref = participant.getInteractorRef();
            InputStreamRange irange = this.index.getInteractorPosition(((InteractorRef)ref).getRef());
            InputStream iis = PsimiXmlExtractor.extractXmlSnippet(fis, irange);
            Interactor interactor = this.ppp.parseInteractor(iis);
            participant.setInteractorRef(null);
            participant.setInteractor(interactor);
        }
        if (participant.hasParticipantIdentificationMethods()) {
            for (ParticipantIdentificationMethod pim : participant.getParticipantIdentificationMethods()) {
                if (!pim.hasExperimentRefs()) continue;
                itex = pim.getExperimentRefs().iterator();
                while (itex.hasNext()) {
                    eref = itex.next();
                    ed = this.getExperimentById(fis, eref.getRef());
                    itex.remove();
                    pim.getExperiments().add(ed);
                }
            }
        }
        if (participant.hasExperimentalRoles()) {
            for (ExperimentalRole er : participant.getExperimentalRoles()) {
                if (!er.hasExperimentRefs()) continue;
                itex = er.getExperimentRefs().iterator();
                while (itex.hasNext()) {
                    eref = itex.next();
                    ed = this.getExperimentById(fis, eref.getRef());
                    itex.remove();
                    er.getExperiments().add(ed);
                }
            }
        }
        if (participant.hasExperimentalPreparations()) {
            for (ExperimentalPreparation ep : participant.getExperimentalPreparations()) {
                if (!ep.hasExperimentRefs()) continue;
                itex = ep.getExperimentRefs().iterator();
                while (itex.hasNext()) {
                    eref = itex.next();
                    ed = this.getExperimentById(fis, eref.getRef());
                    itex.remove();
                    ep.getExperiments().add(ed);
                }
            }
        }
        if (participant.hasExperimentalInteractors()) {
            for (ExperimentalInteractor ei : participant.getExperimentalInteractors()) {
                if (ei.hasExperimentRefs()) {
                    itex = ei.getExperimentRefs().iterator();
                    while (itex.hasNext()) {
                        eref = itex.next();
                        ed = this.getExperimentById(fis, eref.getRef());
                        itex.remove();
                        ei.getExperiments().add(ed);
                    }
                }
                if (!ei.hasInteractorRef()) continue;
                InteractorRef ref2 = ei.getInteractorRef();
                InputStreamRange irange = this.index.getInteractorPosition(ref2.getRef());
                InputStream iis = PsimiXmlExtractor.extractXmlSnippet(fis, irange);
                Interactor interactor = this.ppp.parseInteractor(iis);
                ei.setInteractorRef(null);
                ei.setInteractor(interactor);
            }
        }
        if (participant.hasHostOrganisms()) {
            for (HostOrganism ho : participant.getHostOrganisms()) {
                if (!ho.hasExperimentRefs()) continue;
                itex = ho.getExperimentRefs().iterator();
                while (itex.hasNext()) {
                    eref = itex.next();
                    ed = this.getExperimentById(fis, eref.getRef());
                    itex.remove();
                    ho.getExperiments().add(ed);
                }
            }
        }
        if (participant.hasConfidences()) {
            for (Confidence c : participant.getConfidenceList()) {
                if (!c.hasExperimentRefs()) continue;
                itex = c.getExperimentRefs().iterator();
                while (itex.hasNext()) {
                    eref = itex.next();
                    ed = this.getExperimentById(fis, eref.getRef());
                    itex.remove();
                    c.getExperiments().add(ed);
                }
            }
        }
        if (participant.hasParameters()) {
            for (Parameter pm : participant.getParameters()) {
                if (!pm.hasExperimentRef()) continue;
                ExperimentRef eref2 = pm.getExperimentRef();
                ExperimentDescription ed2 = this.getExperimentById(fis, eref2.getRef());
                pm.setExperimentRef(null);
                pm.setExperiment(ed2);
            }
        }
    }

    public static InputStream extractXmlSnippet(FileInputStream fis, InputStreamRange range) throws PsimiXmlReaderException {
        try {
            int charCount = (int)(range.getToPosition() - range.getFromPosition());
            fis.getChannel().position(range.getFromPosition());
            InputStreamReader isr = new InputStreamReader(fis);
            char[] buf = new char[charCount];
            int read = isr.read(buf, 0, charCount);
            StringBuilder sb = new StringBuilder(charCount);
            for (int i = 0; i < buf.length; ++i) {
                char c = buf[i];
                sb.append(c);
            }
            return new ByteArrayInputStream(sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("An error occured while extracting XML element in " + range, e);
        }
    }
}

