/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter;

import psidev.psi.mi.xml.converter.ConfidenceConverter;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.CvTypeConverter;
import psidev.psi.mi.xml.converter.ExperimentalInteractorConverter;
import psidev.psi.mi.xml.converter.ExperimentalPreparationConverter;
import psidev.psi.mi.xml.converter.ExperimentalRoleConverter;
import psidev.psi.mi.xml.converter.FeatureConverter;
import psidev.psi.mi.xml.converter.HostOrganismConverter;
import psidev.psi.mi.xml.converter.InteractorConverter;
import psidev.psi.mi.xml.converter.NamesConverter;
import psidev.psi.mi.xml.converter.ParticipantIdentificationMethodConverter;
import psidev.psi.mi.xml.converter.ParticipantParameterConverter;
import psidev.psi.mi.xml.converter.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.jaxb.ConfidenceListType;
import psidev.psi.mi.xml.jaxb.FeatureElementType;
import psidev.psi.mi.xml.jaxb.ParticipantType;
import psidev.psi.mi.xml.model.BiologicalRole;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.ExperimentalInteractor;
import psidev.psi.mi.xml.model.ExperimentalPreparation;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.HostOrganism;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionRef;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorRef;
import psidev.psi.mi.xml.model.Parameter;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;

public class ParticipantConverter {
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private ConfidenceConverter confidenceConverter = new ConfidenceConverter();
    private ExperimentalInteractorConverter experimentalInteractorConverter = new ExperimentalInteractorConverter();
    private FeatureConverter featureConverter = new FeatureConverter();
    private HostOrganismConverter hostOrganismConverter = new HostOrganismConverter();
    private ParticipantParameterConverter parameterConverter = new ParticipantParameterConverter();
    private InteractorConverter interactorConverter = new InteractorConverter();
    private ExperimentalRoleConverter experimentalRoleConverter = new ExperimentalRoleConverter();
    private ExperimentalPreparationConverter experimentalPreparationConverter = new ExperimentalPreparationConverter();
    private ParticipantIdentificationMethodConverter participantIdentificationMethodConverter = new ParticipantIdentificationMethodConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.featureConverter.setDAOFactory(factory);
        this.hostOrganismConverter.setDAOFactory(factory);
        this.interactorConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Participant fromJaxb(ParticipantType jParticipant) throws ConverterException {
        if (jParticipant == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Participant.");
        }
        this.checkDependencies();
        Participant mParticipant = new Participant();
        mParticipant.setId(jParticipant.getId());
        Interactor mInteractor = null;
        Interaction mInteraction = null;
        boolean foundInteractor = false;
        if (jParticipant.getInteractorRef() != null) {
            foundInteractor = true;
            mInteractor = this.factory.getInteractorDAO().retreive(jParticipant.getInteractorRef());
            if (mInteractor == null) {
                mParticipant.setInteractorRef(new InteractorRef(jParticipant.getInteractorRef()));
            } else {
                mParticipant.setInteractor(mInteractor);
            }
        } else if (jParticipant.getInteractor() != null) {
            foundInteractor = true;
            mInteractor = this.interactorConverter.fromJaxb(jParticipant.getInteractor());
        } else if (jParticipant.getInteractionRef() != null) {
            foundInteractor = true;
            mInteraction = this.factory.getInteractionDAO().retreive(jParticipant.getInteractionRef());
            if (mInteraction == null) {
                mParticipant.setInteractionRef(new InteractionRef(jParticipant.getInteractionRef()));
            }
        }
        if (!foundInteractor) {
            throw new ConverterException("Could not find either an interactor or an interaction for participant (id=" + jParticipant.getId() + ").");
        }
        if (jParticipant.getBiologicalRole() != null) {
            mParticipant.setBiologicalRole(this.cvTypeConverter.fromJaxb(jParticipant.getBiologicalRole(), BiologicalRole.class));
        }
        if (jParticipant.getNames() != null) {
            mParticipant.setNames(this.namesConverter.fromJaxb(jParticipant.getNames()));
        }
        if (jParticipant.getXref() != null) {
            mParticipant.setXref(this.xrefConverter.fromJaxb(jParticipant.getXref()));
        }
        if (jParticipant.getConfidenceList() != null) {
            for (ConfidenceListType.Confidence jConfidence : jParticipant.getConfidenceList().getConfidence()) {
                mParticipant.getConfidenceList().add(this.confidenceConverter.fromJaxb(jConfidence));
            }
        }
        if (jParticipant.getExperimentalInteractorList() != null) {
            for (ParticipantType.ExperimentalInteractorList.ExperimentalInteractor jExperimentalInteractor : jParticipant.getExperimentalInteractorList().getExperimentalInteractor()) {
                mParticipant.getExperimentalInteractors().add(this.experimentalInteractorConverter.fromJaxb(jExperimentalInteractor));
            }
        }
        if (jParticipant.getExperimentalPreparationList() != null) {
            for (ParticipantType.ExperimentalPreparationList.ExperimentalPreparation jExperimentalPreparation : jParticipant.getExperimentalPreparationList().getExperimentalPreparation()) {
                mParticipant.getExperimentalPreparations().add(this.experimentalPreparationConverter.fromJaxb(jExperimentalPreparation));
            }
        }
        if (jParticipant.getExperimentalRoleList() != null) {
            for (ParticipantType.ExperimentalRoleList.ExperimentalRole jExperimentalRole : jParticipant.getExperimentalRoleList().getExperimentalRole()) {
                mParticipant.getExperimentalRoles().add(this.experimentalRoleConverter.fromJaxb(jExperimentalRole));
            }
        }
        if (jParticipant.getFeatureList() != null) {
            for (FeatureElementType jFeature : jParticipant.getFeatureList().getFeature()) {
                mParticipant.getFeatures().add(this.featureConverter.fromJaxb(jFeature));
            }
        }
        if (jParticipant.getHostOrganismList() != null) {
            for (ParticipantType.HostOrganismList.HostOrganism jOrganism : jParticipant.getHostOrganismList().getHostOrganism()) {
                mParticipant.getHostOrganisms().add(this.hostOrganismConverter.fromJaxb(jOrganism));
            }
        }
        if (jParticipant.getParameterList() != null) {
            for (ParticipantType.ParameterList.Parameter jParameter : jParticipant.getParameterList().getParameter()) {
                mParticipant.getParameters().add(this.parameterConverter.fromJaxb(jParameter));
            }
        }
        if (jParticipant.getParticipantIdentificationMethodList() != null) {
            for (ParticipantType.ParticipantIdentificationMethodList.ParticipantIdentificationMethod jParticipantIdentificationMethod : jParticipant.getParticipantIdentificationMethodList().getParticipantIdentificationMethod()) {
                mParticipant.getParticipantIdentificationMethods().add(this.participantIdentificationMethodConverter.fromJaxb(jParticipantIdentificationMethod));
            }
        }
        PsiDAO<Participant> participantDAO = this.factory.getParticipantDAO();
        participantDAO.store(mParticipant);
        return mParticipant;
    }

    public ParticipantType toJaxb(Participant mParticipant) throws ConverterException {
        if (mParticipant == null) {
            throw new IllegalArgumentException("You must give a non null model Participant.");
        }
        this.checkDependencies();
        ParticipantType jParticipant = new ParticipantType();
        jParticipant.setId(mParticipant.getId());
        if (mParticipant.hasInteractor()) {
            jParticipant.setInteractorRef(mParticipant.getInteractor().getId());
        } else if (mParticipant.hasInteraction()) {
            jParticipant.setInteractionRef(mParticipant.getInteraction().getId());
        } else {
            throw new ConverterException("Neither an interactor or an interaction was present in participant " + mParticipant.getId());
        }
        if (mParticipant.hasBiologicalRole()) {
            jParticipant.setBiologicalRole(this.cvTypeConverter.toJaxb(mParticipant.getBiologicalRole()));
        }
        if (mParticipant.hasNames()) {
            jParticipant.setNames(this.namesConverter.toJaxb(mParticipant.getNames()));
        }
        if (mParticipant.hasXref()) {
            jParticipant.setXref(this.xrefConverter.toJaxb(mParticipant.getXref()));
        }
        if (mParticipant.hasConfidences()) {
            if (jParticipant.getConfidenceList() == null) {
                jParticipant.setConfidenceList(new ConfidenceListType());
            }
            for (Confidence mConfidence : mParticipant.getConfidenceList()) {
                jParticipant.getConfidenceList().getConfidence().add(this.confidenceConverter.toJaxb(mConfidence));
            }
        }
        if (mParticipant.hasExperimentalInteractors()) {
            if (jParticipant.getExperimentalInteractorList() == null) {
                jParticipant.setExperimentalInteractorList(new ParticipantType.ExperimentalInteractorList());
            }
            for (ExperimentalInteractor mExperimentalInteractor : mParticipant.getExperimentalInteractors()) {
                jParticipant.getExperimentalInteractorList().getExperimentalInteractor().add(this.experimentalInteractorConverter.toJaxb(mExperimentalInteractor));
            }
        }
        if (mParticipant.hasExperimentalPreparations()) {
            if (jParticipant.getExperimentalPreparationList() == null) {
                jParticipant.setExperimentalPreparationList(new ParticipantType.ExperimentalPreparationList());
            }
            for (ExperimentalPreparation mExperimentalPreparation : mParticipant.getExperimentalPreparations()) {
                jParticipant.getExperimentalPreparationList().getExperimentalPreparation().add(this.experimentalPreparationConverter.toJaxb(mExperimentalPreparation));
            }
        }
        if (mParticipant.hasExperimentalRoles()) {
            if (jParticipant.getExperimentalRoleList() == null) {
                jParticipant.setExperimentalRoleList(new ParticipantType.ExperimentalRoleList());
            }
            for (ExperimentalRole mExperimentalRole : mParticipant.getExperimentalRoles()) {
                jParticipant.getExperimentalRoleList().getExperimentalRole().add(this.experimentalRoleConverter.toJaxb(mExperimentalRole));
            }
        }
        if (mParticipant.hasFeatures()) {
            if (jParticipant.getFeatureList() == null) {
                jParticipant.setFeatureList(new ParticipantType.FeatureList());
            }
            for (Feature mFeature : mParticipant.getFeatures()) {
                jParticipant.getFeatureList().getFeature().add(this.featureConverter.toJaxb(mFeature));
            }
        }
        if (!mParticipant.getHostOrganisms().isEmpty()) {
            if (jParticipant.getHostOrganismList() == null) {
                jParticipant.setHostOrganismList(new ParticipantType.HostOrganismList());
            }
            for (HostOrganism mHostOrganism : mParticipant.getHostOrganisms()) {
                jParticipant.getHostOrganismList().getHostOrganism().add(this.hostOrganismConverter.toJaxb(mHostOrganism));
            }
        }
        if (mParticipant.hasParameters()) {
            if (jParticipant.getParameterList() == null) {
                jParticipant.setParameterList(new ParticipantType.ParameterList());
            }
            for (Parameter mParameter : mParticipant.getParameters()) {
                jParticipant.getParameterList().getParameter().add(this.parameterConverter.toJaxb(mParameter));
            }
        }
        if (mParticipant.hasParticipantIdentificationMethods()) {
            if (jParticipant.getParticipantIdentificationMethodList() == null) {
                jParticipant.setParticipantIdentificationMethodList(new ParticipantType.ParticipantIdentificationMethodList());
            }
            for (ParticipantIdentificationMethod mParticipantIdentificationMethod : mParticipant.getParticipantIdentificationMethods()) {
                jParticipant.getParticipantIdentificationMethodList().getParticipantIdentificationMethod().add(this.participantIdentificationMethodConverter.toJaxb(mParticipantIdentificationMethod));
            }
        }
        return jParticipant;
    }
}

