/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.OpenCvTypeConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.jaxb.ConfidenceListType;
import psidev.psi.mi.xml.jaxb.ExperimentRefListType;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.Unit;

public class ConfidenceConverter {
    private OpenCvTypeConverter openCvTypeConverter = new OpenCvTypeConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Confidence fromJaxb(ConfidenceListType.Confidence jConfidence) throws ConverterException {
        if (jConfidence == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Confidence.");
        }
        this.checkDependencies();
        Confidence mConfidence = new Confidence();
        mConfidence.setValue(jConfidence.getValue());
        mConfidence.setUnit(this.openCvTypeConverter.fromJaxb(jConfidence.getUnit(), Unit.class));
        if (jConfidence.getExperimentRefList() != null) {
            PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
            for (Integer experimentId : jConfidence.getExperimentRefList().getExperimentRef()) {
                ExperimentDescription experimentDescription = experimentDAO.retreive(experimentId);
                if (experimentDescription == null) {
                    mConfidence.getExperimentRefs().add(new ExperimentRef(experimentId));
                    continue;
                }
                mConfidence.getExperiments().add(experimentDescription);
            }
        }
        return mConfidence;
    }

    public ConfidenceListType.Confidence toJaxb(Confidence mConfidence) throws ConverterException {
        ConfidenceListType.Confidence jConfidence;
        block6: {
            block5: {
                if (mConfidence == null) {
                    throw new IllegalArgumentException("You must give a non null model Confidence.");
                }
                this.checkDependencies();
                jConfidence = new ConfidenceListType.Confidence();
                jConfidence.setValue(mConfidence.getValue());
                jConfidence.setUnit(this.openCvTypeConverter.toJaxb(mConfidence.getUnit()));
                if (!mConfidence.hasExperiments()) break block5;
                if (jConfidence.getExperimentRefList() == null) {
                    jConfidence.setExperimentRefList(new ExperimentRefListType());
                }
                for (ExperimentDescription mExperiment : mConfidence.getExperiments()) {
                    jConfidence.getExperimentRefList().getExperimentRef().add(mExperiment.getId());
                }
                break block6;
            }
            if (!mConfidence.hasExperimentRefs()) break block6;
            if (jConfidence.getExperimentRefList() == null) {
                jConfidence.setExperimentRefList(new ExperimentRefListType());
            }
            for (ExperimentRef mExperiment : mConfidence.getExperimentRefs()) {
                jConfidence.getExperimentRefList().getExperimentRef().add(mExperiment.getRef());
            }
        }
        return jConfidence;
    }
}

