/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.EntrySetConverter;
import psidev.psi.mi.xml.dao.inMemory.InMemoryDAOFactory;
import psidev.psi.mi.xml.jaxb.EntrySet;

public class PsimiXmlReader {
    public static final Log log = LogFactory.getLog(PsimiXmlReader.class);

    private Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"psidev.psi.mi.xml.jaxb");
        return jc.createUnmarshaller();
    }

    private EntrySet unmarshall(URL url) throws JAXBException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("You must give a non null URL.");
        }
        Unmarshaller u = this.getUnmarshaller();
        EntrySet es = (EntrySet)u.unmarshal(url);
        return es;
    }

    private EntrySet unmarshall(File file) throws JAXBException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("You must give an existing file.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("You must give a readable file.");
        }
        Unmarshaller u = this.getUnmarshaller();
        EntrySet es = (EntrySet)u.unmarshal((InputStream)new FileInputStream(file));
        return es;
    }

    private EntrySet unmarshall(InputStream is) throws JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("You must give a non null input stream.");
        }
        Unmarshaller u = this.getUnmarshaller();
        EntrySet es = (EntrySet)u.unmarshal(is);
        return es;
    }

    private EntrySet unmarshall(String s) throws JAXBException {
        if (s == null) {
            throw new IllegalArgumentException("You must give a non null String.");
        }
        Unmarshaller u = this.getUnmarshaller();
        EntrySet es = (EntrySet)u.unmarshal((Reader)new StringReader(s));
        return es;
    }

    private psidev.psi.mi.xml.model.EntrySet convertInMemory(EntrySet jEntrySet) throws ConverterException {
        EntrySetConverter converter = new EntrySetConverter();
        InMemoryDAOFactory dao = new InMemoryDAOFactory();
        converter.setDAOFactory(dao);
        psidev.psi.mi.xml.model.EntrySet mEntrySet = converter.fromJaxb(jEntrySet);
        return mEntrySet;
    }

    public psidev.psi.mi.xml.model.EntrySet read(String s) throws JAXBException, ConverterException {
        EntrySet jEntrySet = this.unmarshall(s);
        return this.convertInMemory(jEntrySet);
    }

    public psidev.psi.mi.xml.model.EntrySet read(File file) throws IOException, JAXBException, ConverterException {
        EntrySet jEntrySet = this.unmarshall(file);
        return this.convertInMemory(jEntrySet);
    }

    public psidev.psi.mi.xml.model.EntrySet read(InputStream is) throws IOException, JAXBException, ConverterException {
        EntrySet jEntrySet = this.unmarshall(is);
        return this.convertInMemory(jEntrySet);
    }

    public psidev.psi.mi.xml.model.EntrySet read(URL url) throws IOException, JAXBException, ConverterException {
        EntrySet jEntrySet = this.unmarshall(url);
        return this.convertInMemory(jEntrySet);
    }
}

