/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import psidev.psi.mi.xml.ExperimentIterator;
import psidev.psi.mi.xml.InteractionIterator;
import psidev.psi.mi.xml.InteractorIterator;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;
import psidev.psi.mi.xml.xmlindex.PsimiXmlIndexer;

public class PsimiXmlPullReader {
    private File file;
    private PsimiXmlFileIndex index;

    public PsimiXmlPullReader(File file) throws PsimiXmlReaderException {
        this.init(file);
    }

    private void init(File file) throws PsimiXmlReaderException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("You must give an existing file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("You must give a readable file: " + file.getAbsolutePath());
        }
        this.file = file;
        PsimiXmlIndexer indexer = new PsimiXmlIndexer();
        try {
            this.index = indexer.build(file);
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("An error occured while indexing the file: " + file.getAbsolutePath(), e);
        }
    }

    public PsimiXmlPullReader(URL url) throws PsimiXmlReaderException {
        if (url == null) {
            throw new IllegalArgumentException("You must give a non null url");
        }
        try {
            File f = this.saveOnDisk(url.openStream());
            this.init(f);
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("An error occured while reading the content of the URL: " + url);
        }
    }

    public PsimiXmlPullReader(InputStream is) throws PsimiXmlReaderException {
        if (is == null) {
            throw new IllegalArgumentException("You must give a non null data stream");
        }
        try {
            File f = this.saveOnDisk(is);
            this.init(f);
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("An error occured while reading the content of the given input stream,");
        }
    }

    private File saveOnDisk(InputStream is) throws IOException {
        String name = "psi25-xml." + System.currentTimeMillis() + ".xml";
        File tmpFile = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + name);
        tmpFile.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile));
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        char[] buf = new char[8192];
        int read = -2;
        while ((read = in.read(buf, 0, 8192)) != -1) {
            out.write(buf, 0, read);
        }
        in.close();
        out.flush();
        out.close();
        return tmpFile;
    }

    public InteractionIterator getInteractionIterator() throws PsimiXmlReaderException {
        try {
            return new InteractionIterator(this.index, this.file);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while building an interaction iterator", e);
        }
    }

    public ExperimentIterator getExperimentIterator() throws PsimiXmlReaderException {
        try {
            return new ExperimentIterator(this.index, this.file);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while building an experiment iterator", e);
        }
    }

    public InteractorIterator getInteractorIterator() throws PsimiXmlReaderException {
        try {
            return new InteractorIterator(this.index, this.file);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while building an interactor iterator", e);
        }
    }

    public Interaction getInteractionById(int id) throws PsimiXmlReaderException {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            PsimiXmlExtractor extractor = new PsimiXmlExtractor(this.index);
            return extractor.getInteractionById(fis, id);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while retrieving interaction by id: " + id, e);
        }
    }

    public Interactor getInteractorById(int id) throws PsimiXmlReaderException {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            PsimiXmlExtractor extractor = new PsimiXmlExtractor(this.index);
            return extractor.getInteractorById(fis, id);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while retrieving interactor by id: " + id, e);
        }
    }

    public ExperimentDescription getExperimentById(int id) throws PsimiXmlReaderException {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            PsimiXmlExtractor extractor = new PsimiXmlExtractor(this.index);
            return extractor.getExperimentById(fis, id);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderException("An error occured while retrieving experiment by id: " + id, e);
        }
    }
}

