/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.processor;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterPerInteractorProcessor
implements PostProcessorStrategy {
    private void mergeCollection(Collection source, Collection target) {
        if (source == null) {
            throw new IllegalArgumentException("source collection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("target collection must not be null.");
        }
        for (Object o : source) {
            if (target.contains(o)) continue;
            target.add(o);
        }
    }

    @Override
    public Collection<BinaryInteraction> process(Collection<BinaryInteraction> interactions) {
        HashMap<TwoInteractor, BinaryInteraction> map = new HashMap<TwoInteractor, BinaryInteraction>(interactions.size());
        for (BinaryInteraction interaction : interactions) {
            TwoInteractor ti = new TwoInteractor(new SimpleInteractor(interaction.getInteractorA()), new SimpleInteractor(interaction.getInteractorB()));
            if (map.containsKey(ti)) {
                BinaryInteraction target = (BinaryInteraction)map.get(ti);
                this.mergeCollection(interaction.getAuthors(), target.getAuthors());
                this.mergeCollection(interaction.getPublications(), target.getPublications());
                this.mergeCollection(interaction.getConfidenceValues(), target.getConfidenceValues());
                this.mergeCollection(interaction.getDetectionMethods(), target.getDetectionMethods());
                this.mergeCollection(interaction.getInteractionTypes(), target.getInteractionTypes());
                this.mergeCollection(interaction.getSourceDatabases(), target.getSourceDatabases());
                continue;
            }
            map.put(ti, interaction);
        }
        return map.values();
    }

    protected static class TwoInteractor {
        private SimpleInteractor interactorA;
        private SimpleInteractor interactorB;

        public TwoInteractor(SimpleInteractor interactorA, SimpleInteractor interactorB) {
            this.interactorA = interactorA;
            this.interactorB = interactorB;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwoInteractor that = (TwoInteractor)o;
            return this.interactorA.equals(that.interactorA) && this.interactorB.equals(that.interactorB) || this.interactorA.equals(that.interactorB) && this.interactorB.equals(that.interactorA);
        }

        public int hashCode() {
            int result = this.interactorA.hashCode();
            result = 31 * result + this.interactorB.hashCode();
            return result;
        }
    }

    protected static class SimpleInteractor {
        Collection<CrossReference> identifiers;
        Integer taxid;

        public SimpleInteractor(Interactor interactor) {
            if (interactor == null) {
                throw new IllegalArgumentException("Interactor should not be null.");
            }
            this.identifiers = interactor.getIdentifiers();
            this.taxid = interactor.getTaxid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleInteractor that = (SimpleInteractor)o;
            if (CollectionUtils.intersection(this.identifiers, that.identifiers).isEmpty()) {
                return false;
            }
            return !(this.taxid != null ? !this.taxid.equals(that.taxid) : that.taxid != null);
        }

        public int hashCode() {
            int result = ((Object)this.identifiers).hashCode();
            result = 31 * result + (this.taxid != null ? this.taxid.hashCode() : 0);
            return result;
        }
    }
}

