/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.txt2tab.FormatterFilter;
import psidev.psi.mi.tab.converter.txt2tab.TabulatedLineFormater;
import psidev.psi.mi.tab.converter.xml2tab.InteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.TabConvertionException;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Interaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2Tab {
    public static final Log log = LogFactory.getLog(Xml2Tab.class);
    private static final int LINE_BUFFER = 100;
    private static final String NEW_LINE = System.getProperty("line.separator");
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";
    private PostProcessorStrategy postProcessor;
    private ExpansionStrategy expansionStrategy;

    public PostProcessorStrategy getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessorStrategy postProcessor) {
        this.postProcessor = postProcessor;
    }

    public ExpansionStrategy getExpansionStrategy() {
        return this.expansionStrategy;
    }

    public void setExpansionStrategy(ExpansionStrategy expansionStrategy) {
        this.expansionStrategy = expansionStrategy;
    }

    public void convert(File xmlInput, File tabOutput) throws JAXBException, IOException, ConverterException, TabConvertionException {
        this.convert(xmlInput, tabOutput, new FormatterFilter());
    }

    public void convert(File xmlInput, File tabOutput, FormatterFilter filter) throws JAXBException, IOException, ConverterException, TabConvertionException {
        if (xmlInput == null) {
            throw new IllegalArgumentException("PSI XML input file must not be null.");
        }
        if (!xmlInput.exists()) {
            throw new IllegalArgumentException(xmlInput.getAbsolutePath() + " does not exist.");
        }
        if (!xmlInput.canRead()) {
            throw new IllegalArgumentException("Could not read " + xmlInput.getAbsolutePath());
        }
        if (tabOutput == null) {
            throw new IllegalArgumentException("Output file must not be null.");
        }
        if (tabOutput.exists()) {
            throw new IllegalArgumentException(tabOutput.getAbsolutePath() + " already exist. Abort.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null.");
        }
        PsimiXmlReader reader = new PsimiXmlReader();
        EntrySet entrySet = reader.read(xmlInput);
        Collection<BinaryInteraction> interactions = this.convert(entrySet);
        if (this.postProcessor != null) {
            log.debug((Object)("Running " + this.postProcessor.getClass().getSimpleName() + "..."));
            interactions = this.postProcessor.process(interactions);
            log.debug((Object)"Post processing completed.");
        } else {
            log.debug((Object)"No post processing requested.");
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(tabOutput));
        int count = 0;
        for (BinaryInteraction interaction : interactions) {
            out.write(TabulatedLineFormater.format(interaction, filter) + NEW_LINE);
            if (++count % 100 != 0) continue;
            out.flush();
        }
        out.flush();
        out.close();
    }

    public Collection<BinaryInteraction> convert(EntrySet entrySet) throws TabConvertionException, ConverterException {
        if (entrySet == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>();
        InteractionConverter interactionConverter = new InteractionConverter();
        for (Entry entry : entrySet.getEntries()) {
            log.debug((Object)("Interaction count: " + entry.getInteractions().size()));
            for (Interaction interaction : entry.getInteractions()) {
                if (this.expansionStrategy != null) {
                    Collection<Interaction> expandedInteractions = this.expansionStrategy.expand(interaction);
                    for (Interaction exi : expandedInteractions) {
                        BinaryInteraction binaryInteraction = interactionConverter.toMitab(exi);
                        if (binaryInteraction == null) continue;
                        interactions.add(binaryInteraction);
                    }
                    continue;
                }
                BinaryInteraction binaryInteraction = interactionConverter.toMitab(interaction);
                if (binaryInteraction == null) continue;
                interactions.add(binaryInteraction);
            }
        }
        return interactions;
    }

    public EntrySet convert(Collection<BinaryInteraction> interactions) {
        throw new UnsupportedOperationException();
    }
}

