/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.TabConvertionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Names;

public class InteractorConverter {
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    public static final Log log = LogFactory.getLog(InteractorConverter.class);

    private CrossReference buildCrossReference(DbReference ref) {
        return new CrossReference(ref.getDb(), ref.getId());
    }

    public Interactor toMitab(psidev.psi.mi.xml.model.Interactor interactor) throws TabConvertionException {
        Names names;
        ArrayList<CrossReference> identifiers = new ArrayList<CrossReference>(2);
        ArrayList<CrossReference> altIdentifiers = new ArrayList<CrossReference>(2);
        if (interactor.getXref() != null) {
            Collection<DbReference> identityRefs = XrefUtils.searchByType(interactor.getXref(), IDENTITY, IDENTITY_REF);
            for (DbReference ref : identityRefs) {
                CrossReference cr = this.buildCrossReference(ref);
                if (identifiers.contains(cr)) continue;
                identifiers.add(cr);
            }
            List<DbReference> allRefs = XrefUtils.getAllDbReferences(interactor.getXref());
            if (identifiers.isEmpty() && allRefs.size() > 0) {
                identifiers.add(this.buildCrossReference((DbReference)allRefs.iterator().next()));
            }
            for (DbReference ref : allRefs) {
                CrossReference cr = this.buildCrossReference(ref);
                if (identifiers.contains(cr) || altIdentifiers.contains(cr)) continue;
                altIdentifiers.add(cr);
            }
        }
        if (identifiers.isEmpty()) {
            throw new TabConvertionException("Could not find any identifiers for interactor " + interactor.getId());
        }
        Interactor tabInteractor = new Interactor(identifiers);
        tabInteractor.setAlternativeIdentifiers(altIdentifiers);
        if (interactor.getNames() != null && (names = interactor.getNames()).hasAliases()) {
            ArrayList<psidev.psi.mi.tab.model.Alias> aliases = new ArrayList<psidev.psi.mi.tab.model.Alias>();
            for (Alias alias : names.getAliases()) {
                String name = alias.getValue();
                if (name == null) continue;
                String type = alias.getType();
                psidev.psi.mi.tab.model.Alias myAlias = new psidev.psi.mi.tab.model.Alias(type, name);
                aliases.add(myAlias);
            }
            tabInteractor.setAliases(aliases);
        }
        if (interactor.hasOrganism()) {
            tabInteractor.setTaxid(interactor.getOrganism().getNcbiTaxId());
        }
        return tabInteractor;
    }

    public psidev.psi.mi.xml.model.Interactor fromMitab(Interactor interactor) {
        throw new UnsupportedOperationException();
    }
}

