/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.CvConverter;
import psidev.psi.mi.tab.converter.xml2tab.InteractorConverter;
import psidev.psi.mi.tab.converter.xml2tab.PublicationConverter;
import psidev.psi.mi.tab.converter.xml2tab.TabConvertionException;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Participant;

public class InteractionConverter {
    public static final Log log = LogFactory.getLog(InteractionConverter.class);
    private InteractorConverter interactorConverter = new InteractorConverter();
    private CvConverter cvConverter = new CvConverter();
    private PublicationConverter pubConverter = new PublicationConverter();

    public BinaryInteraction toMitab(Interaction interaction) throws TabConvertionException {
        int expCount;
        if (interaction.getParticipants().size() != 2) {
            log.warn((Object)("interaction (id:" + interaction.getId() + ") could not be converted to MITAB25 as it does not have exactly 2 participants."));
            return null;
        }
        Iterator pi = interaction.getParticipants().iterator();
        Participant pA = (Participant)pi.next();
        Participant pB = (Participant)pi.next();
        Interactor interactorA = this.interactorConverter.toMitab(pA.getInteractor());
        Interactor interactorB = this.interactorConverter.toMitab(pB.getInteractor());
        BinaryInteraction bi = new BinaryInteraction(interactorA, interactorB);
        if (interaction.hasInteractionTypes()) {
            ArrayList<InteractionType> types = new ArrayList<InteractionType>(interaction.getInteractionTypes().size());
            for (psidev.psi.mi.xml.model.InteractionType interactionType : interaction.getInteractionTypes()) {
                InteractionType type = this.cvConverter.toMitab((CvType)interactionType, InteractionType.class);
                if (type != null) {
                    types.add(type);
                    continue;
                }
                log.warn((Object)("Failed to convert interaction type: " + interactionType));
            }
            if (!types.isEmpty()) {
                bi.setInteractionTypes(types);
            }
        }
        if ((expCount = interaction.getExperiments().size()) > 0) {
            ArrayList<CrossReference> publications = new ArrayList<CrossReference>(expCount);
            bi.setPublications(publications);
            ArrayList<InteractionDetectionMethod> detections = new ArrayList<InteractionDetectionMethod>(expCount);
            bi.setDetectionMethods(detections);
            for (ExperimentDescription experiment : interaction.getExperiments()) {
                CrossReference pub;
                InteractionDetectionMethod detection = this.cvConverter.toMitab((CvType)experiment.getInteractionDetectionMethod(), InteractionDetectionMethod.class);
                if (detection != null) {
                    bi.getDetectionMethods().add(detection);
                }
                if (experiment.getBibref() == null || (pub = this.pubConverter.toMitab(experiment.getBibref())) == null) continue;
                bi.getPublications().add(pub);
            }
        }
        return bi;
    }

    public BinaryInteraction fromMitab(BinaryInteraction interaction) {
        throw new UnsupportedOperationException();
    }
}

