/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.txt2tab.FormatterFilter;
import psidev.psi.mi.tab.converter.txt2tab.TabulatedLineFormater;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.xml.converter.ConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabWriter {
    public static final Log log = LogFactory.getLog(PsimiTabWriter.class);
    public static final String NEW_LINE = System.getProperty("line.separator");
    private FormatterFilter filter = new FormatterFilter();

    public FormatterFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FormatterFilter filter) {
        this.filter = filter;
    }

    public void write(Collection<BinaryInteraction> interactions, File file) throws IOException, ConverterException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (file.exists()) {
            log.warn((Object)(file.getAbsolutePath() + " is going to be overwritten"));
            if (!file.canWrite()) {
                throw new IllegalArgumentException("You must give a writeable file.");
            }
        } else if (!file.createNewFile()) {
            throw new IOException("Could not create file: " + file.getAbsolutePath());
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        for (BinaryInteraction binaryInteraction : interactions) {
            String line = TabulatedLineFormater.format(binaryInteraction, this.filter);
            out.write(line + NEW_LINE);
        }
        out.flush();
        out.close();
    }

    public void write(Collection<BinaryInteraction> interactions, OutputStream os) throws IOException, ConverterException {
        for (BinaryInteraction binaryInteraction : interactions) {
            String line = TabulatedLineFormater.format(binaryInteraction, this.filter);
            os.write(line.getBytes());
        }
    }

    public void write(Collection<BinaryInteraction> interactions, Writer writer) throws IOException, ConverterException {
        for (BinaryInteraction binaryInteraction : interactions) {
            String line = TabulatedLineFormater.format(binaryInteraction, this.filter);
            writer.write(line + NEW_LINE);
        }
    }

    public void write(Collection<BinaryInteraction> interactions, PrintStream ps) throws IOException, ConverterException {
        for (BinaryInteraction binaryInteraction : interactions) {
            String line = TabulatedLineFormater.format(binaryInteraction, this.filter);
            ps.println(line);
        }
    }
}

