/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.PsimiTabWriter;
import psidev.psi.mi.tab.converter.txt2tab.FormatterFilter;
import psidev.psi.mi.tab.converter.xml2tab.TabConvertionException;
import psidev.psi.mi.tab.converter.xml2tab.Xml2Tab;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.processor.ClusterPerInteractorProcessor;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.model.EntrySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetConverter {
    public static final Log log = LogFactory.getLog(FileSetConverter.class);
    private PostProcessorStrategy postProcessor = null;
    private ExpansionStrategy expansionStrategy = null;

    public ExpansionStrategy getExpansionStrategy() {
        return this.expansionStrategy;
    }

    public void setExpansionStrategy(ExpansionStrategy expansionStrategy) {
        this.expansionStrategy = expansionStrategy;
    }

    public PostProcessorStrategy getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessorStrategy postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void convert(File mitabOutputFile, Collection<File> psixmlInputs) throws IOException, ConverterException, JAXBException, TabConvertionException {
        Xml2Tab x2t = new Xml2Tab();
        x2t.setPostProcessor(this.postProcessor);
        x2t.setExpansionStrategy(this.expansionStrategy);
        ArrayList<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>();
        PsimiXmlReader reader = new PsimiXmlReader();
        int fileCount = 0;
        for (File inputFile : psixmlInputs) {
            log.debug((Object)("Loading " + inputFile.getName()));
            EntrySet entrySet = reader.read(inputFile);
            Collection<BinaryInteraction> bis = x2t.convert(entrySet);
            log.debug((Object)(bis.size() + " interaction(s) loaded from " + inputFile.getName()));
            interactions.addAll(bis);
            log.debug((Object)(interactions.size() + " interaction(s) collected over " + ++fileCount + " file(s)."));
        }
        log.debug((Object)(interactions.size() + " interaction(s) loaded overall."));
        ClusterPerInteractorProcessor postProcessor = new ClusterPerInteractorProcessor();
        log.debug((Object)("Running post-processor: " + postProcessor.getClass().getSimpleName()));
        Collection<BinaryInteraction> clusteredInteractions = postProcessor.process(interactions);
        log.debug((Object)"done.");
        log.debug((Object)(clusteredInteractions.size() + " interaction(s) left after post-processing."));
        log.debug((Object)"Writing MITAB25 file...");
        PsimiTabWriter writer = new PsimiTabWriter();
        FormatterFilter noPublicationFilter = new FormatterFilter();
        noPublicationFilter.setPublications(true);
        writer.setFilter(noPublicationFilter);
        writer.write(clusteredInteractions, mitabOutputFile);
        log.debug((Object)"done.");
    }

    public static void main(String[] args) throws JAXBException, IOException, TabConvertionException, ConverterException {
        ArrayList<File> ewingsFiles = new ArrayList<File>();
        for (int i = 1; i < 5; ++i) {
            ewingsFiles.add(new File("C:\\ewing-2006\\ewing-2006-1_0" + i + ".xml"));
        }
        File psixmlOut = new File("C:\\ewing-2006\\ewing-2006.xls");
        FileSetConverter converter = new FileSetConverter();
        converter.convert(psixmlOut, ewingsFiles);
    }
}

