/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.txt2tab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.Interactor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MitabLineParser {
    public static final String PIPE = "\\|";
    public static final String COLON = ":";
    public static final String TAB = "\t";
    public static final String NONE = "-";

    public BinaryInteraction parse(String line) {
        if (line == null) {
            throw new IllegalArgumentException("MITAB25 line must not be null.");
        }
        StringTokenizer st = new StringTokenizer(line, String.valueOf(TAB));
        String field1 = st.nextToken();
        Collection<CrossReference> identifiersA = this.parseCrossReference(field1);
        Interactor ia = new Interactor(identifiersA);
        String field2 = st.nextToken();
        Collection<CrossReference> identifiersB = this.parseCrossReference(field2);
        Interactor ib = new Interactor(identifiersB);
        String field3 = st.nextToken();
        ia.setAlternativeIdentifiers(this.parseCrossReference(field3));
        String field4 = st.nextToken();
        ib.setAlternativeIdentifiers(this.parseCrossReference(field4));
        String field5 = st.nextToken();
        ia.setAliases(this.parseAliases(field5));
        String field6 = st.nextToken();
        ib.setAliases(this.parseAliases(field6));
        BinaryInteraction bi = new BinaryInteraction(ia, ib);
        String field7 = st.nextToken();
        bi.setDetectionMethods(this.parseInteractionDetectionMethods(field7));
        String field8 = st.nextToken();
        bi.setAuthors(this.parseAuthors(field8));
        String field9 = st.nextToken();
        bi.setPublications(this.parseCrossReference(field9));
        String field10 = st.nextToken();
        bi.getInteractorA().setTaxid(Integer.parseInt(field10));
        String field11 = st.nextToken();
        bi.getInteractorB().setTaxid(Integer.parseInt(field11));
        String field12 = st.nextToken();
        bi.setInteractionTypes(this.parseInteractionTypes(field12));
        String field13 = st.nextToken();
        bi.setSourceDatabases(this.parseCrossReference(field13));
        String field14 = st.nextToken();
        bi.setConfidenceValues(this.parseConfidence(field14));
        return bi;
    }

    private String[] splitOnFirstColon(String s) {
        String[] fields = new String[2];
        int idx = s.indexOf(COLON);
        if (idx != -1) {
            fields[0] = s.substring(0, idx);
            fields[1] = s.substring(idx + 1, s.length());
        }
        return fields;
    }

    private Collection<CrossReference> parseCrossReference(String field) {
        ArrayList<CrossReference> refs = new ArrayList<CrossReference>();
        if (!this.isFieldEmpty(field)) {
            String[] items = field.split(PIPE);
            for (int i = 0; i < items.length; ++i) {
                String item = items[i];
                String[] refFields = this.splitOnFirstColon(item);
                refs.add(new CrossReference(refFields[0], refFields[1]));
            }
        }
        return refs;
    }

    private Collection<Confidence> parseConfidence(String field) {
        ArrayList<Confidence> confidences = new ArrayList<Confidence>();
        if (!this.isFieldEmpty(field)) {
            String[] confs = field.split(PIPE);
            for (int i = 0; i < confs.length; ++i) {
                String method = confs[i];
                String[] subFields = this.splitOnFirstColon(method);
                confidences.add(new Confidence(subFields[0], subFields[1]));
            }
        }
        return confidences;
    }

    private Collection<Alias> parseAliases(String field) {
        ArrayList<Alias> aliases = new ArrayList<Alias>();
        if (!this.isFieldEmpty(field)) {
            String[] a = field.split(PIPE);
            for (int i = 0; i < a.length; ++i) {
                String s = a[i];
                String[] typeAndName = this.splitOnFirstColon(s);
                aliases.add(new Alias(typeAndName[0], typeAndName[1]));
            }
        }
        return aliases;
    }

    private Collection<Author> parseAuthors(String field) {
        ArrayList<Author> authors = new ArrayList<Author>();
        if (!this.isFieldEmpty(field)) {
            String[] a = field.split(PIPE);
            for (int i = 0; i < a.length; ++i) {
                String s = a[i];
                authors.add(new Author(s, null));
            }
        }
        return authors;
    }

    private Collection<InteractionType> parseInteractionTypes(String field) {
        ArrayList<InteractionType> interactionTypes = new ArrayList<InteractionType>();
        if (!this.isFieldEmpty(field)) {
            String[] methods = field.split(PIPE);
            for (int i = 0; i < methods.length; ++i) {
                String method = methods[i];
                String[] subFields = this.splitOnFirstColon(method);
                interactionTypes.add(new InteractionType(subFields[0], subFields[1]));
            }
        }
        return interactionTypes;
    }

    private Collection<InteractionDetectionMethod> parseInteractionDetectionMethods(String field) {
        ArrayList<InteractionDetectionMethod> detectionMethods = new ArrayList<InteractionDetectionMethod>();
        if (!this.isFieldEmpty(field)) {
            String[] methods = field.split(PIPE);
            for (int i = 0; i < methods.length; ++i) {
                String method = methods[i];
                String[] subFields = this.splitOnFirstColon(method);
                detectionMethods.add(new InteractionDetectionMethod(subFields[0], subFields[1]));
            }
        }
        return detectionMethods;
    }

    private boolean isFieldEmpty(String field) {
        if (field == null) {
            throw new IllegalArgumentException("Field should not be null ! Empty field is symbolised by '-'.");
        }
        return field.trim().equals(NONE);
    }
}

