/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.client.batch;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.FileSetConverter;
import psidev.psi.mi.tab.client.batch.ConvertAllFiles;
import psidev.psi.mi.tab.client.batch.FileCollector;
import psidev.psi.mi.tab.converter.xml2tab.TabConvertionException;
import psidev.psi.mi.tab.expansion.SpokeExpansion;
import psidev.psi.mi.tab.processor.ClusterPerInteractorProcessor;
import psidev.psi.mi.xml.converter.ConverterException;

public class ProcessDirectory {
    public static final Log log = LogFactory.getLog(ProcessDirectory.class);

    public static void main(String[] args) throws JAXBException, IOException, TabConvertionException, ConverterException {
        File dir;
        if (args.length != 1) {
            System.err.println("usage: ProcessDirectory <dir>");
            System.exit(1);
        }
        if (!(dir = new File(args[0])).exists()) {
            throw new IllegalArgumentException("Directory doesn't exists: " + dir.getAbsolutePath());
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("Cannot read directory: " + dir.getAbsolutePath());
        }
        long start = System.currentTimeMillis();
        FileCollector collector = new FileCollector();
        ConvertAllFiles visitor = new ConvertAllFiles(collector);
        visitor.visit(dir);
        long stop = System.currentTimeMillis();
        log.debug((Object)("Collecting all files took: " + (stop - start) + "ms"));
        System.out.println(collector.getFiles().size() + " file(s) collected.");
        start = System.currentTimeMillis();
        if (!collector.getFiles().isEmpty()) {
            FileSetConverter fsc = new FileSetConverter();
            fsc.setExpansionStrategy(new SpokeExpansion());
            fsc.setPostProcessor(new ClusterPerInteractorProcessor());
            fsc.convert(new File("C:\\intact.csv"), collector.getFiles());
        }
        stop = System.currentTimeMillis();
        log.debug((Object)("Conversion took: " + (stop - start) + "ms"));
    }
}

