/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.txt2tab;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.txt2tab.FormatterFilter;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.SimpleCvType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabulatedLineFormater {
    public static final Log log = LogFactory.getLog(TabulatedLineFormater.class);
    public static final char PIPE = '|';
    public static final char TAB = '\t';
    public static final char COLON = ':';
    public static final char NONE = '-';
    private static final int ID_BUFFER_SIZE = 64;
    private static final int BUFFER_SIZE = 512;

    private static String formatIdentifiers(Collection<CrossReference> references) {
        StringBuffer sb = new StringBuffer(64);
        if (references != null && !references.isEmpty()) {
            Iterator<CrossReference> iterator = references.iterator();
            while (iterator.hasNext()) {
                CrossReference cr = iterator.next();
                sb.append(cr.getDatabase()).append(':').append(cr.getIdentifier());
                if (!iterator.hasNext()) continue;
                sb.append('|');
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    private static String formatAliases(Collection<Alias> aliases) {
        StringBuffer sb = new StringBuffer(64);
        if (aliases != null && !aliases.isEmpty()) {
            Iterator<Alias> iterator = aliases.iterator();
            while (iterator.hasNext()) {
                Alias alias = iterator.next();
                sb.append(alias.getType()).append(':').append(alias.getName());
                if (!iterator.hasNext()) continue;
                sb.append('|');
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    private static <T extends SimpleCvType> String formatCv(Collection<T> cvs) {
        StringBuffer sb = new StringBuffer(64);
        if (cvs != null && !cvs.isEmpty()) {
            Iterator<T> iterator = cvs.iterator();
            while (iterator.hasNext()) {
                SimpleCvType cv = (SimpleCvType)iterator.next();
                sb.append(cv.getName()).append(':').append(cv.getIdentifier());
                if (!iterator.hasNext()) continue;
                sb.append('|');
            }
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String format(BinaryInteraction bi, FormatterFilter filter) {
        if (bi == null) {
            throw new IllegalArgumentException("Interaction must not be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null;");
        }
        StringBuffer sb = new StringBuffer(512);
        Interactor interactorA = bi.getInteractorA();
        sb.append(TabulatedLineFormater.formatIdentifiers(interactorA.getIdentifiers()));
        sb.append('\t');
        Interactor interactorB = bi.getInteractorB();
        sb.append(TabulatedLineFormater.formatIdentifiers(interactorB.getIdentifiers()));
        sb.append('\t');
        if (filter.isAlternativeIdentifier()) {
            sb.append(TabulatedLineFormater.formatIdentifiers(interactorA.getAlternativeIdentifiers()));
            sb.append('\t');
            sb.append(TabulatedLineFormater.formatIdentifiers(interactorB.getAlternativeIdentifiers()));
            sb.append('\t');
        } else {
            sb.append('-').append('\t');
            sb.append('-').append('\t');
        }
        if (filter.isInteractorAlias()) {
            sb.append(TabulatedLineFormater.formatAliases(interactorA.getAliases()));
            sb.append('\t');
            sb.append(TabulatedLineFormater.formatAliases(interactorB.getAliases()));
            sb.append('\t');
        } else {
            sb.append('-').append('\t');
            sb.append('-').append('\t');
        }
        sb.append(TabulatedLineFormater.formatCv(bi.getDetectionMethods()));
        sb.append('\t');
        if (filter.isFirstAuthor()) {
            if (bi.getAuthors() != null && !bi.getAuthors().isEmpty()) {
                Iterator<Author> iterator = bi.getAuthors().iterator();
                while (iterator.hasNext()) {
                    Author author = iterator.next();
                    sb.append(author.getName());
                    if (!iterator.hasNext()) continue;
                    sb.append('|');
                }
            } else {
                sb.append('-');
            }
            sb.append('\t');
        } else {
            sb.append('-').append('\t');
        }
        if (filter.isPublications()) {
            sb.append(TabulatedLineFormater.formatIdentifiers(bi.getPublications()));
            sb.append('\t');
        } else {
            sb.append('-').append('\t');
        }
        if (filter.isInteractorTaxonomy()) {
            if (interactorA.getTaxid() != null) {
                sb.append(interactorA.getTaxid());
            } else {
                sb.append('-');
            }
            sb.append('\t');
            if (interactorB.getTaxid() != null) {
                sb.append(interactorB.getTaxid());
            } else {
                sb.append('-');
            }
            sb.append('\t');
        } else {
            sb.append('-').append('\t');
            sb.append('-').append('\t');
        }
        if (filter.isInteractionTypes()) {
            sb.append(TabulatedLineFormater.formatCv(bi.getInteractionTypes()));
            sb.append('\t');
        } else {
            sb.append('-').append('\t');
        }
        if (filter.isSourceDatabase()) {
            sb.append(TabulatedLineFormater.formatIdentifiers(bi.getSourceDatabases()));
            sb.append('\t');
        } else {
            sb.append('-').append('\t');
        }
        sb.append('-');
        sb.append('\t');
        if (log.isDebugEnabled() && sb.length() > 512) {
            log.debug((Object)("StringBuffer allocated was smaller than required. allocate:512 required:" + sb.length()));
        }
        return sb.toString();
    }

    public static String format(BinaryInteraction bi) {
        return TabulatedLineFormater.format(bi, new FormatterFilter());
    }
}

