/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.CheckConfiguration;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.OntologyCheck;
import org.geneontology.util.ObjectUtil;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.StringUtil;

public class DbxrefCheck
extends AbstractCheck
implements OntologyCheck {
    protected JCheckBox missingDbCheckBox = new JCheckBox("Check for missing database");
    protected JCheckBox missingIDCheckBox = new JCheckBox("Check for missing id");
    protected JCheckBox badCharacterCheckBox = new JCheckBox("Check for non-URL characters");
    protected JCheckBox validURLCheckBox = new JCheckBox("Check that URL dbxrefs are valid URLs");
    protected JCheckBox descriptionCheckBox = new JCheckBox("Check for consistency in dbxref descriptions");
    protected ConfigurationPanel configurationPanel = new ConfigurationPanel();

    protected void updateConfiguration() {
        DbxrefCheckConfiguration dbc = (DbxrefCheckConfiguration)this.configuration;
        dbc.setDoMissingDbCheck(this.missingDbCheckBox.isSelected());
        dbc.setDoMissingIDCheck(this.missingIDCheckBox.isSelected());
        dbc.setDoBadCharactersCheck(this.badCharacterCheckBox.isSelected());
        dbc.setDoValidURLCheck(this.validURLCheckBox.isSelected());
        dbc.setDoDescriptionsCheck(this.descriptionCheckBox.isSelected());
    }

    protected void initConfiguration() {
        this.configuration.setCondition((byte)13);
    }

    protected CheckConfiguration createConfiguration() {
        return new DbxrefCheckConfiguration();
    }

    public JComponent getConfigurationPanel() {
        this.configurationPanel.removeAll();
        this.configurationPanel.setLayout(new BoxLayout(this.configurationPanel, 1));
        Font font = Preferences.getPreferences().getFont();
        this.missingDbCheckBox.setFont(font);
        this.missingIDCheckBox.setFont(font);
        this.badCharacterCheckBox.setFont(font);
        this.validURLCheckBox.setFont(font);
        this.descriptionCheckBox.setFont(font);
        this.missingDbCheckBox.setOpaque(false);
        this.missingIDCheckBox.setOpaque(false);
        this.badCharacterCheckBox.setOpaque(false);
        this.validURLCheckBox.setOpaque(false);
        this.descriptionCheckBox.setOpaque(false);
        DbxrefCheckConfiguration dbc = (DbxrefCheckConfiguration)this.configuration;
        this.missingDbCheckBox.setSelected(dbc.getDoMissingDbCheck());
        this.missingIDCheckBox.setSelected(dbc.getDoMissingIDCheck());
        this.badCharacterCheckBox.setSelected(dbc.getDoBadCharactersCheck());
        this.validURLCheckBox.setSelected(dbc.getDoValidURLCheck());
        this.descriptionCheckBox.setSelected(dbc.getDoDescriptionsCheck());
        this.configurationPanel.setBackground(Preferences.defaultBackgroundColor());
        this.configurationPanel.add(this.missingDbCheckBox);
        this.configurationPanel.add(this.missingIDCheckBox);
        this.configurationPanel.add(this.badCharacterCheckBox);
        this.configurationPanel.add(this.validURLCheckBox);
        this.configurationPanel.add(this.descriptionCheckBox);
        return this.configurationPanel;
    }

    public Collection check(OBOSession session, IdentifiedObject currentObject, byte condition, boolean checkObsoletes) {
        Iterator<Object> it2;
        LinkedList<CheckWarning> out = new LinkedList<CheckWarning>();
        HashMap descMap = null;
        boolean doDescCheck = ((DbxrefCheckConfiguration)this.configuration).getDoDescriptionsCheck();
        if (doDescCheck) {
            descMap = new HashMap();
        }
        Set<IdentifiedObject> checkSet = currentObject != null && !doDescCheck ? Collections.singleton(currentObject) : session.getObjects();
        Iterator<Object> it = checkSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            int percentage = 100 * i / session.getObjects().size();
            this.fireProgressEvent(new ProgressEvent((Object)this, percentage, "checking object " + (i + 1) + " of " + session.getObjects().size()));
            if (checkObsoletes || !TermUtil.isObsolete(io)) {
                if (doDescCheck) {
                    this.mapDbxrefs(descMap, io);
                }
                if (currentObject == null || io.equals(currentObject)) {
                    if (io instanceof DbxrefedObject) {
                        this.checkDbxrefs(((DbxrefedObject)io).getDbxrefs(), io, out, "Dbxref");
                    }
                    if (io instanceof DefinedObject) {
                        this.checkDbxrefs(((DefinedObject)io).getDefDbxrefs(), io, out, "Definition dbxref");
                    }
                    if (io instanceof SynonymedObject) {
                        it2 = ((SynonymedObject)io).getSynonyms().iterator();
                        int sindex = 0;
                        while (it2.hasNext()) {
                            Synonym s = (Synonym)it2.next();
                            this.checkDbxrefs(s.getDbxrefs(), io, out, "Synonym " + i + " dbxref ");
                            ++sindex;
                        }
                    }
                }
            }
            ++i;
        }
        if (doDescCheck) {
            it = descMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Collection c = (Collection)descMap.get(key);
                if (c == null || c.size() <= 1) continue;
                final HashMap<String, LinkedList<DbxrefDescRecord>> textMap = new HashMap<String, LinkedList<DbxrefDescRecord>>();
                it2 = c.iterator();
                while (it2.hasNext()) {
                    DbxrefDescRecord record = (DbxrefDescRecord)it2.next();
                    if (currentObject != null && !currentObject.equals(record.getObj())) continue;
                    LinkedList<DbxrefDescRecord> records = (LinkedList<DbxrefDescRecord>)textMap.get(record.getDesc());
                    if (records == null) {
                        records = new LinkedList<DbxrefDescRecord>();
                        textMap.put(record.getDesc(), records);
                    }
                    records.add(record);
                }
                if (textMap.size() <= 1) continue;
                StringBuffer message = new StringBuffer("The dbxref " + key + " has several different descriptions: ");
                it2 = textMap.keySet().iterator();
                LinkedList<AbstractAction> fixes = new LinkedList<AbstractAction>();
                if (condition != 1) {
                    AbstractAction fixAction = new AbstractAction("Remove all dbxref descriptions."){

                        public void actionPerformed(ActionEvent e) {
                            HistoryItem item = DbxrefCheck.getDbxrefDescItem(textMap, null);
                            Controller.getController().apply(item);
                            Controller.getController().getTextEditManager().forceSync();
                        }
                    };
                    fixes.add(fixAction);
                }
                int i2 = 0;
                while (it2.hasNext()) {
                    String desc;
                    if (i2 > 0 && textMap.keySet().size() > 2) {
                        message.append(", ");
                    }
                    if (i2 > 0 && i2 == textMap.keySet().size() - 1) {
                        message.append(" and ");
                    }
                    if ((desc = (String)it2.next()) != null && condition != 1) {
                        AbstractAction fixAction = new AbstractAction("Set all dbxref descriptions to '" + desc + "'."){

                            public void actionPerformed(ActionEvent e) {
                                HistoryItem item = DbxrefCheck.getDbxrefDescItem(textMap, desc);
                                Controller.getController().apply(item);
                                Controller.getController().getTextEditManager().forceSync();
                            }
                        };
                        fixes.add(fixAction);
                    }
                    Collection records = (Collection)textMap.get(desc);
                    if (desc == null) {
                        message.append("no description in ");
                    } else {
                        message.append("'" + desc + "' in ");
                    }
                    Iterator it3 = records.iterator();
                    int j = 0;
                    while (it3.hasNext()) {
                        DbxrefDescRecord record = (DbxrefDescRecord)it3.next();
                        if (j > 0 && records.size() > 2) {
                            message.append(", ");
                        }
                        if (j > 0 && j == records.size() - 1) {
                            message.append(" and ");
                        }
                        message.append("<a href='file:" + record.getObj().getID() + "'>" + record.getObj().getID() + "</a>");
                        ++j;
                    }
                    ++i2;
                }
                message.append(".");
                out.add(new CheckWarning(message.toString(), false, this, currentObject, fixes));
            }
        }
        return out;
    }

    protected static HistoryItem getDbxrefDescItem(Map textMap, String desc) {
        TermMacroHistoryItem mitem = new TermMacroHistoryItem("Set dbxref descriptions to " + desc);
        Iterator it = textMap.values().iterator();
        while (it.hasNext()) {
            Collection c = (Collection)it.next();
            Iterator it2 = c.iterator();
            while (it2.hasNext()) {
                HistoryItem item;
                String key;
                Dbxref ref;
                Iterator dit;
                IdentifiedObject dbo;
                DbxrefDescRecord record = (DbxrefDescRecord)it2.next();
                IdentifiedObject io = record.getObj();
                if (io instanceof DbxrefedObject) {
                    dbo = (DbxrefedObject)io;
                    dit = dbo.getDbxrefs().iterator();
                    while (dit.hasNext()) {
                        ref = (Dbxref)dit.next();
                        key = ref.getDatabase() + ":" + ref.getID();
                        if (!key.equals(record.getDbxref()) || ObjectUtil.equals((Object)ref.getDesc(), (Object)desc)) continue;
                        item = new DelDbxrefHistoryItem(record.getObj().getID(), ref, false, null);
                        mitem.addHistoryItem(item);
                        ref = (Dbxref)ref.clone();
                        ref.setDesc(desc);
                        item = new AddDbxrefHistoryItem(record.getObj().getID(), ref, false, null);
                        mitem.addHistoryItem(item);
                    }
                }
                if (io instanceof DefinedObject) {
                    dbo = (DefinedObject)io;
                    dit = dbo.getDefDbxrefs().iterator();
                    while (dit.hasNext()) {
                        ref = (Dbxref)dit.next();
                        key = ref.getDatabase() + ":" + ref.getID();
                        if (!key.equals(record.getDbxref()) || ObjectUtil.equals((Object)ref.getDesc(), (Object)desc)) continue;
                        item = new DelDbxrefHistoryItem(record.getObj().getID(), ref, true, null);
                        mitem.addHistoryItem(item);
                        ref = (Dbxref)ref.clone();
                        ref.setDesc(desc);
                        item = new AddDbxrefHistoryItem(record.getObj().getID(), ref, true, null);
                        mitem.addHistoryItem(item);
                    }
                }
                if (!(io instanceof SynonymedObject)) continue;
                dbo = (SynonymedObject)io;
                Iterator sit = dbo.getSynonyms().iterator();
                while (sit.hasNext()) {
                    Synonym s = (Synonym)sit.next();
                    Iterator dit2 = s.getDbxrefs().iterator();
                    while (dit2.hasNext()) {
                        Dbxref ref2 = (Dbxref)dit2.next();
                        String key2 = ref2.getDatabase() + ":" + ref2.getID();
                        if (!key2.equals(record.getDbxref()) || ObjectUtil.equals((Object)ref2.getDesc(), (Object)desc)) continue;
                        HistoryItem item2 = new DelDbxrefHistoryItem(record.getObj().getID(), ref2, false, s.getText());
                        mitem.addHistoryItem(item2);
                        ref2 = (Dbxref)ref2.clone();
                        ref2.setDesc(desc);
                        item2 = new AddDbxrefHistoryItem(record.getObj().getID(), ref2, false, s.getText());
                        mitem.addHistoryItem(item2);
                    }
                }
            }
        }
        return mitem;
    }

    protected void mapDbxrefs(Map descMap, IdentifiedObject io) {
        Collection c = TermUtil.getAllDbxrefs(io);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Dbxref dbxref = (Dbxref)it.next();
            this.addMapRecord(descMap, dbxref, io);
        }
    }

    protected void addMapRecord(Map descMap, Dbxref ref, IdentifiedObject obj) {
        String key = ref.getDatabase() + ":" + ref.getID();
        DbxrefDescRecord record = new DbxrefDescRecord(obj, key, ref.getDesc());
        LinkedList<DbxrefDescRecord> c = (LinkedList<DbxrefDescRecord>)descMap.get(key);
        if (c == null) {
            c = new LinkedList<DbxrefDescRecord>();
            descMap.put(key, c);
        }
        c.add(record);
    }

    protected void checkDbxrefs(Set dbxrefs, IdentifiedObject currentObject, LinkedList out, String title) {
        Iterator it = dbxrefs.iterator();
        int i = 0;
        while (it.hasNext()) {
            Dbxref ref = (Dbxref)it.next();
            this.checkDbxref(ref, currentObject, out, i, title);
            ++i;
        }
    }

    protected static String getWarningHeader(String title, int index, IdentifiedObject currentObject) {
        String indexStr = "";
        if (index > 0) {
            indexStr = " " + (index + 1);
        }
        return title + indexStr + " of <a href='file:" + currentObject.getID() + "'>" + currentObject.getID() + "</a> ";
    }

    protected static boolean isURLStarter(String prefix) {
        String[] starters = new String[]{"ftp", "http", "https", "telnet", "ssh"};
        for (int i = 0; i < starters.length; ++i) {
            if (!prefix.equalsIgnoreCase(starters[i])) continue;
            return true;
        }
        return false;
    }

    protected void checkDbxref(Dbxref ref, IdentifiedObject currentObject, LinkedList out, int index, String title) {
        DbxrefCheckConfiguration dbconfig = (DbxrefCheckConfiguration)this.configuration;
        if (dbconfig.getDoMissingDbCheck() && ref.getDatabase().length() == 0) {
            out.add(new CheckWarning(DbxrefCheck.getWarningHeader(title, index, currentObject) + " has no database name.", false, this, currentObject));
        }
        if (dbconfig.getDoMissingIDCheck() && ref.getID().length() == 0) {
            out.add(new CheckWarning(DbxrefCheck.getWarningHeader(title, index, currentObject) + " has no id string.", false, this, currentObject));
        }
        if (dbconfig.getDoValidURLCheck() && DbxrefCheck.isURLStarter(ref.getDatabase())) {
            try {
                new URL(ref.getDatabase() + ":" + ref.getID());
            }
            catch (MalformedURLException ex) {
                out.add(new CheckWarning(DbxrefCheck.getWarningHeader(title, index, currentObject) + " has a database prefix that looks like a URL prefix, but is not a valid URL.", false, this, currentObject));
            }
        }
        if (!(!dbconfig.getDoBadCharactersCheck() || StringUtil.containsOnlyValidURICharacters((String)ref.getID()) && StringUtil.containsOnlyValidURICharacters((String)ref.getDatabase()))) {
            out.add(new CheckWarning(DbxrefCheck.getWarningHeader(title, index, currentObject) + " contains non-URI characters.", false, this, currentObject));
        }
    }

    public String getID() {
        return "dbxref_check";
    }

    public String getDescription() {
        return "Dbxref check";
    }

    protected static class DbxrefDescRecord {
        protected IdentifiedObject obj;
        protected String dbxref;
        protected String desc;
        protected boolean complained = false;

        public DbxrefDescRecord(IdentifiedObject obj, String dbxref, String desc) {
            this.obj = obj;
            this.dbxref = dbxref;
            this.desc = desc;
        }

        public void setComplained(boolean complained) {
            this.complained = complained;
        }

        public boolean getComplained() {
            return this.complained;
        }

        public String getDbxref() {
            return this.dbxref;
        }

        public void setDbxref(String dbxref) {
            this.dbxref = dbxref;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public IdentifiedObject getObj() {
            return this.obj;
        }

        public void setObj(IdentifiedObject obj) {
            this.obj = obj;
        }
    }

    public static class DbxrefCheckConfiguration
    extends CheckConfiguration {
        protected boolean doMissingDbCheck = true;
        protected boolean doMissingIDCheck = true;
        protected boolean doBadCharactersCheck = true;
        protected boolean doValidURLCheck = true;
        protected boolean doDescriptionsCheck = true;

        public boolean getDoBadCharactersCheck() {
            return this.doBadCharactersCheck;
        }

        public void setDoBadCharactersCheck(boolean doBadCharactersCheck) {
            this.doBadCharactersCheck = doBadCharactersCheck;
        }

        public boolean getDoDescriptionsCheck() {
            return this.doDescriptionsCheck;
        }

        public void setDoDescriptionsCheck(boolean doDescriptionsCheck) {
            this.doDescriptionsCheck = doDescriptionsCheck;
        }

        public boolean getDoMissingDbCheck() {
            return this.doMissingDbCheck;
        }

        public void setDoMissingDbCheck(boolean doMissingDbCheck) {
            this.doMissingDbCheck = doMissingDbCheck;
        }

        public boolean getDoMissingIDCheck() {
            return this.doMissingIDCheck;
        }

        public void setDoMissingIDCheck(boolean doMissingIDCheck) {
            this.doMissingIDCheck = doMissingIDCheck;
        }

        public boolean getDoValidURLCheck() {
            return this.doValidURLCheck;
        }

        public void setDoValidURLCheck(boolean doValidURLCheck) {
            this.doValidURLCheck = doValidURLCheck;
        }
    }

    protected class ConfigurationPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        protected ConfigurationPanel() {
        }

        public void actionPerformed(ActionEvent e) {
            DbxrefCheck.this.updateConfiguration();
        }
    }
}

