/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.FileAdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.SerialAdapter;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.test.TestUtil;

public class DatamodelTest
extends TestCase {
    protected OBOSession session;
    protected OBOSession serialSession;

    public static OBOSession createSerialSession(OBOSession session) throws DataAdapterException, IOException {
        SerialAdapter serialadapter = new SerialAdapter();
        FileAdapterConfiguration serialconfig = new FileAdapterConfiguration();
        File outFile = File.createTempFile("test", "serial");
        outFile.deleteOnExit();
        serialconfig.setWritePath(outFile.getAbsolutePath());
        serialadapter.doOperation(IOOperation.WRITE, (AdapterConfiguration)serialconfig, session);
        serialconfig = new FileAdapterConfiguration();
        serialconfig.getReadPaths().add(outFile.getAbsolutePath());
        OBOSession session2 = (OBOSession)serialadapter.doOperation(IOOperation.READ, (AdapterConfiguration)serialconfig, null);
        outFile.delete();
        return session2;
    }

    public void setUp() throws Exception {
        this.createSessions();
    }

    protected void createSessions() throws DataAdapterException, IOException {
        this.session = TestUtil.createSession();
        this.serialSession = DatamodelTest.createSerialSession(this.session);
    }

    public void testObjectContinuity() {
        DatamodelTest.assertTrue((String)"OBO and Serial versions of ontology should have the same number of objects", (this.session.getObjects().size() == this.session.getObjects().size() ? 1 : 0) != 0);
        Iterator it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            Link link;
            IdentifiedObject io = (IdentifiedObject)it.next();
            IdentifiedObject sio = this.serialSession.getObject(io.getID());
            DatamodelTest.assertNotNull((String)("Serial session did not contain " + io), (Object)sio);
            DatamodelTest.assertTrue((String)("Serial version of " + io + " should equal obo version"), (boolean)io.equals(sio));
            DatamodelTest.assertTrue((String)("Serial version of " + io + " should have same class as obo version"), (boolean)io.getClass().equals(sio.getClass()));
            DatamodelTest.assertTrue((String)("Serial version of " + io + " should have the same hash as obo version"), (io.hashCode() == sio.hashCode() ? 1 : 0) != 0);
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lio = (LinkedObject)io;
            LinkedObject slio = (LinkedObject)sio;
            DatamodelTest.assertTrue((String)("Serial version of " + io + " should have same children as obo version"), (boolean)((Object)lio.getChildren()).equals(slio.getChildren()));
            DatamodelTest.assertTrue((String)("Serial version of " + io + " should have same parents as obo version"), (boolean)((Object)lio.getParents()).equals(slio.getParents()));
            Iterator it2 = lio.getParents().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                Link slink = null;
                Iterator it3 = slio.getParents().iterator();
                while (it3.hasNext()) {
                    Link temp = (Link)it3.next();
                    if (!temp.equals(link)) continue;
                    slink = temp;
                    break;
                }
                DatamodelTest.assertNotNull((String)("Serial version of " + link + " should give true equals() response"), (Object)slink);
                DatamodelTest.assertTrue((String)("Serial version of " + link + " and OBO version should have same hash codes"), (slink.hashCode() == link.hashCode() ? 1 : 0) != 0);
                DatamodelTest.assertTrue((String)("Serial version of " + link + " should be contained in parents of OBO version of " + slio + ", slio.getParents() = " + slio.getParents()), (boolean)slio.getParents().contains(link));
            }
            it2 = slio.getParents().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                DatamodelTest.assertTrue((String)("OBO version of " + link + " should be contained in parents of serial version of " + lio), (boolean)lio.getParents().contains(link));
            }
            DatamodelTest.assertTrue((String)("Serial version of " + lio + " should have the same hash as obo version"), (lio.hashCode() == slio.hashCode() ? 1 : 0) != 0);
        }
    }

    protected void doLinkTest(OBOSession session) throws DataAdapterException, IOException {
        Iterator it = session.getObjects().iterator();
        while (it.hasNext()) {
            Link tlink;
            Iterator it3;
            boolean found;
            Link link;
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            Iterator it2 = lo.getParents().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                found = false;
                it3 = link.getParent().getChildren().iterator();
                while (it3.hasNext()) {
                    tlink = (Link)it3.next();
                    if (!tlink.equals(link)) continue;
                    DatamodelTest.assertTrue((String)("Twinned parent child links should be equal AND identical: " + link), (tlink == link ? 1 : 0) != 0);
                    found = true;
                }
                DatamodelTest.assertTrue((String)("Parent links should be twinned with child links: " + link), (boolean)found);
            }
            it2 = lo.getChildren().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                found = false;
                it3 = link.getChild().getParents().iterator();
                while (it3.hasNext()) {
                    tlink = (Link)it3.next();
                    if (!tlink.equals(link)) continue;
                    DatamodelTest.assertTrue((String)("Twinned parent child links should be equal AND identical: " + link), (tlink == link ? 1 : 0) != 0);
                    found = true;
                }
                DatamodelTest.assertTrue((String)("Parent links should be twinned with child links: " + link), (boolean)found);
            }
        }
    }
}

