/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.geneontology.oboedit.datamodel.ExplanationUtil;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.impl.FilteredReasonedLinkDatabase;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.event.SelectionEvent;
import org.geneontology.oboedit.gui.event.SelectionListener;
import org.geneontology.oboedit.gui.event.TermHyperlinkListener;
import org.geneontology.util.ObjectUtil;

public class ExplanationPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected JEditorPane field = new JEditorPane("text/html", "<html></html>");
    protected JScrollPane scroller = new JScrollPane(this.field, 20, 31);
    protected SelectionListener termSelectListener = new SelectionListener(){

        public void select(SelectionEvent e) {
            ExplanationPlugin.this.update(true);
        }
    };
    TermHyperlinkListener listener = new TermHyperlinkListener(){

        public void linkSelected(String param, Link link) {
            if (ObjectUtil.equals((Object)param, (Object)"EXPAND")) {
                ExplanationPlugin.this.subExplanations.add(link);
                Vector links = ExplanationPlugin.this.controller.getSelectedTerms();
                ExplanationPlugin.this.field.setText(ExplanationPlugin.this.getExplanation(links, ExplanationPlugin.this.subExplanations));
                ExplanationPlugin.this.field.scrollToReference(link.getChild().getID().replace(':', '_') + "-" + link.getType().getID().replace(':', '_') + "-" + link.getParent().getID().replace(':', '_'));
            } else if (ObjectUtil.equals((Object)param, (Object)"HIDE")) {
                ExplanationPlugin.this.subExplanations.remove(link);
                Vector links = ExplanationPlugin.this.controller.getSelectedTerms();
                ExplanationPlugin.this.field.setText(ExplanationPlugin.this.getExplanation(links, ExplanationPlugin.this.subExplanations));
                ExplanationPlugin.this.field.scrollToReference(link.getChild().getID().replace(':', '_') + "-" + link.getType().getID().replace(':', '_') + "-" + link.getParent().getID().replace(':', '_'));
            } else {
                Controller.getController().select(link);
            }
        }

        public void termSelected(String param, IdentifiedObject io) {
            if (io instanceof LinkedObject) {
                Controller.getController().select((LinkedObject)io);
            }
        }

        public void actionSelected(String param, String val) {
        }
    };
    protected Collection subExplanations;
    protected JCheckBox documentationCheckbox = new JCheckBox("Show verbose explanations");

    public ExplanationPlugin() {
        this.setLayout(new BorderLayout());
        this.field.setEditable(false);
        this.field.addHyperlinkListener(this.listener);
        this.add(this.scroller, "Center");
        this.add(this.documentationCheckbox, "South");
        this.documentationCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExplanationPlugin.this.update(false);
            }
        });
    }

    protected void update(boolean resetExpansionState) {
        this.listener.setLinkDatabase(Controller.getController().getFullReasoner());
        if (resetExpansionState) {
            this.subExplanations = new LinkedList();
        }
        Vector links = this.controller.getSelectedTerms();
        this.field.setText(this.getExplanation(links, this.subExplanations));
    }

    private String getExplanation(Collection links, Collection subExplanations) {
        StringBuffer out = new StringBuffer();
        FilteredReasonedLinkDatabase reasoner = Controller.getController().getReasonedLinkDatabase();
        HashMap cache = new HashMap();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            out.append(ExplanationUtil.getDescriptionReasoned(reasoner, Controller.getController().getPrimarySelector().getLinkDatabase(), link, subExplanations, cache, this.documentationCheckbox.isSelected()));
        }
        return out.toString();
    }

    public void init() {
        this.documentationCheckbox.setFont(Controller.getController().getPreferences().getFont());
        this.controller.addListener(this.termSelectListener);
        this.update(true);
    }

    public void cleanup() {
        this.controller.removeListener(this.termSelectListener);
    }

    public String getName() {
        return "Explanation Plugin";
    }
}

