/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.PathThread;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.LineRenderer;
import org.geneontology.oboedit.gui.OBOCellRenderer;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.HistoryAppliedEvent;
import org.geneontology.oboedit.gui.event.HistoryListener;
import org.geneontology.oboedit.gui.event.ReasonerStatusEvent;
import org.geneontology.oboedit.gui.event.ReasonerStatusListener;
import org.geneontology.oboedit.gui.event.ReconfigEvent;
import org.geneontology.oboedit.gui.event.ReconfigListener;
import org.geneontology.oboedit.gui.event.SelectionEvent;
import org.geneontology.oboedit.gui.event.SelectionListener;
import org.geneontology.oboedit.gui.event.SubSelectEvent;
import org.geneontology.oboedit.gui.event.SubSelectListener;
import org.geneontology.swing.PathTreeModel;
import org.geneontology.swing.plaf.DragFriendlyTreeUI;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class DAGView
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected RestrictedJTree tree;
    protected JScrollPane pane;
    protected JLabel emptyLabel = new JLabel("No terms selected");
    protected JLabel statusLabel = new JLabel("No paths loaded");
    protected JCheckBox multiTermCheckbox = new JCheckBox("Show paths to multiple selected terms");
    protected JCheckBox trimPathsCheckbox = new JCheckBox("Collapse already shown paths");
    protected JCheckBox localPathsCheckbox = new JCheckBox("Calculate paths based on primary selector");
    protected JCheckBox showNonTransitiveCheckbox = new JCheckBox("Show non-transitive paths");
    protected JButton configButton = new JButton("Config");
    protected JProgressBar progressBar = new JProgressBar();
    protected ReusableProgressEvent pe = new ReusableProgressEvent((Object)this);
    protected DAGViewConfig configuration = new DAGViewConfig();
    protected SubSelectListener subSelectListener;
    protected SelectionListener termSelectListener;
    protected ReasonerStatusListener reasonerListener;
    protected HistoryListener historyListener;
    TreeModel model;
    ReconfigListener reconfigListener = new ReconfigListener(){

        public void configReloaded(ReconfigEvent e) {
            DAGView.this.setToolTips();
        }
    };
    MouseInputAdapter clickListener = new MouseInputAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isMiddleMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                TreePath path = DAGView.this.tree.getSelectionPath();
                TreePath[] paths = new TreePath[]{path};
                DAGView.this.controller.select(paths);
            }
        }
    };
    protected DAGProgressListener pl = new DAGProgressListener();
    protected PathRunnable pathRunnable = null;

    protected boolean multiTerm() {
        return this.multiTermCheckbox.isSelected();
    }

    public String getName() {
        return "DAG Viewer";
    }

    public ComponentConfiguration getConfiguration() {
        this.configuration.setMultiSelect(this.multiTermCheckbox.isSelected());
        this.configuration.setTrimPaths(this.trimPaths());
        this.configuration.setShowLocal(this.showLocalPaths());
        this.configuration.setShowNonTransitive(this.showNonTransitive());
        return this.configuration;
    }

    public void setConfiguration(ComponentConfiguration configuration) {
        if (configuration instanceof DAGViewConfig) {
            this.configuration = (DAGViewConfig)configuration;
        }
        this.multiTermCheckbox.setSelected(this.configuration.getMultiSelect());
        this.trimPathsCheckbox.setSelected(this.configuration.getTrimPaths());
        this.localPathsCheckbox.setSelected(this.configuration.getShowLocal());
        this.showNonTransitiveCheckbox.setSelected(this.configuration.getShowNonTransitive());
    }

    public DAGView() {
        this.trimPathsCheckbox.setToolTipText("Collapse parts of paths that have already been shown to greatly speed up DAG Viewer redraws.");
        this.multiTermCheckbox.setToolTipText("If multiple terms are selected, show paths to all of them.");
        this.localPathsCheckbox.setToolTipText("Show paths as calculated from the current primary selector, including filters, etc. If this box is not selected, filters are ignored.");
        this.showNonTransitiveCheckbox.setToolTipText("Show paths that contain non-transitive relationships. Enabling this option will cause the view to become very confusing in some ontologies");
        this.progressBar.setStringPainted(true);
        this.multiTermCheckbox.setOpaque(false);
        this.trimPathsCheckbox.setOpaque(false);
        this.localPathsCheckbox.setOpaque(false);
        this.showNonTransitiveCheckbox.setOpaque(false);
        ActionListener updateListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DAGView.this.update();
            }
        };
        this.multiTermCheckbox.addActionListener(updateListener);
        this.trimPathsCheckbox.addActionListener(updateListener);
        this.localPathsCheckbox.addActionListener(updateListener);
        this.showNonTransitiveCheckbox.addActionListener(updateListener);
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DAGView.this.showConfigurationWindow();
            }
        });
    }

    public void setToolTips() {
        if (this.controller.showToolTips()) {
            ToolTipManager.sharedInstance().registerComponent(this.tree);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this.tree);
        }
    }

    public void init() {
        this.removeAll();
        this.configButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        this.progressBar.setFont(this.controller.getDefaultFont());
        selectionModel.setSelectionMode(4);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(200, 200));
        this.setOpaque(true);
        this.setBackground(Preferences.defaultBackgroundColor());
        this.tree = new RestrictedJTree();
        this.tree.setUI((TreeUI)this.getDefaultUI());
        this.tree.setCellRenderer(new OBOCellRenderer(this.controller));
        this.tree.setSelectionModel(selectionModel);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.pane = new JScrollPane(this.tree);
        this.multiTermCheckbox.setFont(this.controller.getDefaultFont());
        this.trimPathsCheckbox.setFont(this.controller.getDefaultFont());
        this.localPathsCheckbox.setFont(this.controller.getDefaultFont());
        this.showNonTransitiveCheckbox.setFont(this.controller.getDefaultFont());
        this.statusLabel.setFont(this.controller.getDefaultFont());
        this.configButton.setFont(this.controller.getDefaultFont());
        JPanel controlPanel = new JPanel();
        controlPanel.setOpaque(false);
        controlPanel.setLayout(new BorderLayout());
        controlPanel.add((Component)this.configButton, "East");
        controlPanel.add((Component)this.statusLabel, "Center");
        this.add("Center", this.pane);
        this.add("South", controlPanel);
        this.emptyLabel.setFont(this.controller.getDefaultFont());
        this.emptyLabel.setHorizontalAlignment(0);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.update();
        this.subSelectListener = new SubSelectListener(){

            public void selectObject(SubSelectEvent e) {
                if (!DAGView.this.multiTerm()) {
                    DAGView.this.update();
                }
            }
        };
        this.termSelectListener = new SelectionListener(){

            public void select(SelectionEvent e) {
                if (DAGView.this.multiTerm()) {
                    DAGView.this.update();
                }
            }
        };
        this.reasonerListener = new ReasonerStatusListener(){

            public void statusChanged(ReasonerStatusEvent e) {
                DAGView.this.update();
            }
        };
        this.historyListener = new HistoryListener(){

            public void applied(HistoryAppliedEvent event) {
                DAGView.this.update();
            }

            public void reversed(HistoryAppliedEvent event) {
                DAGView.this.update();
            }
        };
        this.controller.addListener(this.subSelectListener);
        this.controller.addListener(this.termSelectListener);
        this.controller.addListener(this.reconfigListener);
        this.controller.addListener(this.reasonerListener);
        this.controller.addListener(this.historyListener);
        this.tree.addMouseListener(this.clickListener);
        this.setToolTips();
    }

    public void cleanup() {
        this.controller.removeListener(this.reconfigListener);
        this.controller.removeListener(this.subSelectListener);
        this.controller.removeListener(this.termSelectListener);
        this.controller.removeListener(this.reasonerListener);
        this.controller.removeListener(this.historyListener);
    }

    protected TreePath trimPathToNode(TreePath path, Object node) {
        Object[] objects = path.getPath();
        int length = 0;
        boolean stop = false;
        for (int i = objects.length - 1; i >= 0; --i) {
            if (!objects[i].equals(node)) continue;
            if (stop) {
                length = i + 1;
                break;
            }
            stop = true;
        }
        if (length == 0) {
            return path;
        }
        Object[] nodes = new Object[length];
        for (int i = 0; i < length; ++i) {
            nodes[i] = objects[i];
        }
        return new TreePath(nodes);
    }

    public void finishUpdate(TreePath[] paths) {
        if (paths.length == 0) {
            if (this.isAncestorOf(this.progressBar)) {
                this.remove(this.progressBar);
                this.validate();
            }
            if (this.isAncestorOf(this.pane)) {
                this.remove(this.pane);
            }
            this.validate();
        } else {
            this.progressBar.setString("Setting model...");
            this.progressBar.repaint();
            this.progressBar.setString("Selecting paths...");
            this.progressBar.repaint();
            for (int i = 0; i < paths.length; ++i) {
                if (!this.tree.isVisible(paths[i])) continue;
                this.tree.addSelectionPath(paths[i]);
            }
            if (this.isAncestorOf(this.progressBar)) {
                this.remove(this.progressBar);
                this.validate();
            }
            if (!this.isAncestorOf(this.pane)) {
                this.add(this.pane, "Center");
                this.validate();
            }
        }
        this.statusLabel.setText(paths.length + " path" + (paths.length == 1 ? "" : "s") + " loaded.");
        this.repaint();
    }

    protected void showConfigurationWindow() {
        JButton closeButton = new JButton("Close");
        closeButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        closeButton.setFont(Controller.getController().getPreferences().getFont());
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 1));
        checkboxPanel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        checkboxPanel.add(this.multiTermCheckbox);
        checkboxPanel.add(Box.createVerticalStrut(2));
        checkboxPanel.add(this.trimPathsCheckbox);
        checkboxPanel.add(Box.createVerticalStrut(2));
        checkboxPanel.add(this.localPathsCheckbox);
        checkboxPanel.add(Box.createVerticalStrut(2));
        checkboxPanel.add(this.showNonTransitiveCheckbox);
        checkboxPanel.add(Box.createVerticalStrut(10));
        checkboxPanel.add(closeButton);
        final JDialog dialog = new JDialog((Frame)Controller.getController().getFrame(), true);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.setContentPane(checkboxPanel);
        dialog.pack();
        dialog.show();
    }

    public void update() {
        if (this.pathRunnable != null) {
            this.pathRunnable.halt();
        }
        if (this.controller.getSelectedTerms().size() == 0) {
            if (!this.isAncestorOf(this.emptyLabel)) {
                this.remove(this.pane);
                this.add(this.emptyLabel, "Center");
                this.validate();
                this.repaint();
            }
        } else {
            if (this.isAncestorOf(this.emptyLabel)) {
                this.remove(this.emptyLabel);
            }
            if (this.isAncestorOf(this.pane)) {
                this.remove(this.pane);
            }
            if (!this.isAncestorOf(this.progressBar)) {
                this.add(this.progressBar, "Center");
            }
            this.validate();
            this.repaint();
            this.pathRunnable = new PathRunnable();
            Thread thread = new Thread(this.pathRunnable);
            thread.start();
        }
    }

    protected DragFriendlyTreeUI getDefaultUI() {
        DAGViewUI ui = new DAGViewUI();
        return ui;
    }

    private static String getNSpaces(int depth) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            out.append(' ');
        }
        return out.toString();
    }

    public boolean showNonTransitive() {
        return this.showNonTransitiveCheckbox.isSelected();
    }

    public boolean showLocalPaths() {
        return this.localPathsCheckbox.isSelected();
    }

    public boolean trimPaths() {
        return this.trimPathsCheckbox.isSelected();
    }

    private class RestrictedJTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        protected Runnable visibleRunnable = new Runnable(){

            public void run() {
                RestrictedJTree.this.makeVisible(RestrictedJTree.this.path);
            }
        };
        boolean expandAllowed = false;
        TreePath path;

        private RestrictedJTree() {
        }

        public void refresh() {
            this.refresh(false);
        }

        public void refresh(boolean fromThread) {
            if (DAGView.this.model == null) {
                return;
            }
            this.expandAllowed = true;
            this.expandPaths(fromThread);
            this.expandAllowed = false;
            this.repaint();
        }

        protected void expandPaths(boolean fromThread) {
            Set seenem = TermUtil.mallocSet();
            Object root = this.getModel().getRoot();
            this.expandPaths(null, root, seenem, fromThread);
            TermUtil.freeSet(seenem);
        }

        protected void expandPaths(TreePath parentPath, Object o, Set seenem, boolean fromThread) {
            if (DAGView.this.trimPaths() && seenem.contains(o)) {
                return;
            }
            seenem.add(o);
            TreePath path = parentPath == null ? new TreePath(o) : parentPath.pathByAddingChild(o);
            this.makeVisible(path);
            int childCount = this.getModel().getChildCount(o);
            for (int i = 0; i < childCount; ++i) {
                this.expandPaths(path, this.getModel().getChild(o, i), seenem, fromThread);
            }
        }

        public String getToolTipText(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return null;
            }
            Object o = path.getLastPathComponent();
            if (!(o instanceof Link)) {
                return null;
            }
            LinkedObject child = ((Link)o).getChild();
            return child.getID();
        }

        public void makeVisible(TreePath path) {
            this.expandAllowed = true;
            super.makeVisible(path);
            this.expandAllowed = false;
        }

        protected class VisibleRunnable
        implements Runnable {
            protected TreePath path;

            public VisibleRunnable(TreePath path) {
                this.path = path;
            }

            public void run() {
                RestrictedJTree.this.makeVisible(this.path);
            }
        }
    }

    public class DAGViewUI
    extends DragFriendlyTreeUI {
        protected int[] triangleXBuffer = new int[3];
        protected int[] triangleYBuffer = new int[3];

        protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right, boolean isLeaf, TreePath path) {
            if (this.getCellRenderer() instanceof LineRenderer) {
                LineRenderer lineRenderer = (LineRenderer)((Object)this.getCellRenderer());
                lineRenderer.paintLine(g, c, y, left, right, isLeaf, path);
            }
        }
    }

    protected class PathRunnable
    implements Runnable {
        protected boolean halt = false;
        PathThread pathThread;
        TreePath[] paths = null;
        Runnable finishUpdate = new Runnable(){

            public void run() {
                DAGView.this.finishUpdate(PathRunnable.this.paths);
            }
        };

        protected PathRunnable() {
        }

        public void halt() {
            this.halt = true;
            if (this.pathThread != null) {
                this.pathThread.halt();
            }
        }

        public void run() {
            this.halt = false;
            this.paths = new TreePath[0];
            HashSet<IdentifiedObject> termSet = new HashSet<IdentifiedObject>();
            if (DAGView.this.multiTerm()) {
                Iterator it = DAGView.this.controller.getSelectedTerms().iterator();
                while (it.hasNext()) {
                    Link link = (Link)it.next();
                    termSet.add(link.getChild());
                }
            } else {
                termSet.add(DAGView.this.controller.getSubSelection());
            }
            HashSet<TreePath> out = new HashSet<TreePath>();
            LinkDatabase linkDatabase = DAGView.this.showLocalPaths() ? DAGView.this.controller.getPrimarySelector().getLinkDatabase() : DAGView.this.controller.getCurrentLinkDatabase();
            Iterator it2 = termSet.iterator();
            DAGView.this.pl.setSize(termSet.size());
            int i = 0;
            while (it2.hasNext()) {
                this.pathThread = TermUtil.getPathThread((LinkedObject)it2.next(), linkDatabase);
                this.pathThread.addProgressListener(DAGView.this.pl);
                DAGView.this.pl.setPassnum(i);
                try {
                    this.pathThread.start();
                    this.pathThread.join();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (!this.halt) {
                    DAGView.this.pe.setFastVal(100);
                    DAGView.this.pe.setDescription("Copying paths...");
                    if (this.pathThread == null) {
                        return;
                    }
                    if (this.pathThread.halted()) {
                        return;
                    }
                    Collection v = this.pathThread.getPaths();
                    if (v == null) {
                        return;
                    }
                    Iterator it = v.iterator();
                    while (it.hasNext()) {
                        TreePath path = (TreePath)it.next();
                        if (TermUtil.pathIsCircular(path, new HashSet()) || !DAGView.this.showNonTransitive() && TermUtil.pathContainsNonTransitive(path)) continue;
                        out.add(path);
                    }
                }
                ++i;
            }
            this.paths = new TreePath[out.size()];
            it2 = out.iterator();
            i = 0;
            while (it2.hasNext()) {
                TreePath path;
                this.paths[i] = path = (TreePath)it2.next();
                ++i;
            }
            DAGView.this.pe.setFastVal(100);
            DAGView.this.pe.setDescription("Creating model...");
            DAGView.this.model = new PathTreeModel(this.paths);
            DAGView.this.pe.setFastVal(100);
            DAGView.this.pe.setDescription("Setting model...");
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!PathRunnable.this.halt) {
                            ((PathRunnable)PathRunnable.this).DAGView.this.tree.setModel(((PathRunnable)PathRunnable.this).DAGView.this.model);
                        }
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
            DAGView.this.model = new PathTreeModel(this.paths);
            DAGView.this.pe.setFastVal(100);
            DAGView.this.pe.setDescription("Refreshing tree...");
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!PathRunnable.this.halt) {
                            ((PathRunnable)PathRunnable.this).DAGView.this.tree.refresh(true);
                        }
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                SwingUtilities.invokeLater(this.finishUpdate);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.pathThread = null;
            this.halt = false;
            this.pathThread = null;
        }
    }

    protected class DAGProgressListener
    implements ProgressListener {
        ReusableProgressEvent pe;
        protected int passnum = 0;
        protected int size = 1;
        protected Runnable updateProgress = new Runnable(){

            public void run() {
                int percent = DAGProgressListener.this.pe.getFastVal();
                if (DAGView.this.multiTerm()) {
                    percent = (percent + DAGProgressListener.this.passnum * 100) / DAGProgressListener.this.size;
                }
                ((DAGProgressListener)DAGProgressListener.this).DAGView.this.progressBar.setString(DAGProgressListener.this.pe.getDescription() + " " + percent + "%");
                ((DAGProgressListener)DAGProgressListener.this).DAGView.this.progressBar.setValue(percent);
            }
        };

        protected DAGProgressListener() {
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setPassnum(int passnum) {
            this.passnum = passnum;
        }

        public void progressMade(ProgressEvent pe) {
            this.pe = (ReusableProgressEvent)pe;
            try {
                SwingUtilities.invokeLater(this.updateProgress);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class DAGViewConfig
    implements ComponentConfiguration {
        protected boolean multiSelect = false;
        protected boolean trimPaths = true;
        protected boolean showLocal = false;
        protected boolean showNonTransitive = false;

        public void setShowNonTransitive(boolean showNonTransitive) {
            this.showNonTransitive = showNonTransitive;
        }

        public boolean getShowNonTransitive() {
            return this.showNonTransitive;
        }

        public void setMultiSelect(boolean multiSelect) {
            this.multiSelect = multiSelect;
        }

        public boolean getMultiSelect() {
            return this.multiSelect;
        }

        public void setTrimPaths(boolean trimPaths) {
            this.trimPaths = trimPaths;
        }

        public boolean getTrimPaths() {
            return this.trimPaths;
        }

        public void setShowLocal(boolean showLocal) {
            this.showLocal = showLocal;
        }

        public boolean getShowLocal() {
            return this.showLocal;
        }
    }
}

