/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geneontology.commandline.ArgumentSignature;
import org.geneontology.commandline.CommandLineParser;
import org.geneontology.commandline.EnumArgumentSignature;
import org.geneontology.commandline.FlagSpec;
import org.geneontology.commandline.OrderedArgumentSignature;
import org.geneontology.commandline.Tag;
import org.geneontology.commandline.TagSpec;
import org.geneontology.commandline.UnorderedArgumentSignature;
import org.geneontology.commandline.ValueSpec;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.DefaultIDGenerator;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.impl.AnnotatedObjectImpl;
import org.geneontology.oboedit.datamodel.impl.DefaultOperationModel;
import org.geneontology.oboedit.datamodel.impl.NestedValueImpl;
import org.geneontology.oboedit.datamodel.impl.OBOSessionImpl;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.VectorFilter;

public class OBOMerge {
    public static final int FAIL_ON_ANY_CLASH = 0;
    public static final int FAIL_ON_LIKELY_CLASH = 1;
    public static final int REASSIGN_IDS = 2;
    public static final int NEVER_UPDATE = 0;
    public static final int UPDATE_LIKELY_CLASHES = 1;
    public static final int UPDATE_ALL_CLASHES = 2;
    public static final int POSSIBLE = 0;
    public static final int LIKELY = 1;

    protected static void applyChanges(OBOSession session, HistoryList changes) {
        DefaultOperationModel model = new DefaultOperationModel();
        model.setHistory(session);
        Iterator it = changes.getHistoryItems();
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            OperationWarning warning = model.apply(item);
            if (warning == null) continue;
            System.err.println("* warning: " + warning);
        }
    }

    protected static Collection findClashes(OBOSession original, OBOSession changea, OBOSession changeb, HistoryList changes, Collection clashesToIgnore) {
        VectorFilter creationFilter = new VectorFilter(){

            public boolean satisfies(Object o) {
                return o instanceof CreateObjectHistoryItem;
            }
        };
        HashMap<String, CreateObjectHistoryItem> termCreationMap = new HashMap<String, CreateObjectHistoryItem>();
        LinkedList<IDClash> clashes = new LinkedList<IDClash>();
        Collection termCreations = TermUtil.findMatchingItems(changes, creationFilter);
        Iterator it = termCreations.iterator();
        while (it.hasNext()) {
            CreateObjectHistoryItem item = (CreateObjectHistoryItem)it.next();
            if (clashesToIgnore.contains(item.getObjectID())) continue;
            termCreationMap.put(item.getObjectID(), item);
        }
        HistoryList changes2 = HistoryGenerator.getHistory(original, changeb, null);
        termCreations = TermUtil.findMatchingItems(changes2, creationFilter);
        it = termCreations.iterator();
        while (it.hasNext()) {
            CreateObjectHistoryItem item = (CreateObjectHistoryItem)it.next();
            if (!termCreationMap.containsKey(item.getObjectID())) continue;
            IdentifiedObject obja = changea.getObject(item.getObjectID());
            IdentifiedObject objb = changeb.getObject(item.getObjectID());
            IDClash clash = new IDClash(item.getObjectID());
            if (obja.getName().equals(objb.getName())) {
                clash.setSeverity(0);
                clash.setMessage("Possible ID clash found: Both versions of ontology created a the new term " + obja.getName() + " (" + obja.getID() + ").");
                clash.setPossibleReasons("This may be harmless. Usually it means that the \"original\" file specified is not the true point of divergence for these two terms, but is actually an older file (in this case, the merge will still work correctly).");
            } else {
                clash.setMessage("LIKELY ID CLASH FOUND: Both versions of the ontology created a term with id " + item.getObjectID() + " but " + "the term is named " + obja.getName() + " in one ontology and " + objb.getName() + "in the other.");
                clash.setPossibleReasons("This is probably a harmful id clash. This can happen when 2 users have specified overlapping id spaces and both create a new term. Two semantically distinct terms are then assigned the same id. There's a slight chance that this is a harmless error caused when an old original file is used AND the name of the term was changed in one revision but not the other.");
                clash.setSeverity(1);
            }
            clashes.add(clash);
        }
        return clashes;
    }

    public static ArgumentSignature getArgumentSignature() {
        EnumArgumentSignature updateIDsSig = new EnumArgumentSignature();
        updateIDsSig.addSignature((ArgumentSignature)new FlagSpec("NEVER"), false);
        updateIDsSig.addSignature((ArgumentSignature)new FlagSpec("IF_LIKELY"), false);
        updateIDsSig.addSignature((ArgumentSignature)new FlagSpec("ALWAYS"), false);
        EnumArgumentSignature clashFailSig = new EnumArgumentSignature();
        clashFailSig.addSignature((ArgumentSignature)new FlagSpec("ALWAYS"), false);
        clashFailSig.addSignature((ArgumentSignature)new FlagSpec("IF_LIKELY"), false);
        clashFailSig.addSignature((ArgumentSignature)new FlagSpec("NEVER"), false);
        UnorderedArgumentSignature sig2 = new UnorderedArgumentSignature();
        sig2.addSignature((ArgumentSignature)new TagSpec("-ignore-clash-on-id"), 0, Integer.MAX_VALUE);
        sig2.addSignature((ArgumentSignature)new TagSpec("-update-ids-when", (ArgumentSignature)updateIDsSig), 0, 1, false);
        sig2.addSignature((ArgumentSignature)new TagSpec("-fail-on-clash", (ArgumentSignature)clashFailSig), 0, 1, false);
        sig2.addSignature((ArgumentSignature)new TagSpec("-original"), 1, 1, true);
        sig2.addSignature((ArgumentSignature)new TagSpec("-revision"), 2, 2, true);
        sig2.addSignature((ArgumentSignature)new TagSpec("-o"), 1, 1, true);
        OrderedArgumentSignature sig1 = new OrderedArgumentSignature();
        sig1.addSignature((ArgumentSignature)new ValueSpec());
        sig1.addSignature((ArgumentSignature)new ValueSpec());
        sig1.addSignature((ArgumentSignature)new ValueSpec());
        sig1.addSignature((ArgumentSignature)new ValueSpec());
        EnumArgumentSignature sig = new EnumArgumentSignature();
        sig.addSignature((ArgumentSignature)sig1);
        sig.addSignature((ArgumentSignature)sig2);
        return sig2;
    }

    public static void main(String[] args) throws IOException, DataAdapterException {
        OBOSession writeMe;
        List argVals;
        ArrayList<String> argList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argList.add(args[i]);
        }
        try {
            argVals = CommandLineParser.parse((ArgumentSignature)OBOMerge.getArgumentSignature(), argList);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            OBOMerge.printUsage();
            System.exit(1);
            return;
        }
        Controller.setSuppressInstallations(true);
        boolean forceMode = false;
        String originalFile = null;
        String file1 = null;
        String file2 = null;
        String writePath = null;
        int idUpdateBehavior = 0;
        int clashBehavior = 0;
        HashSet<String> clashesToIgnore = new HashSet<String>();
        boolean autoUpdate = true;
        Iterator<Object> it = argVals.iterator();
        while (it.hasNext()) {
            Tag t;
            Tag val = (Tag)it.next();
            if (val.getName().equals("-ignore-clash-on-id")) {
                clashesToIgnore.add(val.getStringValue());
            }
            if (val.getName().equals("-revision")) {
                if (file1 == null) {
                    file1 = val.getStringValue();
                } else {
                    file2 = val.getStringValue();
                }
            }
            if (val.getName().equals("-original")) {
                originalFile = val.getStringValue();
            }
            if (val.getName().equals("-o")) {
                writePath = val.getStringValue();
            }
            if (val.getName().equals("-update-ids")) {
                t = (Tag)val.getValues().get(0);
                if (t.getName().equals("IF_LIKELY")) {
                    idUpdateBehavior = 1;
                } else if (t.getName().equals("ALWAYS")) {
                    idUpdateBehavior = 2;
                } else if (t.getName().equals("NEVER")) {
                    idUpdateBehavior = 0;
                }
            }
            if (!val.getName().equals("-fail-on-clash")) continue;
            t = (Tag)val.getValues().get(0);
            if (t.getName().equals("IF_LIKELY")) {
                clashBehavior = 1;
                continue;
            }
            if (t.getName().equals("ALWAYS")) {
                clashBehavior = 0;
                continue;
            }
            if (!t.getName().equals("NEVER")) continue;
            clashBehavior = 2;
        }
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOSession original = OBOMerge.getSession(originalFile, adapter);
        OBOSession changea = OBOMerge.getSession(file1, adapter);
        HistoryList changes = HistoryGenerator.getHistory(original, changea, null);
        Map mergeIDRemap = TermUtil.createIDRemapping(changes);
        OBOSession changeb = OBOMerge.getSession(file2, adapter);
        boolean unresolvedClashes = false;
        Collection clashes = null;
        if (!forceMode) {
            clashes = OBOMerge.findClashes(original, changea, changeb, changes, clashesToIgnore);
            boolean foundLikelyClashes = false;
            it = clashes.iterator();
            while (it.hasNext()) {
                IDClash clash = (IDClash)it.next();
                if (clash.getSeverity() == 1) {
                    System.err.print("!!!");
                    foundLikelyClashes = true;
                }
                System.err.println(clash.getMessage());
            }
            if (clashBehavior == 0 && clashes.size() > 0 || clashBehavior == 1 && foundLikelyClashes) {
                System.err.println("ID Clashes detected, aborting.");
                System.exit(1);
            }
            if (idUpdateBehavior == 2 || idUpdateBehavior == 1 && foundLikelyClashes) {
                unresolvedClashes = true;
            }
            if (unresolvedClashes && autoUpdate) {
                Collection ids = DefaultIDGenerator.getIDs(changea);
                ids.addAll(DefaultIDGenerator.getIDs(changeb));
                DefaultIDGenerator generator = new DefaultIDGenerator();
                it = clashes.iterator();
                while (it.hasNext()) {
                    IDClash clash = (IDClash)it.next();
                    if (idUpdateBehavior != 2 && (clash.getSeverity() != 1 || idUpdateBehavior != 1)) continue;
                    String currentRule = null;
                    Pattern p = Pattern.compile("(\\w+):(\\d+)");
                    Matcher m = p.matcher(clash.getID());
                    if (m.matches()) {
                        String prefix = m.group(1);
                        String suffix = m.group(2);
                        currentRule = prefix + ":$sequence(" + suffix.length() + "," + Integer.parseInt(suffix) + ")$";
                    } else {
                        currentRule = clash.getID() + "_$sequence(10)$";
                    }
                    String newID = null;
                    try {
                        IdentifiedObject reassignMe = changeb.getObject(clash.getID());
                        newID = generator.generateID(currentRule, null, ids, false);
                        ((OBOSessionImpl)changeb).changeID((AnnotatedObjectImpl)reassignMe, newID);
                        clash.setReassignedID(newID);
                        System.err.println("updating " + clash.getID() + " to " + newID);
                        ids.add(newID);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.err.println("Could not reassign id " + clash.getID() + " to " + newID + ". This is " + "probably a bug.");
                        System.exit(1);
                    }
                }
            }
        }
        if (clashes != null) {
            it = clashes.iterator();
            while (it.hasNext()) {
                IDClash clash = (IDClash)it.next();
                IdentifiedObject reassignMe = changeb.getObject(clash.getReassignedID());
                if (reassignMe == null) continue;
                if (reassignMe.getIDExtension() == null) {
                    reassignMe.setIDExtension(new NestedValueImpl());
                }
                reassignMe.getIDExtension().setSuggestedComment("id reassigned from " + clash.getID() + " by obomerge");
                System.err.println("set id extension for " + reassignMe.getID() + ", ext = " + reassignMe.getIDExtension());
            }
        }
        if (mergeIDRemap.size() > 0) {
            HistoryList changesb = HistoryGenerator.getHistory(original, changeb, null);
            it = mergeIDRemap.keySet().iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                Collection ids = (Collection)mergeIDRemap.get(id);
                System.err.println("** Warning: Mapping edits that refer to secondary " + id + " in file " + file2 + " to the following primary ids " + ids);
                changesb.forwardID(id, ids);
            }
            OBOMerge.applyChanges(original, changes);
            OBOMerge.applyChanges(original, changesb);
            writeMe = original;
        } else {
            OBOMerge.applyChanges(changeb, changes);
            writeMe = changeb;
        }
        changes = null;
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.setWritePath(writePath);
        adapter.doOperation(IOOperation.WRITE, (AdapterConfiguration)config, writeMe);
    }

    public static OBOSession getSession(String path, OBOFileAdapter adapter) throws DataAdapterException {
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(path);
        Object out = adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
        return (OBOSession)out;
    }

    public static void printUsage() {
        System.err.println("Usage: obomerge " + OBOMerge.getArgumentSignature().getShortDocumentation());
        System.err.println();
    }

    public static class IDClash {
        protected String id;
        protected String reassignedID;
        protected String message;
        protected int severity;
        protected String reason;

        public IDClash(String id) {
            this.id = id;
            if (id == null) {
                throw new IllegalArgumentException();
            }
        }

        public String getReassignedID() {
            return this.reassignedID;
        }

        public void setReassignedID(String reassignedID) {
            this.reassignedID = reassignedID;
            if (reassignedID == null) {
                throw new IllegalArgumentException();
            }
        }

        public String getID() {
            return this.id;
        }

        public void setID(String id) {
            this.id = id;
            if (id == null) {
                throw new IllegalArgumentException();
            }
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getSeverity() {
            return this.severity;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }

        public void setPossibleReasons(String string) {
            this.reason = string;
        }
    }
}

