/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.launcher;

import java.awt.Window;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.geneontology.dataadapter.CommandLineWidget;
import org.geneontology.dataadapter.DataAdapter;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.DataAdapterRegistry;
import org.geneontology.dataadapter.DataAdapterUIException;
import org.geneontology.dataadapter.DataAdapterUtil;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.dataadapter.ParameterUI;
import org.geneontology.io.AuditedPrintStream;
import org.geneontology.io.MultiPrintStream;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.MainFrame;
import org.geneontology.swing.SwingUtil;
import org.geneontology.util.CommandLineParser;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;
import org.geneontology.util.Tag;
import org.geneontology.util.TagSpec;

public class OBOEdit {
    private static TagSpec getCommandLineSpec(DataAdapterRegistry registry) {
        TagSpec loadAdapterSpec = CommandLineWidget.getTagSpec((DataAdapterRegistry)registry, (DataAdapter)Controller.getController().getDefaultReadAdapter(), (IOOperation)IOOperation.READ, null);
        TagSpec vSpec = new TagSpec("-v");
        TagSpec verboseSpec = new TagSpec("-verbose");
        TagSpec listSpec = new TagSpec("--listadapters");
        TagSpec loadSpec = new TagSpec("-load");
        loadSpec.addArgumentSpec(loadAdapterSpec, 1);
        loadSpec.setImpliedSpec(loadAdapterSpec, 1);
        loadSpec.addArgumentSpec(listSpec, 1);
        TagSpec spec = new TagSpec();
        spec.setImpliedSpec(loadSpec, 1);
        spec.addArgumentSpec(loadSpec, 1);
        spec.addArgumentSpec(vSpec, 1);
        spec.addArgumentSpec(verboseSpec, 1);
        return spec;
    }

    public static CommandLineActions getActions(DataAdapterRegistry registry, Tag topLevel) throws DataAdapterException, DataAdapterUIException {
        Class[] classes = new Class[]{ParameterUI.class};
        CommandLineActions actions = new CommandLineActions();
        Tag loadTag = null;
        boolean verbose = false;
        Iterator it = topLevel.getArguments().iterator();
        block0: while (it.hasNext()) {
            Tag tag = (Tag)it.next();
            if (tag.getName().equals("-load")) {
                Iterator it2 = tag.getArguments().iterator();
                while (it2.hasNext()) {
                    Tag t = (Tag)it2.next();
                    if (t.getName().equals("-adapter")) {
                        if (loadTag != null) {
                            throw new DataAdapterUIException("Can't do two load commands at once.");
                        }
                        loadTag = t;
                        continue block0;
                    }
                    if (!t.getName().equals("--listadapters")) continue;
                    DataAdapter[] adapters = DataAdapterUtil.getAdapters((DataAdapterRegistry)registry, (IOOperation)IOOperation.READ, (Class[])classes);
                    System.err.println("Available load adapters...");
                    for (int i = 0; i < adapters.length; ++i) {
                        System.err.println("   -" + adapters[i].getID());
                    }
                    System.err.println();
                    System.exit(0);
                }
                continue;
            }
            if (!tag.getName().equals("-v") && !tag.getName().equals("-verbose")) continue;
            verbose = true;
        }
        if (loadTag != null) {
            Vector<1> progressListeners = new Vector<1>();
            if (verbose) {
                ProgressListener listener = new ProgressListener(){
                    protected int lastDisplay = 0;

                    public void progressMade(ProgressEvent e) {
                        int progressVal;
                        if (e instanceof ReusableProgressEvent) {
                            ReusableProgressEvent rpe = (ReusableProgressEvent)e;
                            progressVal = rpe.getFastVal();
                        } else {
                            progressVal = e.getValue() == null ? -1 : e.getValue().intValue();
                        }
                        if (10 * (progressVal / 10) == this.lastDisplay) {
                            System.err.print(this.lastDisplay + "%...");
                            this.lastDisplay += 10;
                        }
                    }
                };
                progressListeners.add(listener);
            }
            OBOSession o = (OBOSession)CommandLineWidget.execute((DataAdapterRegistry)registry, (IOOperation)IOOperation.READ, loadTag, null, progressListeners);
            actions.setLoadMe(o);
            System.err.println("done");
        }
        return actions;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1 && args[0].equals("-flush_memory_configuration")) {
            Controller.setSuppressInstallations(true);
            Controller.updateLauncherConfigurations();
            System.exit(0);
        }
        Controller.getPrefsDir().mkdirs();
        System.setProperty("sun.awt.exception.handler", "org.geneontology.oboedit.gui.ExceptionHandler");
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        AuditedPrintStream fileStream = new AuditedPrintStream(new PrintStream(new FileOutputStream(Controller.getStderrFile(), true)), 25, true);
        MultiPrintStream mos = new MultiPrintStream();
        mos.addPrintStream((PrintStream)audited);
        mos.addPrintStream((PrintStream)fileStream);
        System.setErr((PrintStream)mos);
        System.err.println("Starting OBO-Edit " + Controller.getVersion() + ": " + new Date());
        DataAdapterRegistry registry = Controller.getController().getAdapterRegistry();
        TagSpec spec = OBOEdit.getCommandLineSpec(registry);
        Tag topLevel = CommandLineParser.parse((TagSpec)spec, (String[])args);
        CommandLineActions actions = OBOEdit.getActions(registry, topLevel);
        MainFrame go = new MainFrame();
        if (actions.getLoadMe() != null) {
            go.setRoot(actions.getLoadMe());
        }
        SwingUtil.center((Window)go);
        go.setVisible(true);
    }

    private static class CommandLineActions {
        protected OBOSession loadMe;

        public void setLoadMe(OBOSession loadMe) {
            this.loadMe = loadMe;
        }

        public OBOSession getLoadMe() {
            return this.loadMe;
        }
    }
}

