/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.launcher;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.GOFlatFileAdapter;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.DestroyObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.ObsoleteObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DbxrefImpl;
import org.geneontology.oboedit.datamodel.impl.DefaultOperationModel;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;

public class OBO2Flat {
    protected static String ROOT_ID = "GO:0003673";
    protected static String FUNCTION_ID = "GO:0003674";
    protected static String COMPONENT_ID = "GO:0005575";
    protected static String PROCESS_ID = "GO:0008150";
    protected static String FUNCTION_OBS_ID = "GO:0008369";
    protected static String COMPONENT_OBS_ID = "GO:0008370";
    protected static String PROCESS_OBS_ID = "GO:0008371";
    protected static double oldValue = 0.0;
    protected static ProgressListener plistener = new ProgressListener(){
        boolean starting = true;
        int reportInc = 10;
        int lastNum = -1;

        public void progressMade(ProgressEvent e) {
            Double d = e.getValue();
            if (d != null) {
                if (this.lastNum == d.intValue()) {
                    return;
                }
                if (this.starting) {
                    System.err.println(e.getDescription());
                    System.err.print("     0%");
                    System.err.flush();
                    this.starting = false;
                } else if (d >= oldValue) {
                    if (d.intValue() % this.reportInc == 0) {
                        this.lastNum = d.intValue() % this.reportInc;
                        System.err.print(d.intValue() + "%");
                    } else if (d.intValue() % 2 == 0) {
                        System.err.print(".");
                        this.lastNum = d.intValue() % 2;
                    }
                    System.err.flush();
                } else if (d < oldValue) {
                    System.err.println("done");
                    this.starting = true;
                }
                oldValue = d;
                this.lastNum = d.intValue();
            }
        }
    };

    private OBO2Flat() {
    }

    public static void main(String[] args) throws Exception {
        Controller.setSuppressInstallations(true);
        ConvertRecord record = OBO2Flat.getRecord(args);
        OBO2Flat.convert(record);
        System.exit(0);
    }

    private static ConvertRecord getRecord(String[] args) {
        Vector v;
        String id;
        int i;
        if (args.length == 0) {
            System.err.println("Usage: obo2flat [options] inputfile1 inputfile2");
            System.err.println();
            System.err.println("IO Switches:");
            System.err.println("  -def <path to write definition file>");
            System.err.println("  -def4root <output root> <path to definition file>");
            System.err.println("  -o <output root> <path to the ouput file>");
            System.err.println();
            System.err.println("Graph rearrangement (required):");
            System.err.println("  -cr <dummy root id> <dummy root name>");
            System.err.println("  -co <parent id> <obsolete holder id> <obsolete holder name>");
            System.err.println("  -adddef <term id> <definition>");
            System.err.println("  -addref <term id> <dbxref>");
            System.err.println("  -mapobs <namespace> <obsolete holder id>");
            System.err.println("  -defaultobs <default obsolete holder id>");
            System.err.println();
            System.err.println("Optional switches:");
            System.err.println("  -rootreltype <root id> <type>");
            System.err.println("  -symbol <type id> <symbol>");
            System.err.println("  -reducefilesize");
            System.err.println("  -dangling");
            System.err.println();
            System.err.println("Presets:");
            System.err.println("  --gopresets <biological_process output file> <cellular_component output file> <molecular_function output file> <defs output file>");
            System.err.println();
            System.err.println("Other switches:");
            System.err.println("  -v\tVerbose mode");
            System.exit(1);
        }
        ConvertRecord record = new ConvertRecord();
        HashMap<String, Vector<String>> temp = new HashMap<String, Vector<String>>();
        for (i = 0; i < args.length; ++i) {
            String obs_id;
            if (args[i].equals("-v") || args[i].equals("-verbose")) {
                record.verbose = true;
                continue;
            }
            if (args[i].equals("-reducefilesize")) {
                record.reducefilesize = true;
                continue;
            }
            if (args[i].equals("-def")) {
                if (++i >= args.length) {
                    System.err.println("-def tag must specify a file name");
                    System.exit(1);
                }
                record.defFile = args[i];
                continue;
            }
            if (args[i].equals("-def4root")) {
                if (++i >= args.length) {
                    System.err.println("-def4root tag must specify a root term");
                    System.exit(1);
                }
                id = args[i++];
                if (i >= args.length) {
                    System.err.println("-def4root tag must specify an output path");
                    System.exit(1);
                }
                System.err.println("id = " + id + ", path = " + args[i]);
                record.defFileHash.put(id, args[i]);
                continue;
            }
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    System.err.println("-o tag must specify a root id");
                    System.exit(1);
                }
                id = args[i];
                if (++i >= args.length) {
                    System.err.println("-o tag must specify an output file path");
                    System.exit(1);
                }
                record.outHash.put(id, args[i]);
                continue;
            }
            if (args[i].equals("-cr")) {
                if (++i >= args.length) {
                    System.err.println("-cr tag must specify a root id");
                    System.exit(1);
                }
                record.fakeRootID = args[i];
                if (++i >= args.length) {
                    System.err.println("-cr tag must specify a root name");
                    System.exit(1);
                }
                record.fakeRootName = args[i];
                continue;
            }
            if (args[i].equals("-adddef")) {
                if (++i >= args.length) {
                    System.err.println("-adddef tag must specify a term id");
                    System.exit(1);
                }
                id = args[i];
                if (++i >= args.length) {
                    System.err.println("-adddef tag must specify a definition");
                    System.exit(1);
                }
                String def = args[i];
                record.defFileHash.put(id, def);
                continue;
            }
            if (args[i].equals("-addref")) {
                if (++i >= args.length) {
                    System.err.println("-addref tag must specify a term id");
                    System.exit(1);
                }
                id = args[i];
                if (++i >= args.length) {
                    System.err.println("-addref tag must specify a dbxref to add");
                    System.exit(1);
                }
                String dbxref = args[i];
                v = (Vector)record.refHash.get(id);
                if (v == null) {
                    v = new Vector();
                    record.refHash.put(id, v);
                }
                int index = dbxref.indexOf(58);
                String dbstr = dbxref.substring(0, index);
                String idstr = dbxref.substring(index + 1, dbxref.length());
                v.add(new DbxrefImpl(dbstr, idstr, 2));
                continue;
            }
            if (args[i].equals("-co")) {
                if (++i >= args.length) {
                    System.err.println("-co tag must specify a parent id");
                    System.exit(1);
                }
                id = args[i];
                if (++i >= args.length) {
                    System.err.println("-co tag must specify an obsolete node id");
                    System.exit(1);
                }
                obs_id = args[i];
                if (++i >= args.length) {
                    System.err.println("-co tag must specify an obsolete node name");
                    System.exit(1);
                }
                ObsoleteRecord or = new ObsoleteRecord();
                or.id = obs_id;
                or.parent_id = id;
                or.name = args[i];
                record.obsoleteNodes.add(or);
                continue;
            }
            if (args[i].equals("-mapobs")) {
                if (++i >= args.length) {
                    System.err.println("-mapobs tag must specify a namespace");
                    System.exit(1);
                }
                String ns = args[i];
                if (++i >= args.length) {
                    System.err.println("-mapobs tag must specify an obsolete node id");
                    System.exit(1);
                }
                if ((v = (Vector)temp.get(obs_id = args[i])) == null) {
                    v = new Vector();
                    temp.put(obs_id, v);
                }
                v.add(ns);
                continue;
            }
            if (args[i].equals("-defaultobs")) {
                if (++i >= args.length) {
                    System.err.println("-defaultobs tag must specify a namespace");
                    System.exit(1);
                }
                record.defaultObsolete = args[i];
                continue;
            }
            if (args[i].equals("-rootreltype")) {
                if (++i >= args.length) {
                    System.err.println("-rootreltype tag must specify a root id");
                    System.exit(1);
                }
                RootRecord rr = new RootRecord();
                rr.id = args[i];
                if (++i >= args.length) {
                    System.err.println("-rootreltype tag must specify a type id");
                    System.exit(1);
                }
                rr.type_id = args[i];
                record.reroots.add(rr);
                continue;
            }
            if (args[i].equals("-symbol")) {
                if (++i >= args.length) {
                    System.err.println("-symbol tag must specify a type id");
                    System.exit(1);
                }
                String typeid = args[i];
                if (++i >= args.length) {
                    System.err.println("-symbol tag must specify a symbol character");
                    System.exit(1);
                }
                System.err.println("mapping " + typeid + " to " + args[i]);
                record.typeToChar.put(typeid, args[i]);
                continue;
            }
            if (args[i].equals("--gopresets")) {
                if (++i >= args.length) {
                    System.err.println("--gopresets tag must specify an output path for the biological process ontology");
                    System.exit(1);
                }
                String proc_out = args[i];
                if (++i >= args.length) {
                    System.err.println("--gopresets tag must specify an output path for the cellular component ontology");
                    System.exit(1);
                }
                String comp_out = args[i];
                if (++i >= args.length) {
                    System.err.println("--gopresets tag must specify an output path for the molecular function ontology");
                    System.exit(1);
                }
                String func_out = args[i];
                if (++i >= args.length) {
                    System.err.println("--gopresets tag must specify an output path for the definitions file");
                    System.exit(1);
                }
                String def_out = args[i];
                record.outHash.put(FUNCTION_ID, func_out);
                record.outHash.put(COMPONENT_ID, comp_out);
                record.outHash.put(PROCESS_ID, proc_out);
                record.defFile = def_out;
                record.typeToChar.put("OBO_REL:is_a", "%");
                record.typeToChar.put("part_of", "<");
                ObsoleteRecord or = new ObsoleteRecord();
                or.id = FUNCTION_OBS_ID;
                or.parent_id = FUNCTION_ID;
                or.name = "obsolete molecular function";
                or.namespaces.add("molecular_function");
                record.obsoleteNodes.add(or);
                or = new ObsoleteRecord();
                or.id = COMPONENT_OBS_ID;
                or.parent_id = COMPONENT_ID;
                or.name = "obsolete cellular component";
                or.namespaces.add("cellular_component");
                record.obsoleteNodes.add(or);
                or = new ObsoleteRecord();
                or.id = PROCESS_OBS_ID;
                or.parent_id = PROCESS_ID;
                or.name = "obsolete biological process";
                or.namespaces.add("biological_process");
                record.obsoleteNodes.add(or);
                record.defaultObsolete = FUNCTION_OBS_ID;
                record.fakeRootID = ROOT_ID;
                record.fakeRootName = "Gene_Ontology";
                Vector<DbxrefImpl> v2 = new Vector<DbxrefImpl>();
                v2.add(new DbxrefImpl("go", "curators", 2));
                record.defHash.put(FUNCTION_OBS_ID, "These are terms that have been removed from the active function ontology.");
                record.refHash.put(FUNCTION_OBS_ID, v2);
                record.defHash.put(COMPONENT_OBS_ID, "These are terms that have been removed from the active component ontology.");
                record.refHash.put(COMPONENT_OBS_ID, v2);
                record.defHash.put(PROCESS_OBS_ID, "These are terms that have been removed from the active process ontology.");
                record.refHash.put(PROCESS_OBS_ID, v2);
                RootRecord rr = new RootRecord();
                rr.id = FUNCTION_ID;
                rr.type_id = "part_of";
                record.reroots.add(rr);
                rr = new RootRecord();
                rr.id = COMPONENT_ID;
                rr.type_id = "part_of";
                record.reroots.add(rr);
                rr = new RootRecord();
                rr.id = PROCESS_ID;
                rr.type_id = "part_of";
                record.reroots.add(rr);
                continue;
            }
            record.inputFiles.add(args[i]);
        }
        for (i = 0; i < record.obsoleteNodes.size(); ++i) {
            ObsoleteRecord or = (ObsoleteRecord)record.obsoleteNodes.get(i);
            Vector v3 = (Vector)temp.get(or.id);
            if (v3 == null) continue;
            or.namespaces.addAll(v3);
        }
        Iterator it = record.defHash.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            boolean valid = false;
            for (int i2 = 0; i2 < record.obsoleteNodes.size(); ++i2) {
                ObsoleteRecord or = (ObsoleteRecord)record.obsoleteNodes.get(i2);
                if (!or.id.equals(id)) continue;
                valid = true;
                break;
            }
            if (record.fakeRootID != null && id.equals(record.fakeRootID)) {
                valid = true;
            }
            if (!valid) {
                System.err.println(id + " is not allowed in an -adddef switch. " + "-adddef switches may only specify " + "terms created with -co or -cr");
                System.exit(1);
            }
            if ((v = (Vector)record.refHash.get(id)) != null && v.size() != 0) continue;
            System.err.println("You must specify at least one dbxref if you want to do an -adddef on " + id);
            System.exit(1);
        }
        it = record.refHash.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            String def = (String)record.defHash.get(id);
            if (def != null) continue;
            System.err.println("You must specify a definition if you want to do an -addref on " + id);
            System.exit(1);
        }
        return record;
    }

    public static void convert(ConvertRecord cr) throws Exception {
        String id;
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.setReadPaths(cr.inputFiles);
        config.setAllowDangling(cr.allowDangling);
        if (cr.verbose) {
            System.err.print("loading files...");
            System.err.flush();
        }
        OBOSession history = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
        if (cr.verbose) {
            System.err.println("done");
            System.err.print("applying changes...");
            System.err.flush();
        }
        DefaultOperationModel opmodel = new DefaultOperationModel();
        opmodel.setHistory(history);
        HashMap<String, ObsoleteRecord> obsHash = new HashMap<String, ObsoleteRecord>();
        HashMap<String, ObsoleteRecord> nsObsHash = new HashMap<String, ObsoleteRecord>();
        for (int i = 0; i < cr.obsoleteNodes.size(); ++i) {
            ObsoleteRecord or = (ObsoleteRecord)cr.obsoleteNodes.get(i);
            obsHash.put(or.parent_id, or);
            for (int j = 0; j < or.namespaces.size(); ++j) {
                String ns = (String)or.namespaces.get(j);
                nsObsHash.put(ns, or);
            }
        }
        HashMap<String, RootRecord> rootHash = new HashMap<String, RootRecord>();
        for (int i = 0; i < cr.reroots.size(); ++i) {
            RootRecord rr = (RootRecord)cr.reroots.get(i);
            rootHash.put(rr.id, rr);
        }
        HistoryItem item = OBO2Flat.getChangeItem(history, cr.fakeRootID, cr.fakeRootName, obsHash, rootHash, cr.defHash, cr.refHash);
        OperationWarning ow = opmodel.apply(item);
        System.err.println("PO:obsolete = " + history.getObject("PO:obsolete"));
        if (ow != null) {
            System.err.println("+++***+++ got operation warning " + ow.getMessage());
        }
        if ((ow = opmodel.reverse(item = OBO2Flat.getReverseItem(history, nsObsHash, cr.fakeRootID, cr.defaultObsolete))) != null) {
            System.err.println("+++***+++ got operation warning " + ow.getMessage());
        }
        if (cr.verbose) {
            System.err.println("done");
        }
        Iterator it2 = history.getObsoleteTerms().iterator();
        while (it2.hasNext()) {
            System.err.println(it2.next() + " is still obsolete!");
        }
        oldValue = 0.0;
        GOFlatFileAdapter fadapter = new GOFlatFileAdapter();
        GOFlatFileAdapter.GOFlatFileConfiguration fconfig = new GOFlatFileAdapter.GOFlatFileConfiguration();
        Iterator it = cr.typeToChar.keySet().iterator();
        Hashtable typeToChar = new Hashtable();
        while (it.hasNext()) {
            String id2 = (String)it.next();
            String chr = (String)cr.typeToChar.get(id2);
            GOFlatFileAdapter.CharTypeMapping mapping = new GOFlatFileAdapter.CharTypeMapping(chr, id2, id2);
            fconfig.getTypeMappings().add(mapping);
        }
        fconfig.setUseLegacyTypes(cr.typeToChar.size() > 0);
        fconfig.setAllowDangling(cr.allowDangling);
        fconfig.setSaveDefFilename(cr.defFile);
        fconfig.setReduceSize(cr.reducefilesize);
        HashMap<String, GOFlatFileAdapter.SaveRecord> saveRecords = new HashMap<String, GOFlatFileAdapter.SaveRecord>();
        it = cr.outHash.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            String path = (String)cr.outHash.get(id);
            GOFlatFileAdapter.SaveRecord sr = new GOFlatFileAdapter.SaveRecord(id, path);
            fconfig.getSaveRecords().add(sr);
            saveRecords.put(id, sr);
        }
        it = cr.defFileHash.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            GOFlatFileAdapter.SaveRecord sr = (GOFlatFileAdapter.SaveRecord)saveRecords.get(id);
            if (sr == null) {
                sr = new GOFlatFileAdapter.SaveRecord(id, null);
                saveRecords.put(id, sr);
                fconfig.getSaveRecords().add(sr);
            }
            String defPath = (String)cr.defFileHash.get(id);
            sr.setDefFilename(defPath);
        }
        System.err.println("saveRecords = " + fconfig.getSaveRecords());
        fadapter.doOperation(IOOperation.WRITE, (AdapterConfiguration)fconfig, history);
    }

    public static TermMacroHistoryItem getChangeItem(OBOSession history, String falseRoot, String falseRootName, Map obsHash, Map rootHash, Map defHash, Map refHash) {
        TermMacroHistoryItem item = new TermMacroHistoryItem("OBO to flatfile operations");
        if (falseRoot != null) {
            OBOClass te = history.getTerm(falseRoot);
            if (te != null) {
                item.addHistoryItem(new DestroyObjectHistoryItem(te));
            }
            item.addHistoryItem(new CreateObjectHistoryItem(falseRoot, OBOClass.OBO_CLASS.getID()));
            item.addHistoryItem(new NameChangeHistoryItem(falseRootName, "<new term>", falseRoot));
        }
        LinkedList<IdentifiedObject> roots = new LinkedList<IdentifiedObject>();
        Iterator<Object> it = history.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof OBOClass) || ((OBOClass)io).getParents().size() != 0 || TermUtil.isObsolete(io) || io.isBuiltIn()) continue;
            roots.add(io);
        }
        if (falseRoot != null) {
            it = roots.iterator();
            while (it.hasNext()) {
                OBOClass type;
                OBOClass t = (OBOClass)it.next();
                RootRecord rr = (RootRecord)rootHash.get(t.getID());
                String type_id = OBOProperty.IS_A.getID();
                if (rr != null && (type = history.getTerm(rr.type_id)) != null && TermUtil.isProperty(type)) {
                    type_id = type.getID();
                }
                TermCopyHistoryItem mi = new TermCopyHistoryItem(falseRoot, t.getID(), type_id);
                System.err.println("copying " + t.getID() + " to " + falseRoot);
                item.addHistoryItem(mi);
            }
        }
        it = defHash.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String def = (String)defHash.get(id);
            if (def == null) continue;
            Vector temp = (Vector)refHash.get(id);
            for (int i = 0; i < temp.size(); ++i) {
                item.addHistoryItem(new AddDbxrefHistoryItem(id, (Dbxref)temp.get(i), true, null));
            }
            item.addHistoryItem(new DefinitionChangeHistoryItem("", def, id));
        }
        it = obsHash.values().iterator();
        while (it.hasNext()) {
            ObsoleteRecord or = (ObsoleteRecord)it.next();
            OBOClass destroyme = history.getTerm(or.id);
            if (destroyme != null) {
                Iterator it2 = destroyme.getParents().iterator();
                while (it2.hasNext()) {
                    Link link = (Link)it2.next();
                    item.addHistoryItem(new DeleteLinkHistoryItem(link));
                }
                item.addHistoryItem(new DestroyObjectHistoryItem(destroyme));
            }
            item.addHistoryItem(new CreateObjectHistoryItem(or.id, OBOClass.OBO_CLASS.getID()));
            item.addHistoryItem(new TermCopyHistoryItem(or.parent_id, or.id, OBOProperty.IS_A.getID()));
            item.addHistoryItem(new NameChangeHistoryItem(or.name, "<new term>", or.id));
        }
        return item;
    }

    public static HistoryItem getReverseItem(OBOSession history, HashMap nsObsHash, String falseRoot, String defaultObsNode) {
        TermMacroHistoryItem item = new TermMacroHistoryItem("");
        Vector delList = new Vector();
        Iterator it = history.getObsoleteTerms().iterator();
        while (it.hasNext()) {
            OBOClass t = (OBOClass)it.next();
            String ns = t.getNamespace().getID();
            ObsoleteRecord or = (ObsoleteRecord)nsObsHash.get(ns);
            String obsNode = null;
            if (or != null) {
                obsNode = or.id;
            }
            if (obsNode == null) {
                obsNode = defaultObsNode;
            }
            if (obsNode == null || obsNode.equals(t.getID()) || falseRoot != null && falseRoot.equals(t.getID())) continue;
            OBOClass a = history.getTerm(obsNode);
            OBOClass b = history.getTerm(t.getID());
            HistoryItem.StringRelationship sr = new HistoryItem.StringRelationship(obsNode, t.getID(), OBOProperty.IS_A.getID());
            item.addHistoryItem(new DeleteLinkHistoryItem(sr));
            item.addHistoryItem(new ObsoleteObjectHistoryItem(t.getID()));
        }
        return item;
    }

    private static class ConvertRecord {
        boolean verbose = false;
        boolean reducefilesize = false;
        Vector inputFiles = new Vector();
        Map outHash = new HashMap();
        Map defHash = new HashMap();
        Map refHash = new HashMap();
        Map defFileHash = new HashMap();
        Vector obsoleteNodes = new Vector();
        Vector reroots = new Vector();
        String defaultObsolete;
        String defFile;
        String fakeRootID;
        String fakeRootName;
        HashMap typeToChar = new HashMap();
        boolean allowDangling = false;

        private ConvertRecord() {
        }
    }

    private static class ObsoleteRecord
    extends CreateRecord {
        String parent_id;
        Vector namespaces = new Vector();

        private ObsoleteRecord() {
        }
    }

    private static class RootRecord {
        String id;
        String type_id;

        private RootRecord() {
        }
    }

    private static class CreateRecord {
        String id;
        String name;

        private CreateRecord() {
        }
    }
}

