/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.filters;

import java.awt.Color;
import org.geneontology.oboedit.gui.filters.RenderSpec;

public class LinkRenderSpec
implements RenderSpec {
    public static final int SOLID_LINE = 0;
    public static final int WAVY_LINE = 1;
    public static final int DASHED_LINE = 2;
    protected Color linkColor;
    protected int lineWidth;
    protected int lineType;

    public LinkRenderSpec() {
        this.clear();
    }

    public String toString() {
        String out = "";
        if (this.linkColor != null) {
            out = out + "color = " + this.linkColor;
        }
        if (this.lineWidth != -1) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            out = out + "line width = " + this.lineWidth;
        }
        if (this.lineType != -1) {
            if (!out.equals("")) {
                out = out + ", ";
            }
            if (this.lineType == 0) {
                out = out + "line type = SOLID";
            } else if (this.lineType == 1) {
                out = out + "line type = WAVY";
            } else if (this.lineType == 2) {
                out = out + "line type = DASHED";
            }
        }
        return out;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void clear() {
        this.linkColor = null;
        this.lineWidth = -1;
        this.lineType = -1;
    }

    public void setLineType(int lineType) {
        this.lineType = lineType;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLinkColor(Color linkColor) {
        this.linkColor = linkColor;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void merge(RenderSpec s) {
        if (s == null) {
            return;
        }
        if (!(s instanceof LinkRenderSpec)) {
            throw new IllegalArgumentException();
        }
        LinkRenderSpec spec = (LinkRenderSpec)s;
        if (this.lineWidth == -1) {
            this.lineWidth = spec.getLineWidth();
        }
        if (this.lineType == -1) {
            this.lineType = spec.getLineType();
        }
        if (this.linkColor == null) {
            this.linkColor = spec.getLinkColor();
        }
    }
}

