/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.filters;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.filters.AbstractStringCriterion;
import org.geneontology.oboedit.gui.filters.CommentSearchCriterion;
import org.geneontology.oboedit.gui.filters.DbxrefSearchCriterion;
import org.geneontology.oboedit.gui.filters.DefinitionSearchCriterion;
import org.geneontology.oboedit.gui.filters.IDSearchCriterion;
import org.geneontology.oboedit.gui.filters.NameSynonymSearchCriterion;
import org.geneontology.oboedit.gui.filters.SearchCriterion;

public class KeywordSearchCriterion
extends AbstractStringCriterion {
    protected List keywordCriteria = new LinkedList();

    public KeywordSearchCriterion() {
        this.keywordCriteria.add(new NameSynonymSearchCriterion());
        this.keywordCriteria.add(new IDSearchCriterion());
        this.keywordCriteria.add(new CommentSearchCriterion());
        this.keywordCriteria.add(new DefinitionSearchCriterion());
        this.keywordCriteria.add(new DbxrefSearchCriterion());
    }

    public Collection getValues(Collection scratch, Object obj) {
        Iterator it = this.keywordCriteria.iterator();
        while (it.hasNext()) {
            SearchCriterion sc = (SearchCriterion)it.next();
            List scratchList = TermUtil.mallocList();
            sc.getValues(scratchList, obj);
            Iterator it2 = scratchList.iterator();
            while (it2.hasNext()) {
                String s = (String)it2.next();
                KeywordSearchCriterion.extractKeywords(scratch, s);
            }
            TermUtil.freeList(scratchList);
        }
        return scratch;
    }

    public String getID() {
        return "keyword";
    }

    public static void extractKeywords(Collection c, String s) {
        if (s == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, "\t -,+_.!?'\"(){}[]<>;/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() <= 0) continue;
            c.add(token);
        }
    }

    public Class getInputType() {
        return IdentifiedObject.class;
    }

    public String toString() {
        return "Keyword";
    }
}

