/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.List;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.NecessarilyTrueHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class SpecificNecessaryAction
implements ClickMenuAction {
    protected TreePath[] sources;
    protected boolean isLegal = false;
    protected Controller controller;
    protected boolean changeTo;

    public SpecificNecessaryAction(boolean changeTo) {
        this.changeTo = changeTo;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public String getName() {
        return "Change necessity to " + this.changeTo;
    }

    public String getDesc() {
        return this.getName();
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] sources, TreePath destItem) {
        this.isLegal = true;
        this.sources = sources;
        if (sources.length < 1) {
            this.isLegal = false;
            return;
        }
        boolean found = false;
        for (int i = 0; i < sources.length; ++i) {
            OBORestriction tr = (OBORestriction)sources[i].getLastPathComponent();
            if (TermUtil.isFake(tr) || tr.isNecessarilyTrue() == this.changeTo) continue;
            found = true;
            break;
        }
        if (!found) {
            this.isLegal = false;
            return;
        }
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        HistoryItem item;
        Vector<NecessarilyTrueHistoryItem> items = new Vector<NecessarilyTrueHistoryItem>();
        for (int i = 0; i < this.sources.length; ++i) {
            OBORestriction tr = (OBORestriction)this.sources[i].getLastPathComponent();
            if (tr.isNecessarilyTrue() == this.changeTo) continue;
            items.add(new NecessarilyTrueHistoryItem(tr));
        }
        if (items.size() == 1) {
            item = (HistoryItem)items.get(0);
        } else {
            item = new TermMacroHistoryItem("Changed necessity");
            for (int i = 0; i < items.size(); ++i) {
                ((TermMacroHistoryItem)item).addHistoryItem((HistoryItem)items.get(i));
            }
        }
        item.setPreSelection(this.sources);
        item.setPostSelection(this.sources);
        return item;
    }
}

