/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.List;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class SpecificCopyAction
implements ClickMenuAction {
    protected boolean useOriginalType;
    protected OBOProperty type;
    protected boolean copyChild;
    protected TreePath[] sources;
    protected TreePath dest;
    protected boolean isLegal = false;
    protected Controller controller;

    public SpecificCopyAction(OBOProperty type, boolean useOriginalType, boolean copyChild) {
        this.type = type;
        this.useOriginalType = useOriginalType;
        this.copyChild = copyChild;
    }

    public void setOriginalType(boolean useOriginalType) {
        this.useOriginalType = useOriginalType;
    }

    public void setCopyChild(boolean copyChild) {
        this.copyChild = copyChild;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return null;
    }

    public OBOProperty getType() {
        return this.type;
    }

    public boolean getUseOriginalType() {
        return this.useOriginalType;
    }

    public String getName() {
        if (this.useOriginalType) {
            return "Use original type";
        }
        return this.type.toString();
    }

    public String getDesc() {
        return this.getName();
    }

    public List getSubActions() {
        return null;
    }

    protected Link getTR(LinkedObject target, LinkedObject copied, OBOProperty type) {
        if (this.copyChild) {
            return new OBORestrictionImpl(copied, target, type);
        }
        return new OBORestrictionImpl(target, copied, type);
    }

    public void clickInit(TreePath[] paths, TreePath destItem) {
        LinkedObject target = null;
        if (destItem == null) {
            this.isLegal = false;
            return;
        }
        if (!(destItem.getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        this.dest = destItem;
        target = ((Link)destItem.getLastPathComponent()).getChild();
        if (paths != null) {
            this.sources = paths;
            for (int i = 0; i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof Link)) {
                    this.isLegal = false;
                    return;
                }
                Link tr = (Link)paths[i].getLastPathComponent();
                if (this.useOriginalType && tr.getType() == null) {
                    this.isLegal = false;
                    return;
                }
                if (this.useOriginalType) {
                    this.type = tr.getType();
                }
                if (this.type == null) {
                    this.isLegal = false;
                    return;
                }
                Link newtr = this.getTR(target, tr.getChild(), this.type);
                if (TermUtil.isLegalRelationship(newtr.getChild(), newtr.getType(), newtr.getParent())) continue;
                this.isLegal = false;
                return;
            }
            this.isLegal = true;
        } else {
            this.isLegal = false;
        }
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        HistoryItem item;
        Vector<TermCopyHistoryItem> historyList = new Vector<TermCopyHistoryItem>();
        Vector<TreePath> pathouts = new Vector<TreePath>();
        LinkedObject target = ((Link)this.dest.getLastPathComponent()).getChild();
        for (int i = 0; i < this.sources.length; ++i) {
            Link tr = (Link)this.sources[i].getLastPathComponent();
            if (this.useOriginalType) {
                this.type = tr.getType();
            }
            Link newtr = this.getTR(target, tr.getChild(), this.type);
            if (this.copyChild) {
                historyList.add(new TermCopyHistoryItem(target, tr.getChild(), this.type));
                TreePath outpath = this.dest.pathByAddingChild(newtr);
                pathouts.add(TermUtil.convertPathToIDs(outpath));
                continue;
            }
            historyList.add(new TermCopyHistoryItem(tr.getChild(), target, this.type));
        }
        if (!this.copyChild) {
            pathouts.add(this.dest);
        }
        if (historyList.size() == 1) {
            item = (HistoryItem)historyList.get(0);
        } else {
            item = new TermMacroHistoryItem("Copied terms");
            for (int i = 0; i < historyList.size(); ++i) {
                ((TermMacroHistoryItem)item).addHistoryItem((HistoryItem)historyList.get(i));
            }
        }
        TreePath[] outpatharr = new TreePath[pathouts.size()];
        for (int i = 0; i < outpatharr.length; ++i) {
            outpatharr[i] = (TreePath)pathouts.get(i);
        }
        item.setPreSelection(TermUtil.convertPathsToIDs(this.sources));
        item.setPostSelection(outpatharr);
        return item;
    }
}

