/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.List;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.RangeHistoryItem;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DropMenuAction;
import org.geneontology.util.ObjectUtil;

public class RangeChangeAction
implements DropMenuAction {
    protected boolean fromDrop = false;
    protected boolean isLegal = false;
    protected OBOProperty target;
    protected OBOClass range;
    protected TreePath[] sources;
    protected TreePath dest;
    protected Controller controller;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public String getName() {
        return "Change range";
    }

    public String getDesc() {
        return "Change range";
    }

    public List getSubActions() {
        return null;
    }

    public void dropInit(TreePath[] paths, TreePath destItem) {
        this.dest = destItem;
        this.sources = paths;
        if (paths == null) {
            this.isLegal = false;
            return;
        }
        if (destItem == null) {
            this.isLegal = false;
            return;
        }
        if (paths.length != 1) {
            this.isLegal = false;
            return;
        }
        if (!(paths[0].getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        if (!(destItem.getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        Link destLink = (Link)destItem.getLastPathComponent();
        Link sourceLink = (Link)paths[0].getLastPathComponent();
        if (!TermUtil.isProperty(destLink.getChild())) {
            this.isLegal = false;
            return;
        }
        if (!TermUtil.isClass(sourceLink.getChild())) {
            this.isLegal = false;
            return;
        }
        this.range = (OBOClass)sourceLink.getChild();
        this.target = (OBOProperty)destLink.getChild();
        if (ObjectUtil.equals((Object)this.target.getRange(), (Object)this.range)) {
            this.isLegal = false;
            return;
        }
        this.isLegal = true;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        RangeHistoryItem item = new RangeHistoryItem(this.target, this.range);
        TreePath[] preSelection = new TreePath[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            preSelection[i] = TermUtil.convertPathToIDs(this.sources[i]);
        }
        item.setPreSelection(preSelection);
        TreePath[] destPaths = new TreePath[]{TermUtil.convertPathToIDs(this.dest)};
        item.setPostSelection(destPaths);
        return item;
    }
}

