/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.ObjectFactory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DefaultObjectFactory;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;

public class CloneAction
implements ClickMenuAction {
    protected TreePath[] sources;
    protected Collection cloneThese = new HashSet();
    protected boolean isLegal = false;
    protected Controller controller;
    protected static KeyStroke keyStroke = KeyStroke.getKeyStroke(76, 2);
    protected HistoryList historyList = new DefaultHistoryList();
    protected ObjectFactory defaultFactory = new DefaultObjectFactory();

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public KeyStroke getKeyStroke() {
        return keyStroke;
    }

    public String getName() {
        return "Clone";
    }

    public String getDesc() {
        return "Clone";
    }

    public List getSubActions() {
        return null;
    }

    public void clickInit(TreePath[] sources, TreePath destItem) {
        this.isLegal = sources.length > 0;
        this.sources = sources;
        this.cloneThese.clear();
        for (int i = 0; i < sources.length; ++i) {
            if (!(sources[i].getLastPathComponent() instanceof Link)) {
                this.isLegal = false;
                return;
            }
            Link tr = (Link)sources[i].getLastPathComponent();
            LinkedObject child = tr.getChild();
            this.cloneThese.add(child);
            if (!child.isBuiltIn()) continue;
            this.isLegal = false;
            return;
        }
        this.sources = sources;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        HistoryItem item;
        LinkedList<TermMacroHistoryItem> itemList = new LinkedList<TermMacroHistoryItem>();
        Iterator it = this.cloneThese.iterator();
        HashSet<String> ids = new HashSet<String>();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            io = (IdentifiedObject)io.clone();
            String id = TermUtil.fetchID(Controller.getController(), null, ids, false);
            ids.add(id);
            io.setName("CLONE OF " + io.getName());
            IdentifiedObject clone = this.defaultFactory.createObject(id, (OBOClass)io.getType(), false);
            this.historyList.getHistoryList().clear();
            this.historyList.addItem(new CreateObjectHistoryItem(id, io.getType().getID()));
            HistoryGenerator.getTermTextChanges(clone, io, this.historyList, true);
            if (io.getNamespace() != null) {
                this.historyList.addItem(new NamespaceHistoryItem(null, io.getNamespace(), id));
            }
            if (io instanceof LinkedObject) {
                Iterator it2 = ((LinkedObject)io).getChildren().iterator();
                while (it2.hasNext()) {
                    Link childLink = (Link)it2.next();
                    this.historyList.addItem(new TermCopyHistoryItem((LinkedObject)clone, childLink));
                }
                it2 = ((LinkedObject)io).getParents().iterator();
                while (it2.hasNext()) {
                    Link parentLink = (Link)it2.next();
                    this.historyList.addItem(new TermCopyHistoryItem(parentLink.getParent(), (LinkedObject)clone, parentLink.getType()));
                }
            }
            HistoryGenerator.getObsoleteChanges(clone, io, this.historyList);
            TermMacroHistoryItem cloneItem = new TermMacroHistoryItem("Clone");
            Iterator it2 = this.historyList.getHistoryItems();
            while (it2.hasNext()) {
                HistoryItem item2 = (HistoryItem)it2.next();
                cloneItem.addHistoryItem(item2);
            }
            itemList.add(cloneItem);
        }
        if (itemList.size() == 1) {
            item = (HistoryItem)itemList.get(0);
        } else {
            item = new TermMacroHistoryItem("Cloned multiple terms");
            it = itemList.iterator();
            while (it.hasNext()) {
                HistoryItem subItem = (HistoryItem)it.next();
                ((TermMacroHistoryItem)item).addHistoryItem(subItem);
            }
        }
        item.setPreSelection(TermUtil.convertPathsToIDs(this.sources));
        item.setPostSelection(new TreePath[0]);
        return item;
    }
}

