/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Dimension;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.geneontology.expression.ExpressionException;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.CheckWarningComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.OBOTextEditComponent;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.HistoryAppliedEvent;
import org.geneontology.oboedit.gui.event.HistoryListener;
import org.geneontology.oboedit.gui.event.PreSelectionEvent;
import org.geneontology.oboedit.gui.event.PreSelectionListener;
import org.geneontology.oboedit.gui.event.ReconfigEvent;
import org.geneontology.oboedit.gui.event.ReconfigListener;
import org.geneontology.oboedit.gui.event.SubSelectEvent;
import org.geneontology.oboedit.gui.event.SubSelectListener;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.swing.XMLLayoutRoot;

public class TextEditManager {
    protected PreSelectionListener listener = new PreSelectionListener(){

        public boolean isPreSelectOkay(PreSelectionEvent e) {
            return TextEditManager.this.checkUncommittedEdits();
        }
    };
    protected SubSelectListener subSelectListener = new SubSelectListener(){

        public void selectObject(SubSelectEvent e) {
            TextEditManager.this.resync();
        }
    };
    protected ReconfigListener reconfigListener = new ReconfigListener(){

        public void configReloaded(ReconfigEvent e) {
            TextEditManager.this.editorComponents.clear();
        }
    };
    protected HistoryListener historyListener = new HistoryListener(){

        public void applied(HistoryAppliedEvent event) {
            String id = event.getHistoryItem().getTarget();
            if (id != null && TextEditManager.this.currentObject != null && id.equals(TextEditManager.this.currentObject.getID())) {
                TextEditManager.this.forceLoad(Controller.getController().getSession().getObject(id));
            }
        }

        public void reversed(HistoryAppliedEvent event) {
            String id = event.getHistoryItem().getTarget();
            if (id != null && TextEditManager.this.currentObject != null && id.equals(TextEditManager.this.currentObject.getID())) {
                TextEditManager.this.forceLoad(Controller.getController().getSession().getObject(id));
            }
        }
    };
    protected IdentifiedObject currentObject;
    protected Set editorComponents = new HashSet();
    protected Set panels = new HashSet();

    public void registerPanel(XMLLayoutRoot panel) {
        this.panels.add(panel);
    }

    public void unregisterPanel(XMLLayoutRoot panel) {
        this.panels.remove(panel);
    }

    public void registerComponent(OBOTextEditComponent c) {
        this.editorComponents.add(c);
    }

    public void unregisterComponent(OBOTextEditComponent c) {
        this.editorComponents.remove(c);
    }

    public void setController(Controller controller) {
        controller.addListener(this.listener);
        controller.addListener(this.subSelectListener);
        controller.addListener(this.historyListener);
        controller.addListener(this.reconfigListener);
    }

    public void clear() {
        this.currentObject = null;
        this.updateComponents();
    }

    public void resync() {
        this.doSelect(Controller.getController().getSubSelection());
    }

    public void forceSync() {
        this.forceLoad(Controller.getController().getSubSelection());
    }

    protected void doSelect(IdentifiedObject io) {
        if (Controller.getController().getPreferences().getAutoCommitTextEdits()) {
            this.flushEdits();
        }
        this.forceLoad(io);
    }

    protected void forceLoad(IdentifiedObject io) {
        this.currentObject = io;
        this.updateComponents();
    }

    protected void updateComponents() {
        Iterator it = this.panels.iterator();
        while (it.hasNext()) {
            XMLLayoutRoot panel = (XMLLayoutRoot)it.next();
            try {
                panel.guiupdate();
            }
            catch (ExpressionException ex) {
                ex.printStackTrace();
            }
        }
        it = this.editorComponents.iterator();
        while (it.hasNext()) {
            OBOTextEditComponent c = (OBOTextEditComponent)it.next();
            c.setObject(this.currentObject);
            this.activateTabs(c);
        }
    }

    public boolean editsArePending() {
        return this.getHistoryItems().size() > 0;
    }

    protected void activateTabs(OBOTextEditComponent c) {
    }

    public IdentifiedObject getCurrentObject() {
        return this.currentObject;
    }

    public void acceptEdits() {
        if (this.checkComponents()) {
            this.flushEdits();
        } else {
            System.err.println("DID NOT FLUSH EDITS BECAUSE checkComponents() returned false");
        }
    }

    public void revert() {
        this.updateComponents();
    }

    public void flushEdits() {
        TermMacroHistoryItem item = new TermMacroHistoryItem("Text edit");
        Iterator it = this.getHistoryItems().iterator();
        while (it.hasNext()) {
            HistoryItem subItem = (HistoryItem)it.next();
            item.addHistoryItem(subItem);
        }
        if (item.getHistoryItemCount() > 0) {
            TreePath[] paths = TermUtil.convertPathsToIDs(Controller.getController().getSelectedPaths());
            item.setPostSelection(paths);
            item.setPreSelection(paths);
            Controller.getController().doApply(item, false);
        }
    }

    public void commit() {
        this.acceptEdits();
    }

    public boolean checkUncommittedEdits() {
        return this.checkUncommittedEdits(true);
    }

    public boolean checkUncommittedEdits(boolean doAutoCommit) {
        Preferences prefs = Controller.getController().getPreferences();
        if (prefs.getAutoCommitTextEdits()) {
            boolean b = this.checkComponents();
            if (doAutoCommit & b) {
                this.flushEdits();
            }
            return b;
        }
        if (prefs.getWarnBeforeDiscardingEdits() && Controller.getController().getTextEditManager().getHistoryItems().size() > 0) {
            int val = JOptionPane.showConfirmDialog(Controller.getController().getFrame(), "There are uncommitted text edits.\nDiscard these edits?", "Pending edits", 0);
            return val == 0;
        }
        return true;
    }

    public Collection getHistoryItems() {
        LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
        Iterator it = this.editorComponents.iterator();
        while (it.hasNext()) {
            OBOTextEditComponent c = (OBOTextEditComponent)it.next();
            Iterator it2 = c.getChanges().iterator();
            while (it2.hasNext()) {
                HistoryItem subItem = (HistoryItem)it2.next();
                out.add(subItem);
            }
        }
        return out;
    }

    protected boolean checkComponents() {
        Object c;
        if (this.currentObject == null) {
            return true;
        }
        IdentifiedObject cloneObject = (IdentifiedObject)this.currentObject.clone();
        boolean changed = false;
        Iterator it = this.editorComponents.iterator();
        while (it.hasNext()) {
            c = (OBOTextEditComponent)it.next();
            if (!changed && c.getChanges().size() > 0) {
                changed = true;
            }
            c.populateFields(cloneObject);
        }
        if (!changed) {
            return true;
        }
        c = Controller.getController().getVerificationEngine().runChecks(Controller.getController().getSession(), cloneObject, (byte)1);
        byte warningConditions = Controller.getController().getVerificationEngine().getWarningConditions();
        int fatalCount = VerificationEngine.countFatal((Collection)c);
        int warningCount = c.size() - fatalCount;
        boolean showWarnings = VerificationEngine.getConditionAtField(warningConditions, (byte)1);
        if (fatalCount > 0 || warningCount > 0 && showWarnings) {
            CheckWarningComponent warningComponent = new CheckWarningComponent();
            String header = null;
            String footer = null;
            if (fatalCount > 0) {
                header = "Cannot commit text edit changes because of " + (fatalCount > 1 ? fatalCount + " fatal errors:" : "a fatal error:");
            } else {
                header = warningCount == 1 ? "There is a potential problem " : "There are " + warningCount + " potential problems " + "with pending text edits:";
                footer = "Proceed with save?";
            }
            warningComponent.setWarnings((Collection)c, header, footer, true, showWarnings, false);
            warningComponent.setPreferredSize(new Dimension(300, 300));
            int dialogType = 2;
            if (fatalCount == 0) {
                dialogType = 1;
            }
            int dialogVal = warningComponent.showDialog(Controller.getController().getFrame(), fatalCount > 0 ? "Fatal errors found" : "Warnings found", dialogType);
            if (fatalCount > 0 || dialogVal != 1) {
                return false;
            }
        }
        return true;
    }
}

