/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.Type;
import org.geneontology.oboedit.datamodel.history.RangeHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropAdapter;
import org.geneontology.swing.event.DropListener;
import org.geneontology.util.ObjectUtil;

public class RangeEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected Border lineBorder = new LineBorder(Color.black);
    protected Border oldBorder;
    protected JButton rangeButton = new JButton("<no range>");
    protected Type range;
    protected DropListener dropRangeListener = new DropAdapter(){

        public boolean allowDrop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1) {
                LinkedObject termRange = ((Link)paths[0].getLastPathComponent()).getChild();
                return !RangeEditorComponent.this.currentObject.equals(termRange);
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            RangeEditorComponent.this.oldBorder = RangeEditorComponent.this.rangeButton.getBorder();
            RangeEditorComponent.this.rangeButton.setBorder(RangeEditorComponent.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            RangeEditorComponent.this.rangeButton.setBorder(RangeEditorComponent.this.oldBorder);
        }

        public void drop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1 && ((Link)paths[0].getLastPathComponent()).getChild() instanceof Type) {
                RangeEditorComponent.this.setRange((Type)((Object)((Link)paths[0].getLastPathComponent()).getChild()));
            }
            RangeEditorComponent.this.rangeButton.setBorder(RangeEditorComponent.this.oldBorder);
        }
    };
    protected DropTarget dropTarget = new DropTarget((Component)this.rangeButton, this.dropRangeListener);

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("range_button")) {
            return this.rangeButton;
        }
        return new JButton(id);
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<box orientation='HORZ'><label text='Range'/><spacer orientation='horz' size='10'/><component id='range_button'/></box>";
    }

    protected void loadGUI() {
        if (this.currentObject != null && this.currentObject instanceof OBOProperty) {
            this.setRange(((OBOProperty)this.currentObject).getRange());
        } else {
            this.setRange(null);
        }
    }

    public void setRange(Type range) {
        this.range = range;
        if (range == null) {
            this.rangeButton.setLabel("<no range specified>");
        } else {
            this.rangeButton.setLabel(range.getName() + " (" + range.getID() + ")");
        }
        this.rangeButton.setMinimumSize(this.rangeButton.getPreferredSize());
    }

    protected String getWarningLabel() {
        return "";
    }

    protected void installListeners() {
        Controller.getController().getDragController().registerDropTarget(this.dropTarget);
    }

    protected void uninstallListeners() {
        Controller.getController().getDragController().unregisterDropTarget(this.dropTarget);
    }

    protected void initializeGUI() {
        Font font = Controller.getController().getDefaultFont();
        this.rangeButton.setFont(font);
        this.rangeButton.setBackground(Controller.getController().getPreferences().getButtonColor());
        this.setMinimumSize(this.getPreferredSize());
    }

    public String getID() {
        return "RANGE_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        if (io instanceof OBOProperty) {
            ((OBOProperty)io).setRange(this.range);
        }
    }

    public List getChanges() {
        if (this.currentObject != null && this.currentObject instanceof OBOProperty) {
            LinkedList<RangeHistoryItem> out = new LinkedList<RangeHistoryItem>();
            if (!ObjectUtil.equals((Object)this.range, (Object)((OBOProperty)this.currentObject).getRange())) {
                out.add(new RangeHistoryItem((OBOProperty)this.currentObject, this.range));
            }
            return out;
        }
        return Collections.EMPTY_LIST;
    }
}

