/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.filters.AbstractFilterEditor;
import org.geneontology.oboedit.gui.filters.AncestorSearchAspect;
import org.geneontology.oboedit.gui.filters.DescendantSearchAspect;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterUtil;
import org.geneontology.oboedit.gui.filters.ObjectFilter;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;
import org.geneontology.oboedit.gui.filters.RootSearchAspect;
import org.geneontology.oboedit.gui.filters.SearchAspect;
import org.geneontology.oboedit.gui.filters.SearchComparison;
import org.geneontology.oboedit.gui.filters.SearchCriterion;
import org.geneontology.oboedit.gui.filters.SelfSearchAspect;

public class ObjectFilterPanel
extends AbstractFilterEditor {
    private static final long serialVersionUID = 1L;
    protected ObjectFilter filter;
    protected JCheckBox notCheckBox = new JCheckBox("NOT");
    protected JComboBox aspectComboBox = new JComboBox();
    protected JComboBox criterionComboBox = new JComboBox();
    protected JComboBox comparisonComboBox = new JComboBox();
    protected JTextField valueField = new JTextField();
    protected Box topLine = new Box(0);
    protected JPanel bottomPanel = new JPanel();
    protected static int idgen = 0;
    protected int id = idgen++;
    protected Class objectClass = Object.class;
    ActionListener criterionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            SearchCriterion sc = (SearchCriterion)ObjectFilterPanel.this.criterionComboBox.getSelectedItem();
            ObjectFilterPanel.this.setComparisonClass(sc.getReturnType());
            ObjectFilterPanel.this.fireFilterEditUpdate();
        }
    };
    KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            ObjectFilterPanel.this.fireFilterEditUpdate();
        }
    };
    ActionListener updatingActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ObjectFilterPanel.this.fireFilterEditUpdate();
        }
    };
    ActionListener acceptListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
        }
    };

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.notCheckBox.setEnabled(enabled);
        this.criterionComboBox.setEnabled(enabled);
        this.aspectComboBox.setEnabled(enabled);
        this.comparisonComboBox.setEnabled(enabled);
        this.valueField.setEnabled(enabled);
    }

    public String toString() {
        return "ObjectFilterPanel:" + this.id;
    }

    public void setFont(Font font) {
        if (this.notCheckBox != null) {
            this.notCheckBox.setFont(font);
        }
        if (this.criterionComboBox != null) {
            this.criterionComboBox.setFont(font);
        }
        if (this.aspectComboBox != null) {
            this.aspectComboBox.setFont(font);
        }
        if (this.comparisonComboBox != null) {
            this.comparisonComboBox.setFont(font);
        }
        if (this.valueField != null) {
            this.valueField.setFont(font);
        }
    }

    public void setButtonColor(Color buttonColor) {
        this.notCheckBox.setBackground(buttonColor);
        this.criterionComboBox.setBackground(buttonColor);
        this.comparisonComboBox.setBackground(buttonColor);
        this.aspectComboBox.setBackground(buttonColor);
    }

    public void setObjectClass(Class c) {
        if (!c.equals(this.objectClass)) {
            this.criterionComboBox.removeActionListener(this.criterionListener);
            Object oldSelection = this.criterionComboBox.getSelectedItem();
            this.criterionComboBox.removeAllItems();
            Collection col = FilterUtil.filterCriteriaByInput(this.getAllCriteria(), c);
            Iterator it = col.iterator();
            boolean matched = false;
            while (it.hasNext()) {
                Object o = it.next();
                if (oldSelection != null && o.equals(oldSelection)) {
                    matched = true;
                }
                this.criterionComboBox.addItem(o);
            }
            if (matched) {
                this.criterionComboBox.setSelectedItem(oldSelection);
                this.criterionComboBox.addActionListener(this.criterionListener);
            } else {
                this.criterionComboBox.addActionListener(this.criterionListener);
                this.criterionComboBox.setSelectedIndex(0);
            }
            this.objectClass = c;
        }
    }

    public void setComparisonClass(Class c) {
        this.topLine.removeAll();
        this.remove(this.bottomPanel);
        this.topLine.add(this.notCheckBox);
        this.topLine.add(Box.createHorizontalStrut(10));
        this.topLine.add(this.aspectComboBox);
        this.topLine.add(Box.createHorizontalStrut(10));
        this.topLine.add(this.criterionComboBox);
        if (!Boolean.class.isAssignableFrom(c)) {
            this.topLine.add(Box.createHorizontalStrut(10));
            this.topLine.add(this.comparisonComboBox);
            this.add((Component)this.bottomPanel, "Center");
            Object oldSelection = this.comparisonComboBox.getSelectedItem();
            boolean stillThere = false;
            this.comparisonComboBox.removeAllItems();
            Collection col = FilterUtil.filterComparisonByInput(this.getAllComparisons(), c);
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (oldSelection != null && o.equals(oldSelection)) {
                    stillThere = true;
                }
                this.comparisonComboBox.addItem(o);
            }
            if (stillThere && oldSelection != null) {
                this.comparisonComboBox.setSelectedItem(oldSelection);
            }
        }
        this.validate();
        this.repaint();
    }

    public ObjectFilterPanel() {
        this.bottomPanel.setLayout(new BorderLayout());
        this.filter = new ObjectFilterImpl();
        this.attachListeners();
        this.setObjectClass(IdentifiedObject.class);
        this.topLine.add(this.notCheckBox);
        this.topLine.add(Box.createHorizontalStrut(10));
        this.topLine.add(this.aspectComboBox);
        this.topLine.add(Box.createHorizontalStrut(10));
        this.topLine.add(this.criterionComboBox);
        this.topLine.add(Box.createHorizontalStrut(10));
        this.topLine.add(this.comparisonComboBox);
        this.bottomPanel.add((Component)this.valueField, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)this.topLine, "North");
        this.add((Component)this.bottomPanel, "Center");
        this.setOpaque(false);
        this.bottomPanel.setOpaque(false);
        this.aspectComboBox.addItem(new SelfSearchAspect());
        this.aspectComboBox.addItem(new AncestorSearchAspect());
        this.aspectComboBox.addItem(new DescendantSearchAspect());
        this.aspectComboBox.addItem(new RootSearchAspect());
        this.notCheckBox.setOpaque(false);
        this.notCheckBox.addActionListener(this.acceptListener);
        this.comparisonComboBox.addActionListener(this.acceptListener);
        this.criterionComboBox.setSelectedIndex(0);
    }

    public void acceptEdits() {
        this.removeListeners();
        this.filter.setNegate(this.notCheckBox.isSelected());
        this.filter.setAspect((SearchAspect)this.aspectComboBox.getSelectedItem());
        this.filter.setCriterion((SearchCriterion)this.criterionComboBox.getSelectedItem());
        this.filter.setComparison((SearchComparison)this.comparisonComboBox.getSelectedItem());
        this.filter.setValue(this.valueField.getText());
        this.attachListeners();
    }

    protected void attachListeners() {
        this.criterionComboBox.addActionListener(this.criterionListener);
        this.notCheckBox.addActionListener(this.updatingActionListener);
        this.aspectComboBox.addActionListener(this.updatingActionListener);
        this.comparisonComboBox.addActionListener(this.updatingActionListener);
        this.valueField.addKeyListener(this.keyListener);
    }

    protected void removeListeners() {
        this.criterionComboBox.removeActionListener(this.criterionListener);
        this.notCheckBox.removeActionListener(this.updatingActionListener);
        this.aspectComboBox.removeActionListener(this.updatingActionListener);
        this.comparisonComboBox.removeActionListener(this.updatingActionListener);
        this.valueField.removeKeyListener(this.keyListener);
    }

    protected void updateGUI() {
        this.removeListeners();
        this.notCheckBox.setSelected(this.filter.getNegate());
        this.aspectComboBox.setSelectedItem(this.filter.getAspect());
        this.criterionComboBox.setSelectedItem(this.filter.getCriterion());
        this.comparisonComboBox.setSelectedItem(this.filter.getComparison());
        this.valueField.setText(this.filter.getValue());
        if (this.filter.getComparison() != null) {
            this.setComparisonClass(this.filter.getCriterion().getReturnType());
        }
        this.attachListeners();
    }

    public void addActionListener(ActionListener listener) {
        this.valueField.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.valueField.removeActionListener(listener);
    }

    public List getAllCriteria() {
        return Controller.getController().getSearchCriteria();
    }

    public List getAllComparisons() {
        return Controller.getController().getSearchComparisons();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = (ObjectFilter)filter;
        this.updateGUI();
    }
}

