/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.gui.CategoryEditorComponent;
import org.geneontology.oboedit.gui.CommentEditorComponent;
import org.geneontology.oboedit.gui.CompleteDefPanel;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DETermEditor;
import org.geneontology.oboedit.gui.DbxrefEditorComponent;
import org.geneontology.oboedit.gui.DefinitionEditorComponent;
import org.geneontology.oboedit.gui.DomainEditorComponent;
import org.geneontology.oboedit.gui.FindPanel;
import org.geneontology.oboedit.gui.IDEditorComponent;
import org.geneontology.oboedit.gui.InstanceBrowserHolder;
import org.geneontology.oboedit.gui.InstanceEditorHolder;
import org.geneontology.oboedit.gui.NameEditorComponent;
import org.geneontology.oboedit.gui.NamespaceEditorComponent;
import org.geneontology.oboedit.gui.OBOCellRenderer;
import org.geneontology.oboedit.gui.OBOCommitButton;
import org.geneontology.oboedit.gui.OBOEditComponent;
import org.geneontology.oboedit.gui.OBOPanelHolder;
import org.geneontology.oboedit.gui.OBORevertButton;
import org.geneontology.oboedit.gui.OBOTermEditor;
import org.geneontology.oboedit.gui.ObjectSelector;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.PropertyBoxesEditorComponent;
import org.geneontology.oboedit.gui.RangeEditorComponent;
import org.geneontology.oboedit.gui.SynonymEditorComponent;
import org.geneontology.oboedit.gui.UserFilterButton;
import org.geneontology.oboedit.gui.event.PluginEvent;
import org.geneontology.oboedit.gui.event.SelectionEvent;
import org.geneontology.oboedit.gui.event.SelectionListener;
import org.geneontology.swing.ComponentNameResolver;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.util.ObjectUtil;
import org.geneontology.util.VectorFilter;
import org.geneontology.util.VectorTransformer;
import org.geneontology.util.VectorUtil;

public class OBOEditComponentNameResolver
implements ComponentNameResolver {
    protected ListEditor listEditor;
    protected InstanceBrowserHolder instanceBrowserHolder;
    protected InstanceEditorHolder instanceEditorHolder;
    protected Map buttonGroups;
    protected ListSelectionListener listSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            Object o = OBOEditComponentNameResolver.this.listEditor.getSelectedItem();
            OBOClass term = (OBOClass)o;
            Controller.getController().setSubSelection(term);
        }
    };
    protected SelectionListener listEditorSelectionListener = new SelectionListener(){

        public void select(SelectionEvent e) {
            IdentifiedObject newSelectedTerm;
            Vector terms = (Vector)Controller.getController().getSelectedTerms().clone();
            VectorFilter filter = new VectorFilter(){
                private static final long serialVersionUID = -575393786243764726L;

                public boolean satisfies(Object in) {
                    if (in == null) {
                        return false;
                    }
                    return in instanceof IdentifiedObject;
                }
            };
            VectorTransformer transformer = new VectorTransformer(){

                public Object transform(Object in) {
                    if (in instanceof Link) {
                        return ((Link)in).getChild();
                    }
                    return in;
                }
            };
            Comparator comparator = new Comparator(){

                public int compare(Object oa, Object ob) {
                    IdentifiedObject a = (IdentifiedObject)oa;
                    IdentifiedObject b = (IdentifiedObject)ob;
                    return a.getName().compareTo(b.getName());
                }
            };
            terms = VectorUtil.transform((VectorTransformer)transformer, (Vector)terms);
            terms = VectorUtil.filter((VectorFilter)filter, (Vector)terms);
            Vector v = new Vector();
            for (int i = 0; i < terms.size(); ++i) {
                if (v.contains(terms.get(i))) continue;
                v.add(terms.get(i));
            }
            Collections.sort(v, comparator);
            terms = v;
            Object selectedValue = OBOEditComponentNameResolver.this.listEditor.getSelectedItem();
            OBOEditComponentNameResolver.this.listEditor.removeListSelectionListener(OBOEditComponentNameResolver.this.listSelectionListener);
            OBOEditComponentNameResolver.this.listEditor.setData(terms);
            if (terms.size() > 1) {
                OBOEditComponentNameResolver.this.listEditor.setShowListPanel(true);
            } else {
                OBOEditComponentNameResolver.this.listEditor.setShowListPanel(false);
            }
            if (terms.size() > 0) {
                OBOEditComponentNameResolver.this.listEditor.select(0);
            }
            if (!ObjectUtil.equals((Object)selectedValue, (Object)(newSelectedTerm = (IdentifiedObject)OBOEditComponentNameResolver.this.listEditor.getSelectedItem()))) {
                Controller.getController().setSubSelection(newSelectedTerm, true);
            }
            OBOEditComponentNameResolver.this.listEditor.addListSelectionListener(OBOEditComponentNameResolver.this.listSelectionListener);
        }
    };

    protected void buildListEditor() {
        DETermEditor editor = new DETermEditor(Controller.getController());
        editor.setFont(Controller.getController().getDefaultFont());
        JTextArea noSelectionLabel = new JTextArea("Select a term from the list to view/edit the term data.");
        noSelectionLabel.setOpaque(false);
        noSelectionLabel.setFont(Controller.getController().getDefaultFont());
        noSelectionLabel.setDisabledTextColor(Color.black);
        noSelectionLabel.setLineWrap(true);
        noSelectionLabel.setWrapStyleWord(true);
        noSelectionLabel.setEditable(false);
        noSelectionLabel.setEnabled(false);
        JPanel noSelectionPanel = new JPanel();
        noSelectionPanel.setLayout(new BoxLayout(noSelectionPanel, 1));
        noSelectionPanel.setBackground(Preferences.defaultBackgroundColor());
        noSelectionPanel.add(Box.createVerticalGlue());
        noSelectionPanel.add(noSelectionLabel);
        noSelectionPanel.add(Box.createVerticalGlue());
        this.listEditor = new ListEditor((GenericEditorComponent)editor, (Component)noSelectionPanel, new Vector(0), true, true, false, false, false);
        this.listEditor.addListSelectionListener(this.listSelectionListener);
        this.listEditor.getList().setCellRenderer(new OBOCellRenderer(Controller.getController()));
        this.listEditor.setButtonColor(Preferences.defaultButtonColor());
        editor.setListEditor(this.listEditor);
        this.listEditor.setFont(Controller.getController().getDefaultFont());
        Controller.getController().addListener(this.listEditorSelectionListener);
    }

    public OBOEditComponentNameResolver() {
        this.buildListEditor();
        this.instanceBrowserHolder = new InstanceBrowserHolder();
        this.instanceEditorHolder = new InstanceEditorHolder();
        this.instanceEditorHolder.init();
        this.instanceBrowserHolder.init();
    }

    protected ButtonGroup getButtonGroup(String name) {
        ButtonGroup group;
        if (name == null) {
            return null;
        }
        if (this.buttonGroups == null) {
            this.buttonGroups = new HashMap();
        }
        if ((group = (ButtonGroup)this.buttonGroups.get(name)) == null) {
            group = new ButtonGroup();
            this.buttonGroups.put(name, group);
        }
        return group;
    }

    public Component resolveName(String id, Properties props, String xml) {
        OBOEditComponent out = null;
        if (id.equals("DAG") || id.equals("OBODAG")) {
            out = new OBOPanelHolder();
        } else if (id.equals("FIND")) {
            FindPanel panel = new FindPanel();
            Controller.getController().setFindPanel(panel);
            out = panel;
        } else if (id.equals("NAME_EDITOR")) {
            out = new NameEditorComponent();
        } else if (id.equals("NAMESPACE_EDITOR")) {
            out = new NamespaceEditorComponent();
        } else if (id.equals("ID_EDITOR")) {
            out = new IDEditorComponent();
        } else if (id.equals("COMMENT_EDITOR")) {
            out = new CommentEditorComponent();
        } else if (id.equals("DEFINITION_EDITOR")) {
            out = new DefinitionEditorComponent();
        } else if (id.equals("DBXREF_EDITOR")) {
            out = new DbxrefEditorComponent();
        } else if (id.equals("SYNONYM_EDITOR")) {
            out = new SynonymEditorComponent();
        } else if (id.equals("COMPLETE_DEF_EDITOR")) {
            out = new CompleteDefPanel();
        } else if (id.equals("TEXT_COMMIT")) {
            out = new OBOCommitButton();
        } else if (id.equals("TEXT_REVERT")) {
            out = new OBORevertButton();
        } else if (id.equals("SEARCH_BUTTON")) {
            String typeStr = props.getProperty("method");
            int type = typeStr == null ? 4 : (typeStr.equals("MODIFY") ? 1 : (typeStr.equals("FILTER") ? 2 : (typeStr.equals("RENDER") ? 3 : 4)));
            String filterPath = props.getProperty("filter");
            String label = props.getProperty("label");
            String iconPath = props.getProperty("icon");
            String tooltipText = props.getProperty("tooltip");
            String selectedStr = props.getProperty("selected");
            String buttonGroupStr = props.getProperty("buttonGroup");
            boolean selected = selectedStr != null && selectedStr.equals("true");
            ButtonGroup group = this.getButtonGroup(buttonGroupStr);
            try {
                out = new UserFilterButton(type, filterPath, label, selected, iconPath, tooltipText, group);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (id.equals("TEXTEDIT")) {
            out = new OBOTermEditor();
        } else if (id.equals("CATEGORY_EDITOR")) {
            out = new CategoryEditorComponent();
        } else if (id.equals("RANGE_EDITOR")) {
            out = new RangeEditorComponent();
        } else if (id.equals("DOMAIN_EDITOR")) {
            out = new DomainEditorComponent();
        } else if (id.equals("PROPERTY_BOXES_EDITOR")) {
            out = new PropertyBoxesEditorComponent();
        } else {
            if (id.equals("INSTANCE_BROWSER")) {
                return this.instanceBrowserHolder;
            }
            if (id.equals("INSTANCE_EDITOR")) {
                return this.instanceEditorHolder;
            }
            if (id.startsWith("plugin:")) {
                String pluginname = id.substring("plugin:".length());
                try {
                    ComponentPlugin nonfinalPlugin = null;
                    for (int i = 0; i < Controller.getController().getPlugins().size(); ++i) {
                        if (!Controller.getController().getPlugins().get(i).getClass().getName().equals(pluginname)) continue;
                        nonfinalPlugin = (ComponentPlugin)Controller.getController().getPlugins().get(i);
                    }
                    if (nonfinalPlugin == null) {
                        return new JLabel("Could not load plugin " + id);
                    }
                    ComponentPlugin plugin = nonfinalPlugin;
                    plugin.setIsEmbedded(true);
                    plugin.setBorder(new TitledBorder(plugin.getName()));
                    plugin.setBackground(Preferences.defaultBackgroundColor());
                    plugin.setController(Controller.getController());
                    Controller.getController().firePluginActivate(new PluginEvent(this, plugin));
                    out = plugin;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (out != null) {
            Map configMap;
            out.setController(Controller.getController());
            if (out instanceof JPanel) {
                ((JComponent)((Object)out)).setMinimumSize(new Dimension(0, 0));
            } else if (out instanceof JComponent) {
                ((JComponent)((Object)out)).setMinimumSize(((JComponent)((Object)out)).getPreferredSize());
            }
            out.init();
            out.setXML(xml);
            if (out instanceof ComponentPlugin) {
                ComponentConfiguration cc;
                configMap = (Map)Controller.getController().getSavedComponentConfigMap().get("Controller.pluginConfigurations");
                if (configMap == null) {
                    configMap = new HashMap();
                }
                if ((cc = (ComponentConfiguration)configMap.get(out.getID())) != null) {
                    out.setConfiguration(cc);
                }
            } else {
                configMap = Controller.getController().getSavedComponentConfigMap();
                if (configMap == null) {
                    configMap = new HashMap();
                }
                List configList = (List)configMap.get(out.getID());
                ComponentConfiguration config = null;
                if (configList != null && configList.size() > 0 && (config = (ComponentConfiguration)configList.remove(0)) != null) {
                    out.setConfiguration(config);
                }
            }
            if (out.isSingleton()) {
                Iterator it = Controller.getController().getActiveComponents().iterator();
                while (it.hasNext()) {
                    OBOEditComponent comp = (OBOEditComponent)it.next();
                    if (!comp.getID().equals(out.getID())) continue;
                    return new JButton(id);
                }
            }
            Controller.getController().addActiveComponent(out);
            return out.getComponent();
        }
        return new JButton(id);
    }

    public void startParseNotify() {
        Controller.getController().flushComponentConfig();
        Iterator it = Controller.getController().getActiveComponents().iterator();
        while (it.hasNext()) {
            OBOEditComponent c = (OBOEditComponent)it.next();
            c.cleanup();
            if (!(c instanceof ComponentPlugin)) continue;
            Controller.getController().firePluginDeactivate(new PluginEvent(this, (ComponentPlugin)c));
        }
        Controller.getController().clearActiveComponents();
        this.buttonGroups = null;
    }

    public void endParseNotify() {
        List dags = Controller.getController().getDAGs();
        if (dags.size() > 0 && !dags.contains(Controller.getController().getPrimarySelector())) {
            Controller.getController().setPrimarySelector((ObjectSelector)dags.iterator().next());
        }
    }
}

