/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.OBOPanelHolder;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.oboedit.gui.ObjectSelector;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.PrimarySelectorChangeEvent;
import org.geneontology.oboedit.gui.event.PrimarySelectorChangeListener;
import org.geneontology.oboedit.gui.event.ReasonerStatusEvent;
import org.geneontology.oboedit.gui.event.ReasonerStatusListener;
import org.geneontology.oboedit.gui.event.SelectionEvent;
import org.geneontology.oboedit.gui.event.SelectionListener;
import org.geneontology.oboedit.gui.event.SubSelectEvent;
import org.geneontology.oboedit.gui.event.SubSelectListener;
import org.geneontology.swing.FreezableScrollPane;
import org.geneontology.util.ObjectUtil;

public class OBOButtonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected OBOTermPanel dag;
    protected static Icon selectorIcon = Preferences.loadLibraryIcon("gray_button_icon.gif");
    protected static Icon selectedIcon = Preferences.loadLibraryIcon("green_button_icon.gif");
    protected static Icon lockedIcon = Preferences.loadLibraryIcon("locked.gif");
    protected static Icon unlockedIcon = Preferences.loadLibraryIcon("unlocked.gif");
    protected static Icon splitHIcon = Preferences.loadLibraryIcon("split_h.gif");
    protected static Icon splitVIcon = Preferences.loadLibraryIcon("split_v.gif");
    protected static Icon mergeIcon = Preferences.loadLibraryIcon("merge_panes.gif");
    protected static Icon plusIcon = Preferences.loadLibraryIcon("plus.gif");
    protected static Icon minusIcon = Preferences.loadLibraryIcon("minus.gif");
    protected static Icon reloadIcon = Preferences.loadLibraryIcon("reload.gif");
    protected static Icon renderIcon = Preferences.loadLibraryIcon("colorwheel.gif");
    protected static Icon rootIcon = Preferences.loadLibraryIcon("root.gif");
    protected static Icon typeIcon = Preferences.loadLibraryIcon("asterisk.gif");
    protected static Icon leftArrowIcon = Preferences.loadLibraryIcon("left.gif");
    protected static Icon leftArrowGrayIcon = Preferences.loadLibraryIcon("left_gray.gif");
    protected static Icon rightArrowIcon = Preferences.loadLibraryIcon("right.gif");
    protected static Icon rightArrowGrayIcon = Preferences.loadLibraryIcon("right_gray.gif");
    protected JScrollPane myScroller;
    protected JButton primarySelectorButton = new JButton(selectorIcon);
    protected JPanel buttonPanel;
    protected JButton splitHButton = new JButton(splitHIcon);
    protected JButton splitVButton = new JButton(splitVIcon);
    protected JButton mergeButton = new JButton(mergeIcon);
    protected JButton lockButton = new JButton(unlockedIcon);
    protected JButton reloadButton = new JButton(reloadIcon);
    protected JButton cornerButton = new JButton(minusIcon);
    protected JButton filterButton = new JButton(renderIcon);
    protected JButton rootButton = new JButton(rootIcon);
    protected JButton typeButton = new JButton(typeIcon);
    protected JButton leftButton = new JButton(leftArrowIcon);
    protected JButton rightButton = new JButton(rightArrowIcon);
    protected JComboBox typeChooser = new JComboBox();
    protected boolean buttonsVisible = false;
    protected ActionListener primaryButtonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (Controller.getController().getPrimarySelector() != OBOButtonPanel.this.dag) {
                Controller.getController().setPrimarySelector(OBOButtonPanel.this.dag);
            } else {
                OBOButtonPanel.this.selectNextDAG();
            }
        }
    };
    protected PrimarySelectorChangeListener selectorListener = new PrimarySelectorChangeListener(){

        public void primarySelectorChange(PrimarySelectorChangeEvent e) {
            OBOButtonPanel.this.updateSelectorButton();
        }
    };
    protected ReasonerStatusListener reasonerListener = new ReasonerStatusListener(){

        public void statusChanged(ReasonerStatusEvent e) {
            OBOButtonPanel.this.updateTypeButton();
        }
    };
    protected SubSelectListener subSelectListener = new SubSelectListener(){

        public void selectObject(SubSelectEvent e) {
            OBOButtonPanel.this.updateArrowButtons();
        }
    };
    protected SelectionListener selectionListener = new SelectionListener(){

        public void select(SelectionEvent e) {
            OBOButtonPanel.this.updateArrowButtons();
        }
    };

    protected void selectNextDAG() {
        List dags = Controller.getController().getDAGs();
        if (dags.size() < 2) {
            return;
        }
        int foundIndex = dags.indexOf(this);
        if (foundIndex >= dags.size() - 1) {
            foundIndex = 0;
        }
        if (foundIndex == -1) {
            return;
        }
        Controller.getController().setPrimarySelector((ObjectSelector)dags.get(foundIndex));
    }

    protected void updateTypeButton() {
        this.typeButton.setEnabled(Controller.getController().getUseReasoner());
    }

    protected void initTypeBox() {
        this.typeChooser.removeAllItems();
        this.typeChooser.addItem("<all types>");
        Iterator it = Controller.getController().getSession().getRelationshipTypes().iterator();
        while (it.hasNext()) {
            OBOProperty prop = (OBOProperty)it.next();
            this.typeChooser.addItem(prop);
        }
    }

    protected void setTypeFilter(OBOProperty type) {
        if (type == null) {
            this.typeButton.setIcon(typeIcon);
        } else {
            this.typeButton.setIcon(Controller.getController().getIconForRelationshipType(type));
        }
        this.dag.setPropertyFilter(type);
    }

    public OBOButtonPanel(final OBOTermPanel dag) {
        this.dag = dag;
        this.buttonPanel = this.getButtonPanel();
        this.setLayout(new BorderLayout());
        this.typeChooser.setEditable(false);
        this.typeChooser.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                OBOButtonPanel.this.initTypeBox();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.typeChooser.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                OBOProperty type = null;
                if (OBOButtonPanel.this.typeChooser.getSelectedIndex() > 0) {
                    type = (OBOProperty)OBOButtonPanel.this.typeChooser.getSelectedItem();
                }
                OBOButtonPanel.this.setTypeFilter(type);
            }
        });
        this.typeButton.setEnabled(false);
        this.typeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem allTypesItem = new JMenuItem("<all types>", typeIcon);
                allTypesItem.setFont(Controller.getController().getDefaultFont());
                allTypesItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        OBOButtonPanel.this.setTypeFilter(null);
                    }
                });
                popupMenu.add(allTypesItem);
                popupMenu.addSeparator();
                Iterator it = Controller.getController().getSession().getRelationshipTypes().iterator();
                while (it.hasNext()) {
                    final OBOProperty type = (OBOProperty)it.next();
                    Icon icon = Controller.getController().getIconForRelationshipType(type);
                    JMenuItem item = new JMenuItem(type.getName(), icon);
                    item.setFont(Controller.getController().getDefaultFont());
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            OBOButtonPanel.this.setTypeFilter(type);
                        }
                    });
                    popupMenu.add(item);
                }
                popupMenu.show(OBOButtonPanel.this.typeButton, OBOButtonPanel.this.typeButton.getWidth() / 2, OBOButtonPanel.this.typeButton.getHeight() / 2);
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                OBOButtonPanel.this.updateButtons();
            }
        });
        this.primarySelectorButton.addActionListener(this.primaryButtonListener);
        this.splitHButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOButtonPanel.this.split(1);
                OBOButtonPanel.this.updateButtons();
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dag.tabBackward();
                OBOButtonPanel.this.updateButtons();
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dag.tabForward();
                OBOButtonPanel.this.updateButtons();
            }
        });
        this.splitVButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOButtonPanel.this.split(0);
                OBOButtonPanel.this.updateButtons();
            }
        });
        this.mergeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOButtonPanel.this.merge();
                OBOButtonPanel.this.updateButtons();
            }
        });
        this.cornerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OBOButtonPanel.this.setButtonPanelVisible(!OBOButtonPanel.this.getButtonPanelVisible());
            }
        });
        this.lockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (dag.getLockedPath() == null) {
                    dag.setLockedPath(dag.getSelectedPaths()[0]);
                } else {
                    dag.setLockedPath(null);
                }
                OBOButtonPanel.this.updateLockedButton();
            }
        });
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dag.reload();
            }
        });
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                Vector v = dag.getFilterMenuItems();
                Iterator it = v.iterator();
                while (it.hasNext()) {
                    JMenuItem item = (JMenuItem)it.next();
                    menu.add(item);
                }
                menu.show(OBOButtonPanel.this.filterButton, OBOButtonPanel.this.filterButton.getWidth() / 2, OBOButtonPanel.this.filterButton.getHeight() / 2);
            }
        });
        this.rootButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem greedyItem = new JMenuItem("Show orphaned terms as roots (GREEDY)");
                JMenuItem strictItem = new JMenuItem("Only show real roots (STRICT)");
                greedyItem.setFont(Controller.getController().getDefaultFont());
                strictItem.setFont(Controller.getController().getDefaultFont());
                menu.add(greedyItem);
                menu.add(strictItem);
                greedyItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        dag.setRootAlgorithm(RootAlgorithm.GREEDY);
                    }
                });
                strictItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        dag.setRootAlgorithm(RootAlgorithm.STRICT);
                    }
                });
                menu.show(OBOButtonPanel.this.rootButton, OBOButtonPanel.this.rootButton.getWidth() / 2, OBOButtonPanel.this.rootButton.getHeight() / 2);
            }
        });
        this.myScroller = new FreezableScrollPane(22, 32);
        this.myScroller.setViewportView(dag);
        this.myScroller.setViewportBorder(new EmptyBorder(1, 1, 1, 1));
        this.myScroller.setCorner("LOWER_RIGHT_CORNER", this.cornerButton);
        this.myScroller.setBackground(Preferences.defaultBackgroundColor());
        this.splitHButton.setToolTipText("Split panel horizontally");
        this.splitVButton.setToolTipText("Split panel vertically");
        this.mergeButton.setToolTipText("Merge panels (or right-click divider)");
        this.lockButton.setToolTipText("Lock selection");
        this.reloadButton.setToolTipText("Force screen reload");
        this.filterButton.setToolTipText("Show filter/render menu");
        this.rootButton.setToolTipText("Choose root detection algorithm");
        this.typeButton.setToolTipText("Filter ontology by types - requires reasoner to be active");
        this.leftButton.setToolTipText("Sub-select previous term (shortcut: open-square-bracket)");
        this.rightButton.setToolTipText("Sub-select next term (shortcut: close-square-bracket)");
        this.configureToolbarButton(this.splitHButton);
        this.configureToolbarButton(this.splitVButton);
        this.configureToolbarButton(this.mergeButton);
        this.configureToolbarButton(this.lockButton);
        this.configureToolbarButton(this.reloadButton);
        this.configureToolbarButton(this.primarySelectorButton);
        this.configureToolbarButton(this.cornerButton);
        this.configureToolbarButton(this.filterButton);
        this.configureToolbarButton(this.rootButton);
        this.configureToolbarButton(this.typeButton);
        this.configureToolbarButton(this.leftButton);
        this.configureToolbarButton(this.rightButton);
        this.cornerButton.setBorder(null);
        this.add((Component)this.myScroller, "Center");
        this.setButtonPanelVisible(true);
        this.updateButtons();
    }

    public boolean getButtonPanelVisible() {
        return this.buttonsVisible;
    }

    public void setButtonPanelVisible(boolean buttonsVisible) {
        if (buttonsVisible != this.buttonsVisible) {
            if (buttonsVisible) {
                this.add((Component)this.buttonPanel, "South");
                this.cornerButton.setIcon(minusIcon);
                this.cornerButton.setToolTipText("Show configuration buttons");
            } else {
                this.remove(this.buttonPanel);
                this.cornerButton.setIcon(plusIcon);
                this.cornerButton.setToolTipText("Hide configuration buttons");
            }
            this.validate();
            this.repaint();
        }
        this.buttonsVisible = buttonsVisible;
    }

    protected void configureToolbarButton(AbstractButton button) {
        button.setBackground(Preferences.defaultButtonColor());
        button.setPreferredSize(new Dimension(20, 20));
    }

    protected void updateButtons() {
        this.updateSelectorButton();
        this.updateLockedButton();
        this.updateMergeButton();
        this.updateTypeButton();
        this.updateArrowButtons();
    }

    protected void updateArrowButtons() {
        if (ObjectUtil.equals((Object)Controller.getController().getPrimarySelector(), (Object)this.dag)) {
            boolean enabled = this.dag.getSelectionCount() > 1;
            this.leftButton.setEnabled(enabled);
            this.rightButton.setEnabled(enabled);
        } else {
            this.leftButton.setEnabled(false);
            this.rightButton.setEnabled(false);
        }
    }

    protected void updateMergeButton() {
        OBOPanelHolder holder = (OBOPanelHolder)SwingUtilities.getAncestorOfClass(OBOPanelHolder.class, this);
        this.mergeButton.setEnabled(holder != null && holder.canMerge());
    }

    protected void updateLockedButton() {
        if (this.dag.getLockedPath() == null) {
            this.lockButton.setIcon(lockedIcon);
            this.lockButton.setToolTipText("Lock selection");
        } else {
            this.lockButton.setToolTipText("Unlock selection");
            this.lockButton.setIcon(unlockedIcon);
        }
    }

    protected void updateSelectorButton() {
        Controller controller = Controller.getController();
        this.primarySelectorButton.removeActionListener(this.primaryButtonListener);
        if (controller.getPrimarySelector() == this.dag) {
            this.primarySelectorButton.setIcon(selectedIcon);
            this.primarySelectorButton.setToolTipText("Make another panel the primary selector");
        } else {
            this.primarySelectorButton.setIcon(selectorIcon);
            this.primarySelectorButton.setToolTipText("Make this panel the primary selector");
        }
        this.primarySelectorButton.repaint();
        this.primarySelectorButton.addActionListener(this.primaryButtonListener);
    }

    protected void merge() {
        OBOPanelHolder holder = (OBOPanelHolder)SwingUtilities.getAncestorOfClass(OBOPanelHolder.class, this);
        holder.merge(this.dag);
    }

    protected void split(int orientation) {
        OBOPanelHolder holder = (OBOPanelHolder)SwingUtilities.getAncestorOfClass(OBOPanelHolder.class, this);
        holder.split(orientation);
    }

    public OBOTermPanel getDAG() {
        return this.dag;
    }

    protected JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setHgap(3);
        panel.setLayout(layout);
        panel.setBackground(Preferences.defaultBackgroundColor());
        panel.add(this.primarySelectorButton);
        panel.add(this.leftButton);
        panel.add(this.rightButton);
        panel.add(this.splitHButton);
        panel.add(this.splitVButton);
        panel.add(this.mergeButton);
        panel.add(this.lockButton);
        panel.add(this.reloadButton);
        panel.add(this.filterButton);
        panel.add(this.typeButton);
        panel.add(this.rootButton);
        return panel;
    }

    public void init() {
        Controller.getController().addListener(this.selectorListener);
        Controller.getController().addListener(this.reasonerListener);
        Controller.getController().addListener(this.subSelectListener);
        Controller.getController().addListener(this.selectionListener);
        this.typeChooser.setFont(Controller.getController().getDefaultFont());
        this.typeChooser.setPreferredSize(new Dimension(100, 20));
        this.initTypeBox();
        this.typeChooser.setSelectedIndex(0);
        this.updateButtons();
    }

    public void cleanup() {
        Controller.getController().removeListener(this.selectorListener);
        Controller.getController().removeListener(this.reasonerListener);
        Controller.getController().removeListener(this.subSelectListener);
        Controller.getController().removeListener(this.selectionListener);
    }

    protected class FreezableViewport
    extends JViewport {
        private static final long serialVersionUID = 1L;
        protected boolean frozen = false;

        protected FreezableViewport() {
        }

        public void setFrozen(boolean frozen) {
            this.frozen = frozen;
        }

        public void setViewPosition(Point p) {
            if (!this.frozen) {
                super.setViewPosition(p);
            }
        }
    }
}

