/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.geneontology.oboedit.gui.FilterBuilder;
import org.geneontology.oboedit.gui.LinkSpecEditor;
import org.geneontology.oboedit.gui.ObjectSpecEditor;
import org.geneontology.oboedit.gui.filters.CompoundEditable;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.KeywordFilterBuilder;
import org.geneontology.oboedit.gui.filters.LinkFilterFactory;
import org.geneontology.oboedit.gui.filters.ObjectFilterFactory;
import org.geneontology.oboedit.gui.filters.RenderSpec;
import org.geneontology.oboedit.gui.filters.SpecEditor;

public class FilterRenderEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected CompoundEditable filterBuilder;
    protected SpecEditor specEditor = new ObjectSpecEditor();
    protected boolean specEditorVisible;
    protected boolean linkMode = false;
    protected TitledBorder titledBorder = new TitledBorder("Term filter");
    protected TitledBorder specBorder = new TitledBorder("Render options");
    protected Color buttonColor;
    protected Collection actionListeners = new LinkedList();
    protected boolean showCompoundFilter = false;

    public void addActionListener(ActionListener listener) {
        this.filterBuilder.addActionListener(listener);
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.filterBuilder.removeActionListener(listener);
        this.actionListeners.remove(listener);
    }

    public void setEnabled(boolean enabled) {
        ((JComponent)((Object)this.specEditor)).setEnabled(enabled);
        ((JComponent)((Object)this.filterBuilder)).setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setSpecEditorVisible(boolean specEditorVisible) {
        if (specEditorVisible != this.specEditorVisible) {
            if (this.specEditorVisible) {
                this.remove((JComponent)((Object)this.specEditor));
            } else {
                this.add((Component)((JComponent)((Object)this.specEditor)), "East");
            }
            this.validate();
            this.repaint();
        }
        this.specEditorVisible = specEditorVisible;
    }

    public void setShowCompoundFilter(boolean showCompoundFilter) {
        this.showCompoundFilter = showCompoundFilter;
        this.filterBuilder.setShowCompoundFilter(showCompoundFilter);
    }

    public FilterRenderEditor() {
        this(false);
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
        this.filterBuilder.setButtonColor(buttonColor);
        this.specEditor.setButtonColor(buttonColor);
    }

    public void acceptEdits() {
        this.filterBuilder.acceptEdits();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.specEditor != null) {
            ((JComponent)((Object)this.specEditor)).setFont(font);
        }
        if (this.filterBuilder != null) {
            ((JComponent)((Object)this.filterBuilder)).setFont(font);
        }
        if (this.titledBorder != null) {
            this.titledBorder.setTitleFont(font);
        }
        if (this.specBorder != null) {
            this.specBorder.setTitleFont(font);
        }
    }

    public FilterRenderEditor(boolean linkMode) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.linkMode = linkMode;
        if (linkMode) {
            this.specEditor = new LinkSpecEditor();
            this.titledBorder.setTitle("Link filter");
            this.setFilterBuilder(new FilterBuilder());
        } else {
            this.specEditor = new ObjectSpecEditor();
            this.titledBorder.setTitle("Term filter");
            this.setFilterBuilder(new KeywordFilterBuilder());
        }
        ((JComponent)((Object)this.specEditor)).setBorder(this.specBorder);
    }

    protected void setFilterBuilder(CompoundEditable filterBuilder) {
        Iterator it;
        if (this.linkMode) {
            filterBuilder.setFilterFactory(new LinkFilterFactory());
        } else {
            filterBuilder.setFilterFactory(new ObjectFilterFactory());
        }
        filterBuilder.setShowCompoundFilter(this.showCompoundFilter);
        if (this.filterBuilder != null) {
            this.filterBuilder.acceptEdits();
            filterBuilder.setFilter(this.filterBuilder.getFilter());
            ((JComponent)((Object)this.filterBuilder)).setBorder(null);
            this.remove((JComponent)((Object)this.filterBuilder));
            it = this.actionListeners.iterator();
            while (it.hasNext()) {
                ActionListener l = (ActionListener)it.next();
                this.filterBuilder.removeActionListener(l);
            }
        }
        ((JComponent)((Object)filterBuilder)).setBorder(this.titledBorder);
        it = this.actionListeners.iterator();
        while (it.hasNext()) {
            filterBuilder.addActionListener((ActionListener)it.next());
        }
        if (this.buttonColor != null) {
            filterBuilder.setButtonColor(this.buttonColor);
        }
        this.add((Component)((Object)filterBuilder), "Center");
        this.filterBuilder = filterBuilder;
    }

    public RenderSpec getSpec() {
        return this.specEditor.getSpec();
    }

    public Filter getFilter() {
        this.acceptEdits();
        return this.filterBuilder.getFilter();
    }

    public void setSpec(RenderSpec spec) {
        this.specEditor.setSpec(spec);
    }

    public void setFilter(Filter filter) {
        this.filterBuilder.setFilter(filter);
    }
}

