/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import org.geneontology.oboedit.datamodel.Explanation;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.impl.LinkExplanation;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.swing.AbstractTreeModel;

public class ExplanationComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JTree explanationTree = new JTree();
    protected ExplanationModel model = new ExplanationModel();
    protected JEditorPane explanationField = new JEditorPane("text/html", "<html></html>");
    protected JScrollPane explanationTreeScroller = new JScrollPane(this.explanationTree, 20, 31);
    protected JScrollPane explanationFieldScroller = new JScrollPane(this.explanationField, 20, 31);
    protected JSplitPane dividerPane = new JSplitPane(0, this.explanationTreeScroller, this.explanationFieldScroller);

    public ExplanationComponent() {
        this.setLayout(new BorderLayout());
        this.explanationTree.setModel((TreeModel)((Object)this.model));
        this.explanationTree.setRootVisible(false);
        this.explanationTree.getSelectionModel().setSelectionMode(1);
        this.explanationTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                if (ExplanationComponent.this.explanationTree.getSelectionPath() != null) {
                    Object selection = ExplanationComponent.this.explanationTree.getSelectionPath().getLastPathComponent();
                    ExplanationComponent.this.explanationField.setText(ExplanationComponent.this.getDescription(selection));
                } else {
                    ExplanationComponent.this.explanationField.setText("<html></html>");
                }
            }
        });
        this.dividerPane.setDividerLocation(0.7);
        this.add((Component)this.dividerPane, "Center");
    }

    public String getDescription(Object selection) {
        return "<html><body>" + selection.toString() + "</body></html>";
    }

    public void setLinks(Collection links) {
        this.model.setLinks(links);
    }

    protected static class ExplanationModel
    extends AbstractTreeModel {
        protected Object root = new Object();
        protected List topLevelLinks = new LinkedList();

        protected ExplanationModel() {
        }

        public void setLinks(Collection links) {
            this.topLevelLinks.clear();
            this.topLevelLinks.addAll(links);
            this.reload();
        }

        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            return this.getChildren(parent).indexOf(child);
        }

        protected List getChildren(Object o) {
            if (o.equals(this.root)) {
                return this.topLevelLinks;
            }
            if (o instanceof Link) {
                Link link = (Link)o;
                LinkedList<Explanation> out = new LinkedList<Explanation>();
                if (Controller.getController().getUseReasoner()) {
                    Collection explanations = Controller.getController().getReasonedLinkDatabase().getExplanations(link);
                    out.addAll(explanations);
                } else {
                    out.add(Explanation.GIVEN_EXPLANATION);
                }
                return out;
            }
            if (o instanceof LinkExplanation) {
                LinkedList out = new LinkedList();
                out.addAll(((LinkExplanation)o).getSupportingLinks());
                return out;
            }
            return Collections.EMPTY_LIST;
        }

        public int getChildCount(Object o) {
            return this.getChildren(o).size();
        }

        public Object getChild(Object parent, int index) {
            return this.getChildren(parent).get(index);
        }

        public Object getRoot() {
            return this.root;
        }
    }
}

