/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelDbxrefHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DbxrefListEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.TextEditorUpdateEvent;
import org.geneontology.oboedit.gui.event.TextEditorUpdateListener;
import org.geneontology.swing.DragList;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropAdapter;
import org.geneontology.swing.event.DropListener;
import org.geneontology.util.ObjectUtil;

public class DefinitionEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected TextEditorUpdateListener textUpdateListener = new TextEditorUpdateListener(){

        public void update(TextEditorUpdateEvent e) {
            Vector dbxrefUpdates;
            if (e.getNewDefinition() != null) {
                DefinitionEditorComponent.this.defField.setText(e.getNewDefinition());
                DefinitionEditorComponent.this.defField.setCaretPosition(0);
            }
            if ((dbxrefUpdates = e.getDbxrefUpdates()) != null) {
                for (int i = 0; i < dbxrefUpdates.size(); ++i) {
                    TextEditorUpdateEvent.DbxrefUpdate update = (TextEditorUpdateEvent.DbxrefUpdate)dbxrefUpdates.get(i);
                    boolean isDef = false;
                    if (update.isAdd()) {
                        if (update.getNewDbxref().getType() == 2) {
                            isDef = true;
                            DefinitionEditorComponent.this.dbxrefs.add(update.getNewDbxref());
                        }
                    } else if (update.isDelete()) {
                        if (update.getOldDbxref().getType() == 2) {
                            isDef = true;
                            DefinitionEditorComponent.this.dbxrefs.remove(update.getOldDbxref());
                        }
                    } else if (update.getOldDbxref().getType() == 2 && update.getOldDbxref().getType() == 2) {
                        isDef = true;
                        DefinitionEditorComponent.this.dbxrefs.remove(update.getOldDbxref());
                        DefinitionEditorComponent.this.dbxrefs.add(update.getNewDbxref());
                    }
                    DefinitionEditorComponent.this.defDbxrefList.setListData(DefinitionEditorComponent.this.dbxrefs);
                }
            }
        }
    };
    protected JTextPane defField = new JTextPane();
    protected JScrollPane defScroller = new JScrollPane(this.defField, 20, 31);
    protected JButton dbxrefButton = new JButton("Edit");
    protected DragList defDbxrefList = new DragList(Controller.getController().getDragController());
    protected JScrollPane defDbxrefScroller = new JScrollPane((Component)this.defDbxrefList, 20, 31);
    protected Vector dbxrefs = new Vector();
    protected Border lineBorder = new LineBorder(Color.black);
    DropListener dropListener = new DropAdapter(){

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof Vector) {
                Vector v = (Vector)e.getData();
                for (int i = 0; i < v.size(); ++i) {
                    if (v.elementAt(i) instanceof Dbxref) continue;
                    return false;
                }
                return true;
            }
            if (e.getData() instanceof Object[]) {
                Object[] v = (Object[])e.getData();
                for (int i = 0; i < v.length; ++i) {
                    if (v[i] instanceof Dbxref) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DefinitionEditorComponent.this.defDbxrefList.setBorder(DefinitionEditorComponent.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            DefinitionEditorComponent.this.defDbxrefList.setBorder(null);
        }

        public void drop(DragEvent e) {
            block3: {
                block2: {
                    DefinitionEditorComponent.this.defDbxrefList.setBorder(null);
                    if (!(e.getData() instanceof Collection)) break block2;
                    Iterator it = ((Collection)e.getData()).iterator();
                    while (it.hasNext()) {
                        Dbxref s = (Dbxref)((Dbxref)it.next()).clone();
                        s.setType(2);
                        if (DefinitionEditorComponent.this.dbxrefs.contains(s)) continue;
                        DefinitionEditorComponent.this.dbxrefs.add(s);
                        DefinitionEditorComponent.this.defDbxrefList.setListData(DefinitionEditorComponent.this.dbxrefs);
                    }
                    break block3;
                }
                if (!(e.getData() instanceof Object[])) break block3;
                Object[] v = (Object[])e.getData();
                for (int i = 0; i < v.length; ++i) {
                    Dbxref s = (Dbxref)((Dbxref)v[i]).clone();
                    s.setType(2);
                    if (DefinitionEditorComponent.this.dbxrefs.contains(s)) continue;
                    DefinitionEditorComponent.this.dbxrefs.add(s);
                    DefinitionEditorComponent.this.defDbxrefList.setListData(DefinitionEditorComponent.this.dbxrefs);
                }
            }
        }
    };
    protected DropTarget dropTarget = new DropTarget((Component)this.defDbxrefList, this.dropListener);

    public Component resolveName(String id, Properties props, String xml) {
        if (id.equals("field")) {
            return this.defScroller;
        }
        if (id.equals("ref_list")) {
            return this.defDbxrefScroller;
        }
        if (id.equals("ref_button")) {
            return this.dbxrefButton;
        }
        return new JButton(id);
    }

    public void showDefDbxrefEditor() {
        JTextArea noDbxLabel = new JTextArea("Select a dbxref from the list to edit it, or press add to create a new dbxref");
        noDbxLabel.setOpaque(false);
        noDbxLabel.setFont(Controller.getController().getDefaultFont());
        noDbxLabel.setLineWrap(true);
        noDbxLabel.setWrapStyleWord(true);
        noDbxLabel.setEditable(false);
        noDbxLabel.setEnabled(false);
        final JDialog dialog = new JDialog((Frame)null, "Edit definition dbxrefs", true);
        dialog.setFont(Controller.getController().getDefaultFont());
        final ListEditor editor = new ListEditor((GenericEditorComponent)new DbxrefListEditor(Controller.getController(), 2), (Component)noDbxLabel, this.dbxrefs, false, true, true, true, false);
        editor.setOpaque(false);
        editor.setPreferredSize(new Dimension(300, 200));
        editor.setFont(Controller.getController().getDefaultFont());
        editor.setDragController(Controller.getController().getDragController());
        editor.setButtonColor(Preferences.defaultButtonColor());
        JButton okButton = new JButton("Ok");
        okButton.setFont(Controller.getController().getDefaultFont());
        okButton.setBackground(Preferences.defaultButtonColor());
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                editor.commit();
                dialog.setVisible(false);
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)editor, "North");
        panel.add((Component)buttonPanel, "South");
        panel.setBackground(Preferences.defaultBackgroundColor());
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.show();
        this.defDbxrefList.setListData(this.dbxrefs);
    }

    public void installListeners() {
        Controller.getController().getDragController().registerDropTarget(this.dropTarget);
        Controller.getController().addListener(this.textUpdateListener);
    }

    public void uninstallListeners() {
        Controller.getController().getDragController().unregisterDropTarget(this.dropTarget);
        Controller.getController().addListener(this.textUpdateListener);
    }

    protected boolean useSubLayout() {
        return true;
    }

    protected String getDefaultLayout() {
        return "<grid cols='2'><component id='field' bordertitle='Definition'/><panel bordertitle='Dbxrefs'><south><component id='ref_button'/></south><center><component id='ref_list'/></center></panel></grid>";
    }

    protected void loadGUI() {
        if (this.currentObject != null && this.currentObject instanceof DefinedObject) {
            DefinedObject defined = (DefinedObject)this.currentObject;
            this.defField.setText(defined.getDefinition());
            this.dbxrefs.clear();
            Iterator it = defined.getDefDbxrefs().iterator();
            while (it.hasNext()) {
                Dbxref dbxref = (Dbxref)it.next();
                this.dbxrefs.add(dbxref.clone());
            }
            Collections.sort(this.dbxrefs, Dbxref.COMPARATOR);
            this.defDbxrefList.setListData(this.dbxrefs);
            boolean enable = !TermUtil.isObsolete(this.currentObject);
            this.defField.setEnabled(enable);
            if (enable) {
                this.defField.setForeground(Color.black);
            } else {
                this.defField.setForeground(Color.gray);
            }
            this.dbxrefButton.setEnabled(enable);
            this.defDbxrefList.setEnabled(enable);
        } else {
            this.defField.setText("<no selection>");
            this.defDbxrefList.setListData(new Vector());
            this.dbxrefButton.setEnabled(false);
            this.defDbxrefList.setEnabled(false);
            this.defField.setEnabled(false);
        }
    }

    protected void initializeGUI() {
        this.defScroller.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        Font font = Controller.getController().getDefaultFont();
        this.dbxrefButton.setBackground(Preferences.defaultButtonColor());
        this.dbxrefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefinitionEditorComponent.this.showDefDbxrefEditor();
            }
        });
        this.defField.setFont(font);
        this.dbxrefButton.setFont(font);
        this.defDbxrefList.setFont(font);
        this.dbxrefButton.setHorizontalTextPosition(2);
        this.dbxrefButton.setVerticalTextPosition(1);
        this.dbxrefButton.setMargin(new Insets(0, 0, 0, 0));
    }

    public String getText() {
        return this.defField.getText().trim();
    }

    public String getID() {
        return "DEFINITION_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        DefinedObject defined = (DefinedObject)io;
        defined.setDefinition(this.getText());
        defined.getDefDbxrefs().clear();
        int count = this.defDbxrefList.getModel().getSize();
        for (int i = 0; i < count; ++i) {
            Dbxref ref = (Dbxref)this.defDbxrefList.getModel().getElementAt(i);
            defined.addDefDbxref(ref);
        }
    }

    public List getChanges() {
        if (this.currentObject != null && this.currentObject instanceof DefinedObject) {
            Dbxref eref;
            boolean found;
            Dbxref ref;
            DefinedObject defined = (DefinedObject)this.currentObject;
            LinkedList<HistoryItem> out = new LinkedList<HistoryItem>();
            if (!ObjectUtil.equals((Object)defined.getDefinition(), (Object)this.getText())) {
                DefinitionChangeHistoryItem ditem = new DefinitionChangeHistoryItem(defined, this.getText());
                out.add(ditem);
            }
            int count = this.defDbxrefList.getModel().getSize();
            for (int i = 0; i < count; ++i) {
                ref = (Dbxref)this.defDbxrefList.getModel().getElementAt(i);
                found = false;
                Iterator it = defined.getDefDbxrefs().iterator();
                while (it.hasNext()) {
                    eref = (Dbxref)it.next();
                    if (!ref.equals(eref)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                AddDbxrefHistoryItem item = new AddDbxrefHistoryItem(defined.getID(), ref, true, null);
                out.add(item);
            }
            Iterator it = defined.getDefDbxrefs().iterator();
            while (it.hasNext()) {
                ref = (Dbxref)it.next();
                found = false;
                count = this.defDbxrefList.getModel().getSize();
                for (int i = 0; i < count; ++i) {
                    eref = (Dbxref)this.defDbxrefList.getModel().getElementAt(i);
                    if (!ref.equals(eref)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                DelDbxrefHistoryItem item = new DelDbxrefHistoryItem(defined.getID(), ref, true, null);
                out.add(item);
            }
            return out;
        }
        return Collections.EMPTY_LIST;
    }
}

