/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.DelDbxrefHistoryItem;
import org.geneontology.oboedit.gui.AbstractTextEditComponent;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DbxrefListEditor;
import org.geneontology.oboedit.gui.event.TextEditorUpdateEvent;
import org.geneontology.oboedit.gui.event.TextEditorUpdateListener;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropListener;
import org.geneontology.util.VectorUtil;

public class DbxrefEditorComponent
extends AbstractTextEditComponent {
    private static final long serialVersionUID = 1L;
    protected Border lineBorder = new LineBorder(Color.black);
    protected Border emptyBorder = new EmptyBorder(1, 1, 1, 1);
    protected TextEditorUpdateListener textUpdateListener = new TextEditorUpdateListener(){

        public void update(TextEditorUpdateEvent e) {
            Vector dbxrefUpdates = e.getDbxrefUpdates();
            if (dbxrefUpdates != null) {
                for (int i = 0; i < dbxrefUpdates.size(); ++i) {
                    TextEditorUpdateEvent.DbxrefUpdate update = (TextEditorUpdateEvent.DbxrefUpdate)dbxrefUpdates.elementAt(i);
                    Vector list = DbxrefEditorComponent.this.dbxrefList.getData();
                    if (update.isAdd()) {
                        if (update.getNewDbxref().getType() != 2) {
                            list.add(update.getNewDbxref());
                        }
                    } else if (update.isDelete()) {
                        if (update.getNewDbxref().getType() != 2) {
                            list.remove(update.getOldDbxref());
                        }
                    } else if (update.getNewDbxref().getType() != 2) {
                        list.remove(update.getOldDbxref());
                        list.add(update.getNewDbxref());
                    }
                    DbxrefEditorComponent.this.dbxrefList.setData(list);
                }
            }
        }
    };
    protected DropListener dropListener = new DropDbxrefsListener();
    protected DropTarget dropTarget;
    protected ListEditor dbxrefList;
    protected DbxrefListEditor listEditor;

    public Component resolveName(String id, Properties props, String xml) {
        return null;
    }

    public DbxrefEditorComponent() {
        JTextArea noDbxLabel = new JTextArea("Select a dbxref from the list to edit it, or press add to create a new dbxref");
        noDbxLabel.setMinimumSize(new Dimension(0, 0));
        noDbxLabel.setOpaque(false);
        noDbxLabel.setFont(Controller.getController().getDefaultFont());
        noDbxLabel.setLineWrap(true);
        noDbxLabel.setWrapStyleWord(true);
        noDbxLabel.setEditable(false);
        noDbxLabel.setEnabled(false);
        this.listEditor = new DbxrefListEditor(Controller.getController());
        this.dbxrefList = new ListEditor((GenericEditorComponent)this.listEditor, (Component)noDbxLabel, new Vector(0), true, true, true, true, true);
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.dbxrefList.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.dropTarget = new DropTarget((Component)this.dbxrefList.getList(), this.dropListener);
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.dbxrefList);
    }

    public void installListeners() {
        Controller.getController().getDragController().registerDropTarget(this.dropTarget);
        Controller.getController().addListener(this.textUpdateListener);
    }

    public void uninstallListeners() {
        Controller.getController().getDragController().unregisterDropTarget(this.dropTarget);
        Controller.getController().removeListener(this.textUpdateListener);
    }

    protected boolean useSubLayout() {
        return false;
    }

    protected String getDefaultLayout() {
        return "";
    }

    protected void loadGUI() {
        if (this.currentObject != null && this.currentObject instanceof DbxrefedObject) {
            boolean enable = !TermUtil.isObsolete(this.currentObject);
            Vector<Object> refs = new Vector<Object>();
            Iterator it = ((DbxrefedObject)this.currentObject).getDbxrefs().iterator();
            while (it.hasNext()) {
                Dbxref dbxref = (Dbxref)it.next();
                refs.add(dbxref.clone());
            }
            Collections.sort(refs);
            this.dbxrefList.setData(refs);
            this.dbxrefList.setEnabled(enable);
        } else {
            this.dbxrefList.setData(new Vector());
            this.dbxrefList.setEnabled(false);
        }
    }

    protected String getWarningLabel() {
        return "Term dbxrefs";
    }

    protected void initializeGUI() {
        this.dbxrefList.setButtonColor(Controller.getController().getPreferences().getButtonColor());
        Font font = Controller.getController().getDefaultFont();
        this.dbxrefList.setFont(font);
    }

    public List getWarnings() {
        return Collections.EMPTY_LIST;
    }

    public String getID() {
        return "DBXREF_EDITOR";
    }

    public void populateFields(IdentifiedObject io) {
        ((DbxrefedObject)io).getDbxrefs().clear();
        ((DbxrefedObject)io).getDbxrefs().addAll(this.dbxrefList.getData());
    }

    public List getChanges() {
        if (this.currentObject != null && this.currentObject instanceof DbxrefedObject) {
            HistoryItem item;
            Dbxref eref;
            Iterator it2;
            boolean found;
            Dbxref ref;
            DbxrefedObject dbxrefed = (DbxrefedObject)this.currentObject;
            LinkedList<AddDbxrefHistoryItem> out = new LinkedList<AddDbxrefHistoryItem>();
            Iterator it = this.dbxrefList.getData().iterator();
            while (it.hasNext()) {
                ref = (Dbxref)it.next();
                found = false;
                it2 = dbxrefed.getDbxrefs().iterator();
                while (it2.hasNext()) {
                    eref = (Dbxref)it2.next();
                    if (!ref.equals(eref)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                item = new AddDbxrefHistoryItem(dbxrefed.getID(), ref, false, null);
                out.add((AddDbxrefHistoryItem)item);
            }
            it = dbxrefed.getDbxrefs().iterator();
            while (it.hasNext()) {
                ref = (Dbxref)it.next();
                found = false;
                it2 = this.dbxrefList.getData().iterator();
                while (it2.hasNext()) {
                    eref = (Dbxref)it2.next();
                    if (!ref.equals(eref)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                item = new DelDbxrefHistoryItem(dbxrefed.getID(), ref, false, null);
                out.add((AddDbxrefHistoryItem)item);
            }
            return out;
        }
        return Collections.EMPTY_LIST;
    }

    protected class DropDbxrefsListener
    implements DropListener {
        protected DropDbxrefsListener() {
        }

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof Vector) {
                Vector v = (Vector)e.getData();
                return v.size() > 0 && v.elementAt(0) instanceof Dbxref;
            }
            if (e.getData() instanceof Object[]) {
                Object[] v = (Object[])e.getData();
                return v.length > 0 && v[0] instanceof Dbxref;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DbxrefEditorComponent.this.dbxrefList.getList().setBorder(DbxrefEditorComponent.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            DbxrefEditorComponent.this.dbxrefList.getList().setBorder(null);
        }

        public void drop(DragEvent e) {
            DbxrefEditorComponent.this.dbxrefList.getList().setBorder(null);
            TextEditorUpdateEvent event = new TextEditorUpdateEvent(this);
            Vector<TextEditorUpdateEvent.DbxrefUpdate> updates = new Vector<TextEditorUpdateEvent.DbxrefUpdate>();
            Vector<Object> dbxrefs = null;
            if (e.getData() instanceof Vector) {
                dbxrefs = VectorUtil.trueClone((Vector)((Vector)e.getData()));
            } else if (e.getData() instanceof Object[]) {
                dbxrefs = new Vector<Object>();
                Object[] os = (Object[])e.getData();
                for (int i = 0; i < os.length; ++i) {
                    Dbxref ref = (Dbxref)os[i];
                    dbxrefs.add(ref.clone());
                }
            }
            for (int i = 0; i < dbxrefs.size(); ++i) {
                Dbxref ref = (Dbxref)dbxrefs.elementAt(i);
                TextEditorUpdateEvent.DbxrefUpdate update = new TextEditorUpdateEvent.DbxrefUpdate(ref, null, true, false);
                updates.addElement(update);
            }
            event.setDbxrefUpdates(updates);
            Controller.getController().fireTextEditorUpdate(event);
        }

        public void draggedOver(DragEvent e) {
        }
    }
}

