/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.CategorizedObject;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MultiIDObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.Type;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.CompleteDefPanel;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DbxrefListEditor;
import org.geneontology.oboedit.gui.DocumentChanger;
import org.geneontology.oboedit.gui.OBOEditComponent;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.SynonymListEditor;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.TextEditorUpdateEvent;
import org.geneontology.oboedit.gui.event.TextEditorUpdateListener;
import org.geneontology.swing.DragList;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropAdapter;
import org.geneontology.swing.event.DropListener;
import org.geneontology.util.VectorUtil;

public class DETermEditor
extends JPanel
implements GenericEditorComponent,
OBOEditComponent {
    private static final long serialVersionUID = 1L;
    DropListener dropListener = new DropAdapter(){

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof Vector) {
                Vector v = (Vector)e.getData();
                for (int i = 0; i < v.size(); ++i) {
                    if (v.elementAt(i) instanceof Dbxref) continue;
                    return false;
                }
                return true;
            }
            if (e.getData() instanceof Object[]) {
                Object[] v = (Object[])e.getData();
                for (int i = 0; i < v.length; ++i) {
                    if (v[i] instanceof Dbxref) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DETermEditor.this.defDbxrefList.setBorder(DETermEditor.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            DETermEditor.this.defDbxrefList.setBorder(null);
        }

        public void drop(DragEvent e) {
            block3: {
                block2: {
                    DETermEditor.this.defDbxrefList.setBorder(null);
                    if (!(e.getData() instanceof Vector)) break block2;
                    Vector v = (Vector)e.getData();
                    for (int i = 0; i < v.size(); ++i) {
                        Dbxref s = (Dbxref)((Dbxref)v.elementAt(i)).clone();
                        s.setType(2);
                        if (DETermEditor.this.defDbxList.contains(s)) continue;
                        DETermEditor.this.defDbxList.addElement(s);
                        DETermEditor.this.defDbxrefList.setListData(DETermEditor.this.defDbxList);
                    }
                    break block3;
                }
                if (!(e.getData() instanceof Object[])) break block3;
                Object[] v = (Object[])e.getData();
                for (int i = 0; i < v.length; ++i) {
                    Dbxref s = (Dbxref)((Dbxref)v[i]).clone();
                    s.setType(2);
                    if (DETermEditor.this.defDbxList.contains(s)) continue;
                    DETermEditor.this.defDbxList.addElement(s);
                    DETermEditor.this.defDbxrefList.setListData(DETermEditor.this.defDbxList);
                }
            }
        }
    };
    DropListener dropRangeListener = new DropAdapter(){

        public boolean allowDrop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1) {
                LinkedObject termRange = ((Link)paths[0].getLastPathComponent()).getChild();
                return !DETermEditor.this.currentTerm.equals(termRange);
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DETermEditor.this.rangeButton.setBorder(DETermEditor.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            DETermEditor.this.rangeButton.setBorder(DETermEditor.this.emptyBorder);
        }

        public void drop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1 && ((Link)paths[0].getLastPathComponent()).getChild() instanceof Type) {
                DETermEditor.this.setRange((Type)((Object)((Link)paths[0].getLastPathComponent()).getChild()));
            }
            DETermEditor.this.rangeButton.setBorder(DETermEditor.this.emptyBorder);
        }
    };
    DropListener dropDomainListener = new DropAdapter(){

        public boolean allowDrop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1) {
                LinkedObject termDomain = ((Link)paths[0].getLastPathComponent()).getChild();
                return !DETermEditor.this.currentTerm.equals(termDomain);
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DETermEditor.this.domainButton.setBorder(DETermEditor.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            DETermEditor.this.domainButton.setBorder(DETermEditor.this.emptyBorder);
        }

        public void drop(DragEvent e) {
            TreePath[] paths = (TreePath[])e.getData();
            if (paths.length == 1 && ((Link)paths[0].getLastPathComponent()).getChild() instanceof OBOClass) {
                DETermEditor.this.setDomain(((Link)paths[0].getLastPathComponent()).getChild());
            }
            DETermEditor.this.domainButton.setBorder(DETermEditor.this.emptyBorder);
        }
    };
    protected FieldMouseListener fieldMouseListener = new FieldMouseListener();
    Border lineBorder = new LineBorder(Color.black);
    Border emptyBorder = new EmptyBorder(1, 1, 1, 1);
    static final int TIMER_CYCLE = 1000;
    protected Timer timer = new Timer(true);
    protected ListEditor parent;
    protected Map listenerHash;
    private JTextField idField;
    private JTextPane secIDField;
    private JComboBox nsField;
    private JTextPane defField;
    private JTextPane commentField;
    private JTextPane termField;
    private JButton rangeButton;
    private JButton domainButton;
    protected SimpleAttributeSet alignAtts = new SimpleAttributeSet();
    protected JCheckBox cyclicBox;
    protected JCheckBox transitiveBox;
    protected JCheckBox symmetricBox;
    protected JTable categoryTable;
    protected JTable relationshipTable;
    private JScrollPane termScroller;
    private JScrollPane defScroller;
    private JScrollPane commentScroller;
    private ListEditor synonymList;
    private ListEditor dbxrefList;
    private DragList defDbxrefList;
    private JButton commitButton;
    private JButton defDbxrefButton;
    protected JPanel secondaryIDOuterPanel;
    protected JPanel secondaryIDPanel;
    protected JPanel northPanel = this.getJPanel();
    protected JPanel leftPanel = this.getJPanel();
    protected JPanel idPanel = this.getJPanel();
    protected JPanel nsPanel = this.getJPanel();
    protected JPanel rangePanel = this.getJPanel();
    protected JPanel domainPanel = this.getJPanel();
    protected JPanel defPanel = this.getJPanel();
    protected JTabbedPane defCommentTabbedPane = new JTabbedPane();
    protected JTabbedPane synRefTabbedPane = new JTabbedPane();
    protected JScrollPane checkboxPane;
    protected JScrollPane relationshipScroller;
    protected JPanel relationshipPanel = this.getJPanel();
    protected JPanel innerButtonPanel = this.getJPanel();
    protected HistoryList historyList = new DefaultHistoryList();
    protected Type range;
    protected IdentifiedObject domain;
    private IdentifiedObject currentTerm;
    private Vector defDbxList = new Vector();
    protected Controller controller;
    protected ListEditor editor;
    protected CompleteDefPanel completeDefPanel = new CompleteDefPanel();
    protected CategoryTableModel categoryTableModel = new CategoryTableModel();
    protected RelationshipTableModel relationshipTableModel = new RelationshipTableModel();
    protected Vector relationshipList = new Vector();
    protected Comparator catComparator = new Comparator(){

        public int compare(Object a, Object b) {
            TermCategory tca = (TermCategory)a;
            TermCategory tcb = (TermCategory)b;
            return tca.toString().compareTo(tcb.toString());
        }
    };
    protected DocumentLater documentLater = new DocumentLater();
    static /* synthetic */ Class class$java$lang$Boolean;

    public void setRange(Type range) {
        this.range = range;
        if (range == null) {
            this.rangeButton.setLabel("<no range specified>");
        } else {
            this.rangeButton.setLabel(range.getID());
        }
    }

    public void setDomain(IdentifiedObject domain) {
        this.domain = domain;
        if (domain == null) {
            this.domainButton.setLabel("<no domain specified>");
        } else {
            this.domainButton.setLabel(domain.getID());
        }
    }

    public void setCyclic(boolean cyclic) {
        this.cyclicBox.setSelected(cyclic);
    }

    public void setTransitive(boolean transitive) {
        this.transitiveBox.setSelected(transitive);
    }

    public void setSymmetric(boolean symmetric) {
        this.symmetricBox.setSelected(symmetric);
    }

    public void setMasterComponent(Component c) {
        if (c instanceof ListEditor) {
            this.editor = (ListEditor)c;
        }
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public JComponent getComponent() {
        return this;
    }

    public DETermEditor(Controller controller) {
        this.controller = controller;
        StyleConstants.setAlignment(this.alignAtts, 2);
        this.setFont(controller.getDefaultFont());
        this.termField = new JTextPane(new DefaultStyledDocument());
        this.defField = new JTextPane(new DefaultStyledDocument());
        this.commentField = new JTextPane(new DefaultStyledDocument());
        this.rangeButton = new JButton("<no range>");
        this.domainButton = new JButton("<no domain>");
        this.cyclicBox = new JCheckBox("Is cyclic");
        this.transitiveBox = new JCheckBox("Is transitive");
        this.symmetricBox = new JCheckBox("Is symmetric");
        this.listenerHash = new HashMap();
        this.listenerHash.put(this.termField, new EditsDocumentListener());
        this.listenerHash.put(this.defField, new EditsDocumentListener());
        this.listenerHash.put(this.commentField, new EditsDocumentListener());
        this.idField = new JTextField("no term loaded");
        this.idField.setEditable(false);
        this.idField.setBorder(null);
        this.idField.setOpaque(false);
        this.secIDField = new JTextPane(new DefaultStyledDocument());
        this.secIDField.setEditable(false);
        this.secIDField.setBorder(null);
        this.secIDField.setOpaque(false);
        this.categoryTable = new JTable();
        this.categoryTable.setModel(this.categoryTableModel);
        this.categoryTable.setDefaultRenderer(TermCategory.class, new DefaultTableCellRenderer());
        this.relationshipTable = new JTable();
        this.relationshipTable.setModel(this.relationshipTableModel);
        this.checkboxPane = new JScrollPane(this.categoryTable, 20, 31);
        this.relationshipScroller = new JScrollPane(this.relationshipPanel, 20, 31);
        this.nsField = new JComboBox();
        this.nsField.setBackground(Preferences.defaultButtonColor());
        this.rangeButton.setBackground(Preferences.defaultButtonColor());
        this.rangeButton.setBorder(null);
        this.rangeButton.setFont(controller.getDefaultFont());
        this.cyclicBox.setOpaque(false);
        this.transitiveBox.setOpaque(false);
        this.symmetricBox.setOpaque(false);
        this.cyclicBox.setFont(controller.getDefaultFont());
        this.transitiveBox.setFont(controller.getDefaultFont());
        this.symmetricBox.setFont(controller.getDefaultFont());
        this.domainButton.setBackground(Preferences.defaultButtonColor());
        this.domainButton.setBorder(this.emptyBorder);
        this.domainButton.setFont(controller.getDefaultFont());
        Font defaultFont = controller.getDefaultFont();
        Font idFont = new Font(defaultFont.getFontName(), 1, defaultFont.getSize() + 2);
        Font nsFont = new Font(defaultFont.getFontName(), 1, defaultFont.getSize());
        this.idField.setFont(idFont);
        this.secIDField.setFont(controller.getDefaultFont());
        this.nsField.setFont(nsFont);
        this.commitButton = new JButton("Commit");
        this.defDbxrefButton = new JButton("Edit");
        this.secondaryIDOuterPanel = this.getJPanel();
        this.secondaryIDOuterPanel.setLayout(new BorderLayout());
        this.secondaryIDPanel = this.getJPanel();
        this.secondaryIDPanel.setLayout(new BoxLayout(this.secondaryIDPanel, 0));
        JScrollPane secIDScroller = new JScrollPane(this.secIDField, 21, 30);
        secIDScroller.setBorder(null);
        secIDScroller.setOpaque(false);
        this.secondaryIDOuterPanel.add((Component)this.secIDField, "Center");
        this.secondaryIDOuterPanel.add((Component)this.getJLabel("Secondary ids"), "West");
        this.termScroller = new JScrollPane(this.termField, 22, 31);
        this.defScroller = new JScrollPane(this.defField, 22, 31);
        this.commentScroller = new JScrollPane(this.commentField, 22, 31);
        SynonymListEditor editSyn = new SynonymListEditor(controller);
        JTextArea noSynLabel = new JTextArea("Select a synonym from the list to edit it, or press add to create a new synonym");
        noSynLabel.setOpaque(false);
        noSynLabel.setFont(controller.getDefaultFont());
        noSynLabel.setDisabledTextColor(this.idField.getForeground());
        noSynLabel.setLineWrap(true);
        noSynLabel.setWrapStyleWord(true);
        noSynLabel.setEditable(false);
        noSynLabel.setEnabled(false);
        this.termScroller.setAlignmentX(0.0f);
        JTextArea noDbxLabel = new JTextArea("Select a dbxref from the list to edit it, or press add to create a new dbxref");
        noDbxLabel.setMinimumSize(new Dimension(0, 0));
        noDbxLabel.setOpaque(false);
        noDbxLabel.setFont(controller.getDefaultFont());
        noDbxLabel.setDisabledTextColor(this.idField.getForeground());
        noDbxLabel.setLineWrap(true);
        noDbxLabel.setWrapStyleWord(true);
        noDbxLabel.setEditable(false);
        noDbxLabel.setEnabled(false);
        this.synonymList = new ListEditor((GenericEditorComponent)editSyn, (Component)noSynLabel, new Vector(0), true, true, true, true, true);
        this.dbxrefList = new ListEditor((GenericEditorComponent)new DbxrefListEditor(controller), (Component)noDbxLabel, new Vector(0), true, true, true, true, true);
        this.defDbxrefList = new DragList(controller.getDragController());
        this.dbxrefList.setDragController(controller.getDragController());
        this.buildGUI();
        this.validate();
        this.attachListeners();
    }

    public void setListEditor(ListEditor parent) {
        this.parent = parent;
    }

    public void showDefDbxrefEditor() {
        JTextArea noDbxLabel = new JTextArea("Select a dbxref from the list to edit it, or press add to create a new dbxref");
        noDbxLabel.setOpaque(false);
        noDbxLabel.setFont(this.controller.getDefaultFont());
        noDbxLabel.setDisabledTextColor(this.idField.getForeground());
        noDbxLabel.setLineWrap(true);
        noDbxLabel.setWrapStyleWord(true);
        noDbxLabel.setEditable(false);
        noDbxLabel.setEnabled(false);
        final JDialog dialog = new JDialog((Frame)null, "Edit definition dbxrefs", true);
        dialog.setFont(this.controller.getDefaultFont());
        final ListEditor editor = new ListEditor((GenericEditorComponent)new DbxrefListEditor(this.controller, 2), (Component)noDbxLabel, this.defDbxList, false, true, true, true, false);
        editor.setOpaque(false);
        editor.setPreferredSize(new Dimension(300, 200));
        editor.setFont(this.controller.getDefaultFont());
        editor.setDragController(this.controller.getDragController());
        editor.setButtonColor(Preferences.defaultButtonColor());
        JButton okButton = new JButton("Ok");
        okButton.setFont(this.controller.getDefaultFont());
        okButton.setBackground(Preferences.defaultButtonColor());
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                editor.commit();
                dialog.setVisible(false);
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)editor, "North");
        panel.add((Component)buttonPanel, "South");
        panel.setBackground(Preferences.defaultBackgroundColor());
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.show();
        this.defDbxrefList.setListData(this.defDbxList);
    }

    protected synchronized boolean alterDocumentStructureLater(Document doc, int start, int end) {
        this.documentLater.setVals(doc, start, end);
        SwingUtilities.invokeLater(this.documentLater);
        return this.documentLater.failed;
    }

    protected void alterDocumentStructure(Document doc, int start, int end) {
        DocumentListener dl;
        Iterator it = this.listenerHash.keySet().iterator();
        while (it.hasNext()) {
            JTextPane pane = (JTextPane)it.next();
            dl = (DocumentListener)this.listenerHash.get(pane);
            pane.getDocument().removeDocumentListener(dl);
        }
        for (int i = 0; i < this.controller.getDocumentPlugins().size(); ++i) {
            DocumentChanger dc = (DocumentChanger)this.controller.getDocumentPlugins().get(i);
            if (!dc.enableDocumentAlteration()) continue;
            dc.alterDocument(doc, start, end);
        }
        it = this.listenerHash.keySet().iterator();
        while (it.hasNext()) {
            JTextPane pane = (JTextPane)it.next();
            dl = (DocumentListener)this.listenerHash.get(pane);
            pane.getDocument().addDocumentListener(dl);
        }
    }

    protected void attachListeners() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 2), "COMMIT");
        this.getActionMap().put("COMMIT", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DETermEditor.this.commit();
            }
        });
        this.rangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DETermEditor.this.setRange(null);
            }
        });
        this.domainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DETermEditor.this.setDomain(null);
            }
        });
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DETermEditor.this.commit();
            }
        });
        this.defDbxrefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DETermEditor.this.showDefDbxrefEditor();
            }
        });
        this.defField.addMouseListener(this.fieldMouseListener);
        this.commentField.addMouseListener(this.fieldMouseListener);
        this.termField.addMouseListener(this.fieldMouseListener);
        Iterator it = this.listenerHash.keySet().iterator();
        int currentOffset = 0;
        while (it.hasNext()) {
            JTextPane pane = (JTextPane)it.next();
            DocumentListener dl = (DocumentListener)this.listenerHash.get(pane);
            pane.getDocument().addDocumentListener(dl);
            this.timer.schedule((TimerTask)((Object)dl), currentOffset, 1000L);
            currentOffset += 1000 / this.listenerHash.size();
        }
        this.controller.addListener(new TextUpdateListener());
        this.controller.addListener(new RefreshListener(){

            public void reload(RefreshEvent e) {
                Iterator it = e.getGraphEditList().iterator();
                boolean dontBother = false;
                while (it.hasNext()) {
                    HistoryItem.GraphOperation op = (HistoryItem.GraphOperation)it.next();
                    if (!op.newSelectionNeeded()) continue;
                    dontBother = true;
                    break;
                }
                if (!dontBother && DETermEditor.this.controller.getSubSelection() != null) {
                    DETermEditor.this.load(DETermEditor.this.controller.getSubSelection());
                }
            }
        });
        this.controller.getDragController().registerDropTarget(new DropTarget((Component)this.dbxrefList.getList(), (DropListener)new DropDbxrefsListener()));
        this.controller.getDragController().registerDropTarget(new DropTarget((Component)this.defDbxrefList, this.dropListener));
        this.controller.getDragController().registerDropTarget(new DropTarget((Component)this.rangeButton, this.dropRangeListener));
        this.controller.getDragController().registerDropTarget(new DropTarget((Component)this.domainButton, this.dropDomainListener));
        this.defDbxrefList.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DETermEditor.this.deleteSelectedDefReferences();
            }
        }, KeyStroke.getKeyStroke(127, 0), 0);
        final MultiIDObject mio = (MultiIDObject)this.currentTerm;
        this.secIDField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && mio.getSecondaryIDs().size() > 0) {
                    JPopupMenu menu = new JPopupMenu();
                    Iterator it = mio.getSecondaryIDs().iterator();
                    while (it.hasNext()) {
                        final String id = (String)it.next();
                        JMenuItem item = new JMenuItem(id);
                        item.setFont(DETermEditor.this.controller.getDefaultFont());
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                StringSelection sel = new StringSelection(id);
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
                                clipboard.setContents(sel, sel);
                            }
                        });
                        menu.add(item);
                    }
                    menu.show(DETermEditor.this.secIDField, e.getX(), e.getY());
                }
            }
        });
    }

    protected void deleteSelectedDefReferences() {
        Object[] selected = this.defDbxrefList.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            this.defDbxList.removeElement(selected[i]);
        }
        this.defDbxrefList.setListData(this.defDbxList);
    }

    protected boolean verify() {
        Dbxref ref;
        int i;
        Dbxref ref2;
        int i2;
        int option;
        if (this.defField.getText().length() > 0 && this.defDbxList.size() < 1) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "You have specified a definition with no definition dbxrefs.\nUnnattributed defintions are not allowed in the Gene Ontology.\nYour changes cannot be committed until a definition dbxref is added.");
            return false;
        }
        if (this.defField.getText().length() < 1 && this.defDbxList.size() > 0) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "You have specified definition dbxrefs, but no definitions.\nYou may not have references for a non-existent definition.");
            return false;
        }
        if (this.defField.getText().startsWith("MERGED DEFINITION:") && (option = JOptionPane.showConfirmDialog(Controller.getController().getFrame(), "This term seems to have a definition that was generated by a merge operation and requires editing. Proceed with commit?", "Definition needs editing", 0)) != 0) {
            return false;
        }
        if (this.commentField.getText().startsWith("MERGED COMMENT:") && (option = JOptionPane.showConfirmDialog(Controller.getController().getFrame(), "This term seems to have a comment that was generated by a merge operation and requires editing. Proceed with commit?", "Comment needs editing", 0)) != 0) {
            return false;
        }
        if (this.termField.getText().length() < 1) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "You have not specified a term name.\nAll terms require a term name.");
            return false;
        }
        if (DETermEditor.containsInvalid(this.termField.getText())) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "OBOClass names may not contain newline characters");
            return false;
        }
        if (DETermEditor.containsExtended(this.termField.getText())) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "OBOClass names may not contain non-ASCII characters");
            return false;
        }
        if (DETermEditor.containsExtended(this.defField.getText())) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "OBOClass definitions may not contain non-ASCII characters");
            return false;
        }
        if (DETermEditor.containsExtended(this.commentField.getText())) {
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "OBOClass comments may not contain non-ASCII characters");
            return false;
        }
        Vector v = this.synonymList.getData();
        for (i2 = 0; i2 < v.size(); ++i2) {
            Synonym s = (Synonym)v.get(i2);
            if (DETermEditor.containsInvalid(s.getText())) {
                JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Synonyms may not contain newline characters");
                return false;
            }
            if (DETermEditor.containsExtended(s.getText())) {
                JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Synonyms may not contain non-ascii characters");
                return false;
            }
            Iterator it = s.getDbxrefs().iterator();
            while (it.hasNext()) {
                Dbxref ref3 = (Dbxref)it.next();
                if (!DETermEditor.containsExtended(ref3.getID()) && !DETermEditor.containsExtended(ref3.getDatabase()) && !DETermEditor.containsExtended(ref3.getDesc())) continue;
                JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Dbxrefs may not contain non-ascii characters");
                return false;
            }
        }
        v = this.dbxrefList.getData();
        for (i2 = 0; i2 < v.size(); ++i2) {
            ref2 = (Dbxref)v.get(i2);
            if (!DETermEditor.containsExtended(ref2.getID()) && !DETermEditor.containsExtended(ref2.getDatabase()) && !DETermEditor.containsExtended(ref2.getDesc())) continue;
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Dbxrefs may not contain non-ascii characters");
            return false;
        }
        v = this.defDbxList;
        for (i2 = 0; i2 < v.size(); ++i2) {
            ref2 = (Dbxref)v.get(i2);
            if (!DETermEditor.containsExtended(ref2.getID()) && !DETermEditor.containsExtended(ref2.getDatabase()) && !DETermEditor.containsExtended(ref2.getDesc())) continue;
            JOptionPane.showMessageDialog(Controller.getController().getFrame(), "Dbxrefs may not contain non-ascii characters");
            return false;
        }
        Iterator it = this.controller.getSession().getObjects().iterator();
        while (it.hasNext()) {
            int option2;
            IdentifiedObject t = (IdentifiedObject)it.next();
            if (t.equals(this.currentTerm) || !this.termField.getText().equals(t.getName()) || (option2 = JOptionPane.showConfirmDialog(Controller.getController().getFrame(), "OBOClass " + t.getID() + " already has " + "the name " + t.getName() + ". Proceed " + "with commit?", "Duplicate term name", 0)) == 0) continue;
            return false;
        }
        boolean foundBadSyn = false;
        boolean foundBadDbxref = false;
        boolean foundBadName = false;
        String badName = null;
        if (this.termField.getText().equals("<new term>") || this.termField.getText().equals("<new ontology>") || this.termField.getText().equals("<new type>")) {
            badName = this.termField.getText();
            foundBadName = true;
        }
        for (i = 0; i < this.synonymList.getData().size(); ++i) {
            Synonym s = (Synonym)this.synonymList.getData().get(i);
            if (!foundBadSyn && s.getText().equals("<new synonym>")) {
                foundBadSyn = true;
            }
            if (!foundBadDbxref) {
                Iterator it2 = s.getDbxrefs().iterator();
                while (it2.hasNext()) {
                    Dbxref ref4 = (Dbxref)it2.next();
                    if (!ref4.getID().equals("<new dbxref>")) continue;
                    foundBadDbxref = true;
                }
            }
            if (foundBadSyn && foundBadDbxref) break;
        }
        if (!foundBadDbxref) {
            for (i = 0; i < this.dbxrefList.getData().size(); ++i) {
                ref = (Dbxref)this.dbxrefList.getData().get(i);
                if (!ref.getID().equals("<new dbxref>")) continue;
                foundBadDbxref = true;
                break;
            }
        }
        if (!foundBadDbxref) {
            for (i = 0; i < this.defDbxList.size(); ++i) {
                ref = (Dbxref)this.defDbxList.get(i);
                if (!ref.getID().equals("<new dbxref>")) continue;
                foundBadDbxref = true;
                break;
            }
        }
        if (foundBadName || foundBadSyn || foundBadDbxref) {
            String out = "";
            if (foundBadName) {
                out = "This term's name is " + badName;
            }
            if (foundBadSyn || foundBadDbxref) {
                out = out.equals("") ? "This term contains " : out + ".\nThis term also contains ";
                if (foundBadSyn) {
                    out = out + "synonyms named <new synonym>";
                    if (foundBadDbxref) {
                        out = out + "\nand dbxrefs named <new dbxref>";
                    }
                } else if (foundBadDbxref) {
                    out = out + "dbxrefs named <new dbxref>";
                }
            }
            out = out + ".\nDo you still want to commit this term?";
            int option3 = JOptionPane.showConfirmDialog(Controller.getController().getFrame(), out, "Potential problem with term text", 0);
            if (option3 != 0) {
                return false;
            }
        }
        return true;
    }

    protected static boolean containsExtended(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (TermUtil.isLegal(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected static boolean containsInvalid(String str) {
        if (str == null) {
            return false;
        }
        return str.indexOf(10) >= 0;
    }

    public void commit() {
        this.commit(true);
    }

    public void commit(boolean reload) {
        this.synonymList.commit();
        this.dbxrefList.commit();
        if (!this.verify()) {
            return;
        }
        this.controller.apply(this.getCommitItem());
    }

    protected TermMacroHistoryItem getCommitItem() {
        Iterator it;
        IdentifiedObject newTerm = (IdentifiedObject)this.currentTerm.clone();
        this.store(newTerm);
        TreePath[] paths = this.controller.getSelectedPaths();
        TermMacroHistoryItem item = new TermMacroHistoryItem("Text edit on " + this.currentTerm.toString());
        this.historyList.getHistoryList().clear();
        HistoryGenerator.getTermTextChanges(this.currentTerm, newTerm, this.historyList);
        HistoryGenerator.getNamespaceChanges(this.currentTerm, newTerm, this.historyList);
        if (this.currentTerm instanceof LinkedObject) {
            it = ((LinkedObject)this.currentTerm).getParents().iterator();
            while (it.hasNext()) {
                Link link = (Link)it.next();
                if (!TermUtil.isIntersection(link)) continue;
                boolean found = false;
                Iterator it2 = this.completeDefPanel.getRelationshipList().iterator();
                while (it2.hasNext()) {
                    Link completeDefLink = (Link)it2.next();
                    if (!completeDefLink.equals(link)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.historyList.addItem(new DeleteLinkHistoryItem(link));
            }
            it = this.completeDefPanel.getRelationshipList().iterator();
            while (it.hasNext()) {
                OBORestriction completeDefLink = (OBORestriction)it.next();
                Link matchLink = TermUtil.findParentRelNoIntersection(completeDefLink, (LinkedObject)this.currentTerm);
                if (matchLink == null) {
                    completeDefLink.setCompletes(false);
                    this.historyList.addItem(new TermCopyHistoryItem(completeDefLink.getParent(), completeDefLink));
                }
                if (matchLink != null && TermUtil.isIntersection(matchLink)) continue;
                completeDefLink.setCompletes(false);
                this.historyList.addItem(new CompletesHistoryItem(completeDefLink));
            }
        }
        it = this.historyList.getHistoryItems();
        while (it.hasNext()) {
            HistoryItem txitem = (HistoryItem)it.next();
            item.addHistoryItem(txitem);
        }
        TreePath[] convertedPaths = TermUtil.convertPathsToIDs(paths);
        TreePath[] threesacharm = TermUtil.convertPathsToObjects(convertedPaths, this.controller.getSession());
        item.setPreSelection(convertedPaths);
        item.setPostSelection(convertedPaths);
        return item;
    }

    protected boolean isDuplicateName() {
        String newName = this.termField.getText();
        Iterator it = this.controller.getSession().getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject t = (IdentifiedObject)it.next();
            if (this.currentTerm.equals(t) || !t.getName().equals(newName)) continue;
            return true;
        }
        return false;
    }

    private JLabel getJLabel(String label) {
        JLabel out = new JLabel(label);
        out.setPreferredSize(new Dimension(80, out.getPreferredSize().height));
        out.setFont(this.controller.getDefaultFont());
        out.setVerticalAlignment(1);
        out.setAlignmentX(0.0f);
        return out;
    }

    private JPanel getJPanel() {
        JPanel out = new JPanel();
        out.setOpaque(true);
        out.setBackground(Preferences.defaultBackgroundColor());
        out.setAlignmentX(0.0f);
        return out;
    }

    public void drawGUI() {
        this.commitButton.setEnabled(true);
        this.nsField.removeAllItems();
        Iterator it = this.controller.getSession().getNamespaces().iterator();
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            this.nsField.addItem(ns);
        }
        if (this.currentTerm instanceof DefinedObject) {
            DefinedObject dio = (DefinedObject)this.currentTerm;
            if (dio.getDefinition() == null || dio.getDefinition().length() == 0) {
                this.defCommentTabbedPane.setTitleAt(0, "Definition");
            } else {
                this.defCommentTabbedPane.setTitleAt(0, "Definition *");
            }
        }
        if (this.currentTerm instanceof CommentedObject) {
            CommentedObject cio = (CommentedObject)this.currentTerm;
            if (cio.getComment() == null || cio.getComment().length() == 0) {
                this.defCommentTabbedPane.setTitleAt(1, "Comment");
            } else {
                this.defCommentTabbedPane.setTitleAt(1, "Comment *");
            }
        }
        if (this.currentTerm instanceof SynonymedObject) {
            this.synRefTabbedPane.setTitleAt(0, "Synonyms" + (((SynonymedObject)this.currentTerm).getSynonyms().size() == 0 ? "" : " *"));
        }
        if (this.currentTerm instanceof DbxrefedObject) {
            this.synRefTabbedPane.setTitleAt(1, "Dbxrefs" + (((DbxrefedObject)this.currentTerm).getDbxrefs().size() == 0 ? "" : " *"));
        }
        this.leftPanel.removeAll();
        this.leftPanel.add(Box.createVerticalStrut(5));
        this.leftPanel.add(this.idPanel);
        if (this.currentTerm != null && this.currentTerm instanceof MultiIDObject && ((MultiIDObject)this.currentTerm).getSecondaryIDs().size() > 0) {
            this.leftPanel.add(this.secondaryIDOuterPanel);
        }
        this.leftPanel.add(this.nsPanel);
        if (this.currentTerm instanceof OBOProperty) {
            this.leftPanel.add(Box.createVerticalStrut(5));
            this.leftPanel.add(this.rangePanel);
            this.leftPanel.add(Box.createVerticalStrut(5));
            this.leftPanel.add(this.domainPanel);
            this.leftPanel.add(Box.createVerticalStrut(5));
            JPanel booleanPanel = new JPanel();
            booleanPanel.setAlignmentX(0.0f);
            booleanPanel.setOpaque(false);
            booleanPanel.setLayout(new BoxLayout(booleanPanel, 0));
            booleanPanel.add(this.cyclicBox);
            booleanPanel.add(Box.createHorizontalStrut(5));
            booleanPanel.add(this.transitiveBox);
            booleanPanel.add(Box.createHorizontalStrut(5));
            booleanPanel.add(this.symmetricBox);
            this.leftPanel.add(booleanPanel);
            this.leftPanel.add(Box.createVerticalStrut(5));
        }
        this.leftPanel.add(this.termScroller);
        this.leftPanel.add(this.defCommentTabbedPane);
        this.leftPanel.add(this.synRefTabbedPane);
        this.synRefTabbedPane.remove(this.checkboxPane);
        if (this.currentTerm != null && this.currentTerm instanceof CategorizedObject && !TermUtil.isObsolete(this.currentTerm) && this.categoryTableModel.getRowCount() > 0) {
            this.synRefTabbedPane.add("Categories" + (((CategorizedObject)this.currentTerm).getCategories().size() > 0 ? " *" : ""), this.checkboxPane);
        }
        this.leftPanel.add(Box.createVerticalStrut(5));
        if (this.currentTerm != null) {
            this.leftPanel.add(this.innerButtonPanel);
            this.leftPanel.add(Box.createVerticalStrut(5));
        }
        this.leftPanel.add(Box.createVerticalGlue());
        this.leftPanel.revalidate();
        this.removeAll();
        this.add(Box.createHorizontalStrut(5));
        this.add(this.leftPanel);
        this.add(Box.createHorizontalStrut(5));
        this.revalidate();
    }

    public void buildGUI() {
        this.setBackground(Preferences.defaultBackgroundColor());
        this.categoryTable.setTableHeader(null);
        this.categoryTable.setColumnSelectionAllowed(false);
        this.categoryTable.setRowSelectionAllowed(false);
        this.categoryTable.setOpaque(false);
        this.categoryTable.setFont(this.controller.getDefaultFont());
        this.defDbxrefButton.setFont(this.controller.getDefaultFont());
        this.defDbxrefButton.setPreferredSize(new Dimension((int)this.defDbxrefButton.getPreferredSize().getWidth(), this.defDbxrefButton.getFont().getSize()));
        this.defDbxrefButton.setBackground(Preferences.defaultButtonColor());
        this.termField.setFont(this.controller.getDefaultFont());
        this.defField.setFont(this.controller.getDefaultFont());
        this.commentField.setFont(this.controller.getDefaultFont());
        this.synonymList.setFont(this.controller.getDefaultFont());
        this.dbxrefList.setFont(this.controller.getDefaultFont());
        this.defDbxrefList.setFont(this.controller.getDefaultFont());
        this.northPanel.setLayout(new BorderLayout());
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.idPanel.setLayout(new BorderLayout());
        this.idPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JLabel idLabel = this.getJLabel("ID");
        this.secondaryIDOuterPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)this.secondaryIDOuterPanel.getPreferredSize().getWidth()));
        this.idField.setAlignmentX(1.0f);
        this.idPanel.add((Component)idLabel, "West");
        this.idPanel.add((Component)this.idField, "East");
        this.nsPanel.setLayout(new BoxLayout(this.nsPanel, 0));
        this.nsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JLabel nsLabel = this.getJLabel("Namespace");
        this.nsField.setAlignmentX(0.0f);
        this.nsPanel.add(nsLabel);
        this.nsPanel.add(Box.createHorizontalGlue());
        this.nsPanel.add(this.nsField);
        this.rangePanel.setLayout(new BoxLayout(this.rangePanel, 0));
        this.rangePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JLabel rangeLabel = this.getJLabel("Range");
        this.rangeButton.setAlignmentX(0.0f);
        this.rangePanel.add(rangeLabel);
        this.rangePanel.add(Box.createHorizontalGlue());
        this.rangePanel.add(this.rangeButton);
        this.domainPanel.setLayout(new BoxLayout(this.domainPanel, 0));
        this.domainPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JLabel domainLabel = this.getJLabel("Domain");
        this.domainButton.setAlignmentX(0.0f);
        this.domainPanel.add(domainLabel);
        this.domainPanel.add(Box.createHorizontalGlue());
        this.domainPanel.add(this.domainButton);
        JLabel termLabel = this.getJLabel("OBOClass");
        JLabel defLabel = this.getJLabel("Text");
        JLabel defDbxrefLabel = this.getJLabel("Dbxrefs");
        this.commitButton.setFont(this.controller.getDefaultFont());
        this.commitButton.setBackground(Preferences.defaultButtonColor());
        TitledBorder termBorder = new TitledBorder("Term name");
        termBorder.setTitleFont(this.controller.getDefaultFont());
        this.termScroller.setBorder(termBorder);
        this.termScroller.setOpaque(false);
        TitledBorder defBorder = new TitledBorder("Definition");
        defBorder.setTitleFont(this.controller.getDefaultFont());
        this.defScroller.setAlignmentX(0.0f);
        this.defDbxrefList.setAlignmentX(0.0f);
        this.defPanel.setLayout(new GridBagLayout());
        JPanel refListLabelPanel = this.getJPanel();
        refListLabelPanel.setLayout(new BoxLayout(refListLabelPanel, 0));
        refListLabelPanel.add(defDbxrefLabel);
        refListLabelPanel.add(Box.createHorizontalStrut(5));
        refListLabelPanel.add(Box.createHorizontalGlue());
        refListLabelPanel.add(this.defDbxrefButton);
        JScrollPane refListPane = new JScrollPane((Component)this.defDbxrefList, 20, 30);
        JPanel defRefPanel = this.getJPanel();
        defRefPanel.setLayout(new BorderLayout());
        defRefPanel.add((Component)refListLabelPanel, "North");
        defRefPanel.add((Component)refListPane, "Center");
        defRefPanel.setPreferredSize(new Dimension(100, 100));
        JPanel defTextPanel = this.getJPanel();
        defTextPanel.setLayout(new BoxLayout(defTextPanel, 1));
        defTextPanel.add(defLabel);
        defTextPanel.add(this.defScroller);
        GridBagConstraints defTextConstraints = new GridBagConstraints();
        GridBagConstraints defRefConstraints = new GridBagConstraints();
        defTextConstraints.weightx = 2.0;
        defTextConstraints.weighty = 1.0;
        defRefConstraints.weightx = 0.0;
        defRefConstraints.weighty = 1.0;
        defRefConstraints.gridwidth = 0;
        defTextConstraints.fill = 1;
        defRefConstraints.fill = 1;
        this.defPanel.add((Component)defTextPanel, defTextConstraints);
        this.defPanel.add(Box.createHorizontalStrut(5));
        this.defPanel.add((Component)defRefPanel, defRefConstraints);
        TitledBorder commentBorder = new TitledBorder("Comment");
        commentBorder.setTitleFont(this.controller.getDefaultFont());
        this.commentScroller.setOpaque(false);
        this.commentScroller.setAlignmentX(0.0f);
        this.checkboxPane.setAlignmentX(0.0f);
        this.checkboxPane.setBackground(Preferences.defaultBackgroundColor());
        this.checkboxPane.setPreferredSize(new Dimension(250, 120));
        this.checkboxPane.setOpaque(false);
        TitledBorder synBorder = new TitledBorder("Synonyms");
        synBorder.setTitleFont(this.controller.getDefaultFont());
        this.synonymList.setBorder((Border)synBorder);
        this.synonymList.setBackground(Preferences.defaultBackgroundColor());
        TitledBorder dbxBorder = new TitledBorder("General DbXrefs");
        dbxBorder.setTitleFont(this.controller.getDefaultFont());
        this.dbxrefList.setBorder((Border)dbxBorder);
        this.dbxrefList.setBackground(Preferences.defaultBackgroundColor());
        this.dbxrefList.setPreferredSize(new Dimension(250, 100));
        this.dbxrefList.setMinimumSize(new Dimension(150, 100));
        this.dbxrefList.setAlignmentX(0.0f);
        this.synonymList.setPreferredSize(new Dimension(250, 180));
        this.synonymList.setMinimumSize(new Dimension(150, 100));
        this.synonymList.setAlignmentX(0.0f);
        this.synonymList.setButtonColor(Preferences.defaultButtonColor());
        this.dbxrefList.setButtonColor(Preferences.defaultButtonColor());
        this.commitButton.setAlignmentX(0.0f);
        this.innerButtonPanel.setLayout(new BoxLayout(this.innerButtonPanel, 0));
        this.innerButtonPanel.add(Box.createHorizontalGlue());
        this.innerButtonPanel.add(this.commitButton);
        if (this.currentTerm != null && !TermUtil.isObsolete(this.currentTerm)) {
            this.innerButtonPanel.add(Box.createHorizontalStrut(8));
        }
        this.innerButtonPanel.add(Box.createHorizontalGlue());
        this.relationshipPanel.setLayout(new BoxLayout(this.relationshipPanel, 1));
        this.idPanel.setAlignmentY(0.0f);
        this.nsPanel.setAlignmentY(0.0f);
        this.termScroller.setAlignmentY(0.0f);
        this.defPanel.setAlignmentY(0.0f);
        this.checkboxPane.setAlignmentY(0.0f);
        this.synonymList.setAlignmentY(0.0f);
        this.dbxrefList.setAlignmentY(0.0f);
        this.commentScroller.setAlignmentY(0.0f);
        this.innerButtonPanel.setAlignmentY(0.0f);
        this.defCommentTabbedPane.add("Definition", this.defPanel);
        this.defCommentTabbedPane.add("Comment", this.commentScroller);
        this.defCommentTabbedPane.add("Cross Products", this.relationshipScroller);
        this.defCommentTabbedPane.setFont(this.controller.getDefaultFont());
        this.defCommentTabbedPane.setBackground(Preferences.defaultButtonColor());
        this.defCommentTabbedPane.setAlignmentX(0.0f);
        this.synRefTabbedPane.add("Synonyms", (Component)this.synonymList);
        this.synRefTabbedPane.add("Dbxrefs", (Component)this.dbxrefList);
        this.synRefTabbedPane.add("Categories", this.checkboxPane);
        this.synRefTabbedPane.setFont(this.controller.getDefaultFont());
        this.synRefTabbedPane.setBackground(Preferences.defaultButtonColor());
        this.synRefTabbedPane.setAlignmentX(0.0f);
        this.setLayout(new BoxLayout(this, 0));
    }

    public void load(Object loadme) {
        Iterator it2;
        this.currentTerm = (IdentifiedObject)loadme;
        if (!(this.currentTerm instanceof OBOClass) && !(this.currentTerm instanceof OBOProperty)) {
            return;
        }
        if (this.currentTerm instanceof OBOProperty) {
            this.setRange(((OBOProperty)this.currentTerm).getRange());
            this.setDomain(((OBOProperty)this.currentTerm).getDomain());
            this.setCyclic(((OBOProperty)this.currentTerm).isCyclic());
            this.setSymmetric(((OBOProperty)this.currentTerm).isSymmetric());
            this.setTransitive(((OBOProperty)this.currentTerm).isTransitive());
        } else {
            this.setRange(null);
            this.setDomain(null);
        }
        this.categoryTableModel.reload();
        this.relationshipPanel.removeAll();
        this.relationshipList.clear();
        if (this.currentTerm instanceof LinkedObject) {
            Iterator it3 = ((LinkedObject)this.currentTerm).getParents().iterator();
            while (it3.hasNext()) {
                OBORestriction tr;
                Link link = (Link)it3.next();
                if (!(link instanceof OBORestriction) || !(tr = (OBORestriction)link).completes()) continue;
                if (tr.getType().equals(OBOProperty.IS_A)) {
                    this.relationshipList.add(0, tr);
                    continue;
                }
                this.relationshipList.add(tr);
            }
        }
        if (this.relationshipList.size() == 0) {
            this.defCommentTabbedPane.setTitleAt(2, "Cross Products");
        } else {
            this.defCommentTabbedPane.setTitleAt(2, "Cross Products *");
        }
        this.relationshipPanel.add((Component)((Object)this.completeDefPanel), "Center");
        if (this.currentTerm instanceof OBOClass) {
            this.completeDefPanel.setClass((OBOClass)this.currentTerm);
        }
        this.relationshipPanel.add(Box.createVerticalGlue());
        this.drawGUI();
        this.idField.setEnabled(!TermUtil.isObsolete(this.currentTerm));
        this.nsField.setEnabled(!TermUtil.isObsolete(this.currentTerm));
        this.termField.setEnabled(!TermUtil.isObsolete(this.currentTerm));
        this.synonymList.setEnabled(!TermUtil.isObsolete(this.currentTerm));
        this.dbxrefList.setEnabled(!TermUtil.isObsolete(this.currentTerm));
        if (this.currentTerm instanceof MultiIDObject) {
            Iterator it = ((MultiIDObject)this.currentTerm).getSecondaryIDs().iterator();
            boolean first = true;
            String out = "";
            while (it.hasNext()) {
                String text = (String)it.next();
                if (!first) {
                    out = out + ", ";
                }
                out = out + text;
                first = false;
            }
            this.secIDField.setText(out + " ");
            this.secIDField.getStyledDocument().setParagraphAttributes(0, out.length(), this.alignAtts, false);
        }
        if (this.currentTerm.getID() == null) {
            this.idField.setText("<not yet assigned>");
        } else {
            this.idField.setText(this.currentTerm.getID());
        }
        if (this.currentTerm.getNamespace() == null) {
            this.nsField.setSelectedItem(null);
        } else {
            this.nsField.setSelectedItem(this.currentTerm.getNamespace());
        }
        this.termField.setText(this.currentTerm.getName());
        if (this.currentTerm instanceof DefinedObject) {
            this.defField.setText(((DefinedObject)this.currentTerm).getDefinition());
            this.defDbxList.removeAllElements();
            it2 = ((DefinedObject)this.currentTerm).getDefDbxrefs().iterator();
            while (it2.hasNext()) {
                this.defDbxList.add(((Dbxref)it2.next()).clone());
            }
            this.defDbxrefList.setListData(this.defDbxList);
            this.defField.setCaretPosition(0);
        }
        if (this.currentTerm instanceof CommentedObject) {
            this.commentField.setText(((CommentedObject)this.currentTerm).getComment());
        }
        this.termField.setCaretPosition(0);
        this.defField.setCaretPosition(0);
        this.commentField.setCaretPosition(0);
        if (this.currentTerm.isBuiltIn()) {
            this.commitButton.setEnabled(false);
        }
        if (this.currentTerm instanceof SynonymedObject) {
            Vector<Object> synList = new Vector<Object>();
            it2 = ((SynonymedObject)this.currentTerm).getSynonyms().iterator();
            while (it2.hasNext()) {
                Synonym s = (Synonym)it2.next();
                if (s.getText().equals("Extra special synonym")) {
                    new Exception("determeditor.s = " + s + ", refs = " + s.getDbxrefs()).printStackTrace();
                }
                synList.add(s.clone());
            }
            this.synonymList.setData(synList);
        }
        if (this.currentTerm instanceof DbxrefedObject) {
            Vector<Object> dbxList = new Vector<Object>();
            it2 = ((DbxrefedObject)this.currentTerm).getDbxrefs().iterator();
            while (it2.hasNext()) {
                dbxList.add(((Dbxref)it2.next()).clone());
            }
            this.dbxrefList.setData(dbxList);
        }
        this.termField.setCaretPosition(0);
        this.alterDocumentStructure(this.defField.getDocument(), 0, this.defField.getDocument().getLength());
        this.alterDocumentStructure(this.termField.getDocument(), 0, this.termField.getDocument().getLength());
        this.alterDocumentStructure(this.commentField.getDocument(), 0, this.commentField.getDocument().getLength());
    }

    protected void buildRelationshipPanel(JPanel panel, Collection relationshipList) {
        Iterator it = relationshipList.iterator();
        while (it.hasNext()) {
            final OBORestriction tr = (OBORestriction)it.next();
            JPanel relPanel = this.getJPanel();
            relPanel.setLayout(new BoxLayout(relPanel, 0));
            if (!tr.getType().equals(OBOProperty.IS_A)) {
                relPanel.add(Box.createHorizontalStrut(20));
            }
            JButton propertyButton = new JButton(tr.getType().getID());
            JButton parentButton = new JButton(tr.getParent().getID());
            parentButton.setForeground(Color.blue);
            JLabel termLabel = new JLabel(tr.getParent().getName());
            parentButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DETermEditor.this.controller.select(tr.getParent());
                }
            });
            propertyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DETermEditor.this.controller.select(tr.getType());
                }
            });
            propertyButton.setOpaque(false);
            parentButton.setOpaque(false);
            propertyButton.setBorder(null);
            parentButton.setBorder(null);
            propertyButton.setFont(this.controller.getDefaultFont());
            parentButton.setFont(this.controller.getDefaultFont());
            termLabel.setFont(this.controller.getDefaultFont());
            relPanel.add(propertyButton);
            relPanel.add(Box.createHorizontalStrut(10));
            relPanel.add(parentButton);
            relPanel.add(Box.createHorizontalStrut(10));
            relPanel.add(termLabel);
            relPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 12));
            this.relationshipPanel.add(relPanel);
        }
    }

    public void store(Object saveme) {
        IdentifiedObject term = (IdentifiedObject)saveme;
        term.setName(this.termField.getText());
        term.setNamespace((Namespace)this.nsField.getSelectedItem());
        if (term instanceof DefinedObject) {
            ((DefinedObject)term).setDefinition(this.defField.getText());
            ((DefinedObject)term).getDefDbxrefs().clear();
            ((DefinedObject)term).getDefDbxrefs().addAll(this.defDbxList);
        }
        if (term instanceof CommentedObject) {
            ((CommentedObject)term).setComment(this.commentField.getText());
        }
        if (term instanceof CategorizedObject) {
            for (int i = 0; i < this.categoryTableModel.getRowCount(); ++i) {
                TermCategory cat = (TermCategory)this.categoryTableModel.getValueAt(i, 0);
                boolean selected = (Boolean)this.categoryTableModel.getValueAt(i, 1);
                if (selected) {
                    ((CategorizedObject)term).addCategory(cat);
                    continue;
                }
                ((CategorizedObject)term).removeCategory(cat);
            }
        }
        if (term instanceof SynonymedObject) {
            ((SynonymedObject)term).getSynonyms().clear();
            ((SynonymedObject)term).getSynonyms().addAll(this.synonymList.getData());
        }
        if (term instanceof DbxrefedObject) {
            ((DbxrefedObject)term).getDbxrefs().clear();
            ((DbxrefedObject)term).getDbxrefs().addAll(this.dbxrefList.getData());
        }
        if (term instanceof OBOProperty) {
            ((OBOProperty)term).setDomain(this.domain);
            ((OBOProperty)term).setRange(this.range);
            ((OBOProperty)term).setSymmetric(this.symmetricBox.isSelected());
            ((OBOProperty)term).setTransitive(this.transitiveBox.isSelected());
            ((OBOProperty)term).setCyclic(this.cyclicBox.isSelected());
        }
    }

    public void setEditable(boolean in) {
    }

    public Object createNewValue() {
        return null;
    }

    public ComponentConfiguration getConfiguration() {
        return null;
    }

    public void setConfiguration(ComponentConfiguration config) {
    }

    public void init() {
    }

    public void cleanup() {
    }

    public boolean isSingleton() {
        return true;
    }

    public String getID() {
        return "TEXTEDIT";
    }

    public void setXML(String xml) {
    }

    protected class DropDbxrefsListener
    implements DropListener {
        protected DropDbxrefsListener() {
        }

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof Vector) {
                Vector v = (Vector)e.getData();
                return v.size() > 0 && v.elementAt(0) instanceof Dbxref;
            }
            if (e.getData() instanceof Object[]) {
                Object[] v = (Object[])e.getData();
                return v.length > 0 && v[0] instanceof Dbxref;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            DETermEditor.this.dbxrefList.getList().setBorder(DETermEditor.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            DETermEditor.this.dbxrefList.getList().setBorder(null);
        }

        public void drop(DragEvent e) {
            DETermEditor.this.dbxrefList.getList().setBorder(null);
            TextEditorUpdateEvent event = new TextEditorUpdateEvent(this);
            Vector<TextEditorUpdateEvent.DbxrefUpdate> updates = new Vector<TextEditorUpdateEvent.DbxrefUpdate>();
            Vector<Dbxref> dbxrefs = null;
            if (e.getData() instanceof Vector) {
                dbxrefs = VectorUtil.trueClone((Vector)((Vector)e.getData()));
            } else if (e.getData() instanceof Object[]) {
                dbxrefs = new Vector<Dbxref>();
                Object[] os = (Object[])e.getData();
                for (int i = 0; i < os.length; ++i) {
                    Dbxref ref = (Dbxref)os[i];
                    dbxrefs.add((Dbxref)ref.clone());
                }
            }
            for (int i = 0; i < dbxrefs.size(); ++i) {
                Dbxref ref = (Dbxref)dbxrefs.elementAt(i);
                TextEditorUpdateEvent.DbxrefUpdate update = new TextEditorUpdateEvent.DbxrefUpdate(ref, null, true, false);
                updates.addElement(update);
            }
            event.setDbxrefUpdates(updates);
            DETermEditor.this.controller.fireTextEditorUpdate(event);
        }

        public void draggedOver(DragEvent e) {
        }
    }

    protected class DocumentLater
    implements Runnable {
        Document doc;
        int start;
        int end;
        boolean failed;

        protected DocumentLater() {
        }

        public void setVals(Document doc, int start, int end) {
            this.doc = doc;
            this.start = start;
            this.end = end;
        }

        public void run() {
            this.failed = false;
            try {
                DETermEditor.this.alterDocumentStructure(this.doc, this.start, this.end);
            }
            catch (Exception ex) {
                this.failed = true;
            }
        }
    }

    protected class TextUpdateListener
    implements TextEditorUpdateListener {
        protected TextUpdateListener() {
        }

        public void update(TextEditorUpdateEvent e) {
            Vector dbxrefUpdates;
            if (e.getNewDefinition() != null) {
                DETermEditor.this.defField.setText(e.getNewDefinition());
                DETermEditor.this.defField.setCaretPosition(0);
            }
            if ((dbxrefUpdates = e.getDbxrefUpdates()) != null) {
                for (int i = 0; i < dbxrefUpdates.size(); ++i) {
                    Vector list;
                    TextEditorUpdateEvent.DbxrefUpdate update = (TextEditorUpdateEvent.DbxrefUpdate)dbxrefUpdates.elementAt(i);
                    boolean isDef = false;
                    if (update.isAdd()) {
                        if (update.getNewDbxref().getType() == 2) {
                            isDef = true;
                            list = DETermEditor.this.defDbxList;
                        } else {
                            list = DETermEditor.this.dbxrefList.getData();
                        }
                        list.addElement(update.getNewDbxref());
                    } else if (update.isDelete()) {
                        if (update.getOldDbxref().getType() == 2) {
                            list = DETermEditor.this.defDbxList;
                            isDef = true;
                        } else {
                            list = DETermEditor.this.dbxrefList.getData();
                        }
                        list.removeElement(update.getOldDbxref());
                    } else {
                        if (update.getOldDbxref().getType() == 2 && update.getOldDbxref().getType() == 2) {
                            list = DETermEditor.this.defDbxList;
                            isDef = true;
                        } else {
                            list = DETermEditor.this.dbxrefList.getData();
                        }
                        list.removeElement(update.getOldDbxref());
                        list.addElement(update.getNewDbxref());
                    }
                    if (isDef) {
                        DETermEditor.this.defDbxrefList.setListData(list);
                        continue;
                    }
                    DETermEditor.this.dbxrefList.setData(list);
                }
            }
        }
    }

    protected class CatPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;

        protected CatPanel() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }
    }

    protected class RelationshipTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected RelationshipTableModel() {
        }

        public void reload() {
            DETermEditor.this.relationshipList.clear();
            if (DETermEditor.this.currentTerm instanceof LinkedObject) {
                Iterator it = ((LinkedObject)DETermEditor.this.currentTerm).getParents().iterator();
                while (it.hasNext()) {
                    OBORestriction tr;
                    Link link = (Link)it.next();
                    if (!(link instanceof OBORestriction) || !(tr = (OBORestriction)link).completes()) continue;
                    if (tr.getType().equals(OBOProperty.IS_A)) {
                        DETermEditor.this.relationshipList.add(0, tr);
                        continue;
                    }
                    DETermEditor.this.relationshipList.add(tr);
                }
            }
        }

        public int getRowCount() {
            return DETermEditor.this.relationshipList.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int column) {
            OBORestriction tr = (OBORestriction)DETermEditor.this.relationshipList.get(row);
            if (column == 0) {
                return tr.getType();
            }
            if (column == 1) {
                return tr.getParent();
            }
            return null;
        }
    }

    protected class CategoryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        protected Vector catList = new Vector();
        protected Vector valList = new Vector();

        public void reload() {
            this.catList.clear();
            this.valList.clear();
            this.catList.addAll(DETermEditor.this.controller.getSession().getCategories());
            Collections.sort(this.catList, DETermEditor.this.catComparator);
            Iterator it = this.catList.iterator();
            while (it.hasNext()) {
                TermCategory cat = (TermCategory)it.next();
                if (!(DETermEditor.this.currentTerm instanceof CategorizedObject)) continue;
                this.valList.add(new Boolean(((CategorizedObject)DETermEditor.this.currentTerm).getCategories().contains(cat)));
            }
            this.fireTableStructureChanged();
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return class$org$geneontology$oboedit$datamodel$TermCategory == null ? (class$org$geneontology$oboedit$datamodel$TermCategory = DETermEditor.class$("org.geneontology.oboedit.datamodel.TermCategory")) : class$org$geneontology$oboedit$datamodel$TermCategory;
            }
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DETermEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Category";
            }
            return "Active?";
        }

        public int getRowCount() {
            return this.valList.size();
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.catList.get(row);
            }
            return this.valList.get(row);
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public void setValueAt(Object val, int row, int col) {
            if (col == 0) {
                return;
            }
            this.valList.set(row, (Boolean)val);
        }
    }

    protected class FieldMouseListener
    extends MouseAdapter {
        protected FieldMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (Controller.isPopupTrigger(e)) {
                for (int i = 0; i < DETermEditor.this.controller.getDocumentPlugins().size(); ++i) {
                    DocumentChanger dc = (DocumentChanger)DETermEditor.this.controller.getDocumentPlugins().get(i);
                    if (!dc.enableDocumentAlteration() || !(e.getSource() instanceof JTextComponent)) continue;
                    JTextComponent comp = (JTextComponent)e.getSource();
                    dc.rightClick(comp.getDocument(), comp.getCaretPosition(), e.getX(), e.getY(), comp);
                }
            }
        }
    }

    protected class EditsDocumentListener
    extends TimerTask
    implements DocumentListener {
        protected int startPos = Integer.MAX_VALUE;
        protected int endPos = -1;
        protected boolean doAlter = false;
        protected boolean altering = false;
        protected Document d;

        protected EditsDocumentListener() {
        }

        public synchronized void run() {
            if (this.doAlter && this.endPos > 0 && this.endPos - this.startPos > 0) {
                this.doAlteration();
            } else {
                this.doAlter = true;
            }
        }

        protected synchronized void handleUpdate(Document d, int start, int end, boolean forceAlter) {
            if (start < this.startPos) {
                this.startPos = start;
            }
            if (end > this.endPos) {
                this.endPos = end;
            }
            if (this.endPos > d.getLength()) {
                this.endPos = d.getLength();
            }
            if (this.startPos > d.getLength()) {
                this.startPos = d.getLength();
            }
            this.d = d;
            try {
                if (forceAlter) {
                    this.doAlteration();
                } else {
                    String s = d.getText(start, end - start);
                    this.doAlter = true;
                    for (int i = 0; i < s.length(); ++i) {
                        if (Character.isLetterOrDigit(s.charAt(i))) {
                            this.doAlter = false;
                            return;
                        }
                        this.doAlteration();
                    }
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
                this.doAlteration();
            }
        }

        protected synchronized void doAlteration() {
            if (this.altering) {
                return;
            }
            this.doAlter = false;
            this.altering = true;
            DETermEditor.this.alterDocumentStructureLater(this.d, this.startPos, this.endPos);
            this.endPos = Integer.MIN_VALUE;
            this.startPos = Integer.MAX_VALUE;
            this.altering = false;
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleUpdate(e.getDocument(), e.getOffset(), e.getOffset() + e.getLength(), false);
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleUpdate(e.getDocument(), e.getOffset(), e.getOffset(), true);
        }
    }
}

