/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import javax.xml.transform.TransformerException;
import org.geneontology.dataadapter.DataAdapter;
import org.geneontology.dataadapter.DataAdapterRegistry;
import org.geneontology.dataadapter.DefaultAdapterRegistry;
import org.geneontology.dataadapter.GraphicalAdapterChooser;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.JexlContext;
import org.geneontology.io.FileUtil;
import org.geneontology.oboedit.controller.ExpressionManager;
import org.geneontology.oboedit.dataadapter.DefaultIDGenerator;
import org.geneontology.oboedit.dataadapter.IDGenerator;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationModel;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.PathCapable;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.DbxrefImpl;
import org.geneontology.oboedit.datamodel.impl.DefaultLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.DefaultOperationModel;
import org.geneontology.oboedit.datamodel.impl.FilteredReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.NamedIDProfile;
import org.geneontology.oboedit.datamodel.impl.OBOSessionImpl;
import org.geneontology.oboedit.datamodel.impl.PushAndBubbleReasoner;
import org.geneontology.oboedit.gui.AutosaveThread;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.DefaultInputHandler;
import org.geneontology.oboedit.gui.DocumentChanger;
import org.geneontology.oboedit.gui.DropMenuAction;
import org.geneontology.oboedit.gui.FindPanel;
import org.geneontology.oboedit.gui.InputHandlerI;
import org.geneontology.oboedit.gui.MiniBrowser;
import org.geneontology.oboedit.gui.OBOEditComponent;
import org.geneontology.oboedit.gui.OBOEditComponentNameResolver;
import org.geneontology.oboedit.gui.OBOEditorKit;
import org.geneontology.oboedit.gui.OBOPanelHolder;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.oboedit.gui.ObjectSelector;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.TextEditManager;
import org.geneontology.oboedit.gui.TextIcon;
import org.geneontology.oboedit.gui.actions.AddAction;
import org.geneontology.oboedit.gui.actions.AddConsiderAction;
import org.geneontology.oboedit.gui.actions.AddParentAction;
import org.geneontology.oboedit.gui.actions.AddReplacementAction;
import org.geneontology.oboedit.gui.actions.AddRootAction;
import org.geneontology.oboedit.gui.actions.ApplyFilterAction;
import org.geneontology.oboedit.gui.actions.CloneAction;
import org.geneontology.oboedit.gui.actions.CompletesAction;
import org.geneontology.oboedit.gui.actions.CopyAction;
import org.geneontology.oboedit.gui.actions.DeleteAction;
import org.geneontology.oboedit.gui.actions.DestroyAction;
import org.geneontology.oboedit.gui.actions.DomainChangeAction;
import org.geneontology.oboedit.gui.actions.InvNecessaryAction;
import org.geneontology.oboedit.gui.actions.MergeAction;
import org.geneontology.oboedit.gui.actions.MoveAction;
import org.geneontology.oboedit.gui.actions.NecessaryAction;
import org.geneontology.oboedit.gui.actions.RangeChangeAction;
import org.geneontology.oboedit.gui.actions.RemoveConsiderAction;
import org.geneontology.oboedit.gui.actions.RemoveReplacementAction;
import org.geneontology.oboedit.gui.actions.RerootAction;
import org.geneontology.oboedit.gui.actions.TypeChangeAction;
import org.geneontology.oboedit.gui.event.HistoryAppliedEvent;
import org.geneontology.oboedit.gui.event.HistoryListener;
import org.geneontology.oboedit.gui.event.InstanceEditEvent;
import org.geneontology.oboedit.gui.event.InstanceEditListener;
import org.geneontology.oboedit.gui.event.NewEditorKitEvent;
import org.geneontology.oboedit.gui.event.NewEditorKitListener;
import org.geneontology.oboedit.gui.event.PluginEvent;
import org.geneontology.oboedit.gui.event.PluginListener;
import org.geneontology.oboedit.gui.event.PreSelectionEvent;
import org.geneontology.oboedit.gui.event.PreSelectionListener;
import org.geneontology.oboedit.gui.event.PrimarySelectorChangeEvent;
import org.geneontology.oboedit.gui.event.PrimarySelectorChangeListener;
import org.geneontology.oboedit.gui.event.ReasonerStatusEvent;
import org.geneontology.oboedit.gui.event.ReasonerStatusListener;
import org.geneontology.oboedit.gui.event.ReconfigEvent;
import org.geneontology.oboedit.gui.event.ReconfigListener;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.oboedit.gui.event.ScrollSyncEvent;
import org.geneontology.oboedit.gui.event.ScrollSyncListener;
import org.geneontology.oboedit.gui.event.SelectionEvent;
import org.geneontology.oboedit.gui.event.SelectionListener;
import org.geneontology.oboedit.gui.event.SubSelectEvent;
import org.geneontology.oboedit.gui.event.SubSelectListener;
import org.geneontology.oboedit.gui.event.TextEditorUpdateEvent;
import org.geneontology.oboedit.gui.event.TextEditorUpdateListener;
import org.geneontology.oboedit.gui.event.VerificationListener;
import org.geneontology.oboedit.gui.filters.AllTextFieldsCriterion;
import org.geneontology.oboedit.gui.filters.CategorySearchCriterion;
import org.geneontology.oboedit.gui.filters.CommentSearchCriterion;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.ContainsComparison;
import org.geneontology.oboedit.gui.filters.DbxrefSearchCriterion;
import org.geneontology.oboedit.gui.filters.DefinitionDbxrefSearchCriterion;
import org.geneontology.oboedit.gui.filters.DefinitionSearchCriterion;
import org.geneontology.oboedit.gui.filters.EndsWithComparison;
import org.geneontology.oboedit.gui.filters.EqualsComparison;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.FilterPairImpl;
import org.geneontology.oboedit.gui.filters.GeneralDbxrefSearchCriterion;
import org.geneontology.oboedit.gui.filters.GreaterThanComparison;
import org.geneontology.oboedit.gui.filters.GreaterThanEqualsComparison;
import org.geneontology.oboedit.gui.filters.HasIsaParentCriterion;
import org.geneontology.oboedit.gui.filters.IDSearchCriterion;
import org.geneontology.oboedit.gui.filters.IsAnonymousCriterion;
import org.geneontology.oboedit.gui.filters.IsBuiltinCriterion;
import org.geneontology.oboedit.gui.filters.IsClassCriterion;
import org.geneontology.oboedit.gui.filters.IsCompleteCriterion;
import org.geneontology.oboedit.gui.filters.IsCompleteLinkCriterion;
import org.geneontology.oboedit.gui.filters.IsImpliedLinkCriterion;
import org.geneontology.oboedit.gui.filters.IsImpliedObjectCriterion;
import org.geneontology.oboedit.gui.filters.IsNecessaryCriterion;
import org.geneontology.oboedit.gui.filters.IsObsoleteCriterion;
import org.geneontology.oboedit.gui.filters.IsPropertyCriterion;
import org.geneontology.oboedit.gui.filters.IsRedundantLinkCriterion;
import org.geneontology.oboedit.gui.filters.IsTransitiveCriterion;
import org.geneontology.oboedit.gui.filters.IsaCompleteCriterion;
import org.geneontology.oboedit.gui.filters.KeywordSearchCriterion;
import org.geneontology.oboedit.gui.filters.LessThanComparison;
import org.geneontology.oboedit.gui.filters.LessThanEqualsComparison;
import org.geneontology.oboedit.gui.filters.LinkFilterImpl;
import org.geneontology.oboedit.gui.filters.LinkNamespaceSearchCriterion;
import org.geneontology.oboedit.gui.filters.LinkRenderSpec;
import org.geneontology.oboedit.gui.filters.NameSearchCriterion;
import org.geneontology.oboedit.gui.filters.NameSynonymSearchCriterion;
import org.geneontology.oboedit.gui.filters.NamespaceSearchCriterion;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;
import org.geneontology.oboedit.gui.filters.ObjectRenderSpec;
import org.geneontology.oboedit.gui.filters.ParentCountCriterion;
import org.geneontology.oboedit.gui.filters.RegexpComparison;
import org.geneontology.oboedit.gui.filters.SearchComparison;
import org.geneontology.oboedit.gui.filters.SearchCriterion;
import org.geneontology.oboedit.gui.filters.StartsWithComparison;
import org.geneontology.oboedit.gui.filters.SynonymDbxrefSearchCriterion;
import org.geneontology.oboedit.gui.filters.SynonymSearchCriterion;
import org.geneontology.oboedit.gui.filters.WildcardComparison;
import org.geneontology.oboedit.script.GUIScriptDelegate;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.Check;
import org.geneontology.oboedit.verify.UserFilterCheck;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.oboedit.verify.impl.CommentCheck;
import org.geneontology.oboedit.verify.impl.CycleCheck;
import org.geneontology.oboedit.verify.impl.DanglingIntersectionCheck;
import org.geneontology.oboedit.verify.impl.DbxrefCheck;
import org.geneontology.oboedit.verify.impl.DefinitionCheck;
import org.geneontology.oboedit.verify.impl.DisjointednessCheck;
import org.geneontology.oboedit.verify.impl.NameCheck;
import org.geneontology.oboedit.verify.impl.NameRedundancyCheck;
import org.geneontology.oboedit.verify.impl.SynonymCheck;
import org.geneontology.swing.ComponentNameResolver;
import org.geneontology.swing.DragContainer;
import org.geneontology.swing.DragController;
import org.geneontology.swing.JDragPanel;
import org.geneontology.swing.KeyRecorder;
import org.geneontology.swing.SwingUtil;
import org.geneontology.swing.XMLLayout;
import org.geneontology.util.BooleanFilter;
import org.geneontology.util.MultiProperties;
import org.geneontology.util.ObjectUtil;
import org.geneontology.util.VectorFilter;
import org.geneontology.util.XMLUtil;

public class Controller
implements ObjectSelector {
    protected static Controller controller;
    protected static File installationDir;
    protected static final boolean isMacOS;
    protected static final File prefsDir;
    protected static final File filterFile;
    protected static final File prefsFile;
    protected static final File prefsXMLFile;
    protected static final File stderrFile;
    protected static boolean suppressInstallations;
    protected Preferences preferences = Preferences.getPreferences();
    protected static String version;
    protected List activeComponents = new LinkedList();
    protected Vector adapterConfigListeners;
    protected DataAdapterRegistry adapterRegistry;
    protected AutosaveThread autosaveThread;
    protected Set checks = new HashSet();
    protected MultiProperties config;
    protected OBOEditorKit currentEditorKit = null;
    protected Cursor defaultCursor;
    protected FilterPair defaultFilterPair = new FilterPairImpl();
    protected Font defaultFont = null;
    protected Vector disableGUIListeners;
    protected Vector documentPlugins;
    protected DragController dragController;
    protected JDragPanel dragPanel;
    protected Vector dropMenuActions;
    protected Vector editActions;
    protected Collection editorKits = new LinkedList();
    protected ClassLoader extensionLoader;
    protected BooleanFilter filter = new BooleanFilter(1);
    protected FindPanel findPanel;
    protected CompoundFilter globalLinkFilter;
    protected Collection globalLinkRenderers;
    protected CompoundFilter globalTermFilter;
    protected Collection globalTermRenderers;
    protected boolean guiActive = false;
    protected boolean guiIsDisabled = false;
    protected HelpBroker helpBroker;
    protected OBOSession history;
    protected Vector historyListeners;
    protected Hashtable iconIndex;
    protected IDGenerator idAdapter = new DefaultIDGenerator();
    protected Vector inputHandlers;
    protected InstanceEditListener instanceEditorListener = new InstanceEditListener(){

        public void editOccurred(InstanceEditEvent event) {
            Controller.this.apply(event.getItem());
        }
    };
    protected KeyRecorder keyRecorder = new KeyRecorder();
    protected Properties lastAdapterProperties;
    protected List livePlugins = new LinkedList();
    protected OutputStream loggingStream;
    protected JFrame mainFrame;
    protected List modifyFilters = new LinkedList();
    protected List newEditorKitListeners;
    protected OperationModel operationModel;
    protected Map pluginConfigurations = new HashMap();
    protected Vector pluginListeners;
    protected Vector plugins;
    protected Vector preSelectionListeners;
    protected List primarySelectorListeners;
    protected FilteredReasonedLinkDatabase reasonedLinkDatabase = new FilteredReasonedLinkDatabase();
    protected List reasonerStatusListeners;
    protected Thread reasonerThread;
    protected Vector reconfigListeners;
    protected Vector reloadListeners;
    protected Vector rendererListeners;
    protected OBOEditComponentNameResolver resolver;
    protected Vector rootListeners;
    protected Vector scrollSyncListeners;
    protected List searchComparisons = new LinkedList();
    protected TreePath[] selectedPaths;
    protected Vector selectedTerms;
    protected Vector selectListeners;
    protected ObjectSelector selector;
    protected List setChoosers = new LinkedList();
    protected IdentifiedObject subSelection;
    protected Vector subSelectListeners;
    protected List termSearchCriteria = new LinkedList();
    protected TextEditManager textEditManager;
    protected Vector textEditorListeners;
    protected VerificationEngine verificationEngine = new VerificationEngine();
    protected Cursor waitArrowCursor;
    protected static final String PLIST_TRANSFORM = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n  <xsl:output method=\"xml\" indent=\"yes\"/>\n  <xsl:param name=\"memoryOption\" select=\"'7M'\"/>\n  <xsl:variable name=\"firstDictID\" select=\"generate-id(/plist/dict[1])\"/>\n  <xsl:template match=\"/\">\n     <xsl:apply-templates/>\n  </xsl:template>\n  <xsl:template match=\"dict\">\n    <xsl:copy>\n      <xsl:copy-of select=\"@*\"/>\n      <xsl:if test=\"generate-id() = $firstDictID and false() = (//key='VMOptions')\">\n\t<key>Java</key>\n\t<dict>\n\t  <key>VMOptions</key>\n\t  <string>-Xmx<xsl:value-of select=\"$memoryOption\"/></string>\n\t</dict>\n      </xsl:if>\n      <xsl:apply-templates/>\n   </xsl:copy>\n  </xsl:template>\n  <xsl:template match=\"string\">\n   <xsl:copy>\n     <xsl:copy-of select=\"@*\"/>\n     <xsl:choose>\n       <xsl:when test=\"preceding-sibling::*[1] = 'VMOptions'\">\n         <xsl:text>-Xmx</xsl:text><xsl:value-of select=\"$memoryOption\"/>\n       </xsl:when>\n       <xsl:otherwise>       \n         <xsl:value-of select=\"text()\"/>\n       </xsl:otherwise>\n     </xsl:choose>\n   </xsl:copy>\t \t\n  </xsl:template>\n  <xsl:template match=\"node()\">\n    <xsl:copy>\n      <xsl:copy-of select=\"@*\"/>\n      <xsl:apply-templates/>\n    </xsl:copy>\n  </xsl:template>\n</xsl:stylesheet>";

    public static ReasonedLinkDatabase createReasoner() {
        return new PushAndBubbleReasoner();
    }

    private static void fillInInstallationDirectory() {
        String prop = System.getProperty("launcherDir");
        if (prop != null && (installationDir = new File(prop)).exists() && installationDir.isDirectory()) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            File file = new File(token);
            if (file.getName().equals("oboedit.jar")) {
                try {
                    installationDir = file.getCanonicalFile().getParentFile().getParentFile();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (!file.getName().equals("oboedit_launcher.jar")) continue;
            try {
                installationDir = file.getCanonicalFile().getParentFile();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static URL getArchiveURL() {
        try {
            return new File(Controller.getInstallationDirectory(), "runtime/oboedit.jar").toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Controller getController() {
        if (controller == null && !suppressInstallations) {
            controller = new Controller();
            controller.postConstruction();
        }
        return controller;
    }

    public static File getFiltersDir() {
        return filterFile;
    }

    public static File getInstallationDirectory() {
        if (installationDir == null) {
            Controller.fillInInstallationDirectory();
        }
        return installationDir;
    }

    public static long getMemVal(String mem) {
        char sizeChar = mem.charAt(mem.length() - 1);
        long size = 0L;
        mem = mem.substring(0, mem.length() - 1);
        if (sizeChar == 'K' || sizeChar == 'k') {
            size = 1024L;
        } else if (sizeChar == 'M' || sizeChar == 'm') {
            size = 0x100000L;
        } else if (sizeChar == 'G' || sizeChar == 'g') {
            size = 0x40000000L;
        }
        try {
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        return size *= (long)Integer.parseInt(mem);
    }

    public static File getPrefsDir() {
        return prefsDir;
    }

    public static File getPrefsFile() {
        return prefsFile;
    }

    public static File getPrefsXMLFile() {
        return prefsXMLFile;
    }

    public static File getStderrFile() {
        return stderrFile;
    }

    public ExpressionManager getExpressionManager() {
        return ExpressionManager.getManager();
    }

    public static String getVersion() {
        if (version == null) {
            try {
                URL url = ClassLoader.getSystemClassLoader().getResource("org/geneontology/oboedit/resources/VERSION");
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                version = reader.readLine();
                reader.close();
            }
            catch (Exception e) {
                version = "<unable to determine>";
            }
        }
        return version;
    }

    public static boolean isMacOS() {
        return isMacOS;
    }

    public static boolean isPopupTrigger(MouseEvent e) {
        return Controller.isPopupTrigger(e, null);
    }

    public static boolean isPopupTrigger(MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (isMacOS) {
            return (e.isMetaDown() || SwingUtilities.isRightMouseButton(e) && !e.isControlDown()) && e.getID() == 502;
        }
        return SwingUtilities.isRightMouseButton(e) && e.getID() == 502;
    }

    public static IDProfile loadCurrentIDProfile() {
        File profileFile = new File(Controller.getPrefsDir(), "idprofiles.xml");
        IDProfile currentProfile = null;
        if (profileFile.exists()) {
            try {
                XMLDecoder decoder = new XMLDecoder(new FileInputStream(profileFile));
                decoder.readObject();
                currentProfile = (IDProfile)decoder.readObject();
                decoder.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            NamedIDProfile defaultProfile;
            currentProfile = defaultProfile = new NamedIDProfile("default");
            defaultProfile.setDefaultRule(controller.getDefaultPrefix() + ":$sequence(" + controller.getIDLength() + "," + controller.getMinID() + "," + controller.getMaxID() + ")$");
        }
        return currentProfile;
    }

    public static List loadIDProfiles() {
        File profileFile = new File(Controller.getPrefsDir(), "idprofiles.xml");
        List<NamedIDProfile> profiles = null;
        if (profileFile.exists()) {
            try {
                XMLDecoder decoder = new XMLDecoder(new FileInputStream(profileFile));
                profiles = (List)decoder.readObject();
                decoder.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (profiles == null) {
            profiles = new LinkedList();
            NamedIDProfile defaultProfile = new NamedIDProfile("default");
            defaultProfile.setDefaultRule(controller.getDefaultPrefix() + ":$sequence(" + controller.getIDLength() + "," + controller.getMinID() + "," + controller.getMaxID() + ")$");
            profiles.add(defaultProfile);
        }
        return profiles;
    }

    public static void setInstallationDirectory(File id) {
        installationDir = id;
    }

    public static void setSuppressInstallations(boolean suppressInstallations) {
        Controller.suppressInstallations = suppressInstallations;
        controller = null;
    }

    private Controller() {
        this.keyRecorder.setCoalesceInterval(600L);
        this.iconIndex = new Hashtable();
        this.plugins = new Vector();
        this.documentPlugins = new Vector();
        this.rootListeners = new Vector();
        this.preSelectionListeners = new Vector();
        this.selectListeners = new Vector();
        this.subSelectListeners = new Vector();
        this.reloadListeners = new Vector();
        this.pluginListeners = new Vector();
        this.reconfigListeners = new Vector();
        this.historyListeners = new Vector();
        this.textEditorListeners = new Vector();
        this.adapterConfigListeners = new Vector();
        this.disableGUIListeners = new Vector();
        this.rendererListeners = new Vector();
        this.scrollSyncListeners = new Vector();
        this.primarySelectorListeners = new LinkedList();
        this.newEditorKitListeners = new LinkedList();
        this.reasonerStatusListeners = new LinkedList();
        this.inputHandlers = new Vector();
        this.editActions = new Vector();
        this.dropMenuActions = new Vector();
        this.selectedTerms = new Vector();
        this.selectedPaths = new TreePath[0];
        this.dragPanel = new JDragPanel();
        if (!suppressInstallations) {
            this.dragController = new DragController((DragContainer)this.dragPanel);
            this.textEditManager = new TextEditManager();
            this.textEditManager.setController(this);
        }
        this.setupListeners();
        this.history = new OBOSessionImpl();
        this.extensionLoader = Controller.class.getClassLoader();
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setHistory(this.history);
    }

    public void addActiveComponent(OBOEditComponent comp) {
        this.activeComponents.add(comp);
    }

    public void addFilter(VectorFilter newFilter) {
        this.filter.addFilter(newFilter);
    }

    public void addListener(EventListener e) {
        if (e instanceof RootChangeListener) {
            this.rootListeners.add(e);
        }
        if (e instanceof ReasonerStatusListener) {
            this.reasonerStatusListeners.add(e);
        }
        if (e instanceof PreSelectionListener) {
            this.preSelectionListeners.add(e);
        }
        if (e instanceof SelectionListener) {
            this.selectListeners.add(e);
        }
        if (e instanceof SubSelectListener) {
            this.subSelectListeners.add(e);
        }
        if (e instanceof RefreshListener) {
            this.reloadListeners.add(e);
        }
        if (e instanceof PluginListener) {
            this.pluginListeners.add(e);
        }
        if (e instanceof ReconfigListener) {
            this.reconfigListeners.add(e);
        }
        if (e instanceof HistoryListener) {
            this.historyListeners.add(e);
        }
        if (e instanceof TextEditorUpdateListener) {
            this.textEditorListeners.add(e);
        }
        if (e instanceof ScrollSyncListener) {
            this.scrollSyncListeners.add(e);
        }
        if (e instanceof PrimarySelectorChangeListener) {
            this.primarySelectorListeners.add(e);
        }
        if (e instanceof NewEditorKitListener) {
            this.newEditorKitListeners.add(e);
        }
        if (e instanceof VerificationListener) {
            this.verificationEngine.addVerificationListener((VerificationListener)e);
        }
    }

    public void addModifyFilter(FilterPair filterPair) {
        this.modifyFilters.add(filterPair);
    }

    public boolean allowCycles() {
        return this.preferences.getAllowCycles();
    }

    public void apply(HistoryItem item) {
        this.doApply(item, true);
        this.history.getRedoHistoryItems().clear();
    }

    public void apply(HistoryList list) {
        Iterator it = list.getHistoryItems();
        HistoryItem item = null;
        while (it.hasNext()) {
            item = (HistoryItem)it.next();
            this.history.applyItem(item);
            OperationWarning warning = this.operationModel.apply(item);
            if (this.getUseReasoner()) {
                this.reasonedLinkDatabase.apply(item);
            }
            if (warning != null) {
                System.err.println("*** GOT WARNING = " + warning);
            }
            this.fireHistoryApplied(new HistoryAppliedEvent(this, item));
        }
        this.fireReload(new RefreshEvent(this));
        this.select(TermUtil.convertPathsToObjects(item.getPostSelection(), this.history));
    }

    protected void buildDefaultGlobalLinkFilter() {
        this.globalLinkFilter = new CompoundFilterImpl(0);
        ObjectFilterImpl iclfilter = new ObjectFilterImpl();
        iclfilter.setNegate(true);
        iclfilter.setCriterion(new IsCompleteLinkCriterion());
        ObjectFilterImpl istransitiveobjectfilter = new ObjectFilterImpl();
        istransitiveobjectfilter.setCriterion(new IsTransitiveCriterion());
        LinkFilterImpl completeFilter = new LinkFilterImpl();
        completeFilter.setAspect(4);
        completeFilter.setFilter(iclfilter);
        LinkFilterImpl transitiveFilter = new LinkFilterImpl();
        transitiveFilter.setAspect(2);
        transitiveFilter.setFilter(istransitiveobjectfilter);
        CompoundFilterImpl andCompleteFilter = new CompoundFilterImpl();
        andCompleteFilter.addFilter(completeFilter);
        andCompleteFilter.addFilter(transitiveFilter);
        this.globalLinkFilter.addFilter(andCompleteFilter);
    }

    protected void buildDefaultGlobalLinkRenderers() {
        this.globalLinkRenderers = new LinkedList();
        this.globalLinkRenderers.add(this.createRedundantRenderer());
        this.globalLinkRenderers.add(this.createImpliedRenderer());
    }

    protected void buildDefaultGlobalTermFilter() {
        this.globalTermFilter = new CompoundFilterImpl(0);
        ObjectFilterImpl propCriterion = new ObjectFilterImpl();
        propCriterion.setNegate(false);
        propCriterion.setCriterion(new IsPropertyCriterion());
        ObjectFilterImpl builtInCriterion = new ObjectFilterImpl();
        builtInCriterion.setNegate(false);
        builtInCriterion.setCriterion(new IsBuiltinCriterion());
        CompoundFilterImpl builtInProps = new CompoundFilterImpl();
        builtInProps.addFilter(propCriterion);
        builtInProps.addFilter(builtInCriterion);
        ObjectFilterImpl nonBuiltInObjects = new ObjectFilterImpl();
        nonBuiltInObjects.setNegate(true);
        nonBuiltInObjects.setCriterion(new IsBuiltinCriterion());
        CompoundFilterImpl builtInClassesFilter2 = new CompoundFilterImpl(1);
        builtInClassesFilter2.addFilter(builtInProps);
        builtInClassesFilter2.addFilter(nonBuiltInObjects);
        this.globalTermFilter.addFilter(builtInClassesFilter2);
    }

    protected void buildDefaultGlobalTermRenderers() {
        this.globalTermRenderers = new LinkedList();
        this.globalTermRenderers.add(this.createObsoleteRenderer());
        this.globalTermRenderers.add(this.createPropertyRenderer());
    }

    public boolean canRedo() {
        return this.history.getRedoHistoryItems().size() > 0;
    }

    public boolean canUndo() {
        return this.history.getCurrentHistory().size() > 0 || Controller.getController().getPreferences().getAutoCommitTextEdits() && Controller.getController().getTextEditManager().editsArePending();
    }

    public boolean caseSensitiveSort() {
        return this.preferences.getCaseSensitiveSort();
    }

    public void clearActiveComponents() {
        this.activeComponents.clear();
    }

    protected FilterPair createImpliedRenderer() {
        ObjectFilterImpl typeFilter = new ObjectFilterImpl();
        typeFilter.setCriterion(new IsImpliedLinkCriterion());
        LinkFilterImpl basicLinkFilter = new LinkFilterImpl();
        basicLinkFilter.setAspect(4);
        basicLinkFilter.setFilter(typeFilter);
        CompoundFilterImpl cfilter = new CompoundFilterImpl(0);
        cfilter.addFilter(basicLinkFilter);
        FilterPairImpl pair = new FilterPairImpl();
        pair.setLinkFilter(cfilter);
        LinkRenderSpec spec = new LinkRenderSpec();
        spec.setLinkColor(Color.blue);
        spec.setLineType(1);
        spec.setLineWidth(2);
        pair.setLinkRenderSpec(spec);
        return pair;
    }

    protected FilterPair createObsoleteRenderer() {
        FilterPairImpl pair = new FilterPairImpl();
        ObjectFilterImpl filter = new ObjectFilterImpl();
        filter.setCriterion(new IsObsoleteCriterion());
        CompoundFilterImpl cfilter = new CompoundFilterImpl(0);
        cfilter.addFilter(filter);
        pair.setObjectFilter(cfilter);
        ObjectRenderSpec spec = new ObjectRenderSpec();
        spec.setForegroundColor(Color.red);
        pair.setObjectRenderSpec(spec);
        return pair;
    }

    protected FilterPair createPropertyRenderer() {
        FilterPairImpl pair = new FilterPairImpl();
        ObjectFilterImpl filter = new ObjectFilterImpl();
        filter.setCriterion(new IsPropertyCriterion());
        CompoundFilterImpl cfilter = new CompoundFilterImpl(0);
        cfilter.addFilter(filter);
        pair.setObjectFilter(cfilter);
        ObjectRenderSpec spec = new ObjectRenderSpec();
        spec.setForegroundColor(Color.blue);
        pair.setObjectRenderSpec(spec);
        return pair;
    }

    protected FilterPair createRedundantRenderer() {
        ObjectFilterImpl typeFilter = new ObjectFilterImpl();
        typeFilter.setCriterion(new IsRedundantLinkCriterion());
        LinkFilterImpl basicLinkFilter = new LinkFilterImpl();
        basicLinkFilter.setAspect(4);
        basicLinkFilter.setFilter(typeFilter);
        CompoundFilterImpl cfilter = new CompoundFilterImpl(0);
        cfilter.addFilter(basicLinkFilter);
        FilterPairImpl pair = new FilterPairImpl();
        pair.setLinkFilter(cfilter);
        LinkRenderSpec spec = new LinkRenderSpec();
        spec.setLinkColor(Color.red);
        spec.setLineWidth(2);
        pair.setLinkRenderSpec(spec);
        return pair;
    }

    protected void doApply(HistoryItem item) {
        this.doApply(item, true);
    }

    protected void doApply(final HistoryItem item, final boolean doSelect) {
        this.history.applyItem(item);
        OperationWarning warning = this.operationModel.apply(item);
        if (warning != null) {
            System.err.println("warning = " + warning);
        }
        Runnable r = new Runnable(){

            public void run() {
                if (Controller.this.getUseReasoner()) {
                    Controller.this.reasonedLinkDatabase.apply(item);
                }
                Runnable r2 = new Runnable(){

                    public void run() {
                        Controller.this.fireHistoryApplied(new HistoryAppliedEvent(this, item));
                        Controller.this.fireReload(new RefreshEvent(this, item.getGraphEditList()));
                        if (item.getPostSelection() != null && doSelect) {
                            TreePath[] paths = TermUtil.convertPathsToObjects(item.getPostSelection(), (this).Controller.this.history);
                            Controller.this.select(paths);
                        }
                        Controller.getController().getDragController().lockWindows(false);
                    }
                };
                SwingUtilities.invokeLater(r2);
            }
        };
        if (this.getUseReasoner()) {
            Controller.getController().getDragController().lockWindows(true);
        }
        Thread thread = new Thread(r);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private void doConfigPatch() {
        URL url;
        String typeStr;
        String iconRes;
        Properties iconProps = this.preferences.getIconProperties();
        int iconCount = 0;
        try {
            String countStr = iconProps.getProperty("iconCount");
            if (countStr != null) {
                iconCount = Integer.parseInt(countStr);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (!this.iconIndex.containsKey("is_a")) {
            iconRes = "org/geneontology/oboedit/gui/resources/icons/isa.gif";
            typeStr = "is_a";
            iconProps.setProperty("iconType" + iconCount, typeStr);
            iconProps.setProperty("iconRes" + iconCount, iconRes);
            url = this.extensionLoader.getResource(iconRes);
            this.iconIndex.put(typeStr, new ImageIcon(url));
            ++iconCount;
        }
        if (!this.iconIndex.containsKey("part_of")) {
            iconRes = "org/geneontology/oboedit/gui/resources/icons/partof.gif";
            typeStr = "part_of";
            iconProps.setProperty("iconType" + iconCount, typeStr);
            iconProps.setProperty("iconRes" + iconCount, iconRes);
            url = this.extensionLoader.getResource(iconRes);
            this.iconIndex.put(typeStr, new ImageIcon(url));
            ++iconCount;
        }
        if (!this.iconIndex.containsKey("develops_from")) {
            iconRes = "org/geneontology/oboedit/gui/resources/icons/develops.gif";
            typeStr = "develops_from";
            iconProps.setProperty("iconType" + iconCount, typeStr);
            iconProps.setProperty("iconRes" + iconCount, iconRes);
            url = this.extensionLoader.getResource(iconRes);
            this.iconIndex.put(typeStr, new ImageIcon(url));
            ++iconCount;
        }
        iconProps.setProperty("iconCount", iconCount + "");
    }

    private void doInstallations() {
        if (!suppressInstallations) {
            this.installExtensions();
            this.installAdaptersAndPlugins();
            this.installIcons();
            this.installCursors();
            this.installConfigPatch();
        }
    }

    public boolean doPreSelectValidation(Object source) {
        PreSelectionEvent event = new PreSelectionEvent(source);
        Iterator it = this.preSelectionListeners.iterator();
        while (it.hasNext()) {
            PreSelectionListener listener = (PreSelectionListener)it.next();
            if (listener.isPreSelectOkay(event)) continue;
            return false;
        }
        return true;
    }

    public void doSelect(boolean propegateSelection) {
        if (this.selector != null && propegateSelection) {
            this.selector.select(this.selectedPaths);
        }
    }

    public void fireChangeRoot(RootChangeEvent event) {
        this.setHistory(event.getRootHistory());
        for (int i = 0; i < this.rootListeners.size(); ++i) {
            RootChangeListener listener = (RootChangeListener)this.rootListeners.elementAt(i);
            listener.changeRoot(event);
        }
    }

    public void fireHistoryApplied(HistoryAppliedEvent event) {
        for (int i = 0; i < this.historyListeners.size(); ++i) {
            HistoryListener listener = (HistoryListener)this.historyListeners.get(i);
            listener.applied(event);
        }
    }

    public void fireHistoryReversed(HistoryAppliedEvent event) {
        for (int i = 0; i < this.historyListeners.size(); ++i) {
            HistoryListener listener = (HistoryListener)this.historyListeners.get(i);
            listener.reversed(event);
        }
    }

    public void fireNewEditorKitEvent(NewEditorKitEvent e) {
        Iterator it = this.newEditorKitListeners.iterator();
        while (it.hasNext()) {
            NewEditorKitListener listener = (NewEditorKitListener)it.next();
            listener.newEditorKit(e);
        }
    }

    public void firePluginActivate(PluginEvent event) {
        this.livePlugins.add(event.getPlugin());
        Iterator it = this.pluginListeners.iterator();
        while (it.hasNext()) {
            PluginListener listener = (PluginListener)it.next();
            listener.pluginActivated(event);
        }
    }

    public void firePluginDeactivate(PluginEvent event) {
        this.pluginConfigurations.put(event.getPlugin().getID(), event.getPlugin().getConfiguration());
        this.flushComponentConfig();
        Iterator it = this.livePlugins.iterator();
        while (it.hasNext()) {
            ComponentPlugin plugin = (ComponentPlugin)it.next();
            if (!plugin.equals(event.getPlugin())) continue;
            it.remove();
            break;
        }
        it = this.pluginListeners.iterator();
        while (it.hasNext()) {
            PluginListener listener = (PluginListener)it.next();
            listener.pluginDeactivated(event);
        }
    }

    public void firePrimarySelectorChange(PrimarySelectorChangeEvent e) {
        Iterator it = this.primarySelectorListeners.iterator();
        while (it.hasNext()) {
            PrimarySelectorChangeListener listener = (PrimarySelectorChangeListener)it.next();
            listener.primarySelectorChange(e);
        }
    }

    public void fireReasonerStatusChange(ReasonerStatusEvent e) {
        Iterator it = this.reasonerStatusListeners.iterator();
        while (it.hasNext()) {
            ReasonerStatusListener listener = (ReasonerStatusListener)it.next();
            listener.statusChanged(e);
        }
    }

    public void fireReconfigEvent(ReconfigEvent event) {
        final ReconfigEvent finalEvent = event;
        Runnable reconfigMaker = new Runnable(){

            public void run() {
                for (int i = 0; i < Controller.this.reconfigListeners.size(); ++i) {
                    ReconfigListener listener = (ReconfigListener)Controller.this.reconfigListeners.elementAt(i);
                    listener.configReloaded(finalEvent);
                }
            }
        };
        reconfigMaker.run();
    }

    public void fireReload(RefreshEvent event) {
        for (int i = 0; i < this.reloadListeners.size(); ++i) {
            RefreshListener listener = (RefreshListener)this.reloadListeners.elementAt(i);
            listener.reload(event);
        }
    }

    public void fireScrollSync(ScrollSyncEvent e) {
        for (int i = 0; i < this.scrollSyncListeners.size(); ++i) {
            ScrollSyncListener listener = (ScrollSyncListener)this.scrollSyncListeners.get(i);
            listener.synchronizeScroll(e);
        }
    }

    private void fireSubSelect(SubSelectEvent event) {
        for (int i = 0; i < this.subSelectListeners.size(); ++i) {
            SubSelectListener listener = (SubSelectListener)this.subSelectListeners.elementAt(i);
            listener.selectObject(event);
        }
    }

    protected void fireTermSelect(SelectionEvent event) {
        for (int i = 0; i < this.selectListeners.size(); ++i) {
            SelectionListener listener = (SelectionListener)this.selectListeners.elementAt(i);
            listener.select(event);
        }
    }

    public void fireTextEditorUpdate(TextEditorUpdateEvent e) {
        final TextEditorUpdateEvent finalEvent = e;
        Runnable updateMaker = new Runnable(){

            public void run() {
                for (int i = 0; i < Controller.this.textEditorListeners.size(); ++i) {
                    TextEditorUpdateListener listener = (TextEditorUpdateListener)Controller.this.textEditorListeners.elementAt(i);
                    listener.update(finalEvent);
                }
            }
        };
        updateMaker.run();
    }

    public void flushComponentConfig() {
        if (!Controller.getController().isGUIActive()) {
            return;
        }
        try {
            XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(new File(Controller.getPrefsDir(), "component_prefs.xml"))));
            encoder.writeObject(this.getActiveComponentConfigMap());
            encoder.close();
        }
        catch (IOException ex) {
            System.err.println("Couldn't flush component config successfully");
        }
    }

    public void flushConfig() {
        try {
            this.writePreferences(this.preferences);
            this.writeVerificationSettings();
            Controller.updateLauncherConfigurations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map getActiveComponentConfigMap() {
        HashMap<String, Object> out = new HashMap<String, Object>();
        Iterator it = this.activeComponents.iterator();
        while (it.hasNext()) {
            OBOEditComponent component = (OBOEditComponent)it.next();
            if (component instanceof ComponentPlugin) {
                ComponentPlugin plugin = (ComponentPlugin)component;
                this.pluginConfigurations.put(plugin.getID(), plugin.getConfiguration());
                continue;
            }
            ArrayList<ComponentConfiguration> compList = (ArrayList<ComponentConfiguration>)out.get(component.getID());
            if (compList == null) {
                compList = new ArrayList<ComponentConfiguration>();
                out.put(component.getID(), compList);
            }
            compList.add(component.getConfiguration());
        }
        out.put("Controller.pluginConfigurations", this.pluginConfigurations);
        out.put("Controller.globalLinkFilter", this.getGlobalLinkFilter());
        out.put("Controller.globalTermFilter", this.getGlobalTermFilter());
        out.put("Controller.globalTermRenderers", this.getGlobalTermRenderers());
        out.put("Controller.globalLinkRenderers", this.getGlobalLinkRenderers());
        return out;
    }

    public List getActiveComponents() {
        return this.activeComponents;
    }

    public Vector getActivePlugins() {
        Vector out = new Vector();
        out.addAll(this.livePlugins);
        return out;
    }

    public MultiProperties getAdapterProperties() {
        return this.preferences.getAdapterChooserProperties();
    }

    public DataAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    public String getAllocatedMemory() {
        return this.preferences.getMemString();
    }

    protected MultiProperties getAnnouncedAddons(ClassLoader classLoader, URL url, boolean builtin) {
        String resourceName;
        MultiProperties pluginInfo = null;
        InputStream stream = null;
        if (builtin) {
            resourceName = "org/geneontology/oboedit/resources/builtinpluginlist";
            stream = classLoader.getResourceAsStream(resourceName);
        } else {
            resourceName = "resources/pluginlist";
            try {
                URL jarURL = new URL("jar:" + url.toString() + "!/");
                JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
                pluginInfo = new MultiProperties();
                JarFile jarFile = jarConnection.getJarFile();
                JarEntry entry = jarFile.getJarEntry(resourceName);
                stream = jarFile.getInputStream(entry);
            }
            catch (Exception ex) {
                System.err.println("exception in creating stream for " + url);
                ex.printStackTrace();
            }
        }
        try {
            pluginInfo = new MultiProperties();
            pluginInfo.load(stream);
        }
        catch (Exception e) {
            System.err.println("exception in reading plugin info stream from " + url);
            e.printStackTrace();
        }
        return pluginInfo;
    }

    public boolean getAutosaveEnabled() {
        return this.preferences.getAutosaveEnabled() && this.preferences.getAutosaveWaitTime() > 0;
    }

    public int getAutosaveExpiration() {
        return this.preferences.getAutosaveExpirationDays();
    }

    public File getAutosavePath() {
        return this.preferences.getAutosavePath();
    }

    public int getAutosaveWaitTime() {
        return this.preferences.getAutosaveWaitTime();
    }

    public String getBrowserCommand() {
        return this.preferences.getBrowserCommand();
    }

    public Set getChecks() {
        return this.checks;
    }

    public LinkDatabase getCurrentLinkDatabase() {
        if (this.getUseReasoner()) {
            return this.reasonedLinkDatabase;
        }
        return this.history.getLinkDatabase();
    }

    public List getDAGs() {
        LinkedList out = new LinkedList();
        Iterator it = this.activeComponents.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof OBOTermPanel) {
                out.add(o);
                continue;
            }
            if (!(o instanceof OBOPanelHolder)) continue;
            out.addAll(((OBOPanelHolder)o).getDAGs());
        }
        return out;
    }

    protected Collection getDefaultChecks() {
        LinkedList<AbstractCheck> out = new LinkedList<AbstractCheck>();
        out.add(new CommentCheck());
        out.add(new DefinitionCheck());
        out.add(new DbxrefCheck());
        out.add(new SynonymCheck());
        out.add(new NameCheck());
        out.add(new NameRedundancyCheck());
        out.add(new DanglingIntersectionCheck());
        out.add(new CycleCheck());
        out.add(new DisjointednessCheck());
        return out;
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public FilterPair getDefaultFilterPair() {
        return this.defaultFilterPair;
    }

    public Font getDefaultFont() {
        return this.preferences.getFont();
    }

    public String getDefaultPrefix() {
        if (this.config != null) {
            String storedPrefix;
            MultiProperties adapterProps = this.config.getProperties("idAdapter");
            String defaultPrefix = "OBOEDIT";
            if (adapterProps != null && (storedPrefix = adapterProps.getProperty("prefix")) != null) {
                defaultPrefix = storedPrefix;
            }
            return defaultPrefix;
        }
        return "ID";
    }

    public DataAdapter getDefaultReadAdapter() {
        if (this.adapterRegistry == null) {
            return new OBOFileAdapter();
        }
        return this.adapterRegistry.getAdapter("OBO_EDIT:OBO_Adapter");
    }

    public Vector getDocumentPlugins() {
        return this.documentPlugins;
    }

    public DragController getDragController() {
        return this.dragController;
    }

    public JDragPanel getDragPanel() {
        return this.dragPanel;
    }

    public List getDropMenuActions() {
        return this.dropMenuActions;
    }

    public List getEditActions() {
        return this.editActions;
    }

    public Collection getEditorKits() {
        return this.editorKits;
    }

    public String getEmailAddress() {
        return this.preferences.getEmail();
    }

    public String getErrorMessages() {
        return this.loggingStream.toString();
    }

    public ClassLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    private ClassLoader getExtensionLoader(URL[] urls) {
        try {
            URLClassLoader loader = URLClassLoader.newInstance(urls);
            return loader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected URL[] getExtensionURLs() {
        File[] dirList;
        File installationDir = new File(Controller.getInstallationDirectory(), "extensions");
        if (!installationDir.exists()) {
            try {
                installationDir.mkdirs();
            }
            catch (Exception e) {
                System.err.println("Could not create extensions/ directory!");
                e.printStackTrace();
                System.err.println("Recovering...");
                return new URL[0];
            }
        }
        if ((dirList = installationDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) == null) {
            System.err.println("There is a file named \"extension\" in the OBO-Edit installation directory that is not a directory! Please remove this file.");
            return new URL[0];
        }
        URL[] urls = new URL[dirList.length];
        for (int i = 0; i < dirList.length; ++i) {
            try {
                urls[i] = dirList[i].toURL();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public VectorFilter getFilter() {
        return this.filter;
    }

    public String getFilterMethod() {
        return this.preferences.getFilterMethod();
    }

    public FindPanel getFindPanel() {
        return this.findPanel;
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    public String getFullName() {
        return this.preferences.getFullName();
    }

    public ReasonedLinkDatabase getFullReasoner() {
        return (ReasonedLinkDatabase)this.reasonedLinkDatabase.getLinkDatabase();
    }

    public CompoundFilter getGlobalLinkFilter() {
        return this.globalLinkFilter;
    }

    public Collection getGlobalLinkRenderers() {
        return this.globalLinkRenderers;
    }

    public CompoundFilter getGlobalTermFilter() {
        return this.globalTermFilter;
    }

    public Collection getGlobalTermRenderers() {
        return this.globalTermRenderers;
    }

    public HelpBroker getHelpBroker() {
        if (this.helpBroker == null) {
            HelpSet hs;
            File docsDir = new File(Controller.getInstallationDirectory(), "docs/OBO-Edit.hs");
            try {
                hs = new HelpSet(null, docsDir.toURL());
            }
            catch (Exception ee) {
                System.out.println("HelpSet " + ee.getMessage());
                System.out.println("HelpSet " + docsDir + " not found");
                return null;
            }
            this.helpBroker = hs.createHelpBroker();
        }
        return this.helpBroker;
    }

    public OBOSession getHistory() {
        return this.getSession();
    }

    public String getHistoryFilePath() {
        return this.preferences.getHistoryFilePath();
    }

    public Icon getIconForRelationshipType(OBOProperty type) {
        Icon out = (Icon)this.iconIndex.get(type.getID());
        if (out == null) {
            out = new TextIcon(type.getName());
            this.iconIndex.put(type, out);
        }
        return out;
    }

    public Hashtable getIconIndex() {
        return this.iconIndex;
    }

    public Vector getIconLibrary() {
        Vector<URL> iconLib = new Vector<URL>();
        try {
            InputStream stream = this.extensionLoader.getResourceAsStream("org/geneontology/oboedit/gui/resources/icons/dir");
            Properties icons = new Properties();
            icons.load(stream);
            int size = Integer.parseInt(icons.getProperty("iconCount"));
            for (int i = 0; i < size; ++i) {
                String iconName = icons.getProperty("icon" + i);
                URL iconURL = this.extensionLoader.getResource(iconName);
                iconLib.addElement(iconURL);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iconLib;
    }

    public IDGenerator getIDAdapter() {
        return this.idAdapter;
    }

    public int getIDLength() {
        MultiProperties adapterProps;
        int length = 7;
        if (this.config != null && (adapterProps = this.config.getProperties("idAdapter")) != null) {
            try {
                length = Integer.parseInt(adapterProps.getProperty("idLength"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return length;
    }

    public List getInputHandlers() {
        return this.inputHandlers;
    }

    public KeyRecorder getKeyRecorder() {
        return this.keyRecorder;
    }

    public Properties getLastAdapterProperties() {
        return this.lastAdapterProperties;
    }

    public LinkDatabase getLinkDatabase() {
        return DefaultLinkDatabase.getDefault();
    }

    public List getLivePlugins() {
        return this.livePlugins;
    }

    public int getMaxID() {
        MultiProperties adapterProps;
        int max = Integer.MAX_VALUE;
        if (this.config != null && (adapterProps = this.config.getProperties("idAdapter")) != null) {
            try {
                max = Integer.parseInt(adapterProps.getProperty("endID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return max;
    }

    public String getMemString() {
        return this.preferences.getMemString();
    }

    public int getMinID() {
        MultiProperties adapterProps;
        int min = 0;
        if (this.config != null && (adapterProps = this.config.getProperties("idAdapter")) != null) {
            try {
                min = Integer.parseInt(adapterProps.getProperty("startID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return min;
    }

    public List getModifyFilters() {
        return this.modifyFilters;
    }

    public OBOEditComponentNameResolver getNameResolver() {
        return this.resolver;
    }

    public OperationModel getOperationModel() {
        return this.operationModel;
    }

    public Dbxref getPersonalDbxref() {
        return this.preferences.getPersonalDbxref();
    }

    public Vector getPlugins() {
        return this.plugins;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public ObjectSelector getPrimarySelector() {
        return this.selector;
    }

    public FilteredReasonedLinkDatabase getReasonedLinkDatabase() {
        return this.reasonedLinkDatabase;
    }

    public HistoryItem getRedoItem() {
        return (HistoryItem)this.history.getRedoHistoryItems().get(this.history.getRedoHistoryItems().size() - 1);
    }

    public RootAlgorithm getRootAlgorithm() {
        return RootAlgorithm.GREEDY;
    }

    public Set getRoots() {
        return this.history.getRoots();
    }

    public Map getSavedComponentConfigMap() {
        try {
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(new File(Controller.getPrefsDir(), "component_prefs.xml"))));
            Map out = (Map)decoder.readObject();
            decoder.close();
            return out;
        }
        catch (Exception ex) {
            return new HashMap();
        }
    }

    public List getSearchComparisons() {
        return this.searchComparisons;
    }

    public List getSearchCriteria() {
        return this.termSearchCriteria;
    }

    public TreePath[] getSelectedPaths() {
        return this.selectedPaths;
    }

    public Vector getSelectedTerms() {
        return this.selectedTerms;
    }

    public int getSelectionBatchSize() {
        return this.preferences.getSelectionBatchSize();
    }

    public OBOSession getSession() {
        return this.history;
    }

    public IdentifiedObject getSubSelection() {
        return this.subSelection;
    }

    public TextEditManager getTextEditManager() {
        return this.textEditManager;
    }

    public HistoryItem getUndoItem() {
        return this.history.getCurrentHistory().peekItem();
    }

    public boolean getUseReasoner() {
        return this.preferences.getUseReasoner();
    }

    public String getUserName() {
        return this.preferences.getUserName();
    }

    public Vector getVectorForListener(EventListener e) {
        if (e instanceof RootChangeListener) {
            return this.rootListeners;
        }
        if (e instanceof SelectionListener) {
            return this.selectListeners;
        }
        if (e instanceof SubSelectListener) {
            return this.subSelectListeners;
        }
        if (e instanceof RefreshListener) {
            return this.reloadListeners;
        }
        if (e instanceof PluginListener) {
            return this.pluginListeners;
        }
        if (e instanceof ReconfigListener) {
            return this.reconfigListeners;
        }
        if (e instanceof TextEditorUpdateListener) {
            return this.textEditorListeners;
        }
        return null;
    }

    public VerificationEngine getVerificationEngine() {
        return this.verificationEngine;
    }

    public int getViewCacheSize() {
        return 10000;
    }

    public Cursor getWaitArrowCursor() {
        return this.waitArrowCursor;
    }

    public String getXMLLayout() {
        return this.preferences.getLayout();
    }

    public XMLLayout getConfiguredXMLLayout() {
        XMLLayout layout = new XMLLayout();
        layout.setLayout(this.getXMLLayout());
        layout.setComponentNameResolver((ComponentNameResolver)this.getNameResolver());
        layout.setContext(this.getExpressionManager().getContext());
        layout.setDefaultTabColor(this.getPreferences().getButtonColor());
        layout.setDefaultBGColor(this.getPreferences().getBackgroundColor());
        layout.setDefaultFont(this.getPreferences().getFont());
        return layout;
    }

    public boolean guiIsDisabled() {
        return this.guiIsDisabled;
    }

    public void haltAutosaveThread() {
        if (this.autosaveThread != null) {
            this.autosaveThread.halt();
        }
    }

    protected void initFilter() {
    }

    protected void initializeReasonerDatabase() {
        ReasonedLinkDatabase linkDatabase = Controller.createReasoner();
        linkDatabase.setLinkDatabase(this.history.getLinkDatabase());
        this.reasonedLinkDatabase.setLinkDatabase(linkDatabase);
        this.reasonedLinkDatabase.recache();
    }

    public void installAdapters(MultiProperties config) {
        int adapterCount = 0;
        try {
            adapterCount = Integer.parseInt(config.getProperty("adapterCount"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < adapterCount; ++i) {
            String adapterName = config.getProperty("installAdapter" + i);
            try {
                Class<?> adapterClass = this.extensionLoader.loadClass(adapterName);
                DataAdapter adapter = (DataAdapter)adapterClass.newInstance();
                this.adapterRegistry.addAdapter(adapter);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not find adapter " + adapterName);
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                System.err.println("Adapter " + adapterName + " does not conform " + "adapter guidelines and could not be " + "loaded");
                continue;
            }
            catch (InstantiationException e) {
                System.err.println("Adapter " + adapterName + " crashed during " + "startup.");
                continue;
            }
            catch (Exception e) {
                System.err.println("Adapter " + adapterName + " failed because of " + e.toString() + " stack trace: ");
                e.printStackTrace(System.err);
            }
        }
    }

    protected void installAdaptersAndPlugins() {
        URL[] urls = this.getExtensionURLs();
        this.adapterRegistry = new DefaultAdapterRegistry();
        this.plugins = new Vector();
        MultiProperties mp = this.getAnnouncedAddons(ClassLoader.getSystemClassLoader(), Controller.getArchiveURL(), true);
        this.installAdapters(mp.getProperties("adapters"));
        this.installPlugins(mp.getProperties("plugins"));
        this.installChecks(mp.getProperties("checks"));
        this.installInputHandlers(mp.getProperties("inputHandlers"));
        this.installDropMenuActions(mp.getProperties("dropMenuActions"));
        this.installEditActions(mp.getProperties("editActions"));
        URLClassLoader classLoader = URLClassLoader.newInstance(urls);
        for (int i = 0; i < urls.length; ++i) {
            mp = this.getAnnouncedAddons(classLoader, urls[i], false);
            if (mp == null) continue;
            this.installAdapters(mp.getProperties("adapters"));
            this.installPlugins(mp.getProperties("plugins"));
            this.installChecks(mp.getProperties("checks"));
            this.installInputHandlers(mp.getProperties("inputHandlers"));
            this.installDropMenuActions(mp.getProperties("dropMenuActions"));
            this.installEditActions(mp.getProperties("editActions"));
        }
    }

    private void installChecks(MultiProperties junk) {
        Check check;
        VerificationEngine.VerificationConfiguration config = null;
        File profileFile = new File(Controller.getPrefsDir(), "verify.xml");
        if (profileFile.exists()) {
            try {
                XMLDecoder decoder = new XMLDecoder(new FileInputStream(profileFile));
                config = (VerificationEngine.VerificationConfiguration)decoder.readObject();
                decoder.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = this.verificationEngine.getConfiguration();
        }
        Iterator it = this.getDefaultChecks().iterator();
        while (it.hasNext()) {
            check = (Check)it.next();
            boolean found = false;
            Iterator it2 = config.getChecks().iterator();
            while (it2.hasNext()) {
                Check check2 = (Check)it2.next();
                if (check2 == null || !check.getClass().equals(check2.getClass())) continue;
                found = true;
                break;
            }
            if (found) continue;
            config.getChecks().add(check);
        }
        it = config.getChecks().iterator();
        while (it.hasNext()) {
            check = (Check)it.next();
            System.err.println("******** loaded check " + check);
            if (check instanceof UserFilterCheck) {
                System.err.println("   " + ((UserFilterCheck)check).getFilter());
            }
            if (check != null) continue;
            System.err.println("Deleting null check");
            it.remove();
        }
        this.verificationEngine.setConfiguration(config);
    }

    private void installConfigPatch() {
        boolean patched = ObjectUtil.equals((Object)Controller.getVersion(), (Object)this.config.getProperty("configPatch"));
        if (!patched) {
            this.doConfigPatch();
            this.config.setProperty("configPatch", Controller.getVersion());
            this.flushConfig();
        }
    }

    private void installCursors() {
        URL url = this.getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/cursors/waitarrow.gif");
        try {
            this.waitArrowCursor = SwingUtil.buildCursorByTrimming((Image)Toolkit.getDefaultToolkit().createImage(url), (String)"WAIT_CURSOR", (Cursor)Cursor.getDefaultCursor());
        }
        catch (Exception e) {
            System.err.println("failed cursor load");
            e.printStackTrace();
        }
        this.defaultCursor = Cursor.getDefaultCursor();
    }

    protected void installDefaultSearchCriteria() {
        this.installSearchComparison(new EqualsComparison());
        this.installSearchComparison(new ContainsComparison());
        this.installSearchComparison(new StartsWithComparison());
        this.installSearchComparison(new EndsWithComparison());
        this.installSearchComparison(new WildcardComparison());
        this.installSearchComparison(new RegexpComparison());
        this.installSearchComparison(new LessThanComparison());
        this.installSearchComparison(new LessThanEqualsComparison());
        this.installSearchComparison(new GreaterThanComparison());
        this.installSearchComparison(new GreaterThanEqualsComparison());
        this.installSearchCriterion(new AllTextFieldsCriterion());
        this.installSearchCriterion(new NameSynonymSearchCriterion());
        this.installSearchCriterion(new IDSearchCriterion());
        this.installSearchCriterion(new CategorySearchCriterion());
        this.installSearchCriterion(new NameSearchCriterion());
        this.installSearchCriterion(new SynonymSearchCriterion());
        this.installSearchCriterion(new CommentSearchCriterion());
        this.installSearchCriterion(new DefinitionSearchCriterion());
        this.installSearchCriterion(new NamespaceSearchCriterion());
        this.installSearchCriterion(new LinkNamespaceSearchCriterion());
        this.installSearchCriterion(new DbxrefSearchCriterion());
        this.installSearchCriterion(new GeneralDbxrefSearchCriterion());
        this.installSearchCriterion(new DefinitionDbxrefSearchCriterion());
        this.installSearchCriterion(new SynonymDbxrefSearchCriterion());
        this.installSearchCriterion(new IsCompleteCriterion());
        this.installSearchCriterion(new IsaCompleteCriterion());
        this.installSearchCriterion(new HasIsaParentCriterion());
        this.installSearchCriterion(new IsAnonymousCriterion());
        this.installSearchCriterion(new IsCompleteLinkCriterion());
        this.installSearchCriterion(new IsClassCriterion());
        this.installSearchCriterion(new IsObsoleteCriterion());
        this.installSearchCriterion(new IsPropertyCriterion());
        this.installSearchCriterion(new IsNecessaryCriterion());
        this.installSearchCriterion(new ParentCountCriterion());
        this.installSearchCriterion(new IsImpliedLinkCriterion());
        this.installSearchCriterion(new IsImpliedObjectCriterion());
        this.installSearchCriterion(new IsRedundantLinkCriterion());
        this.installSearchCriterion(new IsTransitiveCriterion());
        this.installSearchCriterion(new IsBuiltinCriterion());
        this.installSearchCriterion(new KeywordSearchCriterion());
    }

    protected void installDropMenuActions(MultiProperties mp) {
        this.dropMenuActions.clear();
        this.dropMenuActions.add(new CopyAction());
        this.dropMenuActions.add(new AddParentAction());
        this.dropMenuActions.add(new MoveAction());
        this.dropMenuActions.add(new MergeAction());
        this.dropMenuActions.add(new TypeChangeAction());
        this.dropMenuActions.add(new DomainChangeAction());
        this.dropMenuActions.add(new RangeChangeAction());
        this.dropMenuActions.add(new AddConsiderAction());
        this.dropMenuActions.add(new AddReplacementAction());
        for (int i = 0; i < this.dropMenuActions.size(); ++i) {
            DropMenuAction ea = (DropMenuAction)this.dropMenuActions.get(i);
            ea.setController(this);
        }
    }

    protected void installEditActions(MultiProperties mp) {
        this.editActions.clear();
        this.editActions.add(new MoveAction());
        this.editActions.add(new CopyAction());
        this.editActions.add(new AddParentAction());
        this.editActions.add(new MergeAction());
        this.editActions.add(new TypeChangeAction());
        this.editActions.add(new AddAction());
        this.editActions.add(new DeleteAction());
        this.editActions.add(new DestroyAction());
        this.editActions.add(new CloneAction());
        this.editActions.add(new AddRootAction());
        this.editActions.add(new RerootAction());
        this.editActions.add(new NecessaryAction());
        this.editActions.add(new InvNecessaryAction());
        this.editActions.add(new CompletesAction());
        this.editActions.add(new RemoveConsiderAction());
        this.editActions.add(new RemoveReplacementAction());
        for (int i = 0; i < this.editActions.size(); ++i) {
            ClickMenuAction ea = (ClickMenuAction)this.editActions.get(i);
            ea.setController(this);
        }
    }

    private void installExtensions() {
        URL[] extURLs = this.getExtensionURLs();
        URL[] urls = new URL[extURLs.length + 1];
        for (int i = 1; i < extURLs.length + 1; ++i) {
            urls[i] = extURLs[i - 1];
        }
        urls[0] = Controller.getArchiveURL();
        this.extensionLoader = this.getExtensionLoader(urls);
    }

    private void installIcons() {
        this.iconIndex = new Hashtable();
        Properties iconProps = this.preferences.getIconProperties();
        int iconCount = 0;
        try {
            String countStr = iconProps.getProperty("iconCount");
            if (countStr != null) {
                iconCount = Integer.parseInt(countStr);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < iconCount; ++i) {
            try {
                URL url;
                String typeStr = iconProps.getProperty("iconType" + i);
                String urlStr = iconProps.getProperty("iconURL" + i);
                if (urlStr == null) {
                    String resourceStr = iconProps.getProperty("iconRes" + i);
                    url = this.extensionLoader.getResource(resourceStr);
                } else {
                    url = new URL(urlStr);
                }
                if (typeStr == null || url == null) continue;
                this.iconIndex.put(typeStr, new ImageIcon(url));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public URL getResourceURL(String path) {
        return this.extensionLoader.getResource(path);
    }

    protected void installInputHandlers(MultiProperties mp) {
        DefaultInputHandler defaultInputHandler = new DefaultInputHandler();
        if (this.inputHandlers.size() == 0) {
            this.inputHandlers.add(new CopyAction());
            this.inputHandlers.add(new AddParentAction());
            this.inputHandlers.add(new MoveAction());
            this.inputHandlers.add(new MergeAction());
            this.inputHandlers.add(new TypeChangeAction());
            this.inputHandlers.add(new ApplyFilterAction());
            this.inputHandlers.add(defaultInputHandler);
        }
        for (int i = 0; i < this.inputHandlers.size(); ++i) {
            InputHandlerI handler = (InputHandlerI)this.inputHandlers.get(i);
            handler.setController(this);
        }
    }

    private void installPlugins(MultiProperties config) {
        int pluginCount = 0;
        try {
            pluginCount = Integer.parseInt(config.getProperty("pluginCount"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < pluginCount; ++i) {
            String pluginName = config.getProperty("installPlugin" + i);
            try {
                Class<?> pluginClass = this.extensionLoader.loadClass(pluginName);
                ComponentPlugin p = (ComponentPlugin)pluginClass.newInstance();
                this.plugins.add(p);
                if (!(p instanceof DocumentChanger)) continue;
                this.documentPlugins.add(p);
                continue;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not find plugin " + pluginName);
                continue;
            }
            catch (IllegalAccessException e) {
                System.err.println("Plugin " + pluginName + " does not conform " + "plugin guidelines and could not be " + "loaded");
                continue;
            }
            catch (InstantiationException e) {
                System.err.println("Plugin " + pluginName + " crashed during " + "startup.");
                continue;
            }
            catch (Exception e) {
                System.err.println("Plugin " + pluginName + " failed because of " + e.toString() + " stack trace: ");
                e.printStackTrace(System.err);
            }
        }
    }

    public void installSearchComparison(SearchComparison comp) {
        this.searchComparisons.add(comp);
    }

    public void installSearchCriterion(SearchCriterion crit) {
        this.termSearchCriteria.add(crit);
    }

    public boolean isGUIActive() {
        return this.guiActive;
    }

    private MultiProperties loadConfig() {
        File oldPrefsFile = new File(System.getProperty("user.home") + "/.oboeditor");
        if (!prefsFile.exists() && oldPrefsFile.exists()) {
            new File(System.getProperty("user.home") + "/.oboedit/").mkdirs();
            oldPrefsFile.renameTo(prefsFile);
        }
        MultiProperties props = new MultiProperties();
        try {
            FileUtil.ensureExists((File)prefsFile, (String)"org/geneontology/oboedit/resources/oboeditor.cfg");
            props.load((InputStream)new FileInputStream(prefsFile));
        }
        catch (IOException e) {
            System.err.println("Couldn't load file" + prefsFile);
            e.printStackTrace();
        }
        return props;
    }

    protected Preferences loadPreferences(MultiProperties config) {
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(prefsXMLFile)));
            this.preferences = (Preferences)d.readObject();
            d.close();
            return this.preferences;
        }
        catch (Exception ex) {
            String fontStyle;
            String fontSize;
            Font defaultFont;
            MultiProperties iconProperties;
            String out = config.getProperty("memory");
            if (out != null) {
                this.preferences.setMemString(out);
            }
            if ((out = config.getProperty("filterMethod")) != null) {
                this.preferences.setFilterMethod(out);
            }
            if ((out = config.getProperty("useBasicRootDetection")) != null) {
                this.preferences.setUseBasicRootDetection(!out.equals("false"));
            }
            if ((out = config.getProperty("browserCommand")) != null) {
                this.preferences.setBrowserCommand(out);
            }
            if ((out = config.getProperty("username")) != null && out.length() > 0) {
                this.preferences.setUserName(out);
            }
            if ((out = config.getProperty("fullname")) != null) {
                this.preferences.setFullName(out);
            }
            if ((iconProperties = config.getProperties("icons")) != null) {
                this.preferences.setIconProperties((Properties)iconProperties);
            }
            if ((out = config.getProperty("email")) != null) {
                this.preferences.setEmail(out);
            }
            if ((out = config.getProperty("dbxref_id")) != null) {
                String db = config.getProperty("dbxref_db");
                String typeStr = config.getProperty("dbxref_type");
                int type = -1;
                try {
                    type = Integer.parseInt(typeStr);
                }
                catch (NumberFormatException ex2) {
                    // empty catch block
                }
                String desc = config.getProperty("dbxref_desc");
                DbxrefImpl ref = new DbxrefImpl(db, out, type);
                ref.setDesc(desc);
                this.preferences.setPersonalDbxref(ref);
            }
            if ((out = config.getProperty("autosavePath")) != null) {
                this.preferences.setAutosavePath(new File(out));
            }
            if ((out = config.getProperty("autosaveEnabled")) != null) {
                this.preferences.setAutosaveEnabled(out.equals("true"));
            }
            if ((out = config.getProperty("autosaveExpirationDays")) != null) {
                try {
                    this.preferences.setAutosaveExpirationDays(Integer.parseInt(out));
                }
                catch (NumberFormatException ex3) {
                    // empty catch block
                }
            }
            if ((out = config.getProperty("autosaveFrequencyMins")) != null) {
                try {
                    this.preferences.setAutosaveWaitTime(Integer.parseInt(out));
                }
                catch (NumberFormatException ex4) {
                    // empty catch block
                }
            }
            if ((out = config.getProperty("caseSensitiveSort")) != null) {
                this.preferences.setCaseSensitiveSort(out.equals("true"));
            }
            if ((out = config.getProperty("showToolTips")) != null) {
                this.preferences.setShowToolTips(!out.equals("false"));
            }
            if ((out = config.getProperty("allowCycles")) != null) {
                this.preferences.setAllowCycles(out.equals("true"));
            }
            if ((out = config.getProperty("warnBeforeDelete")) != null) {
                this.preferences.setWarnBeforeDelete(!out.equals("false"));
            }
            if ((out = config.getProperty("warnBeforeDefinitionLoss")) != null) {
                this.preferences.setWarnBeforeDefinitionLoss(!out.equals("false"));
            }
            if ((out = config.getProperty("useReasoner")) != null) {
                this.preferences.setUseReasoner(out.equals("true"));
            }
            if ((out = config.getProperty("selectionBatchSize")) != null) {
                try {
                    int batchSize = Integer.parseInt(out);
                    this.preferences.setSelectionBatchSize(batchSize);
                }
                catch (NumberFormatException ex5) {
                    // empty catch block
                }
            }
            if ((out = config.getProperty("defaultFontName")) != null && (defaultFont = Preferences.decodeFont(out, fontSize = config.getProperty("defaultFontSize"), fontStyle = config.getProperty("defaultFontStyle"))) != null) {
                this.preferences.setFont(defaultFont);
            }
            if ((out = config.getProperty("historyFileLoc")) != null) {
                this.preferences.setHistoryFilePath(out);
            }
            try {
                this.writePreferences(this.preferences);
            }
            catch (IOException ex6) {
                // empty catch block
            }
            return this.preferences;
        }
    }

    public void notifySelection(Collection terms) {
        this.selectedTerms.clear();
        if (terms != null) {
            this.selectedPaths = this.selector != null ? TermUtil.getBestPaths(terms, this.getPrimarySelector().getRootAlgorithm(), this.getPrimarySelector().getLinkDatabase()) : new TreePath[0];
            for (int i = 0; i < this.selectedPaths.length; ++i) {
                this.selectedTerms.add(this.selectedPaths[i].getLastPathComponent());
            }
        } else {
            this.selectedPaths = new TreePath[0];
        }
        this.fireTermSelect(new SelectionEvent(this, true));
    }

    public void notifySelection(TreePath[] pathsarr) {
        this.selectedTerms.clear();
        LinkedList<TreePath> paths = new LinkedList<TreePath>();
        for (int i = 0; pathsarr != null && i < pathsarr.length; ++i) {
            TreePath path = pathsarr[i];
            Object o = path.getLastPathComponent();
            if (o instanceof Link) {
                paths.add(path);
                if (this.selectedTerms.contains(o)) continue;
                this.selectedTerms.add(o);
                continue;
            }
            System.err.println("UNEXPECTED CONDITION!!! Non link " + o + " at end of path!");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TreePath[] selectedPaths = new TreePath[paths.size()];
        Iterator it = paths.iterator();
        int i = 0;
        while (it.hasNext()) {
            selectedPaths[i] = (TreePath)it.next();
            ++i;
        }
        this.selectedPaths = selectedPaths;
        this.fireTermSelect(new SelectionEvent(this, true));
    }

    protected void installGlobalScriptObjects(JexlContext context) {
        try {
            context.setGlobalVariable("GUI", (Object)new GUIScriptDelegate(), false);
        }
        catch (ExpressionException expressionException) {
            // empty catch block
        }
    }

    private void postConstruction() {
        this.resolver = new OBOEditComponentNameResolver();
        this.installGlobalScriptObjects(this.getExpressionManager().getContext());
        this.keyRecorder.install();
        this.installDefaultSearchCriteria();
        try {
            this.readConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Couldn't read config file...");
            JOptionPane.showMessageDialog(null, e.toString());
        }
        this.initFilter();
        if (this.reasonerThread != null && this.reasonerThread.isAlive()) {
            try {
                this.reasonerThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.reasonerThread = null;
        }
    }

    public void readConfig() {
        Map configMap = this.getSavedComponentConfigMap();
        if (this.idAdapter instanceof DefaultIDGenerator) {
            ((DefaultIDGenerator)this.idAdapter).setProfile(Controller.loadCurrentIDProfile());
        }
        if (configMap.containsKey("Controller.pluginConfigurations")) {
            this.pluginConfigurations = (Map)configMap.get("Controller.pluginConfigurations");
        }
        this.globalTermFilter = (CompoundFilter)configMap.get("Controller.globalTermFilter");
        this.globalLinkFilter = (CompoundFilter)configMap.get("Controller.globalLinkFilter");
        this.globalTermRenderers = (Collection)configMap.get("Controller.globalTermRenderers");
        this.globalLinkRenderers = (Collection)configMap.get("Controller.globalLinkRenderers");
        if (this.globalTermFilter == null) {
            this.buildDefaultGlobalTermFilter();
        }
        if (this.globalLinkFilter == null) {
            this.buildDefaultGlobalLinkFilter();
        }
        if (this.globalTermRenderers == null) {
            this.buildDefaultGlobalTermRenderers();
        }
        if (this.globalLinkRenderers == null) {
            this.buildDefaultGlobalLinkRenderers();
        }
        try {
            this.config = this.loadConfig();
            this.preferences = this.loadPreferences(this.config);
            Preferences.setGlobalPreferences(this.preferences);
            this.setUseReasoner(this.preferences.getUseReasoner());
            this.fireReconfigEvent(new ReconfigEvent(this));
            this.fireReload(new RefreshEvent(this));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
            ex.printStackTrace();
        }
    }

    public void redo() {
        if (!this.getTextEditManager().checkUncommittedEdits()) {
            return;
        }
        this.textEditManager.clear();
        HistoryItem item = (HistoryItem)this.history.getRedoHistoryItems().remove(this.history.getRedoHistoryItems().size() - 1);
        this.doApply(item);
        this.textEditManager.resync();
    }

    public void removeFilter(VectorFilter newFilter) {
        this.filter.removeFilter(newFilter);
    }

    public void removeListener(EventListener e) {
        if (e instanceof RootChangeListener) {
            this.rootListeners.remove(e);
        }
        if (e instanceof PreSelectionListener) {
            this.preSelectionListeners.remove(e);
        }
        if (e instanceof SelectionListener) {
            this.selectListeners.remove(e);
        }
        if (e instanceof SubSelectListener) {
            this.subSelectListeners.remove(e);
        }
        if (e instanceof RefreshListener) {
            this.reloadListeners.remove(e);
        }
        if (e instanceof PluginListener) {
            this.pluginListeners.remove(e);
        }
        if (e instanceof ReconfigListener) {
            this.reconfigListeners.remove(e);
        }
        if (e instanceof TextEditorUpdateListener) {
            this.textEditorListeners.remove(e);
        }
        if (e instanceof HistoryListener) {
            this.historyListeners.remove(e);
        }
        if (e instanceof ScrollSyncListener) {
            this.scrollSyncListeners.remove(e);
        }
        if (e instanceof PrimarySelectorChangeListener) {
            this.primarySelectorListeners.remove(e);
        }
        if (e instanceof NewEditorKitListener) {
            this.newEditorKitListeners.remove(e);
        }
        if (e instanceof VerificationListener) {
            this.verificationEngine.removeVerificationListener((VerificationListener)e);
        }
    }

    public void removeModifyFilter(FilterPair filterPair) {
        this.modifyFilters.remove(filterPair);
    }

    protected void reverse(HistoryItem item) {
        OperationWarning warning = this.operationModel.reverse(item);
        if (warning != null) {
            System.err.println("warning = " + warning);
        }
        if (this.getUseReasoner()) {
            this.reasonedLinkDatabase.reverse(item);
        }
        this.fireHistoryReversed(new HistoryAppliedEvent(this, item));
        this.fireReload(new RefreshEvent(this, Collections.singletonList(new HistoryItem.GraphOperation(0))));
        this.select(TermUtil.convertPathsToObjects(item.getPreSelection(), this.history));
    }

    public void select(Collection terms) {
        this.select(terms, true);
    }

    public void select(Collection terms, boolean propegate) {
        this.notifySelection(terms);
        this.doSelect(propegate);
    }

    public void select(PathCapable term) {
        this.select(Collections.singleton(term), true);
    }

    public void select(TreePath[] pathsarr) {
        this.select(pathsarr, true);
    }

    public void select(TreePath[] pathsarr, boolean propegate) {
        this.notifySelection(pathsarr);
        this.doSelect(propegate);
    }

    public boolean selectShortestPathOnly() {
        return true;
    }

    public void setAdapterProperties(MultiProperties props) {
        this.preferences.setAdapterChooserProperties(props);
    }

    public void setFindPanel(FindPanel findPanel) {
        this.findPanel = findPanel;
    }

    public void setFrame(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setGUIActive(boolean guiActive) {
        this.guiActive = guiActive;
    }

    public void setHistory(OBOSession history) {
        this.history = history;
        if (this.getUseReasoner()) {
            this.initializeReasonerDatabase();
        }
        LinkedList<KitStruct> matchingKits = new LinkedList<KitStruct>();
        Iterator it = this.editorKits.iterator();
        while (it.hasNext()) {
            OBOEditorKit editorKit = (OBOEditorKit)it.next();
            int suitability = editorKit.getRecognizer().getSuitability(history);
            KitStruct kitStruct = new KitStruct(suitability, editorKit);
            if (suitability <= 0) continue;
            matchingKits.add(kitStruct);
        }
        Collections.sort(matchingKits);
        if (this.currentEditorKit != null) {
            this.currentEditorKit.clear();
            this.currentEditorKit.getEditor().removeInstanceEditListener(this.instanceEditorListener);
            this.currentEditorKit.getBrowser().removeInstanceEditListener(this.instanceEditorListener);
            this.currentEditorKit.getBrowser().clear();
        }
        if (matchingKits.size() > 0) {
            KitStruct kitStruct = (KitStruct)matchingKits.get(0);
            this.currentEditorKit = kitStruct.getKit();
            this.currentEditorKit.getEditor().addInstanceEditListener(this.instanceEditorListener);
            this.currentEditorKit.getBrowser().addInstanceEditListener(this.instanceEditorListener);
            this.currentEditorKit.init();
            this.currentEditorKit.getBrowser().init();
            this.currentEditorKit.getEditor().init();
        }
        this.fireNewEditorKitEvent(new NewEditorKitEvent(this, this.currentEditorKit));
        this.operationModel.setHistory(history);
    }

    public void setLastAdapterProperties(Properties lastAdapterProperties) {
        this.lastAdapterProperties = lastAdapterProperties;
    }

    public void setPrimarySelector(ObjectSelector selector) {
        this.selector = selector;
        this.firePrimarySelectorChange(new PrimarySelectorChangeEvent(this, selector));
        this.select(selector.getSelectedPaths());
    }

    public void setSubSelection(IdentifiedObject term) {
        this.setSubSelection(term, false);
    }

    public void setSubSelection(IdentifiedObject term, boolean partOfSelection) {
        this.subSelection = term;
        if (this.getSelectedTerms().contains(term)) {
            int swapIndex = 0;
            for (int i = 0; i < this.selectedPaths.length; ++i) {
                Object pathEnd = this.selectedPaths[i].getLastPathComponent();
                if (!(pathEnd instanceof Link) || !((Link)pathEnd).getChild().equals(term)) continue;
                TreePath swap = this.selectedPaths[i];
                this.selectedPaths[i] = this.selectedPaths[swapIndex];
                this.selectedPaths[swapIndex] = swap;
                ++swapIndex;
            }
        }
        this.fireSubSelect(new SubSelectEvent(this, term, partOfSelection));
    }

    protected void setupListeners() {
        this.addListener(new ReconfigListener(){

            public void configReloaded(ReconfigEvent e) {
                Controller.this.doInstallations();
            }
        });
        this.addListener(new FilterConfigurationListener());
    }

    public void setUseReasoner(final boolean useReasoner) {
        if (this.preferences.getUseReasoner() != useReasoner) {
            if (useReasoner) {
                Runnable r = new Runnable(){

                    public void run() {
                        Controller.this.initializeReasonerDatabase();
                        Controller.this.preferences.setUseReasoner(useReasoner);
                        Controller.this.flushConfig();
                        Controller.getController().getDragController().lockWindows(false);
                        Controller.this.fireReload(new RefreshEvent(this));
                    }
                };
                Controller.getController().getDragController().lockWindows(true);
                this.reasonerThread = new Thread(r);
                this.reasonerThread.start();
            } else {
                this.preferences.setUseReasoner(useReasoner);
                this.flushConfig();
                this.fireReload(new RefreshEvent(this));
            }
            this.fireReasonerStatusChange(new ReasonerStatusEvent(this, useReasoner));
        }
    }

    public boolean showCompleteRelationships() {
        return false;
    }

    public OBOSession showLoadDialog() {
        try {
            DataAdapterRegistry registry = this.getAdapterRegistry();
            GraphicalAdapterChooser gac = new GraphicalAdapterChooser(registry, IOOperation.READ, (Object)controller.getSession());
            gac.setButtonColor(Preferences.defaultButtonColor(), Color.black);
            gac.setBackground(Preferences.defaultBackgroundColor());
            gac.setHistoryPath(controller.getHistoryFilePath());
            gac.setFont(controller.getDefaultFont());
            boolean worked = gac.showDialog("Load ontology", null);
            if (worked) {
                OBOSession session = (OBOSession)gac.getResult();
                return session;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean showToolTips() {
        return this.preferences.getShowToolTips();
    }

    public void showURL(String url) {
        if (this.getBrowserCommand().length() > 0) {
            StringBuffer cmdBuffer = new StringBuffer(this.getBrowserCommand());
            int index = cmdBuffer.indexOf("$url$");
            if (index != -1) {
                cmdBuffer.replace(index, index + 5, url);
                try {
                    Runtime.getRuntime().exec(cmdBuffer.toString());
                }
                catch (Exception ex) {
                    System.err.println("couldn't browse " + url + "; there's probably a problem with the browser launch string");
                    ex.printStackTrace();
                }
            }
        } else {
            MiniBrowser miniBrowser = new MiniBrowser(null);
            miniBrowser.setMenuFont(controller.getDefaultFont());
            miniBrowser.load(url);
            miniBrowser.setSize(640, 480);
            miniBrowser.show();
        }
    }

    public void startAutosaveThread() {
        this.autosaveThread = new AutosaveThread(this);
        this.autosaveThread.start();
    }

    public String toString() {
        return "THE CONTROLLER";
    }

    public void undo() {
        if (!this.getPreferences().getAutoCommitTextEdits() || !this.textEditManager.editsArePending() || this.getPreferences().getAutoCommitTextEdits() && !this.textEditManager.editsArePending()) {
            if (!this.getTextEditManager().checkUncommittedEdits(false)) {
                return;
            }
            this.textEditManager.clear();
            HistoryItem item = this.history.getCurrentHistory().popItem();
            this.reverse(item);
            this.history.getRedoHistoryItems().add(item);
        }
        this.textEditManager.resync();
    }

    public static void updateInfoPlist() throws IOException {
        String mem = Preferences.getPreferences().getMemString();
        if (mem == null) {
            return;
        }
        File infoPlist = new File(Controller.getInstallationDirectory(), Controller.getLauncherName() + ".app/Contents/Info.plist");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("memoryOption", mem);
        try {
            XMLUtil.transform((String)PLIST_TRANSFORM, (File)infoPlist, params);
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
    }

    public static void updateInstallJLaunchers() throws IOException {
        File optionFile = new File(Controller.getInstallationDirectory(), Controller.getLauncherName() + ".vmoptions");
        PrintWriter stream = new PrintWriter(new FileWriter(optionFile));
        stream.println("-Xmx" + Preferences.getPreferences().getMemString());
        stream.close();
    }

    public static String getLauncherName() {
        return System.getProperty("launcherName", "oboedit");
    }

    public static void updateLauncherConfigurations() {
        if (Controller.isMacOS()) {
            try {
                Controller.updateInfoPlist();
            }
            catch (IOException ex) {
                System.err.println("Could not update launcher script");
            }
        } else {
            try {
                Controller.updateInstallJLaunchers();
            }
            catch (IOException ex) {
                System.err.println("Could not update InstallJ launcher scripts");
            }
        }
    }

    public boolean useBasicRootDetection() {
        return this.preferences.getUseBasicRootDetection();
    }

    public boolean useLeadAsClickDestination() {
        return false;
    }

    public boolean warnBeforeDefinitionLoss() {
        return this.preferences.getWarnBeforeDefinitionLoss();
    }

    public boolean warnBeforeDelete() {
        return this.preferences.getWarnBeforeDelete();
    }

    protected void writePreferences(Preferences preferences) throws IOException {
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(prefsXMLFile)));
        encoder.writeObject(preferences);
        encoder.close();
    }

    protected void writeVerificationSettings() throws IOException {
        File profileFile = new File(Controller.getPrefsDir(), "verify.xml");
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(profileFile)));
        encoder.writeObject(this.verificationEngine.getConfiguration());
        encoder.close();
    }

    static {
        isMacOS = System.getProperty("os.name").equals("Mac OS X");
        prefsDir = new File(System.getProperty("user.home") + "/.oboedit/");
        filterFile = new File(prefsDir, "filters/");
        prefsFile = new File(prefsDir, "config");
        prefsXMLFile = new File(prefsDir, "config.xml");
        stderrFile = new File(prefsDir, "stderr");
        suppressInstallations = false;
    }

    protected static class KitStruct
    implements Comparable {
        protected OBOEditorKit kit;
        protected int suitability;

        public KitStruct(int suitability, OBOEditorKit kit) {
            this.suitability = suitability;
            this.kit = kit;
        }

        public int compareTo(Object o) {
            if (o instanceof KitStruct) {
                KitStruct ks = (KitStruct)o;
                return this.suitability - ks.suitability;
            }
            return -1;
        }

        public OBOEditorKit getKit() {
            return this.kit;
        }

        public int getSuitability() {
            return this.suitability;
        }
    }

    protected class FilterConfigurationListener
    implements RootChangeListener {
        protected FilterConfigurationListener() {
        }

        public void changeRoot(RootChangeEvent e) {
            Controller.this.initFilter();
        }
    }
}

