/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.util.ObjectUtil;

public class SymmetricHistoryItem
extends HistoryItem {
    private static final long serialVersionUID = 6478990619822580131L;
    protected boolean oldSymmetric;

    public SymmetricHistoryItem() {
        this(null, false);
    }

    public SymmetricHistoryItem(OBOProperty target) {
        this(target.getID(), target.isSymmetric());
    }

    public SymmetricHistoryItem(String target, boolean oldSymmetric) {
        this.target = target;
        this.oldSymmetric = oldSymmetric;
    }

    public List getGraphEditList() {
        return Collections.singletonList(new HistoryItem.GraphOperation(1, this.target));
    }

    public boolean equals(Object o) {
        if (!(o instanceof SymmetricHistoryItem)) {
            return false;
        }
        SymmetricHistoryItem item = (SymmetricHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && this.oldSymmetric == item.getOldSymmetric();
    }

    public int hashCode() {
        return SymmetricHistoryItem.getHash(this.target) ^ SymmetricHistoryItem.getHash(this.oldSymmetric);
    }

    public void setOldSymmetric(boolean oldSymmetric) {
        this.oldSymmetric = oldSymmetric;
    }

    public boolean getOldSymmetric() {
        return this.oldSymmetric;
    }

    public String getShortName() {
        return "changed is symmetric";
    }

    public String toString() {
        return "changed \"is symmetric\" status of " + this.target + " to " + !this.oldSymmetric;
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

