/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.util.Collection;
import java.util.Iterator;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Relationship;
import org.geneontology.oboedit.datamodel.ValueLink;
import org.geneontology.oboedit.datamodel.impl.DefaultLinkDatabase;
import org.geneontology.oboedit.gui.Controller;

public interface RootAlgorithm {
    public static final RootAlgorithm STRICT = new AbstractRootAlgorithm(){

        public boolean isRoot(LinkedObject lo) {
            if (lo instanceof Instance) {
                return true;
            }
            boolean useBasic = Controller.getController().useBasicRootDetection();
            Iterator it = lo.getParents().iterator();
            while (it.hasNext()) {
                Relationship link = (Relationship)it.next();
                if (link instanceof Link && ((Link)link).getParent() instanceof DanglingObject || link instanceof ValueLink && !(((ValueLink)link).getValue() instanceof IdentifiedObject) || !useBasic && !link.getType().isTransitive()) continue;
                return false;
            }
            return GREEDY.isRoot(lo);
        }

        public String toString() {
            return "STRICT";
        }
    };
    public static final RootAlgorithm GREEDY = new AbstractRootAlgorithm(){

        public boolean isRoot(LinkedObject lo) {
            if (lo instanceof Instance) {
                return true;
            }
            boolean useBasic = Controller.getController() == null ? false : Controller.getController().useBasicRootDetection();
            Collection parents = this.linkDatabase.getParents(lo);
            Iterator it = parents.iterator();
            while (it.hasNext()) {
                Relationship link = (Relationship)it.next();
                if (link instanceof Link && ((Link)link).getParent() instanceof DanglingObject) continue;
                if (link instanceof ValueLink) {
                    if (((ValueLink)link).getValue() instanceof IdentifiedObject) continue;
                    continue;
                }
                if (!useBasic && !link.getType().isTransitive()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "GREEDY";
        }
    };

    public boolean isRoot(LinkedObject var1);

    public void setLinkDatabase(LinkDatabase var1);

    public static abstract class AbstractRootAlgorithm
    implements RootAlgorithm {
        protected LinkDatabase linkDatabase = DefaultLinkDatabase.getDefault();
        protected Iterator sourceSet;

        public void setLinkDatabase(LinkDatabase linkDatabase) {
            this.linkDatabase = linkDatabase;
        }

        public void setSources(Iterator sourceSet) {
            this.sourceSet = sourceSet;
        }
    }
}

