/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geneontology.oboedit.datamodel.Explanation;
import org.geneontology.oboedit.datamodel.ExplanationType;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.CompletenessExplanation;
import org.geneontology.oboedit.datamodel.impl.CompletenessMatch;
import org.geneontology.oboedit.datamodel.impl.LinkExplanation;

public class ExplanationUtil {
    private ExplanationUtil() {
    }

    public static String getDescriptionReasoned(ReasonedLinkDatabase reasoner, LinkDatabase activeLinkDatabase, Link link, boolean documentation) {
        return ExplanationUtil.getDescriptionReasoned(reasoner, activeLinkDatabase, link, null, new HashMap(), documentation);
    }

    public static boolean isGiven(ReasonedLinkDatabase reasoner, Link link) {
        Collection explanations = reasoner.getExplanations(link);
        boolean isGiven = false;
        Iterator it2 = explanations.iterator();
        while (it2.hasNext()) {
            Explanation e = (Explanation)it2.next();
            if (e.getExplanationType() != ExplanationType.GIVEN) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBeenTrimmed(ReasonedLinkDatabase reasoner, LinkDatabase activeLinkDatabase, Link link) {
        return !ExplanationUtil.isGiven(reasoner, link) && TermUtil.shouldBeTrimmed(activeLinkDatabase, link);
    }

    public static String getDescriptionReasoned(ReasonedLinkDatabase reasoner, LinkDatabase activeLinkDatabase, Link link, Collection subExplanations, Map cachedExplanations, boolean documentation) {
        StringBuffer out = new StringBuffer();
        Collection explanations = reasoner.getExplanations(link);
        out.append("<a name='" + link.getChild().getID().replace(':', '_') + "-" + link.getType().getID().replace(':', '_') + "-" + link.getParent().getID().replace(':', '_') + "'></a>");
        out.append("<b>Why is the link " + TermUtil.getHTMLLink(link, !ExplanationUtil.hasBeenTrimmed(reasoner, activeLinkDatabase, link)) + " in the ontology?</b><br>");
        if (documentation && explanations.size() > 1) {
            out.append("<b>Note:</b>There are several different explanations for why this link appears in the ontology. This is not necessarily a problem; in complex ontologies with  cross products, it's not unusual for there to be several ways of deriving a link. Further, just because a link has multiple explanations does not mean that it is redundant. By default the reasoner considers a link redundant if it can be inferred by the reasoner, but has been explicitly asserted in the ontology as well.<br>");
        }
        if (ExplanationUtil.hasBeenTrimmed(reasoner, activeLinkDatabase, link)) {
            out.append("<b>Note:</b> This link has been \"trimmed\" by the reasoner.");
            if (documentation) {
                out.append(" This means that this link is not normally visible, because the display would become jumbled and confusing if it were shown. Links are only trimmed if they reiterate information that is immediately obvious on visual inspection of the ontology (for example, most trimmed links are implied by transitivity). User-defined links are never trimmed. Please see the OBO-Edit wiki for information on the exact trimming algorithm used by OBO-Edit.<br>");
            }
        }
        if (explanations.size() > 1) {
            out.append("<ol>");
        }
        Iterator it2 = explanations.iterator();
        while (it2.hasNext()) {
            Explanation e = (Explanation)it2.next();
            if (explanations.size() > 1) {
                out.append("<li>");
            }
            if (e.getExplanationType() == ExplanationType.COMPLETENESS) {
                CompletenessMatch me;
                out.append("The reasoner created an <b>is_a</b> link between " + TermUtil.getHTMLLink(link.getChild(), true) + " and " + TermUtil.getHTMLLink(link.getParent(), true) + " because:");
                CompletenessExplanation ce = (CompletenessExplanation)e;
                out.append("<ul>");
                Iterator it3 = ce.getMatches().iterator();
                while (it3.hasNext()) {
                    me = (CompletenessMatch)it3.next();
                    out.append("<li>" + (TermUtil.isImplied(me.getMatchLink()) ? "<i>" : "") + TermUtil.getHTMLLink(me.getMatchLink(), !ExplanationUtil.hasBeenTrimmed(reasoner, activeLinkDatabase, me.getMatchLink())) + (TermUtil.isImplied(me.getMatchLink()) ? "</i>" : ""));
                    out.append(" ");
                    out.append(TermUtil.getHTMLLink(subExplanations.contains(me.getMatchLink()) ? "HIDE" : "EXPAND", subExplanations.contains(me.getMatchLink()) ? "<font size=-1><b>(hide explanation)</b></font>" : "<font size=-1><b>(show explanation)</b></font>", me.getMatchLink(), true));
                    if (subExplanations == null || link.equals(me.getMatchLink()) || !subExplanations.contains(me.getMatchLink()) || cachedExplanations.containsKey(me.getMatchLink())) continue;
                    out.append("<ul>");
                    out.append("<li>");
                    String expStr = (String)cachedExplanations.get(me.getMatchLink());
                    if (expStr == null) {
                        cachedExplanations.put(me.getMatchLink(), null);
                        expStr = ExplanationUtil.getDescriptionReasoned(reasoner, activeLinkDatabase, me.getMatchLink(), subExplanations, cachedExplanations, documentation);
                        cachedExplanations.put(me.getMatchLink(), expStr);
                    }
                    out.append(expStr);
                    out.append("</ul>");
                }
                out.append("</ul>");
                out.append(" and " + TermUtil.getHTMLLink(link.getParent(), true) + " has a cross-product definition that says any term with the following relationships:");
                out.append("<ul>");
                it3 = ce.getMatches().iterator();
                while (it3.hasNext()) {
                    me = (CompletenessMatch)it3.next();
                    out.append("<li><b>" + me.getCompletenessLink().getType().getID() + "</b> " + TermUtil.getHTMLLink(me.getCompletenessLink().getParent(), true));
                }
                out.append("</ul>");
                out.append("is an implied subclass of " + link.getParent());
                continue;
            }
            if (e.getExplanationType() == ExplanationType.TRANSITIVITY) {
                out.append("This reasoner created a <b>" + link.getType().getID() + "</b> link between " + TermUtil.getHTMLLink(link.getChild(), true) + " and " + TermUtil.getHTMLLink(link.getParent(), true) + " because of transitivity. This new link is the result of applying the rules of transitivity to the following links:");
                out.append("<ul>");
                Iterator it3 = ((LinkExplanation)e).getSupportingLinks().iterator();
                while (it3.hasNext()) {
                    Link ev = (Link)it3.next();
                    out.append("<li>" + (TermUtil.isImplied(ev) ? "<i>" : "") + TermUtil.getHTMLLink(ev, !ExplanationUtil.hasBeenTrimmed(reasoner, activeLinkDatabase, ev)) + (TermUtil.isImplied(ev) ? "</i>" : ""));
                    out.append(" ");
                    out.append(TermUtil.getHTMLLink(subExplanations.contains(ev) ? "HIDE" : "EXPAND", subExplanations.contains(ev) ? "<font size=-1><b>(hide explanation)</b></font>" : "<font size=-1><b>(show explanation)</b></font>", ev, true));
                    if (subExplanations == null || ev.equals(link) || !subExplanations.contains(ev) || cachedExplanations.containsKey(ev)) continue;
                    out.append("<ul>");
                    out.append("<li>");
                    String expStr = (String)cachedExplanations.get(ev);
                    if (expStr == null) {
                        cachedExplanations.put(ev, null);
                        expStr = ExplanationUtil.getDescriptionReasoned(reasoner, activeLinkDatabase, ev, subExplanations, cachedExplanations, documentation);
                        cachedExplanations.put(ev, expStr);
                    }
                    out.append(expStr);
                    out.append("</ul>");
                }
                out.append("</ul>");
                if (!documentation) continue;
                out.append("The definition of transitivity can be broken down into two major cases:");
                out.append("<ol>");
                out.append("<li>If <font color=blue>B -<b>p</b>-> C</font> and <font  color=blue>A -<b>is_a</b>-> B</font>, then <font  color=blue>A -<b>p</b>-> C</font>, whether or not relationship type <b>p</b> is transitive.");
                out.append("<li>If <b>p</b> is transitive and <font color=blue>A -<b>p</b>-> B</font> and <font color=blue>B -<b>p</b>-> C</font>, then <font color=blue>A -<b>p</b>-> C</font>.");
                out.append("</ol>");
                continue;
            }
            if (e.getExplanationType() == ExplanationType.GENUS) {
                out.append("This reasoner created an <b>is_a</b> link between " + TermUtil.getHTMLLink(link.getChild(), true) + " and " + TermUtil.getHTMLLink(link.getParent(), true) + " because the cross-product definition of " + TermUtil.getHTMLLink(link.getChild(), true) + " names " + TermUtil.getHTMLLink(link.getParent(), true) + " as its genus term.");
                if (!documentation) continue;
                out.append(" An <b>is_a</b> link is always implied between a term and its genus.");
                continue;
            }
            if (e.getExplanationType() == ExplanationType.DIFFERENTIA) {
                out.append("This reasoner created a <b>" + link.getType().getID() + "</b> link between " + TermUtil.getHTMLLink(link.getChild(), true) + " and " + TermUtil.getHTMLLink(link.getParent(), true) + " because the cross-product definition of " + TermUtil.getHTMLLink(link.getChild(), true) + " lists " + TermUtil.getHTMLLink(link.getParent(), true) + " as a differentia term with type <b>" + link.getType().getID() + "</b>.");
                if (!documentation) continue;
                out.append(" A link of the specified differentia type is always implied between a term and its differentia.");
                continue;
            }
            if (e.getExplanationType() != ExplanationType.GIVEN) continue;
            out.append("This link was explicitly added to the ontology by a human being.");
            if (!reasoner.isRedundant(link)) continue;
            if (documentation) {
                out.append("<font color=red><b>Note:</b> This link has been marked redundant by the reasoner, because the reasoner can infer the link automatically. Redundant links are not necessarily a problem, but they can make an ontology more difficult to maintain.</font>");
                continue;
            }
            out.append("<font color=red><b>Note:</b> This link has been marked redundant by the reasoner.</font>");
        }
        if (explanations.size() > 1) {
            out.append("</ol>");
        }
        return out.toString();
    }
}

