/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.geneontology.io.IOUtil;
import org.geneontology.io.ProgressableInputStream;
import org.geneontology.oboedit.dataadapter.OBOParseException;
import org.geneontology.oboedit.dataadapter.OBOParser;
import org.geneontology.oboedit.dataadapter.OBOSimpleParser;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.PropertyValue;
import org.geneontology.oboedit.datamodel.impl.NestedValueImpl;
import org.geneontology.oboedit.datamodel.impl.PropertyValueImpl;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OBOParseEngine {
    protected OBOSimpleParser parser;
    protected Vector paths = new Vector();
    protected Vector listeners = new Vector();
    protected Stack pathStack;
    protected String line;
    protected int linenum = 0;
    protected int totalSize = 0;
    protected int bytesRead = 0;
    protected boolean halt = false;
    protected StringBuffer tempBuffer = new StringBuffer();
    protected static final HashMap escapeChars = new HashMap();
    protected static final HashMap unescapeChars = new HashMap();

    public OBOParseEngine() {
    }

    public OBOParseEngine(OBOSimpleParser parser) {
        this();
        this.setParser(parser);
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireProgressEvent(ProgressEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProgressListener pl = (ProgressListener)this.listeners.get(i);
            pl.progressMade(e);
        }
    }

    public void cancel() {
        this.halt = true;
        this.parser.cancel();
    }

    protected static String convertPath(String path) {
        return IOUtil.getURL((String)path).toString();
    }

    public void setPath(String path) {
        this.paths = new Vector();
        this.paths.add(OBOParseEngine.convertPath(path));
    }

    public void setPaths(Collection paths) {
        this.paths = new Vector();
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            this.paths.add(OBOParseEngine.convertPath((String)it.next()));
        }
    }

    public void setParser(OBOSimpleParser parser) {
        this.parser = parser;
        parser.setParseEngine(this);
    }

    public static boolean isEscapeStarter(char c) {
        return c == '\\';
    }

    public static boolean isQuote(char c) {
        return c == '\"';
    }

    protected StringBuffer getTempBuffer() {
        this.tempBuffer.delete(0, this.tempBuffer.length());
        return this.tempBuffer;
    }

    protected String getCurrentPath() {
        return (String)this.pathStack.peek();
    }

    protected SOPair readQuotedString(String value, int startIndex, int stopIndex, char terminatingChar, boolean requireQuotes, boolean legalEndOfLine) throws OBOParseException {
        int i;
        char quoteChar = '\u0000';
        StringBuffer out = this.getTempBuffer();
        boolean useQuotes = false;
        for (i = startIndex; i < stopIndex; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            if (!OBOParseEngine.isQuote(value.charAt(i))) {
                if (requireQuotes) {
                    throw new OBOParseException("Expected start of quoted string.", this.line, value, this.linenum, 0);
                }
                useQuotes = false;
                break;
            }
            useQuotes = true;
            quoteChar = value.charAt(i);
            ++i;
            break;
        }
        while (i < stopIndex) {
            if (OBOParseEngine.isEscapeStarter(value.charAt(i))) {
                if (++i >= value.length()) {
                    throw new OBOParseException("Incomplete escape sequence.", this.getCurrentPath(), this.line, this.linenum, 0);
                }
                out.append(value.charAt(i));
            } else {
                if (useQuotes && value.charAt(i) == quoteChar || !useQuotes && value.charAt(i) == terminatingChar) {
                    if (!useQuotes) {
                        return new SOPair(out.toString().trim(), startIndex, i - 1);
                    }
                    return new SOPair(out.toString(), startIndex, i);
                }
                out.append(value.charAt(i));
            }
            ++i;
        }
        if (!useQuotes && legalEndOfLine) {
            return new SOPair(out.toString().trim(), startIndex, i);
        }
        throw new OBOParseException("Unterminated quoted string.", this.getCurrentPath(), this.line, this.linenum, 0);
    }

    protected int getNestedValue(NestedValue nv, String str, int startIndex) throws OBOParseException {
        block0: while (startIndex < str.length()) {
            int equalsIndex = OBOParseEngine.findUnescaped(str, '=', startIndex, str.length());
            if (equalsIndex == -1) {
                throw new OBOParseException("Expected = in trailing modifier", this.getCurrentPath(), this.line, this.linenum, 0);
            }
            String name = str.substring(startIndex, equalsIndex).trim();
            SOPair value = this.readQuotedString(str, equalsIndex + 1, str.length(), ',', false, true);
            PropertyValueImpl pv = new PropertyValueImpl(this.unescape(name), value.str);
            nv.addPropertyValue(pv);
            for (startIndex = value.endIndex + 1; startIndex < str.length(); ++startIndex) {
                if (Character.isWhitespace(str.charAt(startIndex))) continue;
                if (str.charAt(startIndex) == ',') {
                    ++startIndex;
                    continue block0;
                }
                System.err.println("found character |" + str.charAt(startIndex) + "|");
                throw new OBOParseException("Expected comma in trailingmodifier.", this.getCurrentPath(), this.line, this.linenum, 0);
            }
        }
        return str.length();
    }

    public static String stripSpecialCharacters(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(s.charAt(i));
            if (unicodeBlock == null) {
                System.err.println("got null unicode block in " + s);
            }
            if (unicodeBlock == null || !unicodeBlock.equals(Character.UnicodeBlock.BASIC_LATIN)) continue;
            out.append(s.charAt(i));
        }
        return out.toString();
    }

    protected boolean detectXML(String path) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream((InputStream)IOUtil.getProgressableStream((String)path))));
        String line = reader.readLine();
        reader.close();
        return Pattern.matches("\\Q<?xml\\E\\s.*\\Q?>\\E", line);
    }

    protected BufferedReader transformAndReadXML(InputStream stream) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            File stylesheet = new File("/home/jrichter/research/oboxml_to_obotext.xsl");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(stream);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outstream);
            transformer.transform(source, result);
            outstream.close();
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outstream.toByteArray())));
        }
        catch (TransformerConfigurationException tce) {
            return null;
        }
        catch (TransformerException te) {
            return null;
        }
        catch (SAXException sxe) {
            return null;
        }
        catch (ParserConfigurationException pce) {
            return null;
        }
    }

    public void doParse(String path) throws IOException, OBOParseException {
        this.pathStack.push(path);
        this.parser.startFileParse(path);
        String currentStanza = null;
        BufferedReader reader = null;
        if (this.detectXML(path)) {
            ProgressableInputStream stream = IOUtil.getProgressableStream((String)path);
            stream.addProgressListener(new ProgressListener(){

                public void progressMade(ProgressEvent e) {
                    OBOParseEngine.this.fireProgressEvent(e);
                }
            });
            BufferedInputStream is = new BufferedInputStream((InputStream)stream);
            reader = this.transformAndReadXML(is);
        }
        if (reader == null) {
            BufferedInputStream is = new BufferedInputStream((InputStream)IOUtil.getProgressableStream((String)path));
            reader = new BufferedReader(new InputStreamReader(is));
        }
        URL url = IOUtil.getURL((String)path);
        this.totalSize += url.openConnection().getContentLength();
        int oldPercent = 0;
        this.linenum = 1;
        while ((this.line = reader.readLine()) != null) {
            if (this.halt) {
                throw new OBOParseException("Operation cancelled by user", this.getCurrentPath(), null, -1);
            }
            this.bytesRead += this.line.length();
            if (this.line.length() != 0) {
                while (this.line.charAt(this.line.length() - 1) == '\\' && this.line.charAt(this.line.length() - 2) != '\\') {
                    String str = reader.readLine();
                    ++this.linenum;
                    if (str == null) {
                        throw new OBOParseException("Unexpected end of file", this.getCurrentPath(), this.line, this.linenum);
                    }
                    this.line = this.line.substring(0, this.line.length() - 1) + str;
                }
                if (this.line.charAt(0) == '!') {
                    this.parser.readBangComment(this.line.substring(1));
                } else if (this.line.charAt(0) == '[') {
                    if (this.line.charAt(this.line.length() - 1) != ']') {
                        throw new OBOParseException("Unclosed stanza \"" + this.line + "\"", this.getCurrentPath(), this.line, this.linenum);
                    }
                    String stanzaname = this.line.substring(1, this.line.length() - 1);
                    if (stanzaname.length() < 1) {
                        throw new OBOParseException("Empty stanza", this.getCurrentPath(), this.line, this.linenum);
                    }
                    currentStanza = stanzaname;
                    this.parser.startStanza(stanzaname);
                } else {
                    int valueStopIndex;
                    int i;
                    SOPair pair;
                    try {
                        pair = this.unescape(this.line, ':', 0, true);
                    }
                    catch (OBOParseException ex) {
                        OBOParseEngine.translateAndThrow(ex, this.line, this.linenum, 0);
                        break;
                    }
                    String name = pair.str;
                    int lineEnd = OBOParseEngine.findUnescaped(this.line, '!', 0, this.line.length(), true);
                    if (lineEnd == -1) {
                        lineEnd = this.line.length();
                    }
                    NestedValueImpl nv = null;
                    int trailingStartIndex = -1;
                    int trailingEndIndex = -1;
                    for (i = lineEnd - 1; i >= 0; --i) {
                        if (Character.isWhitespace(this.line.charAt(i))) continue;
                        if (this.line.charAt(i) != '}') break;
                        if (i >= 1 && this.line.charAt(i - 1) == '\\') continue;
                        trailingEndIndex = i;
                        break;
                    }
                    if (trailingEndIndex != -1) {
                        for (i = trailingEndIndex - 1; i >= 0; --i) {
                            if (this.line.charAt(i) != '{' || i >= 1 && this.line.charAt(i - 1) == '\\') continue;
                            trailingStartIndex = i + 1;
                        }
                    }
                    if (trailingStartIndex == -1 && trailingEndIndex != -1) {
                        throw new OBOParseException("Unterminated trailing modifier.", this.getCurrentPath(), this.line, this.linenum, 0);
                    }
                    if (trailingStartIndex != -1) {
                        valueStopIndex = trailingStartIndex - 1;
                        String trailing = this.line.substring(trailingStartIndex, trailingEndIndex).trim();
                        nv = new NestedValueImpl();
                        this.getNestedValue(nv, trailing, 0);
                    } else {
                        valueStopIndex = lineEnd;
                    }
                    String value = this.line.substring(pair.index + 1, valueStopIndex);
                    if (value.length() == 0) {
                        throw new OBOParseException("Tag found with no value", this.getCurrentPath(), this.line, this.linenum);
                    }
                    if (this.parser instanceof OBOParser) {
                        try {
                            this.parseTag(currentStanza, this.line, this.linenum, pair.index + 1, name, value, nv);
                        }
                        catch (OBOParseException ex) {
                            ex.printStackTrace();
                            OBOParseEngine.translateAndThrow(ex, this.line, this.linenum, pair.index + 1);
                        }
                    } else {
                        try {
                            this.parser.readTagValue(name, value);
                        }
                        catch (OBOParseException ex) {
                            OBOParseEngine.translateAndThrow(ex, this.line, this.linenum, pair.index + 1);
                        }
                    }
                }
                int percentVal = 100 * this.bytesRead / this.totalSize;
                if (percentVal != oldPercent) {
                    this.fireProgressEvent(new ProgressEvent((Object)this, new Double(percentVal), "Reading " + path));
                    oldPercent = percentVal;
                }
            }
            ++this.linenum;
        }
        this.parser.endFileParse(path);
        this.pathStack.pop();
    }

    public void parse() throws IOException, OBOParseException {
        this.halt = false;
        if (this.parser == null) {
            throw new IOException("Could not parse; no parser installed!");
        }
        this.pathStack = new Stack();
        this.parser.startParse();
        for (int i = 0; i < this.paths.size(); ++i) {
            this.doParse((String)this.paths.get(i));
        }
        this.parser.endParse();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseTag(String stanza, String line, int linenum, int charoffset, String name, String value, NestedValue nv) throws OBOParseException, IOException {
        value = value.trim();
        if (!(stanza == null || stanza.equalsIgnoreCase("term") || stanza.equalsIgnoreCase("typedef") || stanza.equalsIgnoreCase("instance"))) {
            this.parser.readTagValue(name, value);
            return;
        }
        if (name.equals("import")) {
            if (stanza != null) {
                throw new OBOParseException("import tags may only occur in the header", this.getCurrentPath(), line, linenum, 0);
            }
            System.err.println("reading import with value " + value);
            int myLineNum = this.linenum;
            ((OBOParser)this.parser).readImport(value);
            this.linenum = myLineNum;
            return;
        }
        if (name.equals("namespace-id-rule")) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            if (tokens.size() != 2) {
                throw new OBOParseException("Wrong number of arguments to id-mapping tag.", this.getCurrentPath(), line, linenum, 0);
            }
            String ns = (String)tokens.get(0);
            ((OBOParser)this.parser).readNamespaceIDRule(ns.equals("*") ? null : ns, (String)tokens.get(1));
            return;
        }
        if (name.equals("default-namespace")) {
            ((OBOParser)this.parser).readDefaultNamespace(value);
            return;
        }
        if (name.equals("default-relationship-id-prefix")) {
            value = value.trim();
            for (int i = 0; i < value.length(); ++i) {
                if (!Character.isWhitespace(value.charAt(i))) continue;
                throw new OBOParseException("No whitespace is allowed in an id prefix", this.getCurrentPath(), line, linenum, 0);
            }
            ((OBOParser)this.parser).readIDPrefix(value);
            return;
        }
        if (name.equals("id-mapping")) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            Vector<String> tokens = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            if (tokens.size() != 2) {
                throw new OBOParseException("Wrong number of arguments to id-mapping tag.", this.getCurrentPath(), line, linenum, 0);
            }
            ((OBOParser)this.parser).readIDMapping((String)tokens.get(0), (String)tokens.get(1));
            return;
        }
        if (name.equals("format-version")) {
            ((OBOParser)this.parser).readFormatVersion(value);
            return;
        }
        if (name.equals("version") || name.equals("data-version")) {
            ((OBOParser)this.parser).readFileVersion(value);
            return;
        }
        if (name.equals("date")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd:MM:yyyy HH:mm");
            try {
                ((OBOParser)this.parser).readDate(dateFormat.parse(value));
                return;
            }
            catch (ParseException ex) {
                throw new OBOParseException("Badly formatted date: " + value, this.getCurrentPath(), line, linenum, 0);
            }
        }
        if (name.equals("saved-by")) {
            ((OBOParser)this.parser).readSavedBy(value);
            return;
        }
        if (name.equals("auto-generated-by")) {
            ((OBOParser)this.parser).readAutogeneratedBy(value);
            return;
        }
        if (name.equals("remark")) {
            ((OBOParser)this.parser).readRemark(value);
            return;
        }
        if (name.equals("subsetdef")) {
            int subIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            int endDescIndex = OBOParseEngine.findUnescaped(value, '\"', subIndex + 1, value.length());
            String subset = value.substring(0, subIndex).trim();
            String subsetDesc = value.substring(subIndex + 1, endDescIndex).trim();
            ((OBOParser)this.parser).readSubsetDef(subset, subsetDesc);
            return;
        }
        if (name.equals("synonymtypedef")) {
            int subIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            int endDescIndex = OBOParseEngine.findUnescaped(value, '\"', subIndex + 1, value.length());
            String id = value.substring(0, subIndex).trim();
            String desc = value.substring(subIndex + 1, endDescIndex).trim();
            String trailing = value.substring(endDescIndex + 1, value.length()).trim();
            int scope = -1;
            if (trailing.equals("EXACT")) {
                scope = 1;
            } else if (trailing.equals("BROAD")) {
                scope = 3;
            } else if (trailing.equals("NARROW")) {
                scope = 2;
            } else if (trailing.equals("RELATED")) {
                scope = 0;
            }
            ((OBOParser)this.parser).readSynonymCategory(id, desc, scope);
            return;
        }
        if (name.equals("id")) {
            ((OBOParser)this.parser).readID(value, nv);
            return;
        }
        if (name.equals("name")) {
            ((OBOParser)this.parser).readName(this.unescape(value), nv);
            return;
        }
        if (name.equals("alt_id")) {
            ((OBOParser)this.parser).readAltID(value, nv);
            return;
        }
        if (name.equals("comment")) {
            ((OBOParser)this.parser).readComment(this.unescape(value), nv);
            return;
        }
        if (name.equals("namespace")) {
            ((OBOParser)this.parser).readNamespace(value, nv);
            return;
        }
        if (name.equals("domain")) {
            ((OBOParser)this.parser).readDomain(value, nv);
            return;
        }
        if (name.equals("range")) {
            ((OBOParser)this.parser).readRange(value, nv);
            return;
        }
        if (name.equals("def")) {
            int startIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            if (startIndex == -1) {
                throw new OBOParseException("Expected \"", this.getCurrentPath(), line, linenum, 0);
            }
            SOPair p = this.unescape(value, '\"', startIndex + 1, value.length(), true);
            int defIndex = OBOParseEngine.findUnescaped(value, '[', p.index, value.length());
            if (defIndex == -1) {
                throw new OBOParseException("Badly formatted definition. No dbxref list found.", this.getCurrentPath(), line, linenum, 0);
            }
            OBOParser.XrefPair[] refs = this.getDbxrefList(value, linenum, defIndex + 1, value.length());
            ((OBOParser)this.parser).readDef(p.str, refs, nv);
            return;
        }
        if (name.equals("xref_analog")) {
            OBOParser.XrefPair pair = this.parseXref(value, linenum, 0, value.length());
            pair.setNestedValue(nv);
            ((OBOParser)this.parser).readXrefAnalog(pair);
            return;
        }
        if (name.equals("xref_unk")) {
            OBOParser.XrefPair pair = this.parseXref(value, linenum, 0, value.length());
            pair.setNestedValue(nv);
            ((OBOParser)this.parser).readXrefUnk(pair);
            return;
        }
        if (name.equals("xref")) {
            OBOParser.XrefPair pair = this.parseXref(value, linenum, 0, value.length());
            pair.setNestedValue(nv);
            ((OBOParser)this.parser).readXrefUnk(pair);
            return;
        }
        if (name.equals("subset")) {
            ((OBOParser)this.parser).readSubset(value, nv);
            return;
        }
        if (name.equals("instance_of")) {
            ((OBOParser)this.parser).readInstanceOf(value, nv);
            return;
        }
        if (name.equals("property_value")) {
            try {
                int quoteIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
                if (quoteIndex == -1) {
                    StringTokenizer tokenizer = new StringTokenizer(value);
                    Vector<String> tokens = new Vector<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokens.add(tokenizer.nextToken());
                    }
                    if (tokens.size() != 2) {
                        throw new OBOParseException("Wrong number of arguments to property_value tag.", this.getCurrentPath(), line, linenum, 0);
                    }
                    ((OBOParser)this.parser).readPropertyValue((String)tokens.get(0), (String)tokens.get(1), null, false, nv);
                    return;
                }
                SOPair p = this.unescape(value, '\"', quoteIndex + 1, value.length(), true);
                String propID = value.substring(0, quoteIndex).trim();
                String optional = value.substring(p.index + 1, value.length()).trim();
                if (optional.length() == 0) {
                    optional = null;
                }
                ((OBOParser)this.parser).readPropertyValue(propID, p.str, optional, true, nv);
                return;
            }
            catch (OBOParseException ex) {
                ((OBOParser)this.parser).readTagValue(name, value);
            }
            return;
        }
        if (name.equals("synonym")) {
            int startIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            if (startIndex == -1) {
                throw new OBOParseException("Expected \"", this.getCurrentPath(), line, linenum, 0);
            }
            SOPair p = this.unescape(value, '\"', startIndex + 1, value.length(), true);
            int defIndex = OBOParseEngine.findUnescaped(value, '[', p.index, value.length());
            if (defIndex == -1) {
                throw new OBOParseException("Badly formatted synonym. No dbxref list found.", this.getCurrentPath(), line, linenum, 0);
            }
            String leftovers = value.substring(p.index + 1, defIndex).trim();
            StringTokenizer tokenizer = new StringTokenizer(leftovers, " \t");
            int scope = 0;
            String catID = null;
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (i == 0) {
                    if (token.equals("RELATED")) {
                        scope = 0;
                    } else if (token.equals("UNSPECIFIED")) {
                        scope = 0;
                    } else if (token.equals("EXACT")) {
                        scope = 1;
                    } else if (token.equals("BROAD")) {
                        scope = 3;
                    } else {
                        if (!token.equals("NARROW")) throw new OBOParseException("Found unexpected scope identifier " + token, this.getCurrentPath(), line, linenum, 0);
                        scope = 2;
                    }
                } else {
                    if (i != true) throw new OBOParseException("Expected dbxref list, instead found " + token, this.getCurrentPath(), line, linenum, 0);
                    catID = token;
                }
                ++i;
            }
            OBOParser.XrefPair[] refs = this.getDbxrefList(value, linenum, defIndex + 1, value.length());
            ((OBOParser)this.parser).readSynonym(p.str, refs, scope, catID, nv);
            return;
        } else if (name.equals("related_synonym")) {
            int startIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            if (startIndex == -1) {
                throw new OBOParseException("Expected \"", this.getCurrentPath(), line, linenum, 0);
            }
            SOPair p = this.unescape(value, '\"', startIndex + 1, value.length(), true);
            int defIndex = OBOParseEngine.findUnescaped(value, '[', p.index, value.length());
            if (defIndex == -1) {
                throw new OBOParseException("Badly formatted definition. No dbxref list found.", this.getCurrentPath(), line, linenum, 0);
            }
            OBOParser.XrefPair[] refs = this.getDbxrefList(value, linenum, defIndex + 1, value.length());
            ((OBOParser)this.parser).readSynonym(p.str, refs, 0, null, nv);
            return;
        } else if (name.equals("exact_synonym")) {
            int startIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            if (startIndex == -1) {
                throw new OBOParseException("Expected \"", this.getCurrentPath(), line, linenum, 0);
            }
            SOPair p = this.unescape(value, '\"', startIndex + 1, value.length(), true);
            int defIndex = OBOParseEngine.findUnescaped(value, '[', p.index, value.length());
            if (defIndex == -1) {
                throw new OBOParseException("Badly formatted definition. No dbxref list found.", this.getCurrentPath(), line, linenum, 0);
            }
            OBOParser.XrefPair[] refs = this.getDbxrefList(value, linenum, defIndex + 1, value.length());
            ((OBOParser)this.parser).readSynonym(p.str, refs, 1, null, nv);
            return;
        } else if (name.equals("narrow_synonym")) {
            int startIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            if (startIndex == -1) {
                throw new OBOParseException("Expected \"", this.getCurrentPath(), line, linenum, 0);
            }
            SOPair p = this.unescape(value, '\"', startIndex + 1, value.length(), true);
            int defIndex = OBOParseEngine.findUnescaped(value, '[', p.index, value.length());
            if (defIndex == -1) {
                throw new OBOParseException("Badly formatted definition. No dbxref list found.", this.getCurrentPath(), line, linenum, 0);
            }
            OBOParser.XrefPair[] refs = this.getDbxrefList(value, linenum, defIndex + 1, value.length());
            ((OBOParser)this.parser).readSynonym(p.str, refs, 2, null, nv);
            return;
        } else if (name.equals("broad_synonym")) {
            int startIndex = OBOParseEngine.findUnescaped(value, '\"', 0, value.length());
            if (startIndex == -1) {
                throw new OBOParseException("Expected \"", this.getCurrentPath(), line, linenum, 0);
            }
            SOPair p = this.unescape(value, '\"', startIndex + 1, value.length(), true);
            int defIndex = OBOParseEngine.findUnescaped(value, '[', p.index, value.length());
            if (defIndex == -1) {
                throw new OBOParseException("Badly formatted definition. No dbxref list found.", this.getCurrentPath(), line, linenum, 0);
            }
            OBOParser.XrefPair[] refs = this.getDbxrefList(value, linenum, defIndex + 1, value.length());
            ((OBOParser)this.parser).readSynonym(p.str, refs, 3, null, nv);
            return;
        } else if (name.equals("relationship")) {
            RelStruct relStruct = this.parseRelationship(value, nv, null);
            this.doReadRelationship(relStruct, (OBOParser)this.parser);
            return;
        } else if (name.equals("intersection_of")) {
            RelStruct relStruct = this.parseRelationship(value, nv, null, true);
            relStruct.setCompletes(true);
            if (relStruct.getType() == null) {
                relStruct.setType("is_a");
            }
            this.doReadRelationship(relStruct, (OBOParser)this.parser);
            return;
        } else if (name.equals("is_a")) {
            RelStruct relStruct = this.parseRelationship(value, nv, "is_a");
            this.doReadRelationship(relStruct, (OBOParser)this.parser);
            return;
        } else if (name.equals("disjoint_from")) {
            RelStruct relStruct = this.parseRelationship(value, nv, "disjoint_from");
            this.doReadRelationship(relStruct, (OBOParser)this.parser);
            return;
        } else if (name.equals("inverse_of")) {
            RelStruct relStruct = this.parseRelationship(value, nv, "inverse_of");
            this.doReadRelationship(relStruct, (OBOParser)this.parser);
            return;
        } else if (name.equals("is_obsolete")) {
            if (!value.trim().equalsIgnoreCase("true")) return;
            ((OBOParser)this.parser).readIsObsolete(nv);
            return;
        } else if (name.equals("is_anonymous")) {
            if (!value.trim().equalsIgnoreCase("true")) return;
            ((OBOParser)this.parser).readIsAnonymous(nv);
            return;
        } else if (name.equals("is_cyclic")) {
            if (value.trim().equalsIgnoreCase("true")) {
                ((OBOParser)this.parser).readIsCyclic(true, nv);
                return;
            } else {
                if (!value.trim().equalsIgnoreCase("false")) throw new OBOParseException("Invalid value for is_cyclic", this.getCurrentPath(), line, linenum, 0);
                ((OBOParser)this.parser).readIsCyclic(false, nv);
            }
            return;
        } else if (name.equals("is_symmetric")) {
            if (value.trim().equalsIgnoreCase("true")) {
                ((OBOParser)this.parser).readIsSymmetric(true, nv);
                return;
            } else {
                if (!value.trim().equalsIgnoreCase("false")) throw new OBOParseException("Invalid value for is_symmetric", this.getCurrentPath(), line, linenum, 0);
                ((OBOParser)this.parser).readIsSymmetric(false, nv);
            }
            return;
        } else if (name.equals("is_transitive")) {
            if (value.trim().equalsIgnoreCase("true")) {
                ((OBOParser)this.parser).readIsTransitive(true, nv);
                return;
            } else {
                if (!value.trim().equalsIgnoreCase("false")) throw new OBOParseException("Invalid value for is_transitive", this.getCurrentPath(), line, linenum, 0);
                ((OBOParser)this.parser).readIsTransitive(false, nv);
            }
            return;
        } else if (name.equals("consider")) {
            ((OBOParser)this.parser).readConsider(value.trim(), nv);
            return;
        } else if (name.equals("replaced_by")) {
            ((OBOParser)this.parser).readReplacedBy(value.trim(), nv);
            return;
        } else {
            this.parser.readTagValue(name, value);
        }
    }

    protected void doReadRelationship(RelStruct relStruct, OBOParser parser) throws OBOParseException {
        if (relStruct.getType().equals("is_a")) {
            parser.readIsa(relStruct.getID(), relStruct.getNS(), relStruct.completes(), relStruct.isImplied(), relStruct.getNV());
        } else if (relStruct.getType().equals("disjoint_from")) {
            parser.readDisjoint(relStruct.getID(), relStruct.getNS(), relStruct.isImplied(), relStruct.getNV());
        } else if (relStruct.getType().equals("inverse_of")) {
            parser.readInverseOf(relStruct.getID(), relStruct.getNS(), relStruct.isImplied(), relStruct.getNV());
        } else {
            parser.readRelationship(relStruct.getType(), relStruct.getID(), relStruct.getNec(), relStruct.getInvNec(), relStruct.completes(), relStruct.isImplied(), relStruct.getMinCard(), relStruct.getMaxCard(), relStruct.getCard(), relStruct.getNS(), relStruct.getNV());
        }
    }

    protected RelStruct parseRelationship(String value, NestedValue nv, String type) throws OBOParseException {
        return this.parseRelationship(value, nv, type, false);
    }

    protected RelStruct parseRelationship(String value, NestedValue nv, String type, boolean intersection) throws OBOParseException {
        int endoffset;
        String id;
        value = value.trim();
        int typeIndex = 0;
        if (type == null) {
            typeIndex = OBOParseEngine.findUnescaped(value, ' ', 0, value.length()) + 1;
            type = value.substring(0, typeIndex).trim();
            if (!(typeIndex != -1 && type.length() != 0 || intersection)) {
                throw new OBOParseException("No id specified for relationship.", this.getCurrentPath(), this.line, this.linenum, 0);
            }
        }
        if ((id = (endoffset = OBOParseEngine.findUnescaped(value, '[', typeIndex + type.length(), value.length())) == -1 ? value.substring(typeIndex, value.length()).trim() : value.substring(typeIndex, endoffset).trim()).length() == 0) {
            throw new OBOParseException("Empty id specified for relationship.", this.getCurrentPath(), this.line, this.linenum, 0);
        }
        boolean necessary = true;
        boolean inverseNecessary = false;
        boolean completes = false;
        boolean implied = false;
        Integer minCardinality = null;
        Integer maxCardinality = null;
        Integer cardinality = null;
        String ns = null;
        if (nv != null) {
            Vector<PropertyValue> dumpEm = new Vector<PropertyValue>();
            Iterator it = nv.getPropertyValues().iterator();
            while (it.hasNext()) {
                PropertyValue pv = (PropertyValue)it.next();
                if (pv.getProperty().equalsIgnoreCase("necessary")) {
                    necessary = !pv.getValue().equalsIgnoreCase("false");
                    dumpEm.add(pv);
                    continue;
                }
                if (pv.getProperty().equalsIgnoreCase("namespace")) {
                    ns = pv.getValue();
                    dumpEm.add(pv);
                    continue;
                }
                if (pv.getProperty().equalsIgnoreCase("inverse_necessary")) {
                    inverseNecessary = pv.getValue().equalsIgnoreCase("true");
                    dumpEm.add(pv);
                    continue;
                }
                if (pv.getProperty().equalsIgnoreCase("contingent") || pv.getProperty().equalsIgnoreCase("novel_inferred") || pv.getProperty().equalsIgnoreCase("autoparent") || pv.getProperty().equalsIgnoreCase("implied")) {
                    implied = pv.getValue().equalsIgnoreCase("true");
                    System.err.println("read implied = " + implied + ", value = " + pv.getValue());
                    dumpEm.add(pv);
                    continue;
                }
                if (pv.getProperty().equalsIgnoreCase("completes")) {
                    completes = pv.getValue().equalsIgnoreCase("true");
                    dumpEm.add(pv);
                    continue;
                }
                if (pv.getProperty().equalsIgnoreCase("minCardinality")) {
                    try {
                        minCardinality = new Integer(pv.getValue().trim());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    dumpEm.add(pv);
                    continue;
                }
                if (pv.getProperty().equalsIgnoreCase("maxCardinality")) {
                    try {
                        maxCardinality = new Integer(pv.getValue().trim());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    dumpEm.add(pv);
                    continue;
                }
                if (!pv.getProperty().equalsIgnoreCase("cardinality")) continue;
                try {
                    cardinality = new Integer(pv.getValue().trim());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                dumpEm.add(pv);
            }
            nv.getPropertyValues().removeAll(dumpEm);
        }
        if (type.length() == 0) {
            type = null;
        }
        return new RelStruct(type, id, necessary, inverseNecessary, completes, implied, minCardinality, maxCardinality, cardinality, ns, nv);
    }

    protected OBOParser.XrefPair[] getDbxrefList(String line, int linenum, int startoffset, int endoffset) throws OBOParseException {
        Vector<OBOParser.XrefPair> temp = new Vector<OBOParser.XrefPair>();
        boolean stop = false;
        while (!stop) {
            OBOParser.XrefPair pair;
            int braceIndex = OBOParseEngine.findUnescaped(line, '{', startoffset, endoffset);
            int endIndex = OBOParseEngine.findUnescaped(line, ',', startoffset, endoffset, true);
            boolean trailing = false;
            if (endIndex == -1) {
                endIndex = OBOParseEngine.findUnescaped(line, ']', startoffset, endoffset, true);
                if (endIndex == -1) {
                    throw new OBOParseException("Unterminated xref list", this.getCurrentPath(), line, linenum, startoffset);
                }
                stop = true;
            }
            if (braceIndex != -1 && braceIndex < endIndex) {
                endIndex = braceIndex;
                trailing = true;
            }
            if ((pair = this.parseXref(line, linenum, startoffset, endIndex)) == null) {
                ++startoffset;
                continue;
            }
            NestedValueImpl nv = null;
            if (trailing) {
                nv = new NestedValueImpl();
                if ((endIndex = this.getNestedValue(nv, line, endIndex + 1)) == -1) {
                    throw new OBOParseException("Badly formatted trailing properties", this.getCurrentPath(), line, linenum, startoffset);
                }
                pair.nv = nv;
            }
            temp.add(pair);
            startoffset = endIndex + 1;
        }
        OBOParser.XrefPair[] out = new OBOParser.XrefPair[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            OBOParser.XrefPair pair;
            out[i] = pair = (OBOParser.XrefPair)temp.get(i);
        }
        return out;
    }

    protected OBOParser.XrefPair parseXref(String line, int linenum, int startoffset, int endoffset) throws OBOParseException {
        String xref_str = null;
        String desc_str = null;
        SOPair xref = this.unescape(line, '\"', startoffset, endoffset, false);
        xref_str = xref.str.trim();
        if (xref_str.length() == 0) {
            return null;
        }
        if (xref.index != -1) {
            SOPair desc = this.unescape(line, '\"', xref.index + 1, endoffset, true);
            desc_str = desc.str.trim();
        }
        return new OBOParser.XrefPair(xref_str, desc_str);
    }

    public static String escape(String str, boolean escapespaces) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            Object o = unescapeChars.get(new Character(c));
            if (o == null) {
                out.append(c);
                continue;
            }
            if (escapespaces || !escapespaces && c != ' ' && c != '\t') {
                out.append("\\" + o);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public String unescape(String str) throws OBOParseException {
        return this.unescape((String)str, (char)'\u0000', (int)0, (int)str.length(), (boolean)false).str;
    }

    public SOPair unescape(String str, char toChar, int startindex, boolean mustFindChar) throws OBOParseException {
        return this.unescape(str, toChar, startindex, str.length(), mustFindChar);
    }

    public SOPair unescape(String str, char toChar, int startindex, int endindex, boolean mustFindChar) throws OBOParseException {
        StringBuffer out = new StringBuffer();
        int endValue = -1;
        for (int i = startindex; i < endindex; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                Character mapchar;
                if ((mapchar = (Character)escapeChars.get(new Character(c = str.charAt(++i)))) == null) {
                    throw new OBOParseException("Unrecognized escape character " + c + " found.", this.getCurrentPath(), null, -1, i);
                }
                out.append(mapchar);
                continue;
            }
            if (c == toChar) {
                endValue = i;
                break;
            }
            out.append(c);
        }
        if (endValue == -1 && mustFindChar) {
            throw new OBOParseException("Expected " + toChar + ".", this.getCurrentPath(), str, -1);
        }
        return new SOPair(out.toString(), endValue);
    }

    public static int findUnescaped(String str, char toChar) {
        return OBOParseEngine.findUnescaped(str, toChar, 0, str.length());
    }

    public static int findUnescaped(String str, char toChar, int startIndex, int endIndex) {
        return OBOParseEngine.findUnescaped(str, toChar, startIndex, endIndex, false);
    }

    public static int findUnescaped(String str, char toChar, int startindex, int endindex, boolean honorQuotes) {
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = startindex; i < endindex; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (inQuotes) {
                if (c != quoteChar) continue;
                inQuotes = false;
                continue;
            }
            if (c == toChar) {
                return i;
            }
            if (!honorQuotes || !OBOParseEngine.isQuote(c)) continue;
            inQuotes = true;
            quoteChar = c;
        }
        return -1;
    }

    public static void translateAndThrow(OBOParseException ex, String wholeline, int linenum, int charoffset) throws OBOParseException {
        throw OBOParseEngine.translateException(ex, wholeline, linenum, charoffset);
    }

    public static OBOParseException translateException(OBOParseException ex, String wholeline, int linenum, int charoffset) {
        int charnum = ex.getCharNum();
        if (charnum == -1) {
            charnum = 0;
        }
        return new OBOParseException(ex.getMessage(), ex.getPath(), wholeline, linenum, charnum + charoffset);
    }

    public int getLineNum() {
        return this.linenum;
    }

    public String getCurrentLine() {
        return this.line;
    }

    static {
        escapeChars.put(new Character(':'), new Character(':'));
        escapeChars.put(new Character('W'), new Character(' '));
        escapeChars.put(new Character('t'), new Character('\t'));
        escapeChars.put(new Character(','), new Character(','));
        escapeChars.put(new Character('\"'), new Character('\"'));
        escapeChars.put(new Character('\''), new Character('\''));
        escapeChars.put(new Character('n'), new Character('\n'));
        escapeChars.put(new Character('\\'), new Character('\\'));
        escapeChars.put(new Character('{'), new Character('{'));
        escapeChars.put(new Character('}'), new Character('}'));
        escapeChars.put(new Character('['), new Character('['));
        escapeChars.put(new Character(']'), new Character(']'));
        escapeChars.put(new Character('!'), new Character('!'));
        Iterator it = escapeChars.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = escapeChars.get(key);
            unescapeChars.put(value, key);
        }
    }

    protected static class RelStruct {
        protected String type;
        protected String id;
        protected boolean nec;
        protected boolean invNec;
        protected boolean completes;
        protected boolean implied;
        protected Integer minCard;
        protected Integer maxCard;
        protected Integer card;
        protected String ns;
        protected NestedValue nv;

        public RelStruct(String type, String id, boolean nec, boolean invNec, boolean completes, boolean implied, Integer minCard, Integer maxCard, Integer card, String ns, NestedValue nv) {
            this.type = type;
            this.id = id;
            this.nec = nec;
            this.invNec = invNec;
            this.completes = completes;
            this.implied = implied;
            this.minCard = minCard;
            this.maxCard = maxCard;
            this.card = card;
            this.ns = ns;
            this.nv = nv;
        }

        public boolean isImplied() {
            return this.implied;
        }

        public void setNestedValue(NestedValue nv) {
            this.nv = nv;
        }

        public NestedValue getNV() {
            return this.nv;
        }

        public void setNamespace(String ns) {
            this.ns = ns;
        }

        public String getNS() {
            return this.ns;
        }

        public void setCard(Integer card) {
            this.card = card;
        }

        public Integer getCard() {
            return this.card;
        }

        public void setMaxCard(Integer maxCard) {
            this.maxCard = maxCard;
        }

        public Integer getMaxCard() {
            return this.maxCard;
        }

        public void setMinCard(Integer minCard) {
            this.minCard = minCard;
        }

        public Integer getMinCard() {
            return this.minCard;
        }

        public void setCompletes(boolean completes) {
            this.completes = completes;
        }

        public boolean completes() {
            return this.completes;
        }

        public boolean getInvNec() {
            return this.invNec;
        }

        public void setInvNec(boolean invNec) {
            this.invNec = invNec;
        }

        public boolean getNec() {
            return this.nec;
        }

        public void setNec(boolean nec) {
            this.nec = nec;
        }

        public String getID() {
            return this.id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    protected static class NVPair {
        public NestedValue nv;
        public int endIndex;

        public NVPair(NestedValue nv, int endIndex) {
            this.nv = nv;
            this.endIndex = endIndex;
        }
    }

    public static class SOPair {
        public String str = null;
        public int index = -1;
        public int endIndex = -1;

        public SOPair(String str, int index) {
            this(str, index, -1);
        }

        public SOPair(String str, int index, int endIndex) {
            this.str = str;
            this.index = index;
            this.endIndex = endIndex;
        }
    }
}

