/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.CancelledAdapterException;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.DataAdapterUI;
import org.geneontology.dataadapter.DataAdapterUIException;
import org.geneontology.dataadapter.FileAdapterConfiguration;
import org.geneontology.dataadapter.FileAdapterUI;
import org.geneontology.dataadapter.GraphicalUI;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.io.IOUtil;
import org.geneontology.oboedit.dataadapter.AdvancedOBOUI;
import org.geneontology.oboedit.dataadapter.DefaultOBOParser;
import org.geneontology.oboedit.dataadapter.OBOEditAdapter;
import org.geneontology.oboedit.dataadapter.OBOParseEngine;
import org.geneontology.oboedit.dataadapter.OBOParseException;
import org.geneontology.oboedit.dataadapter.OBOSerializationEngine;
import org.geneontology.oboedit.dataadapter.OBOSerializer;
import org.geneontology.oboedit.dataadapter.OBO_1_0_Serializer;
import org.geneontology.oboedit.dataadapter.OBO_1_2_Serializer;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;

public class OBOFileAdapter
implements OBOEditAdapter {
    protected OBOAdapterConfiguration ioprofile;
    protected List progressListeners = new LinkedList();
    protected OBOParseEngine engine;
    protected OBOSerializationEngine serializeEngine;
    protected StringBuffer buffer = new StringBuffer();
    protected boolean cancelled = false;

    public void fireProgressEvent(ProgressEvent e) {
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            ProgressListener pl = (ProgressListener)it.next();
            pl.progressMade(e);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI(){
            private static final long serialVersionUID = 8709597443707849569L;

            public AdapterConfiguration createEmptyConfig() {
                return new OBOAdapterConfiguration();
            }

            public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
                super.acceptComponentConfig(storeonly);
                ((OBOAdapterConfiguration)this.config).setBasicSave(true);
            }
        };
        AdvancedOBOUI advancedUI = new AdvancedOBOUI();
        advancedUI.setSimpleUI((GraphicalUI)ui);
        advancedUI.setFont(Controller.getController().getDefaultFont());
        ui.setAdvancedUI((GraphicalUI)advancedUI);
        ui.setFont(Controller.getController().getDefaultFont());
        ui.setButtonColor(Preferences.defaultButtonColor(), Color.black);
        return ui;
    }

    public String getID() {
        return "OBO_EDIT:OBO_Adapter";
    }

    public String getName() {
        return "OBO Flat File Adapter";
    }

    public IOOperation[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{IOOperation.READ, IOOperation.WRITE};
        return supported;
    }

    public AdapterConfiguration getConfiguration() {
        return this.ioprofile;
    }

    public Object doOperation(IOOperation op, AdapterConfiguration configuration, Object input) throws DataAdapterException {
        if (!(configuration instanceof OBOAdapterConfiguration)) {
            throw new DataAdapterException("Invalid configuration; this adapter requires an OBOAdapterConfiguration object.");
        }
        if (op.equals(IOOperation.READ)) {
            try {
                ProgressListener l;
                int i;
                this.cancelled = false;
                this.ioprofile = (OBOAdapterConfiguration)configuration;
                DefaultOBOParser parser = new DefaultOBOParser();
                parser.setAllowDanglingParents(this.ioprofile.getAllowDangling() && !this.ioprofile.getBasicSave());
                this.engine = new OBOParseEngine(parser);
                for (i = 0; i < this.progressListeners.size(); ++i) {
                    l = (ProgressListener)this.progressListeners.get(i);
                    this.engine.addProgressListener(l);
                }
                this.engine.setPaths(this.ioprofile.getReadPaths());
                this.engine.parse();
                System.err.println("Parse Done!");
                for (i = 0; i < this.progressListeners.size(); ++i) {
                    l = (ProgressListener)this.progressListeners.get(i);
                    this.engine.removeProgressListener(l);
                }
                OBOSession history = parser.getSession();
                history.setNeedsSave(false);
                history.setLoadRemark(this.createLoadRemark());
                return history;
            }
            catch (OBOParseException e) {
                e.printStackTrace();
                if (this.cancelled) {
                    throw new CancelledAdapterException();
                }
                throw new DataAdapterException((Throwable)e, "Load error, line " + e.getLineNum());
            }
            catch (Throwable e) {
                System.err.println("exception " + e);
                if (this.cancelled) {
                    throw new CancelledAdapterException();
                }
                throw new DataAdapterException(e, "Load error");
            }
        }
        if (op.equals(IOOperation.WRITE)) {
            try {
                this.cancelled = false;
                OBO_1_2_Serializer serializer = null;
                this.ioprofile = (OBOAdapterConfiguration)configuration;
                if (this.ioprofile.getSerializer().equals("OBO_1_2")) {
                    serializer = new OBO_1_2_Serializer();
                } else if (this.ioprofile.getSerializer().equals("OBO_1_0")) {
                    serializer = new OBO_1_0_Serializer();
                }
                if (serializer == null) {
                    throw new DataAdapterException("Could not serialize to serializer " + this.ioprofile.getSerializer());
                }
                this.serializeEngine = new OBOSerializationEngine();
                List filteredPaths = TermUtil.mallocList();
                if (this.ioprofile.getBasicSave()) {
                    filteredPaths.add(new OBOSerializationEngine.FilteredPath(null, this.ioprofile.getWritePath()));
                } else {
                    filteredPaths.addAll(this.ioprofile.getSaveRecords());
                }
                Iterator it = this.progressListeners.iterator();
                while (it.hasNext()) {
                    this.serializeEngine.addProgressListener((ProgressListener)it.next());
                }
                this.serializeEngine.serialize((OBOSession)input, (OBOSerializer)serializer, filteredPaths);
                TermUtil.freeList(filteredPaths);
                return input;
            }
            catch (DataAdapterException e) {
                e.printStackTrace();
                throw e;
            }
        }
        throw new DataAdapterException("Operation " + op + " not supported!");
    }

    public void cancel() {
        this.cancelled = true;
        if (this.engine != null) {
            this.engine.cancel();
        }
        if (this.serializeEngine != null) {
            this.serializeEngine.cancel();
        }
    }

    protected String createLoadRemark() {
        StringBuffer out = new StringBuffer();
        Iterator it = this.ioprofile.getReadPaths().iterator();
        int i = 0;
        while (it.hasNext()) {
            String path = (String)it.next();
            path = IOUtil.getShortName((String)path);
            if (i != 0) {
                out.append(", ");
            }
            out.append(path);
            ++i;
        }
        return out.toString();
    }

    protected static class NamespacePair {
        protected Namespace namespace;
        protected Namespace namespace2;

        public NamespacePair(Namespace ns, Namespace ns2) {
            this.namespace = ns;
            this.namespace2 = ns2;
        }

        public boolean equals(Object o) {
            NamespacePair np = (NamespacePair)o;
            return np.namespace.equals(this.namespace) && np.namespace2.equals(this.namespace2);
        }

        public int hashCode() {
            return this.namespace.hashCode() << 2 + this.namespace2.hashCode();
        }
    }

    public static class OBOAdapterConfiguration
    extends FileAdapterConfiguration {
        protected boolean allowDangling = false;
        protected boolean saveImplied;
        protected List saveRecords = new ArrayList();
        protected boolean basicSave = true;
        protected String serializer = "OBO_1_0";
        protected String impliedType = "Save for presentation";

        public void setSerializer(String serializer) {
            this.serializer = serializer;
        }

        public String getSerializer() {
            return this.serializer;
        }

        public boolean getBasicSave() {
            return this.basicSave;
        }

        public void setBasicSave(boolean basicSave) {
            this.basicSave = basicSave;
        }

        public List getSaveRecords() {
            return this.saveRecords;
        }

        public void setSaveRecords(List saveRecords) {
            if (saveRecords.contains(null)) {
                new Exception("Null save record added to profile").printStackTrace();
            }
            this.saveRecords = saveRecords;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }
    }
}

