/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.webdav.lib.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDebugOutputer {
    private static final String INDENT = "                                                                                ";
    private int tabWidth = 3;
    private boolean debug = false;
    private DocumentBuilderFactory dbf = null;
    private DocumentBuilder db = null;

    public XMLDebugOutputer() {
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public void print(Document doc) {
        if (this.debug) {
            Element root = doc.getDocumentElement();
            this.dispatchNode(root, 0);
        }
    }

    public void print(String xmlString) {
        if (this.debug) {
            try {
                Document doc = this.db.parse(new InputSource(new StringReader(xmlString)));
                this.print(doc);
            }
            catch (SAXException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void dispatchNode(Node node, int level) {
        switch (node.getNodeType()) {
            case 4: {
                this.printCDATANode(node, level);
                break;
            }
            case 8: {
                this.printCommentNode(node, level);
                break;
            }
            case 3: {
                this.printTextNode(node, level);
                break;
            }
            case 1: {
                this.printElementNode(node, level);
                break;
            }
        }
    }

    private void printCDATANode(Node node, int level) {
        System.out.print(INDENT.substring(0, level * this.tabWidth));
        System.out.println("<![CDATA[");
        this.indentBlock(node.getNodeValue(), level + 1);
        System.out.print(INDENT.substring(0, level * this.tabWidth));
        System.out.println("]]>");
    }

    private void printTextNode(Node node, int level) {
        this.indentBlock(node.getNodeValue(), level + 1);
    }

    private void printCommentNode(Node node, int level) {
        System.out.print(INDENT.substring(0, level * this.tabWidth));
        System.out.println("<!-- ");
        this.indentBlock(node.getNodeValue(), level + 1);
        System.out.print(INDENT.substring(0, level * this.tabWidth));
        System.out.println(" -->");
    }

    private void printElementNode(Node node, int level) {
        String name = node.getNodeName();
        System.out.print(INDENT.substring(0, level * this.tabWidth));
        System.out.print("<");
        System.out.print(name);
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; attributes != null && i < attributes.getLength(); ++i) {
            if (attributes.getLength() > 1) {
                System.out.println();
                System.out.print(INDENT.substring(0, (2 + level) * this.tabWidth));
            } else {
                System.out.print(" ");
            }
            Node attribute = attributes.item(i);
            System.out.print(attribute.getNodeName());
            System.out.print("=\"");
            System.out.print(attribute.getNodeValue());
            System.out.print("\"");
        }
        System.out.println(">");
        if (attributes.getLength() > 1) {
            System.out.println();
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.dispatchNode(children.item(i), level + 1);
            }
        }
        System.out.print(INDENT.substring(0, level * this.tabWidth));
        System.out.print("</");
        System.out.print(name);
        System.out.println(">");
    }

    private void indentBlock(String block, int level) {
        StringTokenizer linetok = new StringTokenizer(block.replace('\n', ' '));
        int pos = level * this.tabWidth;
        if (linetok.countTokens() > 0) {
            System.out.print(INDENT.substring(0, level * this.tabWidth));
        }
        while (linetok.hasMoreTokens()) {
            String token = linetok.nextToken();
            if ((pos += token.length() + 1) < 80 && token.length() < 80 - level * this.tabWidth) {
                if (linetok.countTokens() > 0) {
                    System.out.print(token);
                    System.out.print(" ");
                    continue;
                }
                System.out.println(token);
                continue;
            }
            System.out.println(token);
            if (linetok.countTokens() > 0) {
                System.out.print(INDENT.substring(0, level * this.tabWidth));
            }
            pos = level * this.tabWidth;
        }
    }
}

