/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.model;

import java.io.InputStream;
import org.biopax.paxtools.impl.level2.Level2FactoryImpl;
import org.biopax.paxtools.impl.level3.Level3FactoryImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BioPAXLevel {
    L1(1, "biopax-level1.owl", Level2FactoryImpl.class, "org.biopax.paxtools.model.level2"),
    L2(2, "biopax-level2.owl", Level2FactoryImpl.class, "org.biopax.paxtools.model.level2"),
    L3(3, "biopax-level3.owl", Level3FactoryImpl.class, "org.biopax.paxtools.model.level3");

    private String filename;
    private BioPAXFactory factory;
    private int value;
    private String packageName;
    public static final String BP_PREFIX = "http://www.biopax.org/release/";

    private BioPAXLevel(int level, String filename, Class<? extends BioPAXFactory> factoryClass, String pm) {
        this.value = level;
        this.filename = filename;
        this.packageName = pm;
        try {
            this.factory = factoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public BioPAXFactory getDefaultFactory() {
        return this.factory;
    }

    public InputStream getLevelFileAsStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream(this.filename);
    }

    public String getNameSpace() {
        return BP_PREFIX + this.filename + "#";
    }

    public boolean isInBioPAXNameSpace(String nameSpace) {
        return nameSpace != null && nameSpace.startsWith(BP_PREFIX);
    }

    public int getValue() {
        return this.value;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean hasElement(BioPAXElement element) {
        return element.getModelInterface().getPackage().getName().equals(this.packageName);
    }
}

