/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.physicalEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInteractionConverter {
    InteractionRule[] rules;
    private Log log = LogFactory.getLog(SimpleInteractionConverter.class);
    private Map options;

    public SimpleInteractionConverter(InteractionRule ... rules) {
        this(new HashMap(), rules);
    }

    public SimpleInteractionConverter(Map options, InteractionRule ... rules) {
        this.options = options;
        this.rules = rules;
    }

    public Set<SimpleInteraction> inferInteractions(Model model) {
        HashSet<SimpleInteraction> interactions = new HashSet<SimpleInteraction>();
        Set<physicalEntity> bioPAXElements = model.getObjects(physicalEntity.class);
        for (physicalEntity pe : bioPAXElements) {
            for (InteractionRule rule : this.rules) {
                rule.inferInteractions(interactions, pe, model, this.options);
            }
        }
        return interactions;
    }

    public void writeInteractionsInSIF(Model model, OutputStream out) throws IOException {
        Set<SimpleInteraction> interactionSet = this.inferInteractions(model);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        for (SimpleInteraction simpleInteraction : interactionSet) {
            writer.write(simpleInteraction.toString() + "\n");
        }
        ((Writer)writer).close();
    }
}

