/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.KPrime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KPrimeImpl
extends L3ElementImpl
implements KPrime {
    private float ionicStrength = Float.NaN;
    private float kPrime = Float.NaN;
    private float ph = Float.NaN;
    private float pMg = Float.NaN;
    private float temperature = Float.NaN;

    KPrimeImpl() {
    }

    @Override
    public Class<? extends BioPAXElement> getModelInterface() {
        return KPrime.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        KPrime aKPrime = (KPrime)element;
        return Float.compare(aKPrime.getIonicStrength(), this.ionicStrength) == 0 && Float.compare(aKPrime.getKPrime(), this.kPrime) == 0 && Float.compare(aKPrime.getPh(), this.ph) == 0 && Float.compare(aKPrime.getPMg(), this.pMg) == 0 && Float.compare(aKPrime.getTemperature(), this.temperature) == 0;
    }

    @Override
    public int equivalenceCode() {
        int result = 29.0f + this.kPrime != 0.0f ? Float.floatToIntBits(this.kPrime) : 0;
        result = (float)(29 * result) + this.temperature != 0.0f ? Float.floatToIntBits(this.temperature) : 0;
        result = (float)(29 * result) + this.ionicStrength != 0.0f ? Float.floatToIntBits(this.ionicStrength) : 0;
        result = (float)(29 * result) + this.ph != 0.0f ? Float.floatToIntBits(this.ph) : 0;
        result = (float)(29 * result) + this.pMg != 0.0f ? Float.floatToIntBits(this.pMg) : 0;
        return result;
    }

    @Override
    public float getIonicStrength() {
        return this.ionicStrength;
    }

    @Override
    public void setIonicStrength(float ionicStrength) {
        this.ionicStrength = ionicStrength;
    }

    @Override
    public float getKPrime() {
        return this.kPrime;
    }

    @Override
    public void setKPrime(float prime) {
        this.kPrime = prime;
    }

    @Override
    public float getPh() {
        return this.ph;
    }

    @Override
    public void setPh(float ph) {
        this.ph = ph;
    }

    @Override
    public float getPMg() {
        return this.pMg;
    }

    @Override
    public void setPMg(float pMg) {
        this.pMg = pMg;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }
}

